/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.bionano;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broad.igv.feature.AbstractFeature;
import org.broad.igv.feature.Strand;
import org.broad.igv.track.WindowFunction;

public class SMAPFeature
extends AbstractFeature {
    private int linkId;
    private String[] headers;
    private String[] tokens;
    double confidence;
    List<SMAPFeature> partialFeatures;
    static Map<String, Color> colors = new HashMap<String, Color>();

    public SMAPFeature(String chr, int start, int end, double confidence, String type, String[] headers, String[] tokens) {
        super(chr, start, end, Strand.NONE);
        this.tokens = tokens;
        this.confidence = confidence;
        this.type = type;
        this.headers = headers;
    }

    public SMAPFeature(String chr, int start, int end, double conf, String t2, String[] headers, String[] tokens, int linkId) {
        this(chr, start, end, conf, t2, headers, tokens);
        this.linkId = linkId;
    }

    @Override
    public Color getColor() {
        if (colors.containsKey(this.type)) {
            return colors.get(this.type);
        }
        return super.getColor();
    }

    public void addPartialFeature(SMAPFeature smapFeature) {
        if (this.partialFeatures == null) {
            this.partialFeatures = new ArrayList<SMAPFeature>();
        }
        this.partialFeatures.add(smapFeature);
    }

    @Override
    public String getURL() {
        return null;
    }

    @Override
    public String getValueString(double position, int mouseX, WindowFunction windowFunction) {
        StringBuffer buf = new StringBuffer();
        buf.append("<b>Type:&nbsp;" + this.type + "</b>");
        for (int i2 = 0; i2 < this.headers.length; ++i2) {
            buf.append("<br>" + this.headers[i2] + ":&nbsp;" + this.tokens[i2]);
        }
        if (this.partialFeatures != null) {
            for (SMAPFeature pf : this.partialFeatures) {
                buf.append("<hr>");
                buf.append(pf.getValueString(position, mouseX, windowFunction));
            }
        }
        return buf.toString();
    }

    public int getLinkId() {
        return this.linkId;
    }

    static {
        colors.put("insertion", new Color(0, 128, 0));
        colors.put("deletion", new Color(255, 0, 0));
    }
}

