/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.basepair;

import htsjdk.tribble.readers.AsciiLineReader;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.exceptions.ParserException;
import org.broad.igv.feature.basepair.BasePairData;
import org.broad.igv.feature.basepair.BasePairFeature;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;

public class BasePairFileParser {
    static Logger log = Logger.getLogger(BasePairFileParser.class);

    public static BasePairData loadData(ResourceLocator locator, Genome genome) {
        AsciiLineReader reader = null;
        ArrayList<Color> colors = new ArrayList<Color>();
        HashMap rowsByColor = new HashMap();
        BasePairData basePairData = new BasePairData();
        String nextLine = null;
        int rowCounter = 0;
        try {
            String[] tokens;
            reader = ParsingUtils.openAsciiReader(locator);
            nextLine = reader.readLine();
            ++rowCounter;
            while (nextLine.substring(0, 6).equals("color:")) {
                tokens = Globals.whitespacePattern.split(nextLine, -1);
                int r2 = Integer.parseInt(tokens[1]);
                int g2 = Integer.parseInt(tokens[2]);
                int b2 = Integer.parseInt(tokens[3]);
                Color color = new Color(r2, g2, b2, 255);
                colors.add(color);
                nextLine = reader.readLine();
                ++rowCounter;
            }
            for (Color color : colors) {
                rowsByColor.put(color, new ArrayList());
            }
            while (nextLine != null) {
                tokens = Globals.whitespacePattern.split(nextLine, -1);
                String chr = genome == null ? tokens[0] : genome.getCanonicalChrName(tokens[0]);
                int startLeftNuc = Integer.parseInt(tokens[1]) - 1;
                int startRightNuc = Integer.parseInt(tokens[2]) - 1;
                int endLeftNuc = Integer.parseInt(tokens[3]) - 1;
                int endRightNuc = Integer.parseInt(tokens[4]) - 1;
                Color color = (Color)colors.get(Integer.parseInt(tokens[5]));
                BasePairFeature feature = startLeftNuc <= endRightNuc ? new BasePairFeature(chr, Math.min(startLeftNuc, startRightNuc), Math.max(startLeftNuc, startRightNuc), Math.min(endLeftNuc, endRightNuc), Math.max(endLeftNuc, endRightNuc), color) : new BasePairFeature(chr, Math.min(endLeftNuc, endRightNuc), Math.max(endLeftNuc, endRightNuc), Math.min(startLeftNuc, startRightNuc), Math.max(startLeftNuc, startRightNuc), color);
                basePairData.addFeature(feature);
                nextLine = reader.readLine();
                ++rowCounter;
            }
            basePairData.finish();
        }
        catch (Exception e2) {
            log.error("Error parsing base pair file", e2);
            if (nextLine != null && rowCounter != 0) {
                throw new ParserException(e2.getMessage(), (Throwable)e2, rowCounter, nextLine);
            }
            throw new RuntimeException(e2);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return basePairData;
    }
}

