/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.exception.NonMonotonousSequenceException;
import org.apache.commons.math.exception.util.Localizable;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.util.FastMath;

public final class MathUtils {
    public static final double EPSILON = (double)1.110223E-16f;
    public static final double SAFE_MIN = Double.MIN_NORMAL;
    public static final double TWO_PI = Math.PI * 2;
    private static final byte NB = -1;
    private static final short NS = -1;
    private static final byte PB = 1;
    private static final short PS = 1;
    private static final byte ZB = 0;
    private static final short ZS = 0;
    private static final int NAN_GAP = 0x400000;
    private static final long SGN_MASK = Long.MIN_VALUE;
    private static final int SGN_MASK_FLOAT = Integer.MIN_VALUE;
    private static final long[] FACTORIALS = new long[]{1L, 1L, 2L, 6L, 24L, 120L, 720L, 5040L, 40320L, 362880L, 3628800L, 39916800L, 479001600L, 6227020800L, 87178291200L, 1307674368000L, 20922789888000L, 355687428096000L, 6402373705728000L, 121645100408832000L, 2432902008176640000L};

    private MathUtils() {
    }

    public static int addAndCheck(int x2, int y) {
        long s2 = (long)x2 + (long)y;
        if (s2 < Integer.MIN_VALUE || s2 > Integer.MAX_VALUE) {
            throw MathRuntimeException.createArithmeticException(LocalizedFormats.OVERFLOW_IN_ADDITION, x2, y);
        }
        return (int)s2;
    }

    public static long addAndCheck(long a2, long b2) {
        return MathUtils.addAndCheck(a2, b2, LocalizedFormats.OVERFLOW_IN_ADDITION);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static long addAndCheck(long a2, long b2, Localizable pattern) {
        if (a2 > b2) {
            return MathUtils.addAndCheck(b2, a2, pattern);
        }
        if (a2 < 0L) {
            if (b2 >= 0L) return a2 + b2;
            if (Long.MIN_VALUE - b2 > a2) throw MathRuntimeException.createArithmeticException(pattern, a2, b2);
            return a2 + b2;
        }
        if (a2 > Long.MAX_VALUE - b2) throw MathRuntimeException.createArithmeticException(pattern, a2, b2);
        return a2 + b2;
    }

    public static long binomialCoefficient(int n2, int k2) {
        MathUtils.checkBinomial(n2, k2);
        if (n2 == k2 || k2 == 0) {
            return 1L;
        }
        if (k2 == 1 || k2 == n2 - 1) {
            return n2;
        }
        if (k2 > n2 / 2) {
            return MathUtils.binomialCoefficient(n2, n2 - k2);
        }
        long result = 1L;
        if (n2 <= 61) {
            int i2 = n2 - k2 + 1;
            for (int j2 = 1; j2 <= k2; ++j2) {
                result = result * (long)i2 / (long)j2;
                ++i2;
            }
        } else if (n2 <= 66) {
            int i3 = n2 - k2 + 1;
            for (int j3 = 1; j3 <= k2; ++j3) {
                long d2 = MathUtils.gcd(i3, j3);
                result = result / ((long)j3 / d2) * ((long)i3 / d2);
                ++i3;
            }
        } else {
            int i4 = n2 - k2 + 1;
            for (int j4 = 1; j4 <= k2; ++j4) {
                long d3 = MathUtils.gcd(i4, j4);
                result = MathUtils.mulAndCheck(result / ((long)j4 / d3), (long)i4 / d3);
                ++i4;
            }
        }
        return result;
    }

    public static double binomialCoefficientDouble(int n2, int k2) {
        MathUtils.checkBinomial(n2, k2);
        if (n2 == k2 || k2 == 0) {
            return 1.0;
        }
        if (k2 == 1 || k2 == n2 - 1) {
            return n2;
        }
        if (k2 > n2 / 2) {
            return MathUtils.binomialCoefficientDouble(n2, n2 - k2);
        }
        if (n2 < 67) {
            return MathUtils.binomialCoefficient(n2, k2);
        }
        double result = 1.0;
        for (int i2 = 1; i2 <= k2; ++i2) {
            result *= (double)(n2 - k2 + i2) / (double)i2;
        }
        return FastMath.floor(result + 0.5);
    }

    public static double binomialCoefficientLog(int n2, int k2) {
        int i2;
        MathUtils.checkBinomial(n2, k2);
        if (n2 == k2 || k2 == 0) {
            return 0.0;
        }
        if (k2 == 1 || k2 == n2 - 1) {
            return FastMath.log(n2);
        }
        if (n2 < 67) {
            return FastMath.log(MathUtils.binomialCoefficient(n2, k2));
        }
        if (n2 < 1030) {
            return FastMath.log(MathUtils.binomialCoefficientDouble(n2, k2));
        }
        if (k2 > n2 / 2) {
            return MathUtils.binomialCoefficientLog(n2, n2 - k2);
        }
        double logSum = 0.0;
        for (i2 = n2 - k2 + 1; i2 <= n2; ++i2) {
            logSum += FastMath.log(i2);
        }
        for (i2 = 2; i2 <= k2; ++i2) {
            logSum -= FastMath.log(i2);
        }
        return logSum;
    }

    private static void checkBinomial(int n2, int k2) throws IllegalArgumentException {
        if (n2 < k2) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.BINOMIAL_INVALID_PARAMETERS_ORDER, n2, k2);
        }
        if (n2 < 0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.BINOMIAL_NEGATIVE_PARAMETER, n2);
        }
    }

    public static int compareTo(double x2, double y, double eps) {
        if (MathUtils.equals(x2, y, eps)) {
            return 0;
        }
        if (x2 < y) {
            return -1;
        }
        return 1;
    }

    public static double cosh(double x2) {
        return (FastMath.exp(x2) + FastMath.exp(-x2)) / 2.0;
    }

    @Deprecated
    public static boolean equals(float x2, float y) {
        return Float.isNaN(x2) && Float.isNaN(y) || x2 == y;
    }

    public static boolean equalsIncludingNaN(float x2, float y) {
        return Float.isNaN(x2) && Float.isNaN(y) || MathUtils.equals(x2, y, 1);
    }

    public static boolean equals(float x2, float y, float eps) {
        return MathUtils.equals(x2, y, 1) || FastMath.abs(y - x2) <= eps;
    }

    public static boolean equalsIncludingNaN(float x2, float y, float eps) {
        return MathUtils.equalsIncludingNaN(x2, y) || FastMath.abs(y - x2) <= eps;
    }

    public static boolean equals(float x2, float y, int maxUlps) {
        assert (maxUlps > 0 && maxUlps < 0x400000);
        int xInt = Float.floatToIntBits(x2);
        int yInt = Float.floatToIntBits(y);
        if (xInt < 0) {
            xInt = Integer.MIN_VALUE - xInt;
        }
        if (yInt < 0) {
            yInt = Integer.MIN_VALUE - yInt;
        }
        boolean isEqual = FastMath.abs(xInt - yInt) <= maxUlps;
        return isEqual && !Float.isNaN(x2) && !Float.isNaN(y);
    }

    public static boolean equalsIncludingNaN(float x2, float y, int maxUlps) {
        return Float.isNaN(x2) && Float.isNaN(y) || MathUtils.equals(x2, y, maxUlps);
    }

    @Deprecated
    public static boolean equals(float[] x2, float[] y) {
        if (x2 == null || y == null) {
            return !(x2 == null ^ y == null);
        }
        if (x2.length != y.length) {
            return false;
        }
        for (int i2 = 0; i2 < x2.length; ++i2) {
            if (MathUtils.equals(x2[i2], y[i2])) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsIncludingNaN(float[] x2, float[] y) {
        if (x2 == null || y == null) {
            return !(x2 == null ^ y == null);
        }
        if (x2.length != y.length) {
            return false;
        }
        for (int i2 = 0; i2 < x2.length; ++i2) {
            if (MathUtils.equalsIncludingNaN(x2[i2], y[i2])) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(double x2, double y) {
        return Double.isNaN(x2) && Double.isNaN(y) || x2 == y;
    }

    public static boolean equalsIncludingNaN(double x2, double y) {
        return Double.isNaN(x2) && Double.isNaN(y) || MathUtils.equals(x2, y, 1);
    }

    public static boolean equals(double x2, double y, double eps) {
        return MathUtils.equals(x2, y) || FastMath.abs(y - x2) <= eps;
    }

    public static boolean equalsIncludingNaN(double x2, double y, double eps) {
        return MathUtils.equalsIncludingNaN(x2, y) || FastMath.abs(y - x2) <= eps;
    }

    public static boolean equals(double x2, double y, int maxUlps) {
        assert (maxUlps > 0 && maxUlps < 0x400000);
        long xInt = Double.doubleToLongBits(x2);
        long yInt = Double.doubleToLongBits(y);
        if (xInt < 0L) {
            xInt = Long.MIN_VALUE - xInt;
        }
        if (yInt < 0L) {
            yInt = Long.MIN_VALUE - yInt;
        }
        return FastMath.abs(xInt - yInt) <= (long)maxUlps;
    }

    public static boolean equalsIncludingNaN(double x2, double y, int maxUlps) {
        return Double.isNaN(x2) && Double.isNaN(y) || MathUtils.equals(x2, y, maxUlps);
    }

    public static boolean equals(double[] x2, double[] y) {
        if (x2 == null || y == null) {
            return !(x2 == null ^ y == null);
        }
        if (x2.length != y.length) {
            return false;
        }
        for (int i2 = 0; i2 < x2.length; ++i2) {
            if (MathUtils.equals(x2[i2], y[i2])) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsIncludingNaN(double[] x2, double[] y) {
        if (x2 == null || y == null) {
            return !(x2 == null ^ y == null);
        }
        if (x2.length != y.length) {
            return false;
        }
        for (int i2 = 0; i2 < x2.length; ++i2) {
            if (MathUtils.equalsIncludingNaN(x2[i2], y[i2])) continue;
            return false;
        }
        return true;
    }

    public static long factorial(int n2) {
        if (n2 < 0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.FACTORIAL_NEGATIVE_PARAMETER, n2);
        }
        if (n2 > 20) {
            throw new ArithmeticException("factorial value is too large to fit in a long");
        }
        return FACTORIALS[n2];
    }

    public static double factorialDouble(int n2) {
        if (n2 < 0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.FACTORIAL_NEGATIVE_PARAMETER, n2);
        }
        if (n2 < 21) {
            return MathUtils.factorial(n2);
        }
        return FastMath.floor(FastMath.exp(MathUtils.factorialLog(n2)) + 0.5);
    }

    public static double factorialLog(int n2) {
        if (n2 < 0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.FACTORIAL_NEGATIVE_PARAMETER, n2);
        }
        if (n2 < 21) {
            return FastMath.log(MathUtils.factorial(n2));
        }
        double logSum = 0.0;
        for (int i2 = 2; i2 <= n2; ++i2) {
            logSum += FastMath.log(i2);
        }
        return logSum;
    }

    public static int gcd(int p2, int q2) {
        int t2;
        int k2;
        int u2 = p2;
        int v2 = q2;
        if (u2 == 0 || v2 == 0) {
            if (u2 == Integer.MIN_VALUE || v2 == Integer.MIN_VALUE) {
                throw MathRuntimeException.createArithmeticException(LocalizedFormats.GCD_OVERFLOW_32_BITS, p2, q2);
            }
            return FastMath.abs(u2) + FastMath.abs(v2);
        }
        if (u2 > 0) {
            u2 = -u2;
        }
        if (v2 > 0) {
            v2 = -v2;
        }
        for (k2 = 0; (u2 & 1) == 0 && (v2 & 1) == 0 && k2 < 31; ++k2) {
            u2 /= 2;
            v2 /= 2;
        }
        if (k2 == 31) {
            throw MathRuntimeException.createArithmeticException(LocalizedFormats.GCD_OVERFLOW_32_BITS, p2, q2);
        }
        int n2 = t2 = (u2 & 1) == 1 ? v2 : -(u2 / 2);
        while (true) {
            if ((t2 & 1) == 0) {
                t2 /= 2;
                continue;
            }
            if (t2 > 0) {
                u2 = -t2;
            } else {
                v2 = t2;
            }
            if ((t2 = (v2 - u2) / 2) == 0) break;
        }
        return -u2 * (1 << k2);
    }

    public static long gcd(long p2, long q2) {
        long t2;
        int k2;
        long u2 = p2;
        long v2 = q2;
        if (u2 == 0L || v2 == 0L) {
            if (u2 == Long.MIN_VALUE || v2 == Long.MIN_VALUE) {
                throw MathRuntimeException.createArithmeticException(LocalizedFormats.GCD_OVERFLOW_64_BITS, p2, q2);
            }
            return FastMath.abs(u2) + FastMath.abs(v2);
        }
        if (u2 > 0L) {
            u2 = -u2;
        }
        if (v2 > 0L) {
            v2 = -v2;
        }
        for (k2 = 0; (u2 & 1L) == 0L && (v2 & 1L) == 0L && k2 < 63; ++k2) {
            u2 /= 2L;
            v2 /= 2L;
        }
        if (k2 == 63) {
            throw MathRuntimeException.createArithmeticException(LocalizedFormats.GCD_OVERFLOW_64_BITS, p2, q2);
        }
        long l2 = t2 = (u2 & 1L) == 1L ? v2 : -(u2 / 2L);
        while (true) {
            if ((t2 & 1L) == 0L) {
                t2 /= 2L;
                continue;
            }
            if (t2 > 0L) {
                u2 = -t2;
            } else {
                v2 = t2;
            }
            if ((t2 = (v2 - u2) / 2L) == 0L) break;
        }
        return -u2 * (1L << k2);
    }

    public static int hash(double value) {
        return new Double(value).hashCode();
    }

    public static int hash(double[] value) {
        return Arrays.hashCode(value);
    }

    public static byte indicator(byte x2) {
        return x2 >= 0 ? (byte)1 : -1;
    }

    public static double indicator(double x2) {
        if (Double.isNaN(x2)) {
            return Double.NaN;
        }
        return x2 >= 0.0 ? 1.0 : -1.0;
    }

    public static float indicator(float x2) {
        if (Float.isNaN(x2)) {
            return Float.NaN;
        }
        return x2 >= 0.0f ? 1.0f : -1.0f;
    }

    public static int indicator(int x2) {
        return x2 >= 0 ? 1 : -1;
    }

    public static long indicator(long x2) {
        return x2 >= 0L ? 1L : -1L;
    }

    public static short indicator(short x2) {
        return x2 >= 0 ? (short)1 : -1;
    }

    public static int lcm(int a2, int b2) {
        if (a2 == 0 || b2 == 0) {
            return 0;
        }
        int lcm = FastMath.abs(MathUtils.mulAndCheck(a2 / MathUtils.gcd(a2, b2), b2));
        if (lcm == Integer.MIN_VALUE) {
            throw MathRuntimeException.createArithmeticException(LocalizedFormats.LCM_OVERFLOW_32_BITS, a2, b2);
        }
        return lcm;
    }

    public static long lcm(long a2, long b2) {
        if (a2 == 0L || b2 == 0L) {
            return 0L;
        }
        long lcm = FastMath.abs(MathUtils.mulAndCheck(a2 / MathUtils.gcd(a2, b2), b2));
        if (lcm == Long.MIN_VALUE) {
            throw MathRuntimeException.createArithmeticException(LocalizedFormats.LCM_OVERFLOW_64_BITS, a2, b2);
        }
        return lcm;
    }

    public static double log(double base, double x2) {
        return FastMath.log(x2) / FastMath.log(base);
    }

    public static int mulAndCheck(int x2, int y) {
        long m2 = (long)x2 * (long)y;
        if (m2 < Integer.MIN_VALUE || m2 > Integer.MAX_VALUE) {
            throw new ArithmeticException("overflow: mul");
        }
        return (int)m2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long mulAndCheck(long a2, long b2) {
        String msg = "overflow: multiply";
        if (a2 > b2) {
            return MathUtils.mulAndCheck(b2, a2);
        }
        if (a2 < 0L) {
            if (b2 < 0L) {
                if (a2 < Long.MAX_VALUE / b2) throw new ArithmeticException(msg);
                return a2 * b2;
            }
            if (b2 <= 0L) return 0L;
            if (Long.MIN_VALUE / b2 > a2) throw new ArithmeticException(msg);
            return a2 * b2;
        }
        if (a2 <= 0L) return 0L;
        if (a2 > Long.MAX_VALUE / b2) throw new ArithmeticException(msg);
        return a2 * b2;
    }

    @Deprecated
    public static double nextAfter(double d2, double direction) {
        if (Double.isNaN(d2) || Double.isInfinite(d2)) {
            return d2;
        }
        if (d2 == 0.0) {
            return direction < 0.0 ? -4.9E-324 : Double.MIN_VALUE;
        }
        long bits = Double.doubleToLongBits(d2);
        long sign = bits & Long.MIN_VALUE;
        long exponent = bits & 0x7FF0000000000000L;
        long mantissa = bits & 0xFFFFFFFFFFFFFL;
        if (d2 * (direction - d2) >= 0.0) {
            if (mantissa == 0xFFFFFFFFFFFFFL) {
                return Double.longBitsToDouble(sign | exponent + 0x10000000000000L);
            }
            return Double.longBitsToDouble(sign | exponent | mantissa + 1L);
        }
        if (mantissa == 0L) {
            return Double.longBitsToDouble(sign | exponent - 0x10000000000000L | 0xFFFFFFFFFFFFFL);
        }
        return Double.longBitsToDouble(sign | exponent | mantissa - 1L);
    }

    @Deprecated
    public static double scalb(double d2, int scaleFactor) {
        return FastMath.scalb(d2, scaleFactor);
    }

    public static double normalizeAngle(double a2, double center) {
        return a2 - Math.PI * 2 * FastMath.floor((a2 + Math.PI - center) / (Math.PI * 2));
    }

    public static double[] normalizeArray(double[] values, double normalizedSum) throws ArithmeticException, IllegalArgumentException {
        int i2;
        if (Double.isInfinite(normalizedSum)) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.NORMALIZE_INFINITE, new Object[0]);
        }
        if (Double.isNaN(normalizedSum)) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.NORMALIZE_NAN, new Object[0]);
        }
        double sum = 0.0;
        int len = values.length;
        double[] out = new double[len];
        for (i2 = 0; i2 < len; ++i2) {
            if (Double.isInfinite(values[i2])) {
                throw MathRuntimeException.createArithmeticException(LocalizedFormats.INFINITE_ARRAY_ELEMENT, values[i2], i2);
            }
            if (Double.isNaN(values[i2])) continue;
            sum += values[i2];
        }
        if (sum == 0.0) {
            throw MathRuntimeException.createArithmeticException(LocalizedFormats.ARRAY_SUMS_TO_ZERO, new Object[0]);
        }
        for (i2 = 0; i2 < len; ++i2) {
            out[i2] = Double.isNaN(values[i2]) ? Double.NaN : values[i2] * normalizedSum / sum;
        }
        return out;
    }

    public static double round(double x2, int scale) {
        return MathUtils.round(x2, scale, 4);
    }

    public static double round(double x2, int scale, int roundingMethod) {
        try {
            return new BigDecimal(Double.toString(x2)).setScale(scale, roundingMethod).doubleValue();
        }
        catch (NumberFormatException ex) {
            if (Double.isInfinite(x2)) {
                return x2;
            }
            return Double.NaN;
        }
    }

    public static float round(float x2, int scale) {
        return MathUtils.round(x2, scale, 4);
    }

    public static float round(float x2, int scale, int roundingMethod) {
        float sign = MathUtils.indicator(x2);
        float factor = (float)FastMath.pow(10.0, scale) * sign;
        return (float)MathUtils.roundUnscaled(x2 * factor, sign, roundingMethod) / factor;
    }

    private static double roundUnscaled(double unscaled, double sign, int roundingMethod) {
        switch (roundingMethod) {
            case 2: {
                if (sign == -1.0) {
                    unscaled = FastMath.floor(MathUtils.nextAfter(unscaled, Double.NEGATIVE_INFINITY));
                    break;
                }
                unscaled = FastMath.ceil(MathUtils.nextAfter(unscaled, Double.POSITIVE_INFINITY));
                break;
            }
            case 1: {
                unscaled = FastMath.floor(MathUtils.nextAfter(unscaled, Double.NEGATIVE_INFINITY));
                break;
            }
            case 3: {
                if (sign == -1.0) {
                    unscaled = FastMath.ceil(MathUtils.nextAfter(unscaled, Double.POSITIVE_INFINITY));
                    break;
                }
                unscaled = FastMath.floor(MathUtils.nextAfter(unscaled, Double.NEGATIVE_INFINITY));
                break;
            }
            case 5: {
                unscaled = MathUtils.nextAfter(unscaled, Double.NEGATIVE_INFINITY);
                double fraction = unscaled - FastMath.floor(unscaled);
                if (fraction > 0.5) {
                    unscaled = FastMath.ceil(unscaled);
                    break;
                }
                unscaled = FastMath.floor(unscaled);
                break;
            }
            case 6: {
                double fraction = unscaled - FastMath.floor(unscaled);
                if (fraction > 0.5) {
                    unscaled = FastMath.ceil(unscaled);
                    break;
                }
                if (fraction < 0.5) {
                    unscaled = FastMath.floor(unscaled);
                    break;
                }
                if (FastMath.floor(unscaled) / 2.0 == FastMath.floor(Math.floor(unscaled) / 2.0)) {
                    unscaled = FastMath.floor(unscaled);
                    break;
                }
                unscaled = FastMath.ceil(unscaled);
                break;
            }
            case 4: {
                unscaled = MathUtils.nextAfter(unscaled, Double.POSITIVE_INFINITY);
                double fraction = unscaled - FastMath.floor(unscaled);
                if (fraction >= 0.5) {
                    unscaled = FastMath.ceil(unscaled);
                    break;
                }
                unscaled = FastMath.floor(unscaled);
                break;
            }
            case 7: {
                if (unscaled == FastMath.floor(unscaled)) break;
                throw new ArithmeticException("Inexact result from rounding");
            }
            case 0: {
                unscaled = FastMath.ceil(MathUtils.nextAfter(unscaled, Double.POSITIVE_INFINITY));
                break;
            }
            default: {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.INVALID_ROUNDING_METHOD, roundingMethod, "ROUND_CEILING", 2, "ROUND_DOWN", 1, "ROUND_FLOOR", 3, "ROUND_HALF_DOWN", 5, "ROUND_HALF_EVEN", 6, "ROUND_HALF_UP", 4, "ROUND_UNNECESSARY", 7, "ROUND_UP", 0);
            }
        }
        return unscaled;
    }

    public static byte sign(byte x2) {
        return (byte)(x2 == 0 ? 0 : (x2 > 0 ? 1 : -1));
    }

    public static double sign(double x2) {
        if (Double.isNaN(x2)) {
            return Double.NaN;
        }
        return x2 == 0.0 ? 0.0 : (x2 > 0.0 ? 1.0 : -1.0);
    }

    public static float sign(float x2) {
        if (Float.isNaN(x2)) {
            return Float.NaN;
        }
        return x2 == 0.0f ? 0.0f : (x2 > 0.0f ? 1.0f : -1.0f);
    }

    public static int sign(int x2) {
        return x2 == 0 ? 0 : (x2 > 0 ? 1 : -1);
    }

    public static long sign(long x2) {
        return x2 == 0L ? 0L : (x2 > 0L ? 1L : -1L);
    }

    public static short sign(short x2) {
        return (short)(x2 == 0 ? 0 : (x2 > 0 ? 1 : -1));
    }

    public static double sinh(double x2) {
        return (FastMath.exp(x2) - FastMath.exp(-x2)) / 2.0;
    }

    public static int subAndCheck(int x2, int y) {
        long s2 = (long)x2 - (long)y;
        if (s2 < Integer.MIN_VALUE || s2 > Integer.MAX_VALUE) {
            throw MathRuntimeException.createArithmeticException(LocalizedFormats.OVERFLOW_IN_SUBTRACTION, x2, y);
        }
        return (int)s2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long subAndCheck(long a2, long b2) {
        String msg = "overflow: subtract";
        if (b2 != Long.MIN_VALUE) return MathUtils.addAndCheck(a2, -b2, LocalizedFormats.OVERFLOW_IN_ADDITION);
        if (a2 >= 0L) throw new ArithmeticException(msg);
        return a2 - b2;
    }

    public static int pow(int k2, int e2) throws IllegalArgumentException {
        if (e2 < 0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.POWER_NEGATIVE_PARAMETERS, k2, e2);
        }
        int result = 1;
        int k2p = k2;
        while (e2 != 0) {
            if ((e2 & 1) != 0) {
                result *= k2p;
            }
            k2p *= k2p;
            e2 >>= 1;
        }
        return result;
    }

    public static int pow(int k2, long e2) throws IllegalArgumentException {
        if (e2 < 0L) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.POWER_NEGATIVE_PARAMETERS, k2, e2);
        }
        int result = 1;
        int k2p = k2;
        while (e2 != 0L) {
            if ((e2 & 1L) != 0L) {
                result *= k2p;
            }
            k2p *= k2p;
            e2 >>= 1;
        }
        return result;
    }

    public static long pow(long k2, int e2) throws IllegalArgumentException {
        if (e2 < 0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.POWER_NEGATIVE_PARAMETERS, k2, e2);
        }
        long result = 1L;
        long k2p = k2;
        while (e2 != 0) {
            if ((e2 & 1) != 0) {
                result *= k2p;
            }
            k2p *= k2p;
            e2 >>= 1;
        }
        return result;
    }

    public static long pow(long k2, long e2) throws IllegalArgumentException {
        if (e2 < 0L) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.POWER_NEGATIVE_PARAMETERS, k2, e2);
        }
        long result = 1L;
        long k2p = k2;
        while (e2 != 0L) {
            if ((e2 & 1L) != 0L) {
                result *= k2p;
            }
            k2p *= k2p;
            e2 >>= 1;
        }
        return result;
    }

    public static BigInteger pow(BigInteger k2, int e2) throws IllegalArgumentException {
        if (e2 < 0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.POWER_NEGATIVE_PARAMETERS, k2, e2);
        }
        return k2.pow(e2);
    }

    public static BigInteger pow(BigInteger k2, long e2) throws IllegalArgumentException {
        if (e2 < 0L) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.POWER_NEGATIVE_PARAMETERS, k2, e2);
        }
        BigInteger result = BigInteger.ONE;
        BigInteger k2p = k2;
        while (e2 != 0L) {
            if ((e2 & 1L) != 0L) {
                result = result.multiply(k2p);
            }
            k2p = k2p.multiply(k2p);
            e2 >>= 1;
        }
        return result;
    }

    public static BigInteger pow(BigInteger k2, BigInteger e2) throws IllegalArgumentException {
        if (e2.compareTo(BigInteger.ZERO) < 0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.POWER_NEGATIVE_PARAMETERS, k2, e2);
        }
        BigInteger result = BigInteger.ONE;
        BigInteger k2p = k2;
        while (!BigInteger.ZERO.equals(e2)) {
            if (e2.testBit(0)) {
                result = result.multiply(k2p);
            }
            k2p = k2p.multiply(k2p);
            e2 = e2.shiftRight(1);
        }
        return result;
    }

    public static double distance1(double[] p1, double[] p2) {
        double sum = 0.0;
        for (int i2 = 0; i2 < p1.length; ++i2) {
            sum += FastMath.abs(p1[i2] - p2[i2]);
        }
        return sum;
    }

    public static int distance1(int[] p1, int[] p2) {
        int sum = 0;
        for (int i2 = 0; i2 < p1.length; ++i2) {
            sum += FastMath.abs(p1[i2] - p2[i2]);
        }
        return sum;
    }

    public static double distance(double[] p1, double[] p2) {
        double sum = 0.0;
        for (int i2 = 0; i2 < p1.length; ++i2) {
            double dp = p1[i2] - p2[i2];
            sum += dp * dp;
        }
        return FastMath.sqrt(sum);
    }

    public static double distance(int[] p1, int[] p2) {
        double sum = 0.0;
        for (int i2 = 0; i2 < p1.length; ++i2) {
            double dp = p1[i2] - p2[i2];
            sum += dp * dp;
        }
        return FastMath.sqrt(sum);
    }

    public static double distanceInf(double[] p1, double[] p2) {
        double max = 0.0;
        for (int i2 = 0; i2 < p1.length; ++i2) {
            max = FastMath.max(max, FastMath.abs(p1[i2] - p2[i2]));
        }
        return max;
    }

    public static int distanceInf(int[] p1, int[] p2) {
        int max = 0;
        for (int i2 = 0; i2 < p1.length; ++i2) {
            max = FastMath.max(max, FastMath.abs(p1[i2] - p2[i2]));
        }
        return max;
    }

    public static void checkOrder(double[] val, OrderDirection dir, boolean strict) {
        double previous = val[0];
        boolean ok = true;
        int max = val.length;
        for (int i2 = 1; i2 < max; ++i2) {
            switch (dir) {
                case INCREASING: {
                    if (strict) {
                        if (!(val[i2] <= previous)) break;
                        ok = false;
                        break;
                    }
                    if (!(val[i2] < previous)) break;
                    ok = false;
                    break;
                }
                case DECREASING: {
                    if (strict) {
                        if (!(val[i2] >= previous)) break;
                        ok = false;
                        break;
                    }
                    if (!(val[i2] > previous)) break;
                    ok = false;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            if (!ok) {
                throw new NonMonotonousSequenceException(val[i2], (Number)previous, i2, dir, strict);
            }
            previous = val[i2];
        }
    }

    public static void checkOrder(double[] val) {
        MathUtils.checkOrder(val, OrderDirection.INCREASING, true);
    }

    @Deprecated
    public static void checkOrder(double[] val, int dir, boolean strict) {
        if (dir > 0) {
            MathUtils.checkOrder(val, OrderDirection.INCREASING, strict);
        } else {
            MathUtils.checkOrder(val, OrderDirection.DECREASING, strict);
        }
    }

    public static double safeNorm(double[] v2) {
        double rdwarf = 3.834E-20;
        double rgiant = 1.304E19;
        double s1 = 0.0;
        double s2 = 0.0;
        double s3 = 0.0;
        double x1max = 0.0;
        double x3max = 0.0;
        double floatn = v2.length;
        double agiant = rgiant / floatn;
        for (int i2 = 0; i2 < v2.length; ++i2) {
            double xabs = Math.abs(v2[i2]);
            if (xabs < rdwarf || xabs > agiant) {
                double r2;
                if (xabs > rdwarf) {
                    if (xabs > x1max) {
                        r2 = x1max / xabs;
                        s1 = 1.0 + s1 * r2 * r2;
                        x1max = xabs;
                        continue;
                    }
                    r2 = xabs / x1max;
                    s1 += r2 * r2;
                    continue;
                }
                if (xabs > x3max) {
                    r2 = x3max / xabs;
                    s3 = 1.0 + s3 * r2 * r2;
                    x3max = xabs;
                    continue;
                }
                if (xabs == 0.0) continue;
                r2 = xabs / x3max;
                s3 += r2 * r2;
                continue;
            }
            s2 += xabs * xabs;
        }
        double norm = s1 != 0.0 ? x1max * Math.sqrt(s1 + s2 / x1max / x1max) : (s2 == 0.0 ? x3max * Math.sqrt(s3) : (s2 >= x3max ? Math.sqrt(s2 * (1.0 + x3max / s2 * (x3max * s3))) : Math.sqrt(x3max * (s2 / x3max + x3max * s3))));
        return norm;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OrderDirection {
        INCREASING,
        DECREASING;

    }
}

