/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.optimization.direct;

import java.util.Comparator;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.optimization.OptimizationException;
import org.apache.commons.math.optimization.RealConvergenceChecker;
import org.apache.commons.math.optimization.RealPointValuePair;
import org.apache.commons.math.optimization.direct.DirectSearchOptimizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiDirectional
extends DirectSearchOptimizer {
    private final double khi;
    private final double gamma;

    public MultiDirectional() {
        this.khi = 2.0;
        this.gamma = 0.5;
    }

    public MultiDirectional(double khi, double gamma) {
        this.khi = khi;
        this.gamma = gamma;
    }

    @Override
    protected void iterateSimplex(Comparator<RealPointValuePair> comparator) throws FunctionEvaluationException, OptimizationException, IllegalArgumentException {
        boolean converged;
        RealConvergenceChecker checker = this.getConvergenceChecker();
        do {
            this.incrementIterationsCounter();
            RealPointValuePair[] original = this.simplex;
            RealPointValuePair best = original[0];
            RealPointValuePair reflected = this.evaluateNewSimplex(original, 1.0, comparator);
            if (comparator.compare(reflected, best) < 0) {
                RealPointValuePair[] reflectedSimplex = this.simplex;
                RealPointValuePair expanded = this.evaluateNewSimplex(original, this.khi, comparator);
                if (comparator.compare(reflected, expanded) <= 0) {
                    this.simplex = reflectedSimplex;
                }
                return;
            }
            RealPointValuePair contracted = this.evaluateNewSimplex(original, this.gamma, comparator);
            if (comparator.compare(contracted, best) < 0) {
                return;
            }
            int iter = this.getIterations();
            converged = true;
            for (int i2 = 0; i2 < this.simplex.length; ++i2) {
                converged &= checker.converged(iter, original[i2], this.simplex[i2]);
            }
        } while (!converged);
    }

    private RealPointValuePair evaluateNewSimplex(RealPointValuePair[] original, double coeff, Comparator<RealPointValuePair> comparator) throws FunctionEvaluationException, OptimizationException {
        double[] xSmallest = original[0].getPointRef();
        int n2 = xSmallest.length;
        this.simplex = new RealPointValuePair[n2 + 1];
        this.simplex[0] = original[0];
        for (int i2 = 1; i2 <= n2; ++i2) {
            double[] xOriginal = original[i2].getPointRef();
            double[] xTransformed = new double[n2];
            for (int j2 = 0; j2 < n2; ++j2) {
                xTransformed[j2] = xSmallest[j2] + coeff * (xSmallest[j2] - xOriginal[j2]);
            }
            this.simplex[i2] = new RealPointValuePair(xTransformed, Double.NaN, false);
        }
        this.evaluateSimplex(comparator);
        return this.simplex[0];
    }
}

