/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.ode.nonstiff;

import org.apache.commons.math.ode.AbstractIntegrator;
import org.apache.commons.math.ode.DerivativeException;
import org.apache.commons.math.ode.FirstOrderDifferentialEquations;
import org.apache.commons.math.ode.IntegratorException;
import org.apache.commons.math.ode.nonstiff.RungeKuttaStepInterpolator;
import org.apache.commons.math.ode.sampling.AbstractStepInterpolator;
import org.apache.commons.math.ode.sampling.DummyStepInterpolator;
import org.apache.commons.math.ode.sampling.StepHandler;
import org.apache.commons.math.util.FastMath;

public abstract class RungeKuttaIntegrator
extends AbstractIntegrator {
    private final double[] c;
    private final double[][] a;
    private final double[] b;
    private final RungeKuttaStepInterpolator prototype;
    private final double step;

    protected RungeKuttaIntegrator(String name, double[] c2, double[][] a2, double[] b2, RungeKuttaStepInterpolator prototype, double step) {
        super(name);
        this.c = c2;
        this.a = a2;
        this.b = b2;
        this.prototype = prototype;
        this.step = FastMath.abs(step);
    }

    public double integrate(FirstOrderDifferentialEquations equations, double t0, double[] y0, double t2, double[] y) throws DerivativeException, IntegratorException {
        AbstractStepInterpolator interpolator;
        this.sanityChecks(equations, t0, y0, t2, y);
        this.setEquations(equations);
        this.resetEvaluations();
        boolean forward = t2 > t0;
        int stages = this.c.length + 1;
        if (y != y0) {
            System.arraycopy(y0, 0, y, 0, y0.length);
        }
        double[][] yDotK = new double[stages][];
        for (int i2 = 0; i2 < stages; ++i2) {
            yDotK[i2] = new double[y0.length];
        }
        double[] yTmp = new double[y0.length];
        double[] yDotTmp = new double[y0.length];
        if (this.requiresDenseOutput()) {
            RungeKuttaStepInterpolator rki = (RungeKuttaStepInterpolator)this.prototype.copy();
            rki.reinitialize(this, yTmp, yDotK, forward);
            interpolator = rki;
        } else {
            interpolator = new DummyStepInterpolator(yTmp, yDotK[stages - 1], forward);
        }
        interpolator.storeTime(t0);
        this.stepStart = t0;
        this.stepSize = forward ? this.step : -this.step;
        for (StepHandler handler : this.stepHandlers) {
            handler.reset();
        }
        this.setStateInitialized(false);
        this.isLastStep = false;
        do {
            boolean nextIsLast;
            interpolator.shift();
            this.computeDerivatives(this.stepStart, y, yDotK[0]);
            for (int k2 = 1; k2 < stages; ++k2) {
                for (int j2 = 0; j2 < y0.length; ++j2) {
                    double sum = this.a[k2 - 1][0] * yDotK[0][j2];
                    for (int l2 = 1; l2 < k2; ++l2) {
                        sum += this.a[k2 - 1][l2] * yDotK[l2][j2];
                    }
                    yTmp[j2] = y[j2] + this.stepSize * sum;
                }
                this.computeDerivatives(this.stepStart + this.c[k2 - 1] * this.stepSize, yTmp, yDotK[k2]);
            }
            for (int j3 = 0; j3 < y0.length; ++j3) {
                double sum = this.b[0] * yDotK[0][j3];
                for (int l3 = 1; l3 < stages; ++l3) {
                    sum += this.b[l3] * yDotK[l3][j3];
                }
                yTmp[j3] = y[j3] + this.stepSize * sum;
            }
            interpolator.storeTime(this.stepStart + this.stepSize);
            System.arraycopy(yTmp, 0, y, 0, y0.length);
            System.arraycopy(yDotK[stages - 1], 0, yDotTmp, 0, y0.length);
            this.stepStart = this.acceptStep(interpolator, y, yDotTmp, t2);
            if (this.isLastStep) continue;
            interpolator.storeTime(this.stepStart);
            double nextT = this.stepStart + this.stepSize;
            boolean bl = forward ? nextT >= t2 : (nextIsLast = nextT <= t2);
            if (!nextIsLast) continue;
            this.stepSize = t2 - this.stepStart;
        } while (!this.isLastStep);
        double stopTime = this.stepStart;
        this.stepStart = Double.NaN;
        this.stepSize = Double.NaN;
        return stopTime;
    }
}

