/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.flow;

import java.awt.geom.Point2D;
import org.apache.batik.gvt.flow.BlockInfo;
import org.apache.batik.gvt.flow.FlowRegions;
import org.apache.batik.gvt.flow.GlyphGroupInfo;
import org.apache.batik.gvt.flow.WordInfo;
import org.apache.batik.gvt.font.GVTGlyphVector;

public class LineInfo {
    FlowRegions fr;
    double lineHeight = -1.0;
    double ascent = -1.0;
    double descent = -1.0;
    double hLeading = -1.0;
    double baseline;
    int numGlyphs;
    int words = 0;
    int size = 0;
    GlyphGroupInfo[] ggis = null;
    int newSize = 0;
    GlyphGroupInfo[] newGGIS = null;
    int numRanges;
    double[] ranges;
    double[] rangeAdv;
    BlockInfo bi = null;
    boolean paraStart;
    boolean paraEnd;
    protected static final int FULL_WORD = 0;
    protected static final int FULL_ADV = 1;
    static final float MAX_COMPRESS = 0.1f;
    static final float COMRESS_SCALE = 3.0f;

    public LineInfo(FlowRegions fr, BlockInfo bi, boolean paraStart) {
        this.fr = fr;
        this.bi = bi;
        this.lineHeight = bi.getLineHeight();
        this.ascent = bi.getAscent();
        this.descent = bi.getDescent();
        this.hLeading = (this.lineHeight - (this.ascent + this.descent)) / 2.0;
        this.baseline = (float)(fr.getCurrentY() + this.hLeading + this.ascent);
        this.paraStart = paraStart;
        this.paraEnd = false;
        if (this.lineHeight > 0.0) {
            fr.newLineHeight(this.lineHeight);
            this.updateRangeInfo();
        }
    }

    public void setParaEnd(boolean paraEnd) {
        this.paraEnd = paraEnd;
    }

    public boolean addWord(WordInfo wi) {
        double nlh = wi.getLineHeight();
        if (nlh <= this.lineHeight) {
            return this.insertWord(wi);
        }
        this.fr.newLineHeight(nlh);
        if (!this.updateRangeInfo()) {
            if (this.lineHeight > 0.0) {
                this.fr.newLineHeight(this.lineHeight);
            }
            return false;
        }
        if (!this.insertWord(wi)) {
            if (this.lineHeight > 0.0) {
                this.setLineHeight(this.lineHeight);
            }
            return false;
        }
        this.lineHeight = nlh;
        if ((double)wi.getAscent() > this.ascent) {
            this.ascent = wi.getAscent();
        }
        if ((double)wi.getDescent() > this.descent) {
            this.descent = wi.getDescent();
        }
        this.hLeading = (nlh - (this.ascent + this.descent)) / 2.0;
        this.baseline = (float)(this.fr.getCurrentY() + this.hLeading + this.ascent);
        return true;
    }

    public boolean insertWord(WordInfo wi) {
        this.mergeGlyphGroups(wi);
        if (!this.assignGlyphGroupRanges(this.newSize, this.newGGIS)) {
            return false;
        }
        this.swapGlyphGroupInfo();
        return true;
    }

    public boolean assignGlyphGroupRanges(int ggSz, GlyphGroupInfo[] ggis) {
        int i2 = 0;
        for (int r2 = 0; r2 < this.numRanges; ++r2) {
            GlyphGroupInfo ggi;
            double range = this.ranges[2 * r2 + 1] - this.ranges[2 * r2];
            float adv = 0.0f;
            float rangeAdvance = 0.0f;
            while (i2 < ggSz) {
                ggi = ggis[i2];
                ggi.setRange(r2);
                adv = ggi.getAdvance();
                double delta = range - (double)(rangeAdvance + adv);
                if (delta < 0.0) break;
                ++i2;
                rangeAdvance += adv;
            }
            if (i2 == ggSz) {
                --i2;
                rangeAdvance -= adv;
            }
            ggi = ggis[i2];
            float ladv = ggi.getLastAdvance();
            while ((double)(rangeAdvance + ladv) > range) {
                ladv = 0.0f;
                if (--i2 < 0 || r2 != (ggi = ggis[i2]).getRange()) break;
                rangeAdvance -= ggi.getAdvance();
                ladv = ggi.getLastAdvance();
            }
            this.rangeAdv[r2] = rangeAdvance + ladv;
            if (++i2 != ggSz) continue;
            return true;
        }
        return false;
    }

    public boolean setLineHeight(double lh) {
        this.fr.newLineHeight(lh);
        if (this.updateRangeInfo()) {
            this.lineHeight = lh;
            return true;
        }
        if (this.lineHeight > 0.0) {
            this.fr.newLineHeight(this.lineHeight);
        }
        return false;
    }

    public double getCurrentY() {
        return this.fr.getCurrentY();
    }

    public boolean gotoY(double y) {
        if (this.fr.gotoY(y)) {
            return true;
        }
        if (this.lineHeight > 0.0) {
            this.updateRangeInfo();
        }
        this.baseline = (float)(this.fr.getCurrentY() + this.hLeading + this.ascent);
        return false;
    }

    protected boolean updateRangeInfo() {
        this.fr.resetRange();
        int nr = this.fr.getNumRangeOnLine();
        if (nr == 0) {
            return false;
        }
        this.numRanges = nr;
        if (this.ranges == null) {
            this.rangeAdv = new double[this.numRanges];
            this.ranges = new double[2 * this.numRanges];
        } else if (this.numRanges > this.rangeAdv.length) {
            int sz = 2 * this.rangeAdv.length;
            if (sz < this.numRanges) {
                sz = this.numRanges;
            }
            this.rangeAdv = new double[sz];
            this.ranges = new double[2 * sz];
        }
        int r2 = 0;
        while (r2 < this.numRanges) {
            double[] rangeBounds = this.fr.nextRange();
            double r0 = rangeBounds[0];
            if (r2 == 0) {
                double delta = this.bi.getLeftMargin();
                if (this.paraStart) {
                    double indent = this.bi.getIndent();
                    delta = delta < -indent ? 0.0 : (delta += indent);
                }
                r0 += delta;
            }
            double r1 = rangeBounds[1];
            if (r2 == this.numRanges - 1) {
                r1 -= (double)this.bi.getRightMargin();
            }
            this.ranges[2 * r2] = r0;
            this.ranges[2 * r2 + 1] = r1;
            ++r2;
        }
        return true;
    }

    protected void swapGlyphGroupInfo() {
        GlyphGroupInfo[] tmp = this.ggis;
        this.ggis = this.newGGIS;
        this.newGGIS = tmp;
        this.size = this.newSize;
        this.newSize = 0;
    }

    protected void mergeGlyphGroups(WordInfo wi) {
        int numGG = wi.getNumGlyphGroups();
        this.newSize = 0;
        if (this.ggis == null) {
            this.newSize = numGG;
            this.newGGIS = new GlyphGroupInfo[numGG];
            int i2 = 0;
            while (i2 < numGG) {
                this.newGGIS[i2] = wi.getGlyphGroup(i2);
                ++i2;
            }
        } else {
            int s2 = 0;
            int i3 = 0;
            GlyphGroupInfo nggi = wi.getGlyphGroup(i3);
            int nStart = nggi.getStart();
            GlyphGroupInfo oggi = this.ggis[this.size - 1];
            int oStart = oggi.getStart();
            this.newGGIS = LineInfo.assureSize(this.newGGIS, this.size + numGG);
            if (nStart < oStart) {
                oggi = this.ggis[s2];
                oStart = oggi.getStart();
                while (s2 < this.size && i3 < numGG) {
                    if (nStart < oStart) {
                        this.newGGIS[this.newSize++] = nggi;
                        if (++i3 >= numGG) continue;
                        nggi = wi.getGlyphGroup(i3);
                        nStart = nggi.getStart();
                        continue;
                    }
                    this.newGGIS[this.newSize++] = oggi;
                    if (++s2 >= this.size) continue;
                    oggi = this.ggis[s2];
                    oStart = oggi.getStart();
                }
            }
            while (s2 < this.size) {
                this.newGGIS[this.newSize++] = this.ggis[s2++];
            }
            while (i3 < numGG) {
                this.newGGIS[this.newSize++] = wi.getGlyphGroup(i3++);
            }
        }
    }

    public void layout() {
        int r2;
        if (this.size == 0) {
            return;
        }
        this.assignGlyphGroupRanges(this.size, this.ggis);
        GVTGlyphVector gv = this.ggis[0].getGlyphVector();
        boolean justType = false;
        double ggAdv = 0.0;
        double gAdv = 0.0;
        int[] rangeGG = new int[this.numRanges];
        int[] rangeG = new int[this.numRanges];
        GlyphGroupInfo[] rangeLastGGI = new GlyphGroupInfo[this.numRanges];
        GlyphGroupInfo ggi = this.ggis[0];
        int n2 = r2 = ggi.getRange();
        rangeGG[n2] = rangeGG[n2] + 1;
        int n3 = r2;
        rangeG[n3] = rangeG[n3] + ggi.getGlyphCount();
        int i2 = 1;
        while (i2 < this.size) {
            ggi = this.ggis[i2];
            r2 = ggi.getRange();
            if (rangeLastGGI[r2] == null || !rangeLastGGI[r2].getHideLast()) {
                int n4 = r2;
                rangeGG[n4] = rangeGG[n4] + 1;
            }
            rangeLastGGI[r2] = ggi;
            int n5 = r2;
            rangeG[n5] = rangeG[n5] + ggi.getGlyphCount();
            GlyphGroupInfo pggi = this.ggis[i2 - 1];
            int pr = pggi.getRange();
            if (r2 != pr) {
                int n6 = pr;
                rangeG[n6] = rangeG[n6] + (pggi.getLastGlyphCount() - pggi.getGlyphCount());
            }
            ++i2;
        }
        int n7 = r2;
        rangeG[n7] = rangeG[n7] + (ggi.getLastGlyphCount() - ggi.getGlyphCount());
        int currRange = -1;
        double locX = 0.0;
        double range = 0.0;
        double rAdv = 0.0;
        r2 = -1;
        ggi = null;
        int i3 = 0;
        while (i3 < this.size) {
            block20: {
                GlyphGroupInfo pggi;
                block19: {
                    pggi = ggi;
                    int prevRange = currRange;
                    ggi = this.ggis[i3];
                    currRange = ggi.getRange();
                    if (currRange == prevRange) break block19;
                    locX = this.ranges[2 * currRange];
                    range = this.ranges[2 * currRange + 1] - locX;
                    rAdv = this.rangeAdv[currRange];
                    int textAlign = this.bi.getTextAlignment();
                    if (this.paraEnd && textAlign == 3) {
                        textAlign = 0;
                    }
                    switch (textAlign) {
                        default: {
                            int numSp;
                            double delta = range - rAdv;
                            if (!justType) {
                                numSp = rangeGG[currRange] - 1;
                                if (numSp >= 1) {
                                    ggAdv = delta / (double)numSp;
                                    break;
                                }
                            } else {
                                numSp = rangeG[currRange] - 1;
                                if (numSp >= 1) {
                                    gAdv = delta / (double)numSp;
                                    break;
                                }
                            }
                            break block20;
                        }
                        case 0: {
                            break;
                        }
                        case 1: {
                            locX += (range - rAdv) / 2.0;
                            break;
                        }
                        case 2: {
                            locX += range - rAdv;
                        }
                    }
                    break block20;
                }
                if (pggi != null && pggi.getHideLast()) {
                    gv.setGlyphVisible(pggi.getEnd(), false);
                }
            }
            int start = ggi.getStart();
            int end = ggi.getEnd();
            boolean[] hide = ggi.getHide();
            Point2D p2d = gv.getGlyphPosition(start);
            double deltaX = p2d.getX();
            double advAdj = 0.0;
            int g2 = start;
            while (g2 <= end) {
                Point2D np2d = gv.getGlyphPosition(g2 + 1);
                if (hide[g2 - start]) {
                    gv.setGlyphVisible(g2, false);
                    advAdj += np2d.getX() - p2d.getX();
                } else {
                    gv.setGlyphVisible(g2, true);
                }
                p2d.setLocation(p2d.getX() - deltaX - advAdj + locX, p2d.getY() + this.baseline);
                gv.setGlyphPosition(g2, p2d);
                p2d = np2d;
                advAdj -= gAdv;
                ++g2;
            }
            locX = ggi.getHideLast() ? (locX += (double)ggi.getAdvance() - advAdj) : (locX += (double)ggi.getAdvance() - advAdj + ggAdv);
            ++i3;
        }
    }

    public static GlyphGroupInfo[] assureSize(GlyphGroupInfo[] ggis, int sz) {
        if (ggis == null) {
            if (sz < 10) {
                sz = 10;
            }
            return new GlyphGroupInfo[sz];
        }
        if (sz <= ggis.length) {
            return ggis;
        }
        int nsz = ggis.length * 2;
        if (nsz < sz) {
            nsz = sz;
        }
        return new GlyphGroupInfo[nsz];
    }
}

