/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.tribble.util.popgen;

public final class HardyWeinbergCalculation {
    private HardyWeinbergCalculation() {
    }

    public static double hwCalculate(int obsAA, int obsAB, int obsBB) {
        int diplotypes = obsAA + obsAB + obsBB;
        int rare = obsAA * 2 + obsAB;
        int hets = obsAB;
        if (rare > diplotypes) {
            rare = 2 * diplotypes - rare;
        }
        if (hets > rare) {
            return -1.0;
        }
        double[] tailProbs = new double[rare + 1];
        for (int z = 0; z < tailProbs.length; ++z) {
            tailProbs[z] = 0.0;
        }
        int mid = (int)((long)rare * (long)(2 * diplotypes - rare) / (long)(2 * diplotypes));
        if ((rare & 1 ^ mid & 1) != 0) {
            ++mid;
        }
        int het = mid;
        int hom_r = (rare - mid) / 2;
        int hom_c = diplotypes - het - hom_r;
        tailProbs[mid] = 1.0;
        double sum = tailProbs[mid];
        for (het = mid; het > 1; het -= 2) {
            tailProbs[het - 2] = tailProbs[het] * (double)het * ((double)het - 1.0) / (4.0 * ((double)hom_r + 1.0) * ((double)hom_c + 1.0));
            sum += tailProbs[het - 2];
            ++hom_r;
            ++hom_c;
        }
        het = mid;
        hom_r = (rare - mid) / 2;
        hom_c = diplotypes - het - hom_r;
        for (het = mid; het <= rare - 2; het += 2) {
            tailProbs[het + 2] = tailProbs[het] * 4.0 * (double)hom_r * (double)hom_c / (((double)het + 2.0) * ((double)het + 1.0));
            sum += tailProbs[het + 2];
            --hom_r;
            --hom_c;
        }
        int z = 0;
        while (z < tailProbs.length) {
            int n2 = z++;
            tailProbs[n2] = tailProbs[n2] / sum;
        }
        double top = tailProbs[hets];
        for (int i2 = hets + 1; i2 <= rare; ++i2) {
            top += tailProbs[i2];
        }
        double otherSide = tailProbs[hets];
        for (int i3 = hets - 1; i3 >= 0; --i3) {
            otherSide += tailProbs[i3];
        }
        if (top > 0.5 && otherSide > 0.5) {
            return 1.0;
        }
        if (top < otherSide) {
            return top * 2.0;
        }
        return otherSide * 2.0;
    }
}

