/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.SAMException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class TestUtil {
    public static final String BASE_URL_FOR_HTTP_TESTS = "https://personal.broadinstitute.org/picard/testdata/";

    public static File getTempDirectory(String prefix, String suffix) {
        File tempDirectory;
        try {
            tempDirectory = File.createTempFile(prefix, suffix);
        }
        catch (IOException e2) {
            throw new SAMException("Failed to create temporary file.", e2);
        }
        if (!tempDirectory.delete()) {
            throw new SAMException("Failed to delete file: " + tempDirectory);
        }
        if (!tempDirectory.mkdir()) {
            throw new SAMException("Failed to make directory: " + tempDirectory);
        }
        tempDirectory.deleteOnExit();
        return tempDirectory;
    }

    @Deprecated
    public static File getTempDirecory(String prefix, String suffix) {
        return TestUtil.getTempDirectory(prefix, suffix);
    }

    public static void recursiveDelete(File directory) {
        for (File f2 : directory.listFiles()) {
            if (f2.isDirectory()) {
                TestUtil.recursiveDelete(f2);
            }
            f2.delete();
        }
    }

    public static <T extends Serializable> T serializeAndDeserialize(T input) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream byteArrayStream = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(byteArrayStream);
        out.writeObject(input);
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(byteArrayStream.toByteArray()));
        Serializable result = (Serializable)in.readObject();
        out.close();
        in.close();
        return (T)result;
    }
}

