/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.AlignmentBlock;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.util.AbstractLocusInfo;
import htsjdk.samtools.util.AbstractLocusIterator;
import htsjdk.samtools.util.AbstractRecordAndOffset;
import htsjdk.samtools.util.IntervalList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SamLocusIterator
extends AbstractLocusIterator<RecordAndOffset, LocusInfo> {
    public SamLocusIterator(SamReader samReader) {
        this(samReader, null);
    }

    public SamLocusIterator(SamReader samReader, IntervalList intervalList) {
        this(samReader, intervalList, samReader.hasIndex());
    }

    public SamLocusIterator(SamReader samReader, IntervalList intervalList, boolean useIndex) {
        super(samReader, intervalList, useIndex);
    }

    @Override
    void accumulateSamRecord(SAMRecord rec) {
        int accOffset = this.getAccumulatorOffset(rec);
        int minQuality = this.getQualityScoreCutoff();
        boolean dontCheckQualities = minQuality == 0;
        byte[] baseQualities = dontCheckQualities ? null : rec.getBaseQualities();
        for (AlignmentBlock alignmentBlock : rec.getAlignmentBlocks()) {
            int readStart = alignmentBlock.getReadStart();
            int refStart = alignmentBlock.getReferenceStart();
            int blockLength = alignmentBlock.getLength();
            for (int i2 = 0; i2 < blockLength; ++i2) {
                int readOffset = readStart + i2 - 1;
                if (!dontCheckQualities && baseQualities.length != 0 && baseQualities[readOffset] < minQuality) continue;
                int refOffset = refStart + i2 - accOffset;
                ((LocusInfo)this.accumulator.get(refOffset)).add(new RecordAndOffset(rec, readOffset));
            }
        }
    }

    @Override
    void accumulateIndels(SAMRecord rec) {
        List<CigarElement> cigar = rec.getCigar().getCigarElements();
        int readBase = 0;
        int refBase = rec.getAlignmentStart() - this.getAccumulatorOffset(rec);
        for (int elementIndex = 0; elementIndex < cigar.size(); ++elementIndex) {
            CigarElement e2 = cigar.get(elementIndex);
            CigarOperator operator = e2.getOperator();
            if (operator.equals((Object)CigarOperator.I)) {
                System.err.println("");
                ((LocusInfo)this.accumulator.get(refBase - 1)).addInserted(rec, readBase);
                readBase += e2.getLength();
                continue;
            }
            if (operator.equals((Object)CigarOperator.D)) {
                for (int i2 = 0; i2 < e2.getLength(); ++i2) {
                    ((LocusInfo)this.accumulator.get(refBase + i2)).addDeleted(rec, readBase - 1);
                }
                refBase += e2.getLength();
                continue;
            }
            if (operator.consumesReadBases()) {
                readBase += e2.getLength();
            }
            if (!operator.consumesReferenceBases()) continue;
            refBase += e2.getLength();
        }
    }

    private int getAccumulatorOffset(SAMRecord rec) {
        int insOffset;
        SAMSequenceRecord ref = this.getReferenceSequence(rec.getReferenceIndex());
        int alignmentStart = rec.getAlignmentStart();
        int alignmentEnd = rec.getAlignmentEnd();
        int alignmentLength = alignmentEnd - alignmentStart;
        int n2 = insOffset = this.includeIndels && SamLocusIterator.startWithInsertion(rec.getCigar()) ? 1 : 0;
        if (insOffset == 1 && this.accumulator.isEmpty()) {
            this.accumulator.add(new LocusInfo(ref, alignmentStart - 1));
        }
        for (int i2 = this.accumulator.size(); i2 <= alignmentLength + insOffset; ++i2) {
            this.accumulator.add(new LocusInfo(ref, alignmentStart + i2 - insOffset));
        }
        return alignmentStart - insOffset;
    }

    @Override
    RecordAndOffset createRecordAndOffset(SAMRecord rec, int readOffset, int length, int refPos) {
        return new RecordAndOffset(rec, readOffset);
    }

    @Override
    LocusInfo createLocusInfo(SAMSequenceRecord referenceSequence, int lastPosition) {
        return new LocusInfo(referenceSequence, lastPosition);
    }

    public static final class LocusInfo
    extends AbstractLocusInfo<RecordAndOffset> {
        private List<RecordAndOffset> deletedInRecord = null;
        private List<RecordAndOffset> insertedInRecord = null;

        public LocusInfo(SAMSequenceRecord referenceSequence, int position) {
            super(referenceSequence, position);
        }

        public void addDeleted(SAMRecord read, int previousPosition) {
            if (this.deletedInRecord == null) {
                this.deletedInRecord = new ArrayList<RecordAndOffset>();
            }
            this.deletedInRecord.add(new RecordAndOffset(read, previousPosition));
        }

        public void addInserted(SAMRecord read, int firstPosition) {
            if (this.insertedInRecord == null) {
                this.insertedInRecord = new ArrayList<RecordAndOffset>();
            }
            this.insertedInRecord.add(new RecordAndOffset(read, firstPosition));
        }

        public List<RecordAndOffset> getDeletedInRecord() {
            return this.deletedInRecord == null ? Collections.emptyList() : Collections.unmodifiableList(this.deletedInRecord);
        }

        public List<RecordAndOffset> getInsertedInRecord() {
            return this.insertedInRecord == null ? Collections.emptyList() : Collections.unmodifiableList(this.insertedInRecord);
        }

        @Override
        public int size() {
            return super.size() + (this.deletedInRecord == null ? 0 : this.deletedInRecord.size());
        }

        @Override
        public boolean isEmpty() {
            return !(!this.getRecordAndOffsets().isEmpty() || this.deletedInRecord != null && !this.deletedInRecord.isEmpty() || this.insertedInRecord != null && !this.insertedInRecord.isEmpty());
        }
    }

    public static class RecordAndOffset
    extends AbstractRecordAndOffset {
        public RecordAndOffset(SAMRecord record, int offset) {
            super(record, offset);
        }
    }
}

