/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;

public final class Log {
    private static LogLevel globalLogLevel = LogLevel.INFO;
    private final Class<?> clazz;
    private final String className;
    private final PrintStream out = System.err;

    private Log(Class<?> clazz) {
        this.clazz = clazz;
        this.className = clazz.getSimpleName();
    }

    public static Log getInstance(Class<?> clazz) {
        return new Log(clazz);
    }

    public static void setGlobalLogLevel(LogLevel logLevel) {
        globalLogLevel = logLevel;
    }

    public static final boolean isEnabled(LogLevel level) {
        return level.ordinal() <= globalLogLevel.ordinal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void emit(LogLevel level, Throwable throwable, Object ... parts) {
        if (Log.isEnabled(level)) {
            StringBuffer tmp = new StringBuffer();
            tmp.append(level.name()).append('\t').append(this.getTimestamp()).append('\t').append(this.className).append('\t');
            for (Object part : parts) {
                if (part != null && part.getClass().isArray()) {
                    Class<?> component = part.getClass().getComponentType();
                    if (component.equals(Boolean.TYPE)) {
                        tmp.append(Arrays.toString((boolean[])part));
                        continue;
                    }
                    if (component.equals(Byte.TYPE)) {
                        tmp.append(Arrays.toString((byte[])part));
                        continue;
                    }
                    if (component.equals(Character.TYPE)) {
                        tmp.append(Arrays.toString((char[])part));
                        continue;
                    }
                    if (component.equals(Double.TYPE)) {
                        tmp.append(Arrays.toString((double[])part));
                        continue;
                    }
                    if (component.equals(Float.TYPE)) {
                        tmp.append(Arrays.toString((float[])part));
                        continue;
                    }
                    if (component.equals(Integer.TYPE)) {
                        tmp.append(Arrays.toString((int[])part));
                        continue;
                    }
                    if (component.equals(Long.TYPE)) {
                        tmp.append(Arrays.toString((long[])part));
                        continue;
                    }
                    if (component.equals(Short.TYPE)) {
                        tmp.append(Arrays.toString((short[])part));
                        continue;
                    }
                    tmp.append(Arrays.toString((Object[])part));
                    continue;
                }
                tmp.append(part);
            }
            if (throwable != null) {
                PrintStream printStream = this.out;
                synchronized (printStream) {
                    this.out.println(tmp.toString());
                    throwable.printStackTrace(this.out);
                }
            } else {
                this.out.println(tmp.toString());
            }
        }
    }

    protected String getTimestamp() {
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return fmt.format(new Date());
    }

    public final void error(Throwable throwable, Object ... messageParts) {
        this.emit(LogLevel.ERROR, throwable, messageParts);
    }

    public final void warn(Throwable throwable, Object ... messageParts) {
        this.emit(LogLevel.WARNING, throwable, messageParts);
    }

    public final void info(Throwable throwable, Object ... messageParts) {
        this.emit(LogLevel.INFO, throwable, messageParts);
    }

    public final void debug(Throwable throwable, Object ... messageParts) {
        this.emit(LogLevel.DEBUG, throwable, messageParts);
    }

    public final void error(Object ... messageParts) {
        this.emit(LogLevel.ERROR, null, messageParts);
    }

    public final void warn(Object ... messageParts) {
        this.emit(LogLevel.WARNING, null, messageParts);
    }

    public final void info(Object ... messageParts) {
        this.emit(LogLevel.INFO, null, messageParts);
    }

    public final void debug(Object ... messageParts) {
        this.emit(LogLevel.DEBUG, null, messageParts);
    }

    public static enum LogLevel {
        ERROR,
        WARNING,
        INFO,
        DEBUG;

    }
}

