/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.Defaults;
import htsjdk.samtools.util.LineReader;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;

public class BufferedLineReader
implements LineReader {
    private final BufferedReader reader;
    private int lineNumber = 0;
    private String peekedLine;

    public BufferedLineReader(InputStream is) {
        this(is, Defaults.NON_ZERO_BUFFER_SIZE);
    }

    public BufferedLineReader(InputStream is, int bufferSize) {
        this.reader = new BufferedReader(new InputStreamReader(is, Charset.forName("UTF-8")), bufferSize);
    }

    @Override
    public String readLine() {
        ++this.lineNumber;
        try {
            String ret;
            if (this.peekedLine != null) {
                ret = this.peekedLine;
                this.peekedLine = null;
            } else {
                ret = this.reader.readLine();
            }
            return ret;
        }
        catch (IOException e2) {
            throw new RuntimeIOException(e2);
        }
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public int peek() {
        if (this.peekedLine == null) {
            try {
                this.peekedLine = this.reader.readLine();
            }
            catch (IOException e2) {
                throw new RuntimeIOException(e2);
            }
        }
        if (this.peekedLine == null) {
            return -1;
        }
        if (this.peekedLine.isEmpty()) {
            return 10;
        }
        return this.peekedLine.charAt(0);
    }

    @Override
    public void close() {
        this.peekedLine = null;
        try {
            this.reader.close();
        }
        catch (IOException e2) {
            throw new RuntimeIOException(e2);
        }
    }
}

