/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.util.ProgressLoggerInterface;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public abstract class AbstractProgressLogger
implements ProgressLoggerInterface {
    private final int n;
    private final String verb;
    private final String noun;
    private final long startTime = System.currentTimeMillis();
    private final NumberFormat fmt = new DecimalFormat("#,###");
    private final NumberFormat timeFmt = new DecimalFormat("00");
    private long processed = 0L;
    private long lastStartTime = -1L;

    protected AbstractProgressLogger(String noun, String verb, int n2) {
        this.noun = noun;
        this.verb = verb;
        this.n = n2;
    }

    protected abstract void log(String ... var1);

    @Override
    public synchronized boolean record(String chrom, int pos) {
        if (this.lastStartTime == -1L) {
            this.lastStartTime = System.currentTimeMillis();
        }
        if (++this.processed % (long)this.n == 0L) {
            long now = System.currentTimeMillis();
            long lastPeriodSeconds = (now - this.lastStartTime) / 1000L;
            this.lastStartTime = now;
            long seconds = (System.currentTimeMillis() - this.startTime) / 1000L;
            String elapsed = this.formatElapseTime(seconds);
            String period = this.pad(this.fmt.format(lastPeriodSeconds), 4);
            String processed = this.pad(this.fmt.format(this.processed), 13);
            String readInfo = chrom == null ? "*/*" : chrom + ":" + this.fmt.format(pos);
            this.log(this.verb, " ", processed, " " + this.noun + ".  Elapsed time: ", elapsed, "s.  Time for last ", this.fmt.format(this.n), ": ", period, "s.  Last read position: ", readInfo);
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean record(SAMRecord rec) {
        if ("*".equals(rec.getReferenceName())) {
            return this.record(null, 0);
        }
        return this.record(rec.getReferenceName(), rec.getAlignmentStart());
    }

    @Override
    public boolean record(SAMRecord ... recs) {
        boolean triggered = false;
        for (SAMRecord rec : recs) {
            triggered = this.record(rec) || triggered;
        }
        return triggered;
    }

    public synchronized long getCount() {
        return this.processed;
    }

    public long getElapsedSeconds() {
        return (System.currentTimeMillis() - this.startTime) / 1000L;
    }

    private String pad(String in, int length) {
        while (in.length() < length) {
            in = " " + in;
        }
        return in;
    }

    private String formatElapseTime(long seconds) {
        long s2 = seconds % 60L;
        long allMinutes = seconds / 60L;
        long m2 = allMinutes % 60L;
        long h2 = allMinutes / 60L;
        return this.timeFmt.format(h2) + ":" + this.timeFmt.format(m2) + ":" + this.timeFmt.format(s2);
    }
}

