/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.reference;

import htsjdk.samtools.reference.FastaSequenceFile;
import htsjdk.samtools.reference.IndexedFastaSequenceFile;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;

public class ReferenceSequenceFileFactory {
    public static final Set<String> FASTA_EXTENSIONS = new HashSet<String>(){
        {
            this.add(".fasta");
            this.add(".fasta.gz");
            this.add(".fa");
            this.add(".fa.gz");
            this.add(".fna");
            this.add(".fna.gz");
            this.add(".txt");
            this.add(".txt.gz");
        }
    };

    public static ReferenceSequenceFile getReferenceSequenceFile(File file) {
        return ReferenceSequenceFileFactory.getReferenceSequenceFile(file, true);
    }

    public static ReferenceSequenceFile getReferenceSequenceFile(File file, boolean truncateNamesAtWhitespace) {
        return ReferenceSequenceFileFactory.getReferenceSequenceFile(file, truncateNamesAtWhitespace, true);
    }

    public static ReferenceSequenceFile getReferenceSequenceFile(File file, boolean truncateNamesAtWhitespace, boolean preferIndexed) {
        return ReferenceSequenceFileFactory.getReferenceSequenceFile(file.toPath(), truncateNamesAtWhitespace, preferIndexed);
    }

    public static ReferenceSequenceFile getReferenceSequenceFile(Path path) {
        return ReferenceSequenceFileFactory.getReferenceSequenceFile(path, true);
    }

    public static ReferenceSequenceFile getReferenceSequenceFile(Path path, boolean truncateNamesAtWhitespace) {
        return ReferenceSequenceFileFactory.getReferenceSequenceFile(path, truncateNamesAtWhitespace, true);
    }

    public static ReferenceSequenceFile getReferenceSequenceFile(Path path, boolean truncateNamesAtWhitespace, boolean preferIndexed) {
        ReferenceSequenceFileFactory.getFastaExtension(path);
        if (truncateNamesAtWhitespace && preferIndexed && IndexedFastaSequenceFile.canCreateIndexedFastaReader(path)) {
            try {
                return new IndexedFastaSequenceFile(path);
            }
            catch (FileNotFoundException e2) {
                throw new IllegalStateException("Should never happen, because existence of files has been checked.", e2);
            }
        }
        return new FastaSequenceFile(path, truncateNamesAtWhitespace);
    }

    public static File getDefaultDictionaryForReferenceSequence(File file) {
        return ReferenceSequenceFileFactory.getDefaultDictionaryForReferenceSequence(file.toPath()).toFile();
    }

    public static Path getDefaultDictionaryForReferenceSequence(Path path) {
        String name = path.getFileName().toString();
        int extensionIndex = name.length() - ReferenceSequenceFileFactory.getFastaExtension(path).length();
        return path.resolveSibling(name.substring(0, extensionIndex) + ".dict");
    }

    public static String getFastaExtension(Path path) {
        String name = path.getFileName().toString();
        return FASTA_EXTENSIONS.stream().filter(name::endsWith).findFirst().orElseGet(() -> {
            throw new IllegalArgumentException("File is not a supported reference file type: " + path.toAbsolutePath());
        });
    }

    public static Path getFastaIndexFileName(Path fastaFile) {
        return fastaFile.resolveSibling(fastaFile.getFileName() + ".fai");
    }
}

