/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.reference;

import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMTextHeaderCodec;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import htsjdk.samtools.reference.ReferenceSequenceFileFactory;
import htsjdk.samtools.util.BufferedLineReader;
import htsjdk.samtools.util.IOUtil;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;

abstract class AbstractFastaSequenceFile
implements ReferenceSequenceFile {
    private final Path path;
    protected SAMSequenceDictionary sequenceDictionary;

    AbstractFastaSequenceFile(File file) {
        this(file == null ? null : file.toPath());
    }

    AbstractFastaSequenceFile(Path path) {
        this.path = path;
        Path dictionary = AbstractFastaSequenceFile.findSequenceDictionary(path);
        if (dictionary != null) {
            IOUtil.assertFileIsReadable(dictionary);
            try {
                SAMTextHeaderCodec codec = new SAMTextHeaderCodec();
                BufferedLineReader reader = new BufferedLineReader(Files.newInputStream(dictionary, new OpenOption[0]));
                SAMFileHeader header = codec.decode(reader, dictionary.toString());
                if (header.getSequenceDictionary() != null && !header.getSequenceDictionary().isEmpty()) {
                    this.sequenceDictionary = header.getSequenceDictionary();
                }
                reader.close();
            }
            catch (Exception e2) {
                throw new SAMException("Could not open sequence dictionary file: " + dictionary, e2);
            }
        }
    }

    protected static File findSequenceDictionary(File file) {
        if (file == null) {
            return null;
        }
        Path dictionary = AbstractFastaSequenceFile.findSequenceDictionary(file.toPath());
        if (dictionary == null) {
            return null;
        }
        return dictionary.toFile();
    }

    protected static Path findSequenceDictionary(Path path) {
        if (path == null) {
            return null;
        }
        Path dictionary = ReferenceSequenceFileFactory.getDefaultDictionaryForReferenceSequence(path);
        path.toAbsolutePath();
        if (Files.exists(dictionary, new LinkOption[0])) {
            return dictionary;
        }
        Path dictionaryExt = path.resolveSibling(path.getFileName().toString() + ".dict");
        if (Files.exists(dictionaryExt, new LinkOption[0])) {
            return dictionaryExt;
        }
        return null;
    }

    protected Path getPath() {
        return this.path;
    }

    @Override
    public SAMSequenceDictionary getSequenceDictionary() {
        return this.sequenceDictionary;
    }

    protected String getAbsolutePath() {
        return this.path.toAbsolutePath().toString();
    }

    @Override
    public String toString() {
        return this.getAbsolutePath();
    }

    @Override
    public boolean isIndexed() {
        return false;
    }

    @Override
    public ReferenceSequence getSequence(String contig) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ReferenceSequence getSubsequenceAt(String contig, long start, long stop) {
        throw new UnsupportedOperationException("Index does not appear to exist for " + this.getAbsolutePath() + ".  samtools faidx can be used to create an index");
    }
}

