/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.metrics;

import htsjdk.samtools.SAMException;
import htsjdk.samtools.util.FormatUtil;
import java.lang.reflect.Field;

public class MetricBase {
    public boolean equals(Object o2) {
        if (o2 == null) {
            return false;
        }
        if (o2.getClass() != this.getClass()) {
            return false;
        }
        FormatUtil formatter = new FormatUtil();
        for (Field f2 : this.getClass().getFields()) {
            try {
                Object lhs = f2.get(this);
                Object rhs = f2.get(o2);
                if (lhs == null) {
                    if (rhs == null) continue;
                    return false;
                }
                if (formatter.format(lhs).equals(formatter.format(rhs))) continue;
                return false;
            }
            catch (IllegalAccessException iae) {
                throw new SAMException("Could not read field " + f2.getName() + " from a " + this.getClass().getSimpleName());
            }
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        FormatUtil formatter = new FormatUtil();
        for (Field f2 : this.getClass().getFields()) {
            try {
                Object value = f2.get(this);
                value = formatter.format(value);
                int fieldHash = value != null ? value.hashCode() : 0;
                result = 31 * result + fieldHash;
            }
            catch (IllegalAccessException e2) {
                throw new SAMException("Could not read field " + f2.getName() + " from a " + this.getClass().getSimpleName());
            }
        }
        return result;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        FormatUtil formatter = new FormatUtil();
        for (Field f2 : this.getClass().getFields()) {
            try {
                buffer.append(f2.getName());
                buffer.append('\t');
                buffer.append(formatter.format(f2.get(this)));
                buffer.append('\n');
            }
            catch (IllegalAccessException iae) {
                throw new SAMException("Could not read field " + f2.getName() + " from a " + this.getClass().getSimpleName());
            }
        }
        return buffer.toString();
    }
}

