/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.reader;

import htsjdk.samtools.cram.CRAMException;
import htsjdk.samtools.cram.common.IntHashMap;
import htsjdk.samtools.cram.encoding.BitCodec;
import htsjdk.samtools.cram.encoding.DataSeries;
import htsjdk.samtools.cram.encoding.DataSeriesMap;
import htsjdk.samtools.cram.encoding.DataSeriesType;
import htsjdk.samtools.cram.encoding.Encoding;
import htsjdk.samtools.cram.encoding.EncodingFactory;
import htsjdk.samtools.cram.encoding.reader.AbstractReader;
import htsjdk.samtools.cram.encoding.reader.CramRecordReader;
import htsjdk.samtools.cram.encoding.reader.DataReader;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.structure.CompressionHeader;
import htsjdk.samtools.cram.structure.EncodingID;
import htsjdk.samtools.cram.structure.EncodingKey;
import htsjdk.samtools.cram.structure.EncodingParams;
import htsjdk.samtools.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.TreeMap;

public class DataReaderFactory {
    private static Log log = Log.getInstance(DataReaderFactory.class);
    private static final boolean collectStats = false;

    public AbstractReader buildReader(AbstractReader reader, BitInputStream bitInputStream, Map<Integer, InputStream> inputMap, CompressionHeader header, int refId) throws IllegalArgumentException {
        reader.captureReadNames = header.readNamesIncluded;
        reader.refId = refId;
        reader.APDelta = header.APDelta;
        for (Field field : reader.getClass().getFields()) {
            DataSeriesMap dataSeriesMap;
            String name;
            if (field.isAnnotationPresent(DataSeries.class)) {
                DataSeries dataSeries = field.getAnnotation(DataSeries.class);
                EncodingKey key = dataSeries.key();
                DataSeriesType type = dataSeries.type();
                if (header.encodingMap.get((Object)key) != null) {
                    try {
                        field.set(reader, this.createReader(type, header.encodingMap.get((Object)key), bitInputStream, inputMap));
                    }
                    catch (IllegalAccessException e2) {
                        throw new CRAMException(e2);
                    }
                }
            }
            if (!field.isAnnotationPresent(DataSeriesMap.class) || !"TAG".equals(name = (dataSeriesMap = field.getAnnotation(DataSeriesMap.class)).name())) continue;
            IntHashMap map = new IntHashMap();
            for (Integer key : header.tMap.keySet()) {
                EncodingParams params = header.tMap.get(key);
                DataReader tagReader = this.createReader(DataSeriesType.BYTE_ARRAY, params, bitInputStream, inputMap);
                map.put(key, tagReader);
            }
            try {
                field.set(reader, map);
            }
            catch (IllegalAccessException e3) {
                throw new CRAMException(e3);
            }
        }
        reader.tagIdDictionary = header.dictionary;
        return reader;
    }

    private <T> DataReader<T> createReader(DataSeriesType valueType2, EncodingParams params, BitInputStream bitInputStream, Map<Integer, InputStream> inputMap) {
        if (params.id == EncodingID.NULL) {
            return DataReaderFactory.buildNullReader(valueType2);
        }
        EncodingFactory encodingFactory = new EncodingFactory();
        Encoding encoding = encodingFactory.createEncoding(valueType2, params.id);
        if (encoding == null) {
            throw new RuntimeException("Encoding not found for value type " + valueType2.name() + ", id=" + (Object)((Object)params.id));
        }
        encoding.fromByteArray(params.params);
        return new DefaultDataReader(encoding.buildCodec(inputMap, null), bitInputStream);
    }

    private static <T> DataReader<T> buildNullReader(DataSeriesType valueType2) {
        switch (valueType2) {
            case BYTE: {
                return new SingleValueReader<Byte>((byte)0);
            }
            case INT: {
                return new SingleValueReader<Integer>(0);
            }
            case LONG: {
                return new SingleValueReader<Long>(0L);
            }
            case BYTE_ARRAY: {
                return new SingleValueReader<byte[]>(new byte[0]);
            }
        }
        throw new RuntimeException("Unknown data type: " + valueType2.name());
    }

    public Map<String, DataReaderWithStats> getStats(CramRecordReader reader) throws IllegalArgumentException, IllegalAccessException {
        TreeMap<String, DataReaderWithStats> map = new TreeMap<String, DataReaderWithStats>();
        return map;
    }

    public static class DataReaderWithStats<T>
    implements DataReader<T> {
        public long nanos = 0L;
        final DataReader<T> delegate;

        public DataReaderWithStats(DataReader<T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public T readData() throws IOException {
            long time = System.nanoTime();
            T value = this.delegate.readData();
            this.nanos += System.nanoTime() - time;
            return value;
        }

        @Override
        public T readDataArray(int length) throws IOException {
            long time = System.nanoTime();
            T value = this.delegate.readDataArray(length);
            this.nanos += System.nanoTime() - time;
            return value;
        }
    }

    private static class SingleValueReader<T>
    implements DataReader<T> {
        private final T value;

        public SingleValueReader(T value) {
            this.value = value;
        }

        @Override
        public T readData() throws IOException {
            return this.value;
        }

        @Override
        public T readDataArray(int length) {
            return this.value;
        }
    }

    private static class DefaultDataReader<T>
    implements DataReader<T> {
        private final BitCodec<T> codec;
        private final BitInputStream bitInputStream;

        public DefaultDataReader(BitCodec<T> codec, BitInputStream bitInputStream) {
            this.codec = codec;
            this.bitInputStream = bitInputStream;
        }

        @Override
        public T readData() throws IOException {
            return this.codec.read(this.bitInputStream);
        }

        @Override
        public T readDataArray(int length) throws IOException {
            return this.codec.read(this.bitInputStream, length);
        }
    }
}

