/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.rans;

import java.nio.ByteBuffer;

class Decoding {
    Decoding() {
    }

    static void RansDecSymbolInit(RansDecSymbol symbol, int start, int freq) {
        assert (start <= 65536);
        assert (freq <= 65536 - start);
        symbol.start = start;
        symbol.freq = freq;
    }

    private static int RansDecAdvanceStep(int r2, int start, int freq, int scale_bits) {
        int mask = (1 << scale_bits) - 1;
        return freq * (r2 >> scale_bits) + (r2 & mask) - start;
    }

    static int RansDecAdvanceSymbolStep(int r2, RansDecSymbol sym, int scale_bits) {
        return Decoding.RansDecAdvanceStep(r2, sym.start, sym.freq, scale_bits);
    }

    static int RansDecGet(int r2, int scale_bits) {
        return r2 & (1 << scale_bits) - 1;
    }

    static int RansDecAdvanceSymbol(int r2, ByteBuffer pptr, RansDecSymbol sym, int scale_bits) {
        return Decoding.RansDecAdvance(r2, pptr, sym.start, sym.freq, scale_bits);
    }

    private static int RansDecAdvance(int r2, ByteBuffer pptr, int start, int freq, int scale_bits) {
        int mask = (1 << scale_bits) - 1;
        if ((r2 = freq * (r2 >> scale_bits) + (r2 & mask) - start) < 0x800000) {
            int b2;
            while ((r2 = r2 << 8 | (b2 = 0xFF & pptr.get())) < 0x800000) {
            }
        }
        return r2;
    }

    static int RansDecRenormalize(int r2, ByteBuffer pptr) {
        if (r2 < 0x800000) {
            while ((r2 = r2 << 8 | 0xFF & pptr.get()) < 0x800000) {
            }
        }
        return r2;
    }

    static class RansDecSymbol {
        int start;
        int freq;

        RansDecSymbol() {
        }
    }

    static class AriDecoder {
        final FC[] fc = new FC[256];
        byte[] R;

        AriDecoder() {
        }
    }

    static class FC {
        int F;
        int C;

        FC() {
        }
    }
}

