/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.huffman.codec;

import htsjdk.samtools.cram.common.MutableInt;
import htsjdk.samtools.cram.encoding.huffman.HuffmanCode;
import htsjdk.samtools.cram.encoding.huffman.HuffmanTree;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

class HuffmanParamsCalculator {
    private final HashMap<Integer, MutableInt> countMap = new HashMap();
    private int[] values = new int[0];
    private int[] bitLens = new int[0];

    HuffmanParamsCalculator() {
    }

    public void add(int value) {
        MutableInt counter = this.countMap.get(value);
        if (counter == null) {
            counter = new MutableInt();
            this.countMap.put(value, counter);
        }
        ++counter.value;
    }

    public void add(Integer value, int inc) {
        MutableInt counter = this.countMap.get(value);
        if (counter == null) {
            counter = new MutableInt();
            this.countMap.put(value, counter);
        }
        counter.value += inc;
    }

    public int[] bitLens() {
        return this.bitLens;
    }

    public int[] values() {
        return this.values;
    }

    public Integer[] valuesAsAutoIntegers() {
        Integer[] intValues = new Integer[this.values.length];
        for (int i2 = 0; i2 < intValues.length; ++i2) {
            intValues[i2] = this.values[i2];
        }
        return intValues;
    }

    public byte[] valuesAsBytes() {
        byte[] byteValues = new byte[this.values.length];
        for (int i2 = 0; i2 < byteValues.length; ++i2) {
            byteValues[i2] = (byte)(0xFF & this.values[i2]);
        }
        return byteValues;
    }

    public Byte[] valuesAsAutoBytes() {
        Byte[] byteValues = new Byte[this.values.length];
        for (int i2 = 0; i2 < byteValues.length; ++i2) {
            byteValues[i2] = (byte)(0xFF & this.values[i2]);
        }
        return byteValues;
    }

    public void calculate() {
        int size = this.countMap.size();
        int[] frequencies = new int[size];
        int[] values = new int[size];
        int i2 = 0;
        for (Integer key : this.countMap.keySet()) {
            values[i2] = key;
            frequencies[i2] = this.countMap.get((Object)key).value;
            ++i2;
        }
        HuffmanTree<Integer> tree = HuffmanCode.buildTree(frequencies, HuffmanParamsCalculator.autobox(values));
        ArrayList valueList = new ArrayList();
        ArrayList<Integer> lens = new ArrayList<Integer>();
        HuffmanCode.getValuesAndBitLengths(valueList, lens, tree);
        Object[] codes = new BitCode[valueList.size()];
        for (i2 = 0; i2 < valueList.size(); ++i2) {
            codes[i2] = new BitCode((Integer)valueList.get(i2), (Integer)lens.get(i2));
        }
        Arrays.sort(codes);
        this.values = new int[codes.length];
        this.bitLens = new int[codes.length];
        for (i2 = 0; i2 < codes.length; ++i2) {
            Object code = codes[i2];
            this.bitLens[i2] = ((BitCode)code).length;
            this.values[i2] = ((BitCode)code).value;
        }
    }

    private static Integer[] autobox(int[] array) {
        Integer[] newArray = new Integer[array.length];
        for (int i2 = 0; i2 < array.length; ++i2) {
            newArray[i2] = array[i2];
        }
        return newArray;
    }

    private static class BitCode
    implements Comparable<BitCode> {
        final int value;
        final int length;

        public BitCode(int value, int length) {
            this.value = value;
            this.length = length;
        }

        @Override
        public int compareTo(BitCode o2) {
            int result = this.value - o2.value;
            if (result != 0) {
                return result;
            }
            return this.length - o2.length;
        }
    }
}

