/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.huffman.codec;

import htsjdk.samtools.cram.encoding.huffman.codec.HuffmanBitCode;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

class HuffmanByteHelper {
    TreeMap<Integer, HuffmanBitCode> codes;
    private final int[] values;
    private final int[] bitLengths;
    private TreeMap<Integer, SortedSet<Integer>> codeBook;
    private final HuffmanBitCode[] sortedCodes;
    private final int[] sortedValuesByBitCode;
    private final int[] sortedBitLensByBitCode;
    private final int[] bitCodeToValue;
    private final HuffmanBitCode[] valueToCode;
    private static final Comparator<HuffmanBitCode> bitCodeComparator = new Comparator<HuffmanBitCode>(){

        @Override
        public int compare(HuffmanBitCode o1, HuffmanBitCode o2) {
            int result = o1.bitLength - o2.bitLength;
            if (result == 0) {
                return o1.bitCode - o2.bitCode;
            }
            return result;
        }
    };

    HuffmanByteHelper(byte[] values, int[] bitLengths) {
        int i2;
        this.values = new int[values.length];
        for (int i3 = 0; i3 < values.length; ++i3) {
            this.values[i3] = 0xFF & values[i3];
        }
        this.bitLengths = bitLengths;
        this.buildCodeBook();
        this.buildCodes();
        ArrayList<HuffmanBitCode> list = new ArrayList<HuffmanBitCode>(this.codes.size());
        list.addAll(this.codes.values());
        Collections.sort(list, bitCodeComparator);
        this.sortedCodes = list.toArray(new HuffmanBitCode[list.size()]);
        byte[] sortedValues = Arrays.copyOf(values, values.length);
        Arrays.sort(sortedValues);
        this.sortedValuesByBitCode = new int[this.sortedCodes.length];
        this.sortedBitLensByBitCode = new int[this.sortedCodes.length];
        int maxBitCode = 0;
        for (i2 = 0; i2 < this.sortedCodes.length; ++i2) {
            this.sortedValuesByBitCode[i2] = this.sortedCodes[i2].value;
            this.sortedBitLensByBitCode[i2] = this.sortedCodes[i2].bitLength;
            if (maxBitCode >= this.sortedCodes[i2].bitCode) continue;
            maxBitCode = this.sortedCodes[i2].bitCode;
        }
        this.bitCodeToValue = new int[maxBitCode + 1];
        Arrays.fill(this.bitCodeToValue, -1);
        for (i2 = 0; i2 < this.sortedCodes.length; ++i2) {
            this.bitCodeToValue[this.sortedCodes[i2].bitCode] = i2;
        }
        this.valueToCode = new HuffmanBitCode[255];
        Arrays.fill(this.valueToCode, null);
        HuffmanBitCode[] huffmanBitCodeArray = this.sortedCodes;
        int n2 = huffmanBitCodeArray.length;
        for (int i4 = 0; i4 < n2; ++i4) {
            HuffmanBitCode code;
            this.valueToCode[code.value] = code = huffmanBitCodeArray[i4];
        }
    }

    private void buildCodeBook() {
        this.codeBook = new TreeMap();
        for (int i2 = 0; i2 < this.values.length; ++i2) {
            if (this.codeBook.containsKey(this.bitLengths[i2])) {
                this.codeBook.get(this.bitLengths[i2]).add(this.values[i2]);
                continue;
            }
            TreeSet<Integer> entry = new TreeSet<Integer>();
            entry.add(this.values[i2]);
            this.codeBook.put(this.bitLengths[i2], entry);
        }
    }

    private void buildCodes() {
        this.codes = new TreeMap();
        int codeLength = 0;
        int codeValue = -1;
        for (Integer key : this.codeBook.keySet()) {
            SortedSet<Integer> get = this.codeBook.get(key);
            int intKey = Integer.parseInt(((Object)key).toString());
            for (Integer entry : get) {
                HuffmanBitCode code = new HuffmanBitCode();
                code.bitLength = intKey;
                code.value = entry;
                ++codeValue;
                int delta = intKey - codeLength;
                code.bitCode = codeValue <<= delta;
                codeLength += delta;
                if (HuffmanByteHelper.NumberOfSetBits(codeValue) > intKey) {
                    throw new IllegalArgumentException("Symbol out of range");
                }
                this.codes.put(entry, code);
            }
        }
    }

    final long write(BitOutputStream bitOutputStream, byte value) throws IOException {
        HuffmanBitCode code = this.valueToCode[value];
        if (code.value != value) {
            throw new RuntimeException(String.format("Searching for %d but found %s.", value, code.toString()));
        }
        bitOutputStream.write(code.bitCode, code.bitLength);
        return code.bitLength;
    }

    final byte read(BitInputStream bitInputStream) throws IOException {
        int prevLen = 0;
        int bits = 0;
        for (int i2 = 0; i2 < this.sortedCodes.length; ++i2) {
            int length = this.sortedCodes[i2].bitLength;
            bits <<= length - prevLen;
            prevLen = length;
            int index = this.bitCodeToValue[bits |= bitInputStream.readBits(length - prevLen)];
            if (index > -1 && this.sortedBitLensByBitCode[index] == length) {
                return (byte)(0xFF & this.sortedValuesByBitCode[index]);
            }
            for (int j2 = i2; this.sortedCodes[j2 + 1].bitLength == length && j2 < this.sortedCodes.length; ++j2) {
                ++i2;
            }
        }
        throw new RuntimeException("Not found.");
    }

    private static int NumberOfSetBits(int i2) {
        i2 -= i2 >> 1 & 0x55555555;
        i2 = (i2 & 0x33333333) + (i2 >> 2 & 0x33333333);
        return (i2 + (i2 >> 4) & 0xF0F0F0F) * 0x1010101 >> 24;
    }
}

