/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.AbstractBitCodec;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;
import java.io.IOException;

class GolombIntegerCodec
extends AbstractBitCodec<Integer> {
    private int m;
    private boolean quotientBit = true;
    private int offset = 0;

    public GolombIntegerCodec(int m2, Integer offset) {
        if (m2 < 2) {
            throw new IllegalArgumentException("M parameter must be at least 2.");
        }
        this.m = m2;
        this.quotientBit = true;
        this.offset = offset;
    }

    @Override
    public final Integer read(BitInputStream bitInputStream) throws IOException {
        int quotient = 0;
        while (bitInputStream.readBit() == this.quotientBit) {
            ++quotient;
        }
        int ceiling = (int)(Math.log(this.m) / Math.log(2.0) + 1.0);
        int reminder = bitInputStream.readBits(ceiling - 1);
        if ((double)reminder >= Math.pow(2.0, ceiling) - (double)this.m) {
            reminder <<= 1;
            reminder |= bitInputStream.readBits(1);
            reminder = (int)((double)reminder - (Math.pow(2.0, ceiling) - (double)this.m));
        }
        return quotient * this.m + reminder - this.offset;
    }

    @Override
    public final long write(BitOutputStream bitOutputStream, Integer value) throws IOException {
        int newValue = value + this.offset;
        int quotient = newValue / this.m;
        int reminder = newValue % this.m;
        int ceiling = (int)(Math.log(this.m) / Math.log(2.0) + 1.0);
        int length = quotient + 1;
        bitOutputStream.write(this.quotientBit, (long)quotient);
        bitOutputStream.write(!this.quotientBit);
        if ((double)reminder < Math.pow(2.0, ceiling) - (double)this.m) {
            bitOutputStream.write(reminder, ceiling - 1);
            length += ceiling - 1;
        } else {
            bitOutputStream.write((int)((double)reminder + Math.pow(2.0, ceiling) - (double)this.m), ceiling);
            length += ceiling;
        }
        return length;
    }

    @Override
    public final long numberOfBits(Integer value) {
        int newValue = value + this.offset;
        int quotient = newValue / this.m;
        int reminder = newValue % this.m;
        int ceiling = (int)(Math.log(this.m) / Math.log(2.0) + 1.0);
        int l2 = quotient + 1;
        l2 = (double)reminder < Math.pow(2.0, ceiling) - (double)this.m ? (l2 += ceiling - 1) : (l2 += ceiling);
        return l2;
    }

    @Override
    public Integer read(BitInputStream bitInputStream, int length) throws IOException {
        throw new RuntimeException("Multi-value read method not defined.");
    }
}

