/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.build;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.cram.encoding.reader.CramRecordReader;
import htsjdk.samtools.cram.encoding.reader.DataReaderFactory;
import htsjdk.samtools.cram.encoding.reader.RefSeqIdReader;
import htsjdk.samtools.cram.io.DefaultBitInputStream;
import htsjdk.samtools.cram.structure.AlignmentSpan;
import htsjdk.samtools.cram.structure.CompressionHeader;
import htsjdk.samtools.cram.structure.Container;
import htsjdk.samtools.cram.structure.CramCompressionRecord;
import htsjdk.samtools.cram.structure.Slice;
import htsjdk.samtools.util.Log;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class ContainerParser {
    private static final Log log = Log.getInstance(ContainerParser.class);
    private final SAMFileHeader samFileHeader;
    private final Map<String, Long> nanosecondsMap = new TreeMap<String, Long>();

    public ContainerParser(SAMFileHeader samFileHeader) {
        this.samFileHeader = samFileHeader;
    }

    public List<CramCompressionRecord> getRecords(Container container, ArrayList<CramCompressionRecord> records, ValidationStringency validationStringency) throws IllegalArgumentException, IllegalAccessException {
        if (container.isEOF()) {
            return Collections.emptyList();
        }
        long time1 = System.nanoTime();
        if (records == null) {
            records = new ArrayList(container.nofRecords);
        }
        for (Slice slice : container.slices) {
            records.addAll(this.getRecords(slice, container.header, validationStringency));
        }
        long time2 = System.nanoTime();
        container.parseTime = time2 - time1;
        if (Log.isEnabled(Log.LogLevel.DEBUG)) {
            for (String key : this.nanosecondsMap.keySet()) {
                log.debug(String.format("%s: %dms.", key, this.nanosecondsMap.get(key) / 1000000L));
            }
        }
        return records;
    }

    public Map<Integer, AlignmentSpan> getReferences(Container container, ValidationStringency validationStringency) throws IOException {
        HashMap<Integer, AlignmentSpan> containerSpanMap = new HashMap<Integer, AlignmentSpan>();
        for (Slice slice : container.slices) {
            ContainerParser.addAllSpans(containerSpanMap, this.getReferences(slice, container.header, validationStringency));
        }
        return containerSpanMap;
    }

    private static void addSpan(int seqId, int start, int span, int count, Map<Integer, AlignmentSpan> map) {
        if (map.containsKey(seqId)) {
            map.get(seqId).add(start, span, count);
        } else {
            map.put(seqId, new AlignmentSpan(start, span, count));
        }
    }

    private static Map<Integer, AlignmentSpan> addAllSpans(Map<Integer, AlignmentSpan> spanMap, Map<Integer, AlignmentSpan> addition) {
        for (Map.Entry<Integer, AlignmentSpan> entry : addition.entrySet()) {
            ContainerParser.addSpan(entry.getKey(), entry.getValue().getStart(), entry.getValue().getCount(), entry.getValue().getSpan(), spanMap);
        }
        return spanMap;
    }

    Map<Integer, AlignmentSpan> getReferences(Slice slice, CompressionHeader header, ValidationStringency validationStringency) throws IOException {
        HashMap<Integer, AlignmentSpan> spanMap = new HashMap<Integer, AlignmentSpan>();
        switch (slice.sequenceId) {
            case -1: {
                spanMap.put(-1, AlignmentSpan.UNMAPPED_SPAN);
                break;
            }
            case -2: {
                DataReaderFactory dataReaderFactory = new DataReaderFactory();
                HashMap<Integer, InputStream> inputMap = new HashMap<Integer, InputStream>();
                for (Integer exId : slice.external.keySet()) {
                    inputMap.put(exId, new ByteArrayInputStream(slice.external.get(exId).getRawContent()));
                }
                RefSeqIdReader reader = new RefSeqIdReader(-2, slice.alignmentStart, validationStringency);
                dataReaderFactory.buildReader(reader, new DefaultBitInputStream(new ByteArrayInputStream(slice.coreBlock.getRawContent())), inputMap, header, slice.sequenceId);
                for (int i2 = 0; i2 < slice.nofRecords; ++i2) {
                    reader.read();
                }
                ContainerParser.addAllSpans(spanMap, reader.getReferenceSpans());
                break;
            }
            default: {
                ContainerParser.addSpan(slice.sequenceId, slice.alignmentStart, slice.alignmentSpan, slice.nofRecords, spanMap);
            }
        }
        return spanMap;
    }

    ArrayList<CramCompressionRecord> getRecords(ArrayList<CramCompressionRecord> records, Slice slice, CompressionHeader header, ValidationStringency validationStringency) throws IllegalArgumentException, IllegalAccessException {
        String seqName = "*";
        switch (slice.sequenceId) {
            case -2: 
            case -1: {
                break;
            }
            default: {
                SAMSequenceRecord sequence = this.samFileHeader.getSequence(slice.sequenceId);
                seqName = sequence.getSequenceName();
            }
        }
        DataReaderFactory dataReaderFactory = new DataReaderFactory();
        HashMap<Integer, InputStream> inputMap = new HashMap<Integer, InputStream>();
        for (Integer exId : slice.external.keySet()) {
            log.debug("Adding external data: " + exId);
            inputMap.put(exId, new ByteArrayInputStream(slice.external.get(exId).getRawContent()));
        }
        CramRecordReader reader = new CramRecordReader(validationStringency);
        dataReaderFactory.buildReader(reader, new DefaultBitInputStream(new ByteArrayInputStream(slice.coreBlock.getRawContent())), inputMap, header, slice.sequenceId);
        if (records == null) {
            records = new ArrayList(slice.nofRecords);
        }
        long readNanos = 0L;
        int prevStart = slice.alignmentStart;
        for (int i2 = 0; i2 < slice.nofRecords; ++i2) {
            CramCompressionRecord record = new CramCompressionRecord();
            record.sliceIndex = slice.index;
            record.index = i2;
            long time = System.nanoTime();
            reader.read(record);
            readNanos += System.nanoTime() - time;
            if (record.sequenceId == slice.sequenceId) {
                record.sequenceName = seqName;
                record.sequenceId = slice.sequenceId;
            } else {
                record.sequenceName = record.sequenceId == -1 ? "*" : this.samFileHeader.getSequence(record.sequenceId).getSequenceName();
            }
            records.add(record);
            if (!header.APDelta) continue;
            record.alignmentStart = prevStart += record.alignmentDelta;
        }
        log.debug("Slice records read time: " + readNanos / 1000000L);
        Map<String, DataReaderFactory.DataReaderWithStats> statMap = dataReaderFactory.getStats(reader);
        for (String key : statMap.keySet()) {
            long value;
            if (!this.nanosecondsMap.containsKey(key)) {
                this.nanosecondsMap.put(key, 0L);
                value = 0L;
            } else {
                value = this.nanosecondsMap.get(key);
            }
            this.nanosecondsMap.put(key, value + statMap.get((Object)key).nanos);
        }
        return records;
    }

    List<CramCompressionRecord> getRecords(Slice slice, CompressionHeader header, ValidationStringency validationStringency) throws IllegalArgumentException, IllegalAccessException {
        return this.getRecords(null, slice, header, validationStringency);
    }
}

