/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram;

import htsjdk.samtools.CRAMBAIIndexer;
import htsjdk.samtools.CRAMCRAIIndexer;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.cram.CRAIEntry;
import htsjdk.samtools.cram.encoding.reader.DataReaderFactory;
import htsjdk.samtools.cram.encoding.reader.RefSeqIdReader;
import htsjdk.samtools.cram.io.DefaultBitInputStream;
import htsjdk.samtools.cram.structure.AlignmentSpan;
import htsjdk.samtools.cram.structure.CompressionHeader;
import htsjdk.samtools.cram.structure.Container;
import htsjdk.samtools.cram.structure.CramCompressionRecord;
import htsjdk.samtools.cram.structure.Slice;
import htsjdk.samtools.seekablestream.SeekableMemoryStream;
import htsjdk.samtools.seekablestream.SeekableStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CRAIIndex {
    public static final String CRAI_INDEX_SUFFIX = ".crai";
    private final List<CRAIEntry> entries = new ArrayList<CRAIEntry>();

    public void addEntry(CRAIEntry entry) {
        this.entries.add(entry);
    }

    public List<CRAIEntry> getCRAIEntries() {
        return this.entries;
    }

    public void writeIndex(OutputStream os) {
        Collections.sort(this.entries, CRAIEntry.byStartDesc);
        this.entries.stream().forEach(e2 -> e2.writeToStream(os));
    }

    public void processContainer(Container c2) {
        if (!c2.isEOF()) {
            for (int i2 = 0; i2 < c2.slices.length; ++i2) {
                Slice s2 = c2.slices[i2];
                if (s2.sequenceId == -2) {
                    this.entries.addAll(CRAIIndex.getCRAIEntriesForMultiRefSlice(s2, c2.header, c2.offset, c2.landmarks));
                    continue;
                }
                CRAIEntry e2 = new CRAIEntry();
                e2.sequenceId = c2.sequenceId;
                e2.alignmentStart = s2.alignmentStart;
                e2.alignmentSpan = s2.alignmentSpan;
                e2.containerStartOffset = c2.offset;
                e2.sliceOffset = c2.landmarks[i2];
                e2.sliceSize = s2.size;
                e2.sliceIndex = i2;
                this.entries.add(e2);
            }
        }
    }

    private static Collection<CRAIEntry> getCRAIEntriesForMultiRefSlice(Slice slice, CompressionHeader header, long containerOffset, int[] landmarks) {
        DataReaderFactory dataReaderFactory = new DataReaderFactory();
        HashMap<Integer, InputStream> inputMap = new HashMap<Integer, InputStream>();
        for (Integer exId : slice.external.keySet()) {
            inputMap.put(exId, new ByteArrayInputStream(slice.external.get(exId).getRawContent()));
        }
        RefSeqIdReader reader = new RefSeqIdReader(slice.sequenceId, slice.alignmentStart, ValidationStringency.DEFAULT_STRINGENCY);
        dataReaderFactory.buildReader(reader, new DefaultBitInputStream(new ByteArrayInputStream(slice.coreBlock.getRawContent())), inputMap, header, slice.sequenceId);
        reader.APDelta = header.APDelta;
        for (int i2 = 0; i2 < slice.nofRecords; ++i2) {
            CramCompressionRecord record = new CramCompressionRecord();
            record.sliceIndex = slice.index;
            record.index = i2;
            reader.read();
            if (record.sequenceId == slice.sequenceId) {
                record.sequenceId = slice.sequenceId;
                continue;
            }
            if (record.sequenceId != -1) continue;
            record.sequenceName = "*";
        }
        Map<Integer, AlignmentSpan> spans = reader.getReferenceSpans();
        ArrayList<CRAIEntry> entries = new ArrayList<CRAIEntry>(spans.size());
        for (int seqId : spans.keySet()) {
            CRAIEntry e2 = new CRAIEntry();
            e2.sequenceId = seqId;
            AlignmentSpan span = spans.get(seqId);
            e2.alignmentStart = span.getStart();
            e2.alignmentSpan = span.getSpan();
            e2.sliceSize = slice.size;
            e2.sliceIndex = slice.index;
            e2.containerStartOffset = containerOffset;
            e2.sliceOffset = landmarks[slice.index];
            entries.add(e2);
        }
        return entries;
    }

    public static SeekableStream openCraiFileAsBaiStream(File cramIndexFile, SAMSequenceDictionary dictionary) throws IOException {
        return CRAIIndex.openCraiFileAsBaiStream(new FileInputStream(cramIndexFile), dictionary);
    }

    public static SeekableStream openCraiFileAsBaiStream(InputStream indexStream, SAMSequenceDictionary dictionary) throws IOException, CRAIIndexException {
        List<CRAIEntry> full = CRAMCRAIIndexer.readIndex(indexStream).getCRAIEntries();
        Collections.sort(full);
        SAMFileHeader header = new SAMFileHeader();
        header.setSequenceDictionary(dictionary);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CRAMBAIIndexer indexer = new CRAMBAIIndexer(baos, header);
        for (CRAIEntry entry : full) {
            Slice slice = new Slice();
            slice.containerOffset = entry.containerStartOffset;
            slice.alignmentStart = entry.alignmentStart;
            slice.alignmentSpan = entry.alignmentSpan;
            slice.sequenceId = entry.sequenceId;
            slice.nofRecords = entry.sliceSize;
            slice.index = entry.sliceIndex;
            slice.offset = entry.sliceOffset;
            indexer.processSingleReferenceSlice(slice);
        }
        indexer.finish();
        return new SeekableMemoryStream(baos.toByteArray(), "CRAI to BAI converter");
    }

    public static List<CRAIEntry> find(List<CRAIEntry> list, int seqId, int start, int span) {
        boolean whole = start < 1 || span < 1;
        CRAIEntry query = new CRAIEntry();
        query.sequenceId = seqId;
        query.alignmentStart = start < 1 ? 1 : start;
        query.alignmentSpan = span < 1 ? Integer.MAX_VALUE : span;
        query.containerStartOffset = Long.MAX_VALUE;
        query.sliceOffset = Integer.MAX_VALUE;
        query.sliceSize = Integer.MAX_VALUE;
        ArrayList<CRAIEntry> l2 = new ArrayList<CRAIEntry>();
        for (CRAIEntry e2 : list) {
            if (e2.sequenceId != seqId || !whole && !CRAIEntry.intersect(e2, query)) continue;
            l2.add(e2);
        }
        Collections.sort(l2, CRAIEntry.byStart);
        return l2;
    }

    public static CRAIEntry getLeftmost(List<CRAIEntry> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        CRAIEntry left = list.get(0);
        for (CRAIEntry e2 : list) {
            if (e2.alignmentStart >= left.alignmentStart) continue;
            left = e2;
        }
        return left;
    }

    public static int findLastAlignedEntry(List<CRAIEntry> list) {
        if (list.isEmpty()) {
            return -1;
        }
        int low = 0;
        int high = list.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            CRAIEntry midVal = list.get(mid);
            if (midVal.sequenceId >= 0) {
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        if (low >= list.size()) {
            return list.size() - 1;
        }
        while (low >= 0 && list.get((int)low).sequenceId == -1) {
            --low;
        }
        return low;
    }

    public static class CRAIIndexException
    extends RuntimeException {
        public CRAIIndexException(String s2) {
            super(s2);
        }

        public CRAIIndexException(NumberFormatException e2) {
            super(e2);
        }
    }
}

