/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram;

import htsjdk.samtools.cram.CRAIIndex;
import htsjdk.samtools.cram.structure.Container;
import htsjdk.samtools.cram.structure.Slice;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class CRAIEntry
implements Comparable<CRAIEntry>,
Cloneable {
    public int sequenceId;
    public int alignmentStart;
    public int alignmentSpan;
    public long containerStartOffset;
    public int sliceOffset;
    public int sliceSize;
    public int sliceIndex;
    private static int CRAI_INDEX_COLUMNS = 6;
    private static String entryFormat = "%d\t%d\t%d\t%d\t%d\t%d";
    public static Comparator<CRAIEntry> byEnd = new Comparator<CRAIEntry>(){

        @Override
        public int compare(CRAIEntry o1, CRAIEntry o2) {
            if (o1.sequenceId != o2.sequenceId) {
                return o2.sequenceId - o1.sequenceId;
            }
            if (o1.alignmentStart + o1.alignmentSpan != o2.alignmentStart + o2.alignmentSpan) {
                return o1.alignmentStart + o1.alignmentSpan - o2.alignmentStart - o2.alignmentSpan;
            }
            return (int)(o1.containerStartOffset - o2.containerStartOffset);
        }
    };
    public static final Comparator<CRAIEntry> byStart = new Comparator<CRAIEntry>(){

        @Override
        public int compare(CRAIEntry o1, CRAIEntry o2) {
            if (o1.sequenceId != o2.sequenceId) {
                return o2.sequenceId - o1.sequenceId;
            }
            if (o1.alignmentStart != o2.alignmentStart) {
                return o1.alignmentStart - o2.alignmentStart;
            }
            return (int)(o1.containerStartOffset - o2.containerStartOffset);
        }
    };
    public static Comparator<CRAIEntry> byStartDesc = new Comparator<CRAIEntry>(){

        @Override
        public int compare(CRAIEntry o1, CRAIEntry o2) {
            if (o1.sequenceId != o2.sequenceId) {
                if (o1.sequenceId == -1) {
                    return 1;
                }
                if (o2.sequenceId == -1) {
                    return -1;
                }
                return -o2.sequenceId + o1.sequenceId;
            }
            if (o1.alignmentStart != o2.alignmentStart) {
                return o1.alignmentStart - o2.alignmentStart;
            }
            return (int)(o1.containerStartOffset - o2.containerStartOffset);
        }
    };

    public CRAIEntry() {
    }

    public CRAIEntry(String line) throws CRAIIndex.CRAIIndexException {
        String[] chunks = line.split("\t");
        if (chunks.length != CRAI_INDEX_COLUMNS) {
            throw new CRAIIndex.CRAIIndexException("Malformed CRAI index entry: expecting " + CRAI_INDEX_COLUMNS + " columns but got " + chunks.length);
        }
        try {
            this.sequenceId = Integer.parseInt(chunks[0]);
            this.alignmentStart = Integer.parseInt(chunks[1]);
            this.alignmentSpan = Integer.parseInt(chunks[2]);
            this.containerStartOffset = Long.parseLong(chunks[3]);
            this.sliceOffset = Integer.parseInt(chunks[4]);
            this.sliceSize = Integer.parseInt(chunks[5]);
        }
        catch (NumberFormatException e2) {
            throw new CRAIIndex.CRAIIndexException(e2);
        }
    }

    public void writeToStream(OutputStream os) {
        try {
            os.write(this.serializeToString().getBytes());
            os.write(10);
        }
        catch (IOException e2) {
            throw new RuntimeIOException(e2);
        }
    }

    private String serializeToString() {
        return String.format(entryFormat, this.sequenceId, this.alignmentStart, this.alignmentSpan, this.containerStartOffset, this.sliceOffset, this.sliceSize);
    }

    public String toString() {
        return this.serializeToString();
    }

    public static List<CRAIEntry> fromContainer(Container container) {
        ArrayList<CRAIEntry> entries = new ArrayList<CRAIEntry>(container.slices.length);
        int i2 = 0;
        while (i2 < container.slices.length) {
            Slice s2 = container.slices[i2];
            CRAIEntry e2 = new CRAIEntry();
            e2.sequenceId = s2.sequenceId;
            e2.alignmentStart = s2.alignmentStart;
            e2.alignmentSpan = s2.alignmentSpan;
            e2.containerStartOffset = s2.containerOffset;
            e2.sliceOffset = container.landmarks[i2];
            e2.sliceSize = s2.size;
            e2.sliceIndex = i2++;
            entries.add(e2);
        }
        return entries;
    }

    @Override
    public int compareTo(CRAIEntry o2) {
        if (o2 == null) {
            return 1;
        }
        if (this.sequenceId != o2.sequenceId) {
            return this.sequenceId - o2.sequenceId;
        }
        if (this.alignmentStart != o2.alignmentStart) {
            return this.alignmentStart - o2.alignmentStart;
        }
        return (int)(this.containerStartOffset - o2.containerStartOffset);
    }

    public CRAIEntry clone() throws CloneNotSupportedException {
        super.clone();
        CRAIEntry entry = new CRAIEntry();
        entry.sequenceId = this.sequenceId;
        entry.alignmentStart = this.alignmentStart;
        entry.alignmentSpan = this.alignmentSpan;
        entry.containerStartOffset = this.containerStartOffset;
        entry.sliceOffset = this.sliceOffset;
        entry.sliceSize = this.sliceSize;
        return entry;
    }

    public static boolean intersect(CRAIEntry e0, CRAIEntry e1) {
        if (e0.sequenceId != e1.sequenceId) {
            return false;
        }
        if (e0.sequenceId < 0) {
            return false;
        }
        int a0 = e0.alignmentStart;
        int b0 = a0 + e0.alignmentSpan;
        int a1 = e1.alignmentStart;
        int b1 = a1 + e1.alignmentSpan;
        return Math.abs(a0 + b0 - a1 - b1) < e0.alignmentSpan + e1.alignmentSpan;
    }
}

