/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.AbstractSAMHeaderRecord;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMTextHeaderCodec;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlValue;

@XmlRootElement(name="Reference")
public class SAMSequenceRecord
extends AbstractSAMHeaderRecord
implements Cloneable {
    public static final long serialVersionUID = 1L;
    private String mSequenceName = null;
    private int mSequenceIndex = -1;
    private int mSequenceLength = 0;
    public static final String SEQUENCE_NAME_TAG = "SN";
    public static final String SEQUENCE_LENGTH_TAG = "LN";
    public static final String MD5_TAG = "M5";
    public static final String ASSEMBLY_TAG = "AS";
    public static final String URI_TAG = "UR";
    public static final String SPECIES_TAG = "SP";
    public static final int UNKNOWN_SEQUENCE_LENGTH = 0;
    public static final String RESERVED_MRNM_SEQUENCE_NAME = "=";
    public static final Set<String> STANDARD_TAGS = new HashSet<String>(Arrays.asList("SN", "LN", "AS", "M5", "UR", "SP"));
    private static Pattern SEQUENCE_NAME_SPLITTER = Pattern.compile("\\s");
    private static char[] WHITESPACE_CHARS = new char[]{' ', '\t', '\n', '\u000b', '\f', '\r'};

    private SAMSequenceRecord() {
    }

    @Deprecated
    public SAMSequenceRecord(String name) {
        this(name, 0);
    }

    public SAMSequenceRecord(String name, int sequenceLength) {
        if (name != null) {
            if (SEQUENCE_NAME_SPLITTER.matcher(name).find()) {
                throw new SAMException("Sequence name contains invalid character: " + name);
            }
            SAMSequenceRecord.validateSequenceName(name);
            this.mSequenceName = name.intern();
        }
        this.mSequenceLength = sequenceLength;
    }

    @XmlValue
    public String getSequenceName() {
        return this.mSequenceName;
    }

    private void setSequenceName(String name) {
        this.mSequenceName = name != null ? name.intern() : null;
    }

    @XmlAttribute(name="length")
    public int getSequenceLength() {
        return this.mSequenceLength;
    }

    public void setSequenceLength(int value) {
        this.mSequenceLength = value;
    }

    @XmlAttribute(name="assembly")
    public String getAssembly() {
        return this.getAttribute(ASSEMBLY_TAG);
    }

    public void setAssembly(String value) {
        this.setAttribute(ASSEMBLY_TAG, value);
    }

    @XmlAttribute(name="species")
    public String getSpecies() {
        return this.getAttribute(SPECIES_TAG);
    }

    public void setSpecies(String value) {
        this.setAttribute(SPECIES_TAG, value);
    }

    @XmlAttribute(name="md5")
    public String getMd5() {
        return this.getAttribute(MD5_TAG);
    }

    public void setMd5(String value) {
        this.setAttribute(MD5_TAG, value);
    }

    @XmlAttribute(name="index")
    public int getSequenceIndex() {
        return this.mSequenceIndex;
    }

    public void setSequenceIndex(int value) {
        this.mSequenceIndex = value;
    }

    public boolean isSameSequence(SAMSequenceRecord that) {
        BigInteger thatMd5;
        BigInteger thisMd5;
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (this.mSequenceIndex != that.mSequenceIndex) {
            return false;
        }
        if (this.mSequenceLength != 0 && that.mSequenceLength != 0 && this.mSequenceLength != that.mSequenceLength) {
            return false;
        }
        return !(this.getAttribute(MD5_TAG) != null && that.getAttribute(MD5_TAG) != null ? !(thisMd5 = new BigInteger(this.getAttribute(MD5_TAG), 16)).equals(thatMd5 = new BigInteger(that.getAttribute(MD5_TAG), 16)) : this.mSequenceName != that.mSequenceName);
    }

    private URI makeURI(String s2) throws URISyntaxException {
        URI uri = new URI(s2);
        if (uri.getScheme() == null) {
            uri = new URI("file", uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
        }
        return uri;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof SAMSequenceRecord)) {
            return false;
        }
        SAMSequenceRecord that = (SAMSequenceRecord)o2;
        if (this.mSequenceIndex != that.mSequenceIndex) {
            return false;
        }
        if (this.mSequenceLength != that.mSequenceLength) {
            return false;
        }
        if (!this.attributesEqual(that)) {
            return false;
        }
        return this.mSequenceName == that.mSequenceName;
    }

    public int hashCode() {
        return this.mSequenceName != null ? this.mSequenceName.hashCode() : 0;
    }

    @Override
    Set<String> getStandardTags() {
        return STANDARD_TAGS;
    }

    public final SAMSequenceRecord clone() {
        SAMSequenceRecord ret = new SAMSequenceRecord(this.mSequenceName, this.mSequenceLength);
        ret.mSequenceIndex = this.mSequenceIndex;
        for (Map.Entry<String, String> entry : this.getAttributes()) {
            ret.setAttribute(entry.getKey(), entry.getValue());
        }
        return ret;
    }

    public static String truncateSequenceName(String sequenceName) {
        int truncateAt = sequenceName.length();
        for (char c2 : WHITESPACE_CHARS) {
            int index = sequenceName.indexOf(c2);
            if (index == -1 || index >= truncateAt) continue;
            truncateAt = index;
        }
        return sequenceName.substring(0, truncateAt);
    }

    public static void validateSequenceName(String name) {
        if (RESERVED_MRNM_SEQUENCE_NAME.equals(name)) {
            throw new SAMException("'=' is not a valid sequence name");
        }
    }

    @Override
    public String toString() {
        return String.format("SAMSequenceRecord(name=%s,length=%s,dict_index=%s,assembly=%s)", this.getSequenceName(), this.getSequenceLength(), this.getSequenceIndex(), this.getAssembly());
    }

    @Override
    public String getSAMString() {
        return new SAMTextHeaderCodec().getSQLine(this);
    }
}

