/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMValidationError;
import htsjdk.samtools.TextCigarCodec;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class Cigar
implements Serializable,
Iterable<CigarElement> {
    public static final long serialVersionUID = 1L;
    private final List<CigarElement> cigarElements = new ArrayList<CigarElement>();

    public Cigar() {
    }

    public Cigar(List<CigarElement> cigarElements) {
        this.cigarElements.addAll(cigarElements);
    }

    public List<CigarElement> getCigarElements() {
        return Collections.unmodifiableList(this.cigarElements);
    }

    public CigarElement getCigarElement(int i2) {
        return this.cigarElements.get(i2);
    }

    public void add(CigarElement cigarElement) {
        this.cigarElements.add(cigarElement);
    }

    public int numCigarElements() {
        return this.cigarElements.size();
    }

    public boolean isEmpty() {
        return this.cigarElements.isEmpty();
    }

    public int getReferenceLength() {
        int length = 0;
        for (CigarElement element : this.cigarElements) {
            switch (element.getOperator()) {
                case M: 
                case D: 
                case N: 
                case EQ: 
                case X: {
                    length += element.getLength();
                    break;
                }
            }
        }
        return length;
    }

    public int getPaddedReferenceLength() {
        int length = 0;
        for (CigarElement element : this.cigarElements) {
            switch (element.getOperator()) {
                case M: 
                case D: 
                case N: 
                case EQ: 
                case X: 
                case P: {
                    length += element.getLength();
                    break;
                }
            }
        }
        return length;
    }

    public int getReadLength() {
        return Cigar.getReadLength(this.cigarElements);
    }

    public static int getReadLength(List<CigarElement> cigarElements) {
        int length = 0;
        for (CigarElement element : cigarElements) {
            if (!element.getOperator().consumesReadBases()) continue;
            length += element.getLength();
        }
        return length;
    }

    public List<SAMValidationError> isValid(String readName, long recordNumber) {
        if (this.isEmpty()) {
            return null;
        }
        ArrayList<SAMValidationError> ret = null;
        boolean seenRealOperator = false;
        for (int i2 = 0; i2 < this.cigarElements.size(); ++i2) {
            CigarOperator op;
            CigarElement element = this.cigarElements.get(i2);
            if (element.getLength() == 0) {
                if (ret == null) {
                    ret = new ArrayList();
                }
                ret.add(new SAMValidationError(SAMValidationError.Type.INVALID_CIGAR, "CIGAR element with zero length", readName, recordNumber));
            }
            if (Cigar.isClippingOperator(op = element.getOperator())) {
                if (op == CigarOperator.H) {
                    if (i2 == 0 || i2 == this.cigarElements.size() - 1) continue;
                    if (ret == null) {
                        ret = new ArrayList();
                    }
                    ret.add(new SAMValidationError(SAMValidationError.Type.INVALID_CIGAR, "Hard clipping operator not at start or end of CIGAR", readName, recordNumber));
                    continue;
                }
                if (op != CigarOperator.S) {
                    throw new IllegalStateException("Should never happen: " + op.name());
                }
                if (i2 == 0 || i2 == this.cigarElements.size() - 1) continue;
                if (i2 == 1) {
                    if (this.cigarElements.size() == 3 && this.cigarElements.get(2).getOperator() == CigarOperator.H || this.cigarElements.get(0).getOperator() == CigarOperator.H) continue;
                    if (ret == null) {
                        ret = new ArrayList();
                    }
                    ret.add(new SAMValidationError(SAMValidationError.Type.INVALID_CIGAR, "Soft clipping CIGAR operator can only be inside of hard clipping operator", readName, recordNumber));
                    continue;
                }
                if (i2 == this.cigarElements.size() - 2) {
                    if (this.cigarElements.get(this.cigarElements.size() - 1).getOperator() == CigarOperator.H) continue;
                    if (ret == null) {
                        ret = new ArrayList();
                    }
                    ret.add(new SAMValidationError(SAMValidationError.Type.INVALID_CIGAR, "Soft clipping CIGAR operator can only be inside of hard clipping operator", readName, recordNumber));
                    continue;
                }
                if (ret == null) {
                    ret = new ArrayList();
                }
                ret.add(new SAMValidationError(SAMValidationError.Type.INVALID_CIGAR, "Soft clipping CIGAR operator can at start or end of read, or be inside of hard clipping operator", readName, recordNumber));
                continue;
            }
            if (Cigar.isRealOperator(op)) {
                CigarOperator nextOperator;
                seenRealOperator = true;
                if (!Cigar.isInDelOperator(op)) continue;
                for (int j2 = i2 + 1; !(j2 >= this.cigarElements.size() || Cigar.isRealOperator(nextOperator = this.cigarElements.get(j2).getOperator()) && !Cigar.isInDelOperator(nextOperator) || Cigar.isPaddingOperator(nextOperator)); ++j2) {
                    if (!Cigar.isInDelOperator(nextOperator) || op != nextOperator) continue;
                    if (ret == null) {
                        ret = new ArrayList();
                    }
                    ret.add(new SAMValidationError(SAMValidationError.Type.ADJACENT_INDEL_IN_CIGAR, "No M or N operator between pair of " + op.name() + " operators in CIGAR", readName, recordNumber));
                }
                continue;
            }
            if (!Cigar.isPaddingOperator(op) || i2 == 0) continue;
            if (i2 == this.cigarElements.size() - 1) {
                if (ret == null) {
                    ret = new ArrayList();
                }
                ret.add(new SAMValidationError(SAMValidationError.Type.INVALID_CIGAR, "Padding operator not valid at end of CIGAR", readName, recordNumber));
                continue;
            }
            if (Cigar.isRealOperator(this.cigarElements.get(i2 - 1).getOperator()) && Cigar.isRealOperator(this.cigarElements.get(i2 + 1).getOperator())) continue;
            if (ret == null) {
                ret = new ArrayList();
            }
            ret.add(new SAMValidationError(SAMValidationError.Type.INVALID_CIGAR, "Padding operator not between real operators in CIGAR", readName, recordNumber));
        }
        if (!seenRealOperator) {
            if (ret == null) {
                ret = new ArrayList<SAMValidationError>();
            }
            ret.add(new SAMValidationError(SAMValidationError.Type.INVALID_CIGAR, "No real operator (M|I|D|N) in CIGAR", readName, recordNumber));
        }
        return ret;
    }

    private static boolean isRealOperator(CigarOperator op) {
        return op == CigarOperator.M || op == CigarOperator.EQ || op == CigarOperator.X || op == CigarOperator.I || op == CigarOperator.D || op == CigarOperator.N;
    }

    private static boolean isInDelOperator(CigarOperator op) {
        return op != null && op.isIndel();
    }

    private static boolean isClippingOperator(CigarOperator op) {
        return op != null && op.isClipping();
    }

    private static boolean isPaddingOperator(CigarOperator op) {
        return op != null && op.isPadding();
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof Cigar)) {
            return false;
        }
        Cigar cigar = (Cigar)o2;
        return this.cigarElements.equals(cigar.cigarElements);
    }

    public static Cigar fromCigarOperators(List<CigarOperator> cigarOperators) {
        if (cigarOperators == null) {
            throw new IllegalArgumentException("cigarOperators is null");
        }
        ArrayList<CigarElement> cigarElementList = new ArrayList<CigarElement>();
        int i2 = 0;
        while (i2 < cigarOperators.size()) {
            int j2;
            CigarOperator currentOp = cigarOperators.get(i2);
            for (j2 = i2 + 1; j2 < cigarOperators.size() && cigarOperators.get(j2).equals((Object)currentOp); ++j2) {
            }
            cigarElementList.add(new CigarElement(j2 - i2, currentOp));
            i2 = j2;
        }
        return new Cigar(cigarElementList);
    }

    @Override
    public Iterator<CigarElement> iterator() {
        return this.getCigarElements().iterator();
    }

    public boolean containsOperator(CigarOperator operator) {
        return this.cigarElements.stream().anyMatch(element -> element.getOperator() == operator);
    }

    public CigarElement getFirstCigarElement() {
        return this.isEmpty() ? null : this.cigarElements.get(0);
    }

    public CigarElement getLastCigarElement() {
        return this.isEmpty() ? null : this.cigarElements.get(this.numCigarElements() - 1);
    }

    public boolean isLeftClipped() {
        return !this.isEmpty() && Cigar.isClippingOperator(this.getFirstCigarElement().getOperator());
    }

    public boolean isRightClipped() {
        return !this.isEmpty() && Cigar.isClippingOperator(this.getLastCigarElement().getOperator());
    }

    public boolean isClipped() {
        return this.isLeftClipped() || this.isRightClipped();
    }

    public int hashCode() {
        return this.cigarElements.hashCode();
    }

    public String toString() {
        return TextCigarCodec.encode(this);
    }
}

