/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.BAMFileSpan;
import htsjdk.samtools.BAMIndexContent;
import htsjdk.samtools.CachingBAMFileIndex;
import htsjdk.samtools.Chunk;
import htsjdk.samtools.LinearIndex;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SamReader;
import java.util.Arrays;
import java.util.List;

public class BamIndexValidator {
    public static int exhaustivelyTestIndex(SamReader reader) {
        if (reader.indexing().hasBrowseableIndex()) {
            CachingBAMFileIndex existingIndex = (CachingBAMFileIndex)reader.indexing().getBrowseableIndex();
            int numRefs = existingIndex.getNumberOfReferences();
            int chunkCount = 0;
            int indexCount = 0;
            for (int i2 = 0; i2 < numRefs; ++i2) {
                BAMIndexContent content = existingIndex.getQueryResults(i2);
                for (Chunk c2 : content.getAllChunks()) {
                    SAMRecordIterator iter = ((SamReader.PrimitiveSamReaderToSamReaderAdapter)reader).iterator(new BAMFileSpan(c2));
                    ++chunkCount;
                    SAMRecord sam = null;
                    try {
                        sam = (SAMRecord)iter.next();
                        iter.close();
                    }
                    catch (Exception e2) {
                        throw new SAMException("Exception in BamIndexValidator. Last good record " + sam + " in chunk " + c2 + " chunkCount=" + chunkCount, e2);
                    }
                }
                LinearIndex linearIndex = content.getLinearIndex();
                for (long l2 : linearIndex.getIndexEntries()) {
                    try {
                        if (l2 == 0L) continue;
                        SAMRecordIterator iter = ((SamReader.PrimitiveSamReaderToSamReaderAdapter)reader).iterator(new BAMFileSpan(new Chunk(l2, l2 + 1L)));
                        SAMRecord sam = (SAMRecord)iter.next();
                        ++indexCount;
                        iter.close();
                    }
                    catch (Exception e3) {
                        throw new SAMException("Exception in BamIndexValidator. Linear index access failure " + l2 + " indexCount=" + indexCount, e3);
                    }
                }
            }
            return chunkCount;
        }
        return 0;
    }

    public static int lessExhaustivelyTestIndex(SamReader reader) {
        if (reader.indexing().hasBrowseableIndex()) {
            CachingBAMFileIndex existingIndex = (CachingBAMFileIndex)reader.indexing().getBrowseableIndex();
            int numRefs = existingIndex.getNumberOfReferences();
            int chunkCount = 0;
            int indexCount = 0;
            for (int i2 = 0; i2 < numRefs; ++i2) {
                BAMIndexContent content = existingIndex.getQueryResults(i2);
                List<Chunk> chunks = content.getAllChunks();
                int numChunks = chunks.size();
                for (int chunkNo : Arrays.asList(0, numChunks - 1)) {
                    ++chunkCount;
                    Chunk c2 = chunks.get(chunkNo);
                    SAMRecordIterator iter = ((SamReader.PrimitiveSamReaderToSamReaderAdapter)reader).iterator(new BAMFileSpan(c2));
                    try {
                        SAMRecord sam = (SAMRecord)iter.next();
                        iter.close();
                    }
                    catch (Exception e2) {
                        throw new SAMException("Exception querying chunk " + chunkNo + " from reference index " + i2, e2);
                    }
                }
                long[] linearIndexEntries = content.getLinearIndex().getIndexEntries();
                for (int binNo : Arrays.asList(0, linearIndexEntries.length - 1)) {
                    ++indexCount;
                    long l2 = linearIndexEntries[binNo];
                    try {
                        if (l2 == 0L) continue;
                        SAMRecordIterator iter = ((SamReader.PrimitiveSamReaderToSamReaderAdapter)reader).iterator(new BAMFileSpan(new Chunk(l2, l2 + 1L)));
                        SAMRecord sam = (SAMRecord)iter.next();
                        iter.close();
                    }
                    catch (Exception e3) {
                        throw new SAMException("Exception in BamIndexValidator. Linear index access failure " + l2 + " indexCount=" + indexCount, e3);
                    }
                }
            }
            return chunkCount;
        }
        return 0;
    }

    public static enum IndexValidationStringency {
        EXHAUSTIVE,
        LESS_EXHAUSTIVE,
        NONE;

    }
}

