/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.Alignable;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.SystemInfo;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.MenuSelectionManager;
import javax.swing.Timer;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class JideMenu
extends JMenu
implements Alignable {
    private int _preferredPopupHorizontalAlignment = 2;
    private int _preferredPopupVerticalAlignment = 3;
    private MenuCreator _menuCreator;
    private PopupMenuCustomizer _customizer;
    private PopupMenuOriginCalculator _originCalculator;
    public static int DELAY = 400;
    private int _orientation;
    private static JideMenu _pendingMenu;
    private static HideTimer _timer;
    private static final boolean DISABLE_TIMER = true;

    public JideMenu() {
        this.initMenu();
    }

    public JideMenu(String s2) {
        super(s2);
        this.initMenu();
    }

    public JideMenu(Action a2) {
        super(a2);
        this.initMenu();
    }

    public JideMenu(String s2, boolean b2) {
        super(s2, b2);
        this.initMenu();
    }

    protected void initMenu() {
        this.addMenuListener(new MenuListener(){

            public void menuSelected(MenuEvent e2) {
                PopupMenuCustomizer customizer;
                MenuCreator menuCreator = JideMenu.this.getMenuCreator();
                if (menuCreator != null) {
                    menuCreator.createMenu();
                    if (JideMenu.this.getPopupMenu().getComponentCount() == 0) {
                        return;
                    }
                }
                if ((customizer = JideMenu.this.getPopupMenuCustomizer()) != null) {
                    customizer.customize(JideMenu.this.getPopupMenu());
                }
            }

            public void menuDeselected(MenuEvent e2) {
            }

            public void menuCanceled(MenuEvent e2) {
            }
        });
    }

    public boolean isTopLevelMenu() {
        return this.getParent() == null || !(this.getParent() instanceof JPopupMenu);
    }

    public PopupMenuOriginCalculator getOriginCalculator() {
        return this._originCalculator;
    }

    public void setOriginCalculator(PopupMenuOriginCalculator originCalculator) {
        this._originCalculator = originCalculator;
    }

    @Deprecated
    public MenuCreator getMenuCreator() {
        return this._menuCreator;
    }

    @Deprecated
    public void setMenuCreator(MenuCreator menuCreator) {
        this._menuCreator = menuCreator;
    }

    public PopupMenuCustomizer getPopupMenuCustomizer() {
        return this._customizer;
    }

    public void setPopupMenuCustomizer(PopupMenuCustomizer customizer) {
        this._customizer = customizer;
    }

    protected Point getPopupMenuOrigin() {
        int y;
        int x2;
        int yOffset;
        int xOffset;
        Container parent;
        GraphicsDevice[] gds;
        if (this._originCalculator != null) {
            return this._originCalculator.getPopupMenuOrigin(this);
        }
        JPopupMenu pm = this.getPopupMenu();
        Dimension s2 = this.getSize();
        Dimension pmSize = pm.getPreferredSize();
        Point position = this.getLocationOnScreen();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        GraphicsConfiguration gc = this.getGraphicsConfiguration();
        Rectangle screenBounds = new Rectangle(toolkit.getScreenSize());
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice gd : gds = ge.getScreenDevices()) {
            GraphicsConfiguration dgc;
            if (gd.getType() != 0 || !(dgc = gd.getDefaultConfiguration()).getBounds().contains(position)) continue;
            gc = dgc;
            break;
        }
        if (gc != null) {
            screenBounds = gc.getBounds();
            Insets screenInsets = toolkit.getScreenInsets(gc);
            screenBounds.width -= Math.abs(screenInsets.left + screenInsets.right);
            screenBounds.height -= Math.abs(screenInsets.top + screenInsets.bottom);
            position.x -= Math.abs(screenInsets.left);
            position.y -= Math.abs(screenInsets.top);
        }
        if ((parent = this.getParent()) instanceof JPopupMenu) {
            xOffset = UIDefaultsLookup.getInt("Menu.submenuPopupOffsetX");
            yOffset = UIDefaultsLookup.getInt("Menu.submenuPopupOffsetY");
            if (this.getComponentOrientation().isLeftToRight()) {
                if (JideSwingUtilities.getOrientationOf(this) == 0) {
                    x2 = s2.width + xOffset;
                    if (position.x + x2 + pmSize.width >= screenBounds.width + screenBounds.x && screenBounds.width - s2.width < 2 * (position.x - screenBounds.x)) {
                        x2 = 0 - xOffset - pmSize.width;
                    }
                } else {
                    x2 = s2.width + xOffset;
                    if (position.x + x2 + pmSize.width >= screenBounds.width + screenBounds.x && screenBounds.width - s2.width < 2 * (position.x - screenBounds.x)) {
                        x2 = 0 - xOffset - pmSize.width;
                    }
                }
            } else {
                x2 = 0 - xOffset - pmSize.width;
                if (position.x + x2 < screenBounds.x && screenBounds.width - s2.width > 2 * (position.x - screenBounds.x)) {
                    x2 = s2.width + xOffset;
                }
            }
            if (position.y + (y = yOffset) + pmSize.height >= screenBounds.height + screenBounds.y && screenBounds.height - s2.height < 2 * (position.y - screenBounds.y)) {
                y = s2.height - yOffset - pmSize.height;
            }
        } else {
            xOffset = UIDefaultsLookup.getInt("Menu.menuPopupOffsetX");
            yOffset = UIDefaultsLookup.getInt("Menu.menuPopupOffsetY");
            if (this.getComponentOrientation().isLeftToRight()) {
                if (JideSwingUtilities.getOrientationOf(this) == 0) {
                    if (this.getPreferredPopupHorizontalAlignment() == 2) {
                        x2 = xOffset;
                        if (position.x + x2 + pmSize.width >= screenBounds.width + screenBounds.x && screenBounds.width - s2.width < 2 * (position.x - screenBounds.x)) {
                            x2 = s2.width - xOffset - pmSize.width;
                        }
                    } else {
                        x2 = -pmSize.width + xOffset + s2.width;
                        if (position.x + x2 < screenBounds.x) {
                            x2 = screenBounds.x - position.x;
                        }
                    }
                } else {
                    x2 = 1 - xOffset - pmSize.width;
                    if (position.x + x2 < screenBounds.x && screenBounds.width - s2.width > 2 * (position.x - screenBounds.x)) {
                        x2 = s2.width + xOffset - 1;
                    }
                }
            } else if (this.getPreferredPopupHorizontalAlignment() == 2) {
                x2 = s2.width - xOffset - pmSize.width;
                if (position.x + x2 < screenBounds.x && screenBounds.width - s2.width > 2 * (position.x - screenBounds.x)) {
                    x2 = xOffset;
                }
            } else {
                x2 = xOffset;
            }
            if (JideSwingUtilities.getOrientationOf(this) == 0) {
                y = s2.height + yOffset - 1;
                if (this.getPreferredPopupVerticalAlignment() == 1 || position.y + y + pmSize.height >= screenBounds.height && screenBounds.height - s2.height < 2 * (position.y - screenBounds.y)) {
                    y = 1 - yOffset - pmSize.height;
                }
            } else {
                y = -yOffset;
                if (position.y + y + pmSize.height >= screenBounds.height && screenBounds.height - s2.height < 2 * (position.y - screenBounds.y)) {
                    y = 0 - yOffset - pmSize.height;
                }
            }
        }
        return new Point(x2, y);
    }

    public boolean isOpaque() {
        return SystemInfo.isMacOSX() && this.isSelected() ? super.isOpaque() : !this.isTopLevelMenu() && super.isOpaque();
    }

    public boolean originalIsOpaque() {
        return super.isOpaque();
    }

    protected void hideMenu() {
        MenuSelectionManager msm = MenuSelectionManager.defaultManager();
        msm.clearSelectedPath();
    }

    public int getPreferredPopupHorizontalAlignment() {
        return this._preferredPopupHorizontalAlignment;
    }

    public void setPreferredPopupHorizontalAlignment(int preferredPopupHorizontalAlignment) {
        this._preferredPopupHorizontalAlignment = preferredPopupHorizontalAlignment;
    }

    public int getPreferredPopupVerticalAlignment() {
        return this._preferredPopupVerticalAlignment;
    }

    public void setPreferredPopupVerticalAlignment(int preferredPopupVerticalAlignment) {
        this._preferredPopupVerticalAlignment = preferredPopupVerticalAlignment;
    }

    public boolean supportVerticalOrientation() {
        return true;
    }

    public boolean supportHorizontalOrientation() {
        return true;
    }

    public void setOrientation(int orientation) {
        int old = this._orientation;
        if (old != orientation) {
            this._orientation = orientation;
            this.firePropertyChange("orientation", old, orientation);
        }
    }

    public int getOrientation() {
        return this._orientation;
    }

    public void setPopupMenuVisible(boolean b2) {
        PopupMenuCustomizer customizer;
        MenuCreator menuCreator;
        if (b2 && (menuCreator = this.getMenuCreator()) != null) {
            menuCreator.createMenu();
        }
        if (b2 && (customizer = this.getPopupMenuCustomizer()) != null) {
            customizer.customize(this.getPopupMenu());
            if (this.shouldHidePopupMenu()) {
                return;
            }
        } else if (b2 && this.shouldHidePopupMenu()) {
            return;
        }
        this.setPopupMenuVisibleImmediately(b2);
    }

    protected boolean shouldHidePopupMenu() {
        return this.getPopupMenu().getComponentCount() == 0;
    }

    void setPopupMenuVisibleImmediately(boolean b2) {
        super.setPopupMenuVisible(b2);
    }

    private void startTimer() {
        if (_timer != null) {
            this.stopTimer();
        }
        _pendingMenu = this;
        _timer = new HideTimer();
        _timer.start();
    }

    private void stopTimer() {
        if (_timer != null) {
            if (_pendingMenu != null) {
                _pendingMenu.setPopupMenuVisibleImmediately(false);
                _pendingMenu = null;
            }
            _timer.stop();
            _timer = null;
        }
    }

    private class HideTimer
    extends Timer
    implements ActionListener {
        private static final long serialVersionUID = 561631364532967870L;

        public HideTimer() {
            super(DELAY + 300, null);
            this.addActionListener(this);
            this.setRepeats(false);
        }

        public void actionPerformed(ActionEvent e2) {
            JideMenu.this.stopTimer();
        }
    }

    public static interface PopupMenuOriginCalculator {
        public Point getPopupMenuOrigin(JideMenu var1);
    }

    public static interface PopupMenuCustomizer {
        public void customize(JPopupMenu var1);
    }

    @Deprecated
    public static interface MenuCreator {
        public void createMenu();
    }
}

