/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.plaf.HeaderBoxUI;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.swing.HeaderBox;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.ComponentUI;

public class BasicHeaderBoxUI
extends HeaderBoxUI {
    private static HeaderBoxUI _headerBoxUI;
    protected ThemePainter _painter;

    public static ComponentUI createUI(JComponent c2) {
        if (_headerBoxUI == null) {
            _headerBoxUI = new BasicHeaderBoxUI();
        }
        return _headerBoxUI;
    }

    public void installUI(JComponent c2) {
        HeaderBox p2 = (HeaderBox)c2;
        super.installUI(p2);
        this.installDefaults(p2);
        this.installListeners(p2);
    }

    public void uninstallUI(JComponent c2) {
        HeaderBox p2 = (HeaderBox)c2;
        this.uninstallDefaults(p2);
        this.uninstallListeners(p2);
        super.uninstallUI(c2);
    }

    protected void installListeners(JComponent c2) {
        RolloverMouseInputAdapter l2 = this.createHeaderBoxMouseListener();
        c2.addMouseListener(l2);
    }

    private RolloverMouseInputAdapter getMouseListener(HeaderBox b2) {
        MouseMotionListener[] listeners = b2.getMouseMotionListeners();
        if (listeners != null) {
            for (MouseMotionListener listener : listeners) {
                if (!(listener instanceof RolloverMouseInputAdapter)) continue;
                return (RolloverMouseInputAdapter)listener;
            }
        }
        return null;
    }

    private RolloverMouseInputAdapter createHeaderBoxMouseListener() {
        return new RolloverMouseInputAdapter();
    }

    protected void uninstallListeners(JComponent c2) {
        HeaderBox b2 = (HeaderBox)c2;
        RolloverMouseInputAdapter listener = this.getMouseListener(b2);
        if (listener != null) {
            b2.removeMouseListener(listener);
        }
    }

    protected void installDefaults(HeaderBox p2) {
        this._painter = (ThemePainter)UIDefaultsLookup.get("Theme.painter");
        LookAndFeel.installColorsAndFont(p2, "Panel.background", "Panel.foreground", "Panel.font");
        LookAndFeel.installBorder(p2, "Panel.border");
    }

    public void paint(Graphics g2, JComponent c2) {
        super.paint(g2, c2);
        this.paintBackground(g2, c2);
        this.paintBorder(g2, c2);
    }

    protected void paintBorder(Graphics g2, JComponent c2) {
    }

    protected void paintBackground(Graphics g2, JComponent c2) {
        HeaderBox headerBox = (HeaderBox)c2;
        Rectangle rect = new Rectangle(0, 0, c2.getWidth(), c2.getHeight());
        if (headerBox.getModel().isPressed()) {
            this._painter.paintHeaderBoxBackground(c2, g2, rect, 0, 1);
        } else if (headerBox.getModel().isSelected()) {
            this._painter.paintHeaderBoxBackground(c2, g2, rect, 0, 3);
        } else if (headerBox.getModel().isRollover()) {
            this._painter.paintHeaderBoxBackground(c2, g2, rect, 0, 2);
        } else {
            this._painter.paintHeaderBoxBackground(c2, g2, rect, 0, 0);
        }
    }

    protected void uninstallDefaults(HeaderBox p2) {
        LookAndFeel.uninstallBorder(p2);
        this._painter = null;
    }

    protected class RolloverMouseInputAdapter
    extends MouseInputAdapter {
        private long lastPressedTimestamp = -1L;
        private boolean shouldDiscardRelease = false;

        protected RolloverMouseInputAdapter() {
        }

        public void mousePressed(MouseEvent e2) {
            AbstractButton b2;
            if (SwingUtilities.isLeftMouseButton(e2) && (b2 = (AbstractButton)e2.getSource()).contains(e2.getX(), e2.getY())) {
                long multiClickThreshold = b2.getMultiClickThreshhold();
                long lastTime = this.lastPressedTimestamp;
                long currentTime = this.lastPressedTimestamp = e2.getWhen();
                if (lastTime != -1L && currentTime - lastTime < multiClickThreshold) {
                    this.shouldDiscardRelease = true;
                    return;
                }
                ButtonModel model = b2.getModel();
                if (!model.isEnabled()) {
                    return;
                }
                if (!model.isArmed()) {
                    model.setArmed(true);
                }
                model.setPressed(true);
                if (!b2.hasFocus() && b2.isRequestFocusEnabled()) {
                    b2.requestFocus();
                }
            }
        }

        public void mouseReleased(MouseEvent e2) {
            if (SwingUtilities.isLeftMouseButton(e2)) {
                if (this.shouldDiscardRelease) {
                    this.shouldDiscardRelease = false;
                    return;
                }
                AbstractButton b2 = (AbstractButton)e2.getSource();
                ButtonModel model = b2.getModel();
                model.setPressed(false);
                model.setArmed(false);
            }
        }

        public void mouseEntered(MouseEvent e2) {
            AbstractButton b2 = (AbstractButton)e2.getSource();
            ButtonModel model = b2.getModel();
            if (b2.isRolloverEnabled() && !SwingUtilities.isLeftMouseButton(e2)) {
                model.setRollover(true);
            }
            if (model.isPressed()) {
                model.setArmed(true);
            }
        }

        public void mouseExited(MouseEvent e2) {
            AbstractButton b2 = (AbstractButton)e2.getSource();
            ButtonModel model = b2.getModel();
            if (b2.isRolloverEnabled()) {
                model.setRollover(false);
            }
            model.setArmed(false);
        }
    }
}

