/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarException;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import javax.crypto.CryptoPermissions;
import javax.crypto.CryptoPolicyParser;
import sun.security.validator.Validator;

final class JarVerifier {
    private static final String PLUGIN_IMPL_NAME = "sun.plugin.net.protocol.jar.CachedJarURLConnection";
    private static X509Certificate frameworkCertificate;
    private static Validator providerValidator;
    private static Validator exemptValidator;
    private List<X509Certificate> verifiedSignerCache = null;
    private URL jarURL;
    private Validator validator;
    private boolean savePerms;
    private CryptoPermissions appPerms = null;

    private static X509Certificate parseCertificate(String string, CertificateFactory certificateFactory) throws Exception {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes("UTF8"));
        return (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
    }

    JarVerifier(URL uRL, boolean bl) {
        this.jarURL = uRL;
        this.savePerms = bl;
        this.validator = bl ? providerValidator : exemptValidator;
        this.verifiedSignerCache = Collections.synchronizedList(new ArrayList(2));
    }

    void verify() throws JarException, IOException {
        if (this.jarURL == null) {
            throw new JarException("Class is on the bootclasspath");
        }
        try {
            this.verifyJars(this.jarURL, null);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new JarException("Cannot verify " + this.jarURL.toString());
        }
        catch (CertificateException certificateException) {
            throw new JarException("Cannot verify " + this.jarURL.toString());
        }
        catch (CryptoPolicyParser.ParsingException parsingException) {
            throw new JarException("Cannot parse " + this.jarURL.toString());
        }
        finally {
            if (this.verifiedSignerCache != null) {
                this.verifiedSignerCache.clear();
            }
        }
    }

    static void verifyPolicySigned(Certificate[] certificateArray) throws Exception {
        List<X509Certificate[]> list = JarVerifier.convertCertsToChains(certificateArray);
        boolean bl = false;
        for (X509Certificate[] x509CertificateArray : list) {
            X509Certificate x509Certificate = x509CertificateArray[0];
            if (!x509Certificate.equals(frameworkCertificate)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            throw new SecurityException("The jurisdiction policy files are not signed by a trusted signer!");
        }
    }

    CryptoPermissions getPermissions() {
        return this.appPerms;
    }

    private void verifyJars(URL uRL, List<String> list) throws NoSuchProviderException, CertificateException, IOException, CryptoPolicyParser.ParsingException {
        String string = uRL.toString();
        if (list == null || !list.contains(string)) {
            String string2 = this.verifySingleJar(uRL);
            if (list != null) {
                list.add(string);
            }
            if (string2 != null) {
                if (list == null) {
                    list = Collections.synchronizedList(new ArrayList());
                    list.add(string);
                }
                this.verifyManifestClassPathJars(uRL, string2, list);
            }
        }
    }

    private void verifyManifestClassPathJars(URL uRL, String string, List<String> list) throws NoSuchProviderException, CertificateException, IOException, CryptoPolicyParser.ParsingException {
        String[] stringArray = JarVerifier.parseAttrClasspath(string);
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                URL uRL2 = new URL(uRL, stringArray[i]);
                this.verifyJars(uRL2, list);
            }
        }
        catch (MalformedURLException malformedURLException) {
            MalformedURLException malformedURLException2 = new MalformedURLException("The JAR file " + uRL.toString() + " contains invalid URLs in its Class-Path attribute");
            malformedURLException2.initCause(malformedURLException);
            throw malformedURLException2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String verifySingleJar(URL uRL) throws NoSuchProviderException, CertificateException, IOException, CryptoPolicyParser.ParsingException {
        final URL uRL2 = uRL.getProtocol().equalsIgnoreCase("jar") ? uRL : new URL("jar:" + uRL.toString() + "!/");
        JarHolder jarHolder = null;
        try {
            try {
                jarHolder = AccessController.doPrivileged(new PrivilegedExceptionAction<JarHolder>(){

                    @Override
                    public JarHolder run() throws Exception {
                        boolean bl = false;
                        JarURLConnection jarURLConnection = (JarURLConnection)uRL2.openConnection();
                        if (jarURLConnection.getClass().getName().equals(JarVerifier.PLUGIN_IMPL_NAME)) {
                            bl = true;
                        }
                        jarURLConnection.setUseCaches(bl);
                        JarFile jarFile = jarURLConnection.getJarFile();
                        if (jarFile != null) {
                            return new JarHolder(jarFile, bl);
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                SecurityException securityException = new SecurityException("Cannot verify " + uRL2.toString());
                securityException.initCause(privilegedActionException);
                throw securityException;
            }
            if (jarHolder != null) {
                Object object;
                Object object2;
                Cloneable cloneable;
                JarFile jarFile = jarHolder.file;
                byte[] byArray = new byte[8192];
                Enumeration<JarEntry> enumeration = jarFile.entries();
                while (enumeration.hasMoreElements()) {
                    cloneable = enumeration.nextElement();
                    object2 = new BufferedInputStream(jarFile.getInputStream((ZipEntry)cloneable));
                    object = null;
                    try {
                        while (((BufferedInputStream)object2).read(byArray, 0, byArray.length) != -1) {
                        }
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (object2 == null) continue;
                        if (object != null) {
                            try {
                                ((BufferedInputStream)object2).close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                            continue;
                        }
                        ((BufferedInputStream)object2).close();
                    }
                }
                cloneable = jarFile.getManifest();
                if (cloneable == null) {
                    throw new JarException(uRL.toString() + " is not signed.");
                }
                object2 = jarFile.entries();
                while (object2.hasMoreElements()) {
                    X509Certificate[] x509CertificateArray;
                    object = (JarEntry)object2.nextElement();
                    if (((ZipEntry)object).isDirectory()) continue;
                    Certificate[] certificateArray = ((JarEntry)object).getCertificates();
                    if (certificateArray == null || certificateArray.length == 0) {
                        if (((ZipEntry)object).getName().startsWith("META-INF")) continue;
                        throw new JarException(uRL.toString() + " has unsigned entries - " + ((ZipEntry)object).getName());
                    }
                    int n = 0;
                    boolean bl = false;
                    while ((x509CertificateArray = JarVerifier.getAChain(certificateArray, n)) != null) {
                        if (this.verifiedSignerCache.contains(x509CertificateArray[0])) {
                            bl = true;
                            break;
                        }
                        if (this.isTrusted(x509CertificateArray)) {
                            bl = true;
                            this.verifiedSignerCache.add(x509CertificateArray[0]);
                            break;
                        }
                        n += x509CertificateArray.length;
                    }
                    if (bl) continue;
                    throw new JarException(uRL.toString() + " is not signed by a trusted signer.");
                }
                if (this.jarURL.equals(uRL) && this.savePerms) {
                    object = jarHolder.file.getJarEntry("cryptoPerms");
                    if (object == null) {
                        throw new JarException("Can not find cryptoPerms");
                    }
                    this.appPerms = new CryptoPermissions();
                    this.appPerms.load(jarHolder.file.getInputStream((ZipEntry)object));
                }
                object = ((Manifest)cloneable).getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
                return object;
            }
            String string = null;
            return string;
        }
        finally {
            if (jarHolder != null && !jarHolder.useCaches) {
                jarHolder.file.close();
            }
        }
    }

    private static String[] parseAttrClasspath(String string) throws JarException {
        string = string.trim();
        int n = string.indexOf(32);
        String string2 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        do {
            if (n > 0) {
                string2 = string.substring(0, n);
                string = string.substring(n + 1).trim();
                n = string.indexOf(32);
            } else {
                string2 = string;
                bl = true;
            }
            if (!string2.endsWith(".jar")) {
                throw new JarException("The provider contains un-verifiable components");
            }
            arrayList.add(string2);
        } while (!bl);
        return arrayList.toArray(new String[0]);
    }

    private boolean isTrusted(X509Certificate[] x509CertificateArray) {
        try {
            this.validator.validate(x509CertificateArray);
            return true;
        }
        catch (CertificateException certificateException) {
            return false;
        }
    }

    private static X509Certificate[] getAChain(Certificate[] certificateArray, int n) {
        int n2;
        if (n > certificateArray.length - 1) {
            return null;
        }
        for (n2 = n; n2 < certificateArray.length - 1 && ((X509Certificate)certificateArray[n2 + 1]).getSubjectDN().equals(((X509Certificate)certificateArray[n2]).getIssuerDN()); ++n2) {
        }
        int n3 = n2 - n + 1;
        X509Certificate[] x509CertificateArray = new X509Certificate[n3];
        for (int i = 0; i < n3; ++i) {
            x509CertificateArray[i] = (X509Certificate)certificateArray[n + i];
        }
        return x509CertificateArray;
    }

    private static List<X509Certificate[]> convertCertsToChains(Certificate[] certificateArray) throws CertificateException {
        if (certificateArray == null) {
            return Collections.emptyList();
        }
        ArrayList<X509Certificate[]> arrayList = new ArrayList<X509Certificate[]>();
        X509Certificate[] x509CertificateArray = null;
        int n = 0;
        while ((x509CertificateArray = JarVerifier.getAChain(certificateArray, n)) != null) {
            arrayList.add(x509CertificateArray);
            n += x509CertificateArray.length;
        }
        return arrayList;
    }

    private static void testSignatures(X509Certificate x509Certificate, CertificateFactory certificateFactory) throws Exception {
        PublicKey[] publicKeyArray;
        String string = "-----BEGIN CERTIFICATE-----\nMIIDLDCCAukCBDf5OeUwCwYHKoZIzjgEAwUAMHsxCzAJBgNVBAYTAlVTMQswCQYDVQQIEwJDQTESMBAGA1UEBxMJQ3VwZXJ0aW5vMRkwFwYDVQQKExBTdW4gTWljcm9zeXN0ZW1zMRYwFAYDVQQLEw1KYXZhIFNvZnR3YXJlMRgwFgYDVQQDEw9KQ0UgRGV2ZWxvcG1lbnQwHhcNOTkxMDA0MjMzNjA1WhcNMDAxMDAzMjMzNjA1WjB7MQswCQYDVQQGEwJVUzELMAkGA1UECBMCQ0ExEjAQBgNVBAcTCUN1cGVydGlubzEZMBcGA1UEChMQU3VuIE1pY3Jvc3lzdGVtczEWMBQGA1UECxMNSmF2YSBTb2Z0d2FyZTEYMBYGA1UEAxMPSkNFIERldmVsb3BtZW50MIIBuDCCASwGByqGSM44BAEwggEfAoGBAP1/U4EddRIpUt9KnC7s5Of2EbdSPO9EAMMeP4C2USZpRV1AIlH7WT2NWPq/xfW6MPbLm1Vs14E7gB00b/JmYLdrmVClpJ+f6AR7ECLCT7up1/63xhv4O1fnxqimFQ8E+4P208UewwI1VBNaFpEy9nXzrith1yrv8iIDGZ3RSAHHAhUAl2BQjxUjC8yykrmCouuEC/BYHPUCgYEA9+GghdabPd7LvKtcNrhXuXmUr7v6OuqC+VdMCz0HgmdRWVeOutRZT+ZxBxCBgLRJFnEj6EwoFhO3zwkyjMim4TwWeotUfI0o4KOuHiuzpnWRbqN/C/ohNWLx+2J6ASQ7zKTxvqhRkImog9/hWuWfBpKLZl6Ae1UlZAFMO/7PSSoDgYUAAoGBAOGsR8waR5aiuOk1yBLemRlVCY+APJv3xqmPRxWAF6nwV2xrFUB8ghSEMFcHywoe4vBDvkGSoAFzeB5jy5wjDiFsN5AFPEVRfveS4NNZ1dgRdHbbh3h5O1dZE4MAKQwQfUoh9Oa3aahlB+orRzKOHLlGDpbNRQLST5BClvohramCMAsGByqGSM44BAMFAAMwADAtAhRF46T3nS+inP9TA1pLd3LIV0NNDQIVAIafi+1/+JKxu0rcoXWMFSxNaRb3\n-----END CERTIFICATE-----";
        byte[] byArray = JarVerifier.getSystemEntropy();
        int n = byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8 | (byArray[2] & 0xFF) << 16 | byArray[3] << 24;
        X509Certificate[] x509CertificateArray = new X509Certificate[]{x509Certificate, JarVerifier.parseCertificate(string, certificateFactory), JarVerifier.parseCertificate("-----BEGIN CERTIFICATE-----\nMIIB4DCCAYoCAQEwDQYJKoZIhvcNAQEEBQAwezELMAkGA1UEBhMCVVMxCzAJBgNVBAgTAkNBMRIwEAYDVQQHEwlDdXBlcnRpbm8xGTAXBgNVBAoTEFN1biBNaWNyb3N5c3RlbXMxFjAUBgNVBAsTDUphdmEgU29mdHdhcmUxGDAWBgNVBAMTD0pDRSBEZXZlbG9wbWVudDAeFw0wMjEwMzExNTI3NDRaFw0wNzEwMzExNTI3NDRaMHsxCzAJBgNVBAYTAlVTMQswCQYDVQQIEwJDQTESMBAGA1UEBxMJQ3VwZXJ0aW5vMRkwFwYDVQQKExBTdW4gTWljcm9zeXN0ZW1zMRYwFAYDVQQLEw1KYXZhIFNvZnR3YXJlMRgwFgYDVQQDEw9KQ0UgRGV2ZWxvcG1lbnQwXDANBgkqhkiG9w0BAQEFAANLADBIAkEAo/4CddEOa3M6v9JFAhnBYgTq54Y30++F8yzCK9EeYaG3AzvzZqNshDy579647p0cOM/4VO6rU2PgbzgKXPcs8wIDAQABMA0GCSqGSIb3DQEBBAUAA0EACqPlFmVdKdYSCTNltXKQnBqss9GNjbnB+CitvWrwN+oOK8qQpvV+5LB6LruvRy6zCedCV95Z2kXKg/Fnj0gvsg==\n-----END CERTIFICATE-----", certificateFactory), JarVerifier.parseCertificate("-----BEGIN CERTIFICATE-----\nMIIB4DCCAYoCAQIwDQYJKoZIhvcNAQEEBQAwezELMAkGA1UEBhMCVVMxCzAJBgNVBAgTAkNBMRIwEAYDVQQHEwlDdXBlcnRpbm8xGTAXBgNVBAoTEFN1biBNaWNyb3N5c3RlbXMxFjAUBgNVBAsTDUphdmEgU29mdHdhcmUxGDAWBgNVBAMTD0pDRSBEZXZlbG9wbWVudDAeFw0wMjEwMzExNTI3NDRaFw0wNzEwMzExNTI3NDRaMHsxCzAJBgNVBAYTAlVTMQswCQYDVQQIEwJDQTESMBAGA1UEBxMJQ3VwZXJ0aW5vMRkwFwYDVQQKExBTdW4gTWljcm9zeXN0ZW1zMRYwFAYDVQQLEw1KYXZhIFNvZnR3YXJlMRgwFgYDVQQDEw9KQ0UgRGV2ZWxvcG1lbnQwXDANBgkqhkiG9w0BAQEFAANLADBIAkEAr1OSXaOzpnVoqL2LqS5+HLy1kVvBwiM/E5iYT9eZaghE8qvF+4fETipWUNTWCQzHR4cDJGJOl9Nm77tELhES4QIDAQABMA0GCSqGSIb3DQEBBAUAA0EAL+WcVFyj+iXlEVNVQbNOOUlWmlmXGiNKKXnIdNcc1ZUyi+JW0zmlfZ7iU/eRYhEEJBwdrUoyiGOGLo7pi6JzAA==\n-----END CERTIFICATE-----", certificateFactory)};
        publicKeyArray = new PublicKey[]{x509Certificate.getPublicKey(), publicKeyArray[0], x509CertificateArray[2].getPublicKey(), publicKeyArray[2]};
        boolean[] blArray = new boolean[]{true, false, true, false};
        for (int i = 0; i < 12; ++i) {
            boolean bl;
            int n2 = n & 3;
            n >>= 2;
            try {
                x509CertificateArray[n2].verify(publicKeyArray[n2]);
                bl = true;
            }
            catch (SignatureException signatureException) {
                bl = false;
            }
            catch (InvalidKeyException invalidKeyException) {
                bl = false;
            }
            if (bl == blArray[n2]) continue;
            throw new SecurityException("Signature classes have been tampered with");
        }
    }

    private static byte[] getSystemEntropy() {
        Object object;
        Object object2;
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InternalError("internal error: SHA-1 not available.", noSuchAlgorithmException);
        }
        byte by = (byte)System.currentTimeMillis();
        messageDigest.update(by);
        try {
            object2 = System.getProperties();
            for (String string : ((Properties)object2).stringPropertyNames()) {
                messageDigest.update(string.getBytes());
                messageDigest.update(((Properties)object2).getProperty(string).getBytes());
            }
            JarVerifier.addNetworkAdapterInfo(messageDigest);
            object = new File(((Properties)object2).getProperty("java.io.tmpdir"));
            int n = 0;
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(((File)object).toPath());){
                Random random = new Random();
                for (Path path : directoryStream) {
                    if (n < 512 || random.nextBoolean()) {
                        messageDigest.update(path.getFileName().toString().getBytes());
                    }
                    if (n++ <= 1024) continue;
                    break;
                }
            }
        }
        catch (Exception exception) {
            messageDigest.update((byte)exception.hashCode());
        }
        object2 = Runtime.getRuntime();
        object = JarVerifier.longToByteArray(((Runtime)object2).totalMemory());
        messageDigest.update((byte[])object, 0, ((Object)object).length);
        object = JarVerifier.longToByteArray(((Runtime)object2).freeMemory());
        messageDigest.update((byte[])object, 0, ((Object)object).length);
        return messageDigest.digest();
    }

    private static byte[] longToByteArray(long l) {
        byte[] byArray = new byte[8];
        for (int i = 0; i < 8; ++i) {
            byArray[i] = (byte)l;
            l >>= 8;
        }
        return byArray;
    }

    private static void addNetworkAdapterInfo(MessageDigest messageDigest) {
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                byte[] byArray;
                NetworkInterface networkInterface = enumeration.nextElement();
                messageDigest.update(networkInterface.toString().getBytes());
                if (networkInterface.isVirtual() || (byArray = networkInterface.getHardwareAddress()) == null) continue;
                messageDigest.update(byArray);
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                    frameworkCertificate = JarVerifier.parseCertificate("-----BEGIN CERTIFICATE-----\nMIICoTCCAl+gAwIBAgICAzkwCwYHKoZIzjgEAwUAMIGQMQswCQYDVQQGEwJVUzELMAkGA1UECBMCQ0ExEjAQBgNVBAcTCVBhbG8gQWx0bzEdMBsGA1UEChMUU3VuIE1pY3Jvc3lzdGVtcyBJbmMxIzAhBgNVBAsTGkphdmEgU29mdHdhcmUgQ29kZSBTaWduaW5nMRwwGgYDVQQDExNKQ0UgQ29kZSBTaWduaW5nIENBMB4XDTExMDQxMTA2MDA0M1oXDTE2MDQxNDA2MDA0M1owYTEdMBsGA1UEChMUU3VuIE1pY3Jvc3lzdGVtcyBJbmMxIzAhBgNVBAsTGkphdmEgU29mdHdhcmUgQ29kZSBTaWduaW5nMRswGQYDVQQDExJPcmFjbGUgQ29ycG9yYXRpb24wgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBALR6pnmTTdvYtjj0EH7nQTa52aHuWTsxIgX+sVzy5MyYcGZJk23QI623tCNLk1MgPf0ntUKe/HZjuvdrBIfgBcu2C+Htw0PwmQyjHQToAMUt5CfWpGLmBh0LVblnOb9mcOp/Ety4myc9V8c3LSVXpgvNgIUhu8Vv3IEM966NKtmLAgMBAAGjgY4wgYswEQYJYIZIAYb4QgEBBAQDAgQQMA4GA1UdDwEB/wQEAwIF4DAdBgNVHQ4EFgQU5YHrhAD3Wo9gQZEycFmm7NAgzUUwHwYDVR0jBBgwFoAUZeL0hsnTTvCRTliiavXYeFqawaYwJgYDVR0RBB8wHYEbYnJhZGZvcmQud2V0bW9yZUBvcmFjbGUuY29tMAsGByqGSM44BAMFAAMvADAsAhRVoQglrJDMgxGzsGFS7oHMbzLioQIUSps7E1B/RSMh6ooea/mGwKX4iVc=\n-----END CERTIFICATE-----", certificateFactory);
                    X509Certificate[] x509CertificateArray = new X509Certificate[]{JarVerifier.parseCertificate("-----BEGIN CERTIFICATE-----\nMIIDwDCCA36gAwIBAgIBEDALBgcqhkjOOAQDBQAwgZAxCzAJBgNVBAYTAlVTMQswCQYDVQQIEwJDQTESMBAGA1UEBxMJUGFsbyBBbHRvMR0wGwYDVQQKExRTdW4gTWljcm9zeXN0ZW1zIEluYzEjMCEGA1UECxMaSmF2YSBTb2Z0d2FyZSBDb2RlIFNpZ25pbmcxHDAaBgNVBAMTE0pDRSBDb2RlIFNpZ25pbmcgQ0EwHhcNMDEwNDI1MDcwMDAwWhcNMjAwNDI1MDcwMDAwWjCBkDELMAkGA1UEBhMCVVMxCzAJBgNVBAgTAkNBMRIwEAYDVQQHEwlQYWxvIEFsdG8xHTAbBgNVBAoTFFN1biBNaWNyb3N5c3RlbXMgSW5jMSMwIQYDVQQLExpKYXZhIFNvZnR3YXJlIENvZGUgU2lnbmluZzEcMBoGA1UEAxMTSkNFIENvZGUgU2lnbmluZyBDQTCCAbcwggEsBgcqhkjOOAQBMIIBHwKBgQDrrzcEHspRHmldsPKP9rVJH8akmQXXKb90t2r1Gdge5Bv4CgGamP9wq+JKVoZsU7P84ciBjDHwxPOwi+ZwBuz3aWjbg0xyKYkpNhdcO0oHoCACKkaXUR1wyAgYC84Mbpt29wXj5/vTYXnhYJokjQaVgzxRIOEwzzhXgqYacg3O0wIVAIQlReG6ualiq3noWzC4iWsb/3t1AoGBAKvJdHt07+5CtWpTTTvdkAZyaJEPC6Qpdi5VO9WuTWVcfio6BKZnptBxqqXXt+LBcg2k0aoeklRMIAAJorAJQRkzALLDXK5C+LGLynyW2BB/N0Rbqsx4yNdydjdrQJmoVWb6qAMei0oRAmnLTLglBhygd9LJrNI96QoQ+nZwt/vcA4GEAAKBgC0JmFysuJzHmX7uIBkqNJD516urrt1rcpUNZvjvJ49Esu0oRMf+r7CmJ28AZ0WCWweoVlY70ilRYV5pOdcudHcSzxlK9S3Iy3JhxE5v+kdDPxS7+rwYZijC2WaLei0vwmCSSxT+WD4hf2hivmxISfmgS16FnRkQ+RVFURtx1PcLo2YwZDARBglghkgBhvhCAQEEBAMCAAcwDwYDVR0TAQH/BAUwAwEB/zAfBgNVHSMEGDAWgBRl4vSGydNO8JFOWKJq9dh4WprBpjAdBgNVHQ4EFgQUZeL0hsnTTvCRTliiavXYeFqawaYwCwYHKoZIzjgEAwUAAy8AMCwCFCr3zzyXXfl4tgjXQbTZDUVM5LScAhRFzXVpDiH6HdazKbLp9zMdM/38SQ==\n-----END CERTIFICATE-----", certificateFactory), JarVerifier.parseCertificate("-----BEGIN CERTIFICATE-----\nMIIDUTCCAw2gAwIBAgIEQCFoETALBgcqhkjOOAQDBQAwYDELMAkGA1UEBhMCVVMxGDAWBgNVBAoTD0lCTSBDb3Jwb3JhdGlvbjEZMBcGA1UECxMQSUJNIENvZGUgU2lnbmluZzEcMBoGA1UEAxMTSkNFIENvZGUgU2lnbmluZyBDQTAeFw0wNDAyMDQyMTQ1NTNaFw0yMDA1MjYyMDQ1NTNaMGAxCzAJBgNVBAYTAlVTMRgwFgYDVQQKEw9JQk0gQ29ycG9yYXRpb24xGTAXBgNVBAsTEElCTSBDb2RlIFNpZ25pbmcxHDAaBgNVBAMTE0pDRSBDb2RlIFNpZ25pbmcgQ0EwggG4MIIBLAYHKoZIzjgEATCCAR8CgYEA/X9TgR11EilS30qcLuzk5/YRt1I870QAwx4/gLZRJmlFXUAiUftZPY1Y+r/F9bow9subVWzXgTuAHTRv8mZgt2uZUKWkn5/oBHsQIsJPu6nX/rfGG/g7V+fGqKYVDwT7g/bTxR7DAjVUE1oWkTL2dfOuK2HXKu/yIgMZndFIAccCFQCXYFCPFSMLzLKSuYKi64QL8Fgc9QKBgQD34aCF1ps93su8q1w2uFe5eZSvu/o66oL5V0wLPQeCZ1FZV4661FlP5nEHEIGAtEkWcSPoTCgWE7fPCTKMyKbhPBZ6i1R8jSjgo64eK7OmdZFuo38L+iE1YvH7YnoBJDvMpPG+qFGQiaiD3+Fa5Z8GkotmXoB7VSVkAUw7/s9JKgOBhQACgYEA6msAx98QO7l0NafhbWaCTfdbVnHCJkUncj1REGL/s9wQyftRE9Sti6glbl3JeNJbJ9MTQUcUBnzLgjhexgthoEyDLZTMjC6EkDqPQgppUtN0JnekFH0qcUGIiXemLWKaoViYbWzPzqjqut3ooRBEjIRCwbgfK7S8s110YICNQlSjUzBRMB0GA1UdDgQWBBR+PU1NzBBZuvmuQj3lyVdaUgt+hzAfBgNVHSMEGDAWgBR+PU1NzBBZuvmuQj3lyVdaUgt+hzAPBgNVHRMBAf8EBTADAQH/MAsGByqGSM44BAMFAAMxADAuAhUAi5ncRzk0NqFYt4yWsnlcVBPt+zsCFQCM9M0mv0t9iodsOOHJhqUrW1QjAA==\n-----END CERTIFICATE-----", certificateFactory), JarVerifier.parseCertificate("-----BEGIN CERTIFICATE-----\nMIIDqDCCApCgAwIBAgIIPJ6x/In3M9MwDQYJKoZIhvcNAQELBQAwYDEbMBkGA1UECgwST3JhY2xlIENvcnBvcmF0aW9uMSMwIQYDVQQLDBpKYXZhIFNvZnR3YXJlIENvZGUgU2lnbmluZzEcMBoGA1UEAwwTSkNFIENvZGUgU2lnbmluZyBDQTAeFw0xNjA3MDYyMzQ4NDRaFw0zMDEyMzEwMDAwMDBaMGAxGzAZBgNVBAoMEk9yYWNsZSBDb3Jwb3JhdGlvbjEjMCEGA1UECwwaSmF2YSBTb2Z0d2FyZSBDb2RlIFNpZ25pbmcxHDAaBgNVBAMME0pDRSBDb2RlIFNpZ25pbmcgQ0EwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCHGu8ubNImPxLYDIBNUFLAwFODNNwSTqsJqcdV66GV7VXa6niJSXAo+5z6Uy13UUA3KDqZ1xqyJ49ktAL2kmj8iMcqqQqGw6EwV1/MsgAxc1NXULIaShqyp5yt2Lj620J5FIlMNjXfWtJflOWMUPnMjE1sHf60OGIeDiqg4upSliI0VDnaO5y+6uJrqAXukQQQjYwu98boK7M8V2sR2wQNh03oIFMJCF9Hm66r5J53ADfEZRuPvgfxuZJaHCLbqOXpsp3pLMPRjhRsoY/UCzTfyNwA1kSyO6R43rIzqRvi3eOXQNIZwnPXzG/H48YU0A3I4KOZ1Nrkpe8CcieqxHMBAgMBAAGjZjBkMB0GA1UdDgQWBBRZ1QGE0wI7jUGXRpfnpVEHvGwgKzASBgNVHRMBAf8ECDAGAQH/AgEAMB8GA1UdIwQYMBaAFFnVAYTTAjuNQZdGl+elUQe8bCArMA4GA1UdDwEB/wQEAwIBhjANBgkqhkiG9w0BAQsFAAOCAQEAPxN/18JA6B7OeYYQa5K3+2vVwFYMETqEzCiXvsiWoGx6e7LSYiMlpCQwDoYyz2nuUB3bb1EA1o0Uiayv/zuTGLjjoa1wtTx5G+4ig6V+ahl/V6bGTT6dhoDeVMUApbltPKJ8ebSYNRoZHbjkIegN1mJA9hE+Opft2P9raT/MJJxjdVGP/d6pLBQUu/tQ7/8fsEItFzSjFEOUwsXD9kw8zTVOFigo36ZDtMuMMHas+FtqvjEAHUN5WicO2HweUFNOyiZoJkGdycW/VXBF91e1Fbgxb3naPbZ/OUivlUToFjICSLDlq8TxEaNhIQ7B1JxwxnW3vWorRmFelMg4aQNawA==\n-----END CERTIFICATE-----", certificateFactory), frameworkCertificate};
                    providerValidator = Validator.getInstance("Simple", "jce signing", Arrays.asList(x509CertificateArray));
                    exemptValidator = providerValidator;
                    JarVerifier.testSignatures(x509CertificateArray[0], certificateFactory);
                    return null;
                }
            });
        }
        catch (Exception exception) {
            SecurityException securityException = new SecurityException("Framework jar verification can not be initialized");
            securityException.initCause(exception);
            throw securityException;
        }
    }

    private static class JarHolder {
        JarFile file;
        boolean useCaches;

        JarHolder(JarFile jarFile, boolean bl) {
            this.file = jarFile;
            this.useCaches = bl;
        }
    }
}

