/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.peer.ComponentPeer;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FilePermission;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.Attribute;
import javax.print.attribute.EnumSyntax;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttribute;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Chromaticity;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.Destination;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.MediaTray;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PageRanges;
import javax.print.attribute.standard.PrintQuality;
import javax.print.attribute.standard.PrinterResolution;
import javax.print.attribute.standard.SheetCollate;
import javax.print.attribute.standard.Sides;
import sun.awt.Win32FontManager;
import sun.awt.windows.WPageDialog;
import sun.awt.windows.WPathGraphics;
import sun.awt.windows.WPrintDialog;
import sun.awt.windows.WWindowPeer;
import sun.java2d.Disposer;
import sun.java2d.DisposerRecord;
import sun.java2d.DisposerTarget;
import sun.print.DialogOwner;
import sun.print.PeekGraphics;
import sun.print.PeekMetrics;
import sun.print.RasterPrinterJob;
import sun.print.ServiceDialog;
import sun.print.SunAlternateMedia;
import sun.print.SunPageSelection;
import sun.print.Win32MediaTray;
import sun.print.Win32PrintService;
import sun.print.Win32PrintServiceLookup;

public final class WPrinterJob
extends RasterPrinterJob
implements DisposerTarget {
    protected static final long PS_ENDCAP_ROUND = 0L;
    protected static final long PS_ENDCAP_SQUARE = 256L;
    protected static final long PS_ENDCAP_FLAT = 512L;
    protected static final long PS_JOIN_ROUND = 0L;
    protected static final long PS_JOIN_BEVEL = 4096L;
    protected static final long PS_JOIN_MITER = 8192L;
    protected static final int POLYFILL_ALTERNATE = 1;
    protected static final int POLYFILL_WINDING = 2;
    private static final int MAX_WCOLOR = 255;
    private static final int SET_DUP_VERTICAL = 16;
    private static final int SET_DUP_HORIZONTAL = 32;
    private static final int SET_RES_HIGH = 64;
    private static final int SET_RES_LOW = 128;
    private static final int SET_COLOR = 512;
    private static final int SET_ORIENTATION = 16384;
    private static final int SET_COLLATED = 32768;
    private static final int PD_COLLATE = 16;
    private static final int PD_PRINTTOFILE = 32;
    private static final int DM_ORIENTATION = 1;
    private static final int DM_PAPERSIZE = 2;
    private static final int DM_COPIES = 256;
    private static final int DM_DEFAULTSOURCE = 512;
    private static final int DM_PRINTQUALITY = 1024;
    private static final int DM_COLOR = 2048;
    private static final int DM_DUPLEX = 4096;
    private static final int DM_YRESOLUTION = 8192;
    private static final int DM_COLLATE = 32768;
    private static final short DMCOLLATE_FALSE = 0;
    private static final short DMCOLLATE_TRUE = 1;
    private static final short DMORIENT_PORTRAIT = 1;
    private static final short DMORIENT_LANDSCAPE = 2;
    private static final short DMCOLOR_MONOCHROME = 1;
    private static final short DMCOLOR_COLOR = 2;
    private static final short DMRES_DRAFT = -1;
    private static final short DMRES_LOW = -2;
    private static final short DMRES_MEDIUM = -3;
    private static final short DMRES_HIGH = -4;
    private static final short DMDUP_SIMPLEX = 1;
    private static final short DMDUP_VERTICAL = 2;
    private static final short DMDUP_HORIZONTAL = 3;
    private static final int MAX_UNKNOWN_PAGES = 9999;
    private boolean driverDoesMultipleCopies = false;
    private boolean driverDoesCollation = false;
    private boolean userRequestedCollation = false;
    private boolean noDefaultPrinter = false;
    private HandleRecord handleRecord = new HandleRecord();
    private int mPrintPaperSize;
    private int mPrintXRes;
    private int mPrintYRes;
    private int mPrintPhysX;
    private int mPrintPhysY;
    private int mPrintWidth;
    private int mPrintHeight;
    private int mPageWidth;
    private int mPageHeight;
    private int mAttSides;
    private int mAttChromaticity;
    private int mAttXRes;
    private int mAttYRes;
    private int mAttQuality;
    private int mAttCollate;
    private int mAttCopies;
    private int mAttMediaSizeName;
    private int mAttMediaTray;
    private String mDestination = null;
    private Color mLastColor;
    private Color mLastTextColor;
    private String mLastFontFamily;
    private float mLastFontSize;
    private int mLastFontStyle;
    private int mLastRotation;
    private float mLastAwScale;
    private PrinterJob pjob;
    private ComponentPeer dialogOwnerPeer = null;
    private Object disposerReferent = new Object();
    private String lastNativeService = null;
    private boolean defaultCopies = true;

    public WPrinterJob() {
        this.handleRecord = new HandleRecord();
        Disposer.addRecord(this.disposerReferent, this.handleRecord);
        this.initAttributeMembers();
    }

    @Override
    public Object getDisposerReferent() {
        return this.disposerReferent;
    }

    @Override
    public PageFormat pageDialog(PageFormat pageFormat) throws HeadlessException {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        if (!(this.getPrintService() instanceof Win32PrintService)) {
            return super.pageDialog(pageFormat);
        }
        PageFormat pageFormat2 = (PageFormat)pageFormat.clone();
        boolean bl = false;
        WPageDialog wPageDialog = new WPageDialog((Frame)null, (PrinterJob)this, pageFormat2, null);
        wPageDialog.setRetVal(false);
        wPageDialog.setVisible(true);
        bl = wPageDialog.getRetVal();
        wPageDialog.dispose();
        if (bl && this.myService != null) {
            String string = this.getNativePrintService();
            if (!this.myService.getName().equals(string)) {
                try {
                    this.setPrintService(Win32PrintServiceLookup.getWin32PrintLUS().getPrintServiceByName(string));
                }
                catch (PrinterException printerException) {
                    // empty catch block
                }
            }
            this.updatePageAttributes(this.myService, pageFormat2);
            return pageFormat2;
        }
        return pageFormat;
    }

    private boolean displayNativeDialog() {
        Object object;
        Object object2;
        String string;
        if (this.attributes == null) {
            return false;
        }
        DialogOwner dialogOwner = (DialogOwner)this.attributes.get(DialogOwner.class);
        Frame frame = dialogOwner != null ? dialogOwner.getOwner() : null;
        WPrintDialog wPrintDialog = new WPrintDialog(frame, (PrinterJob)this);
        wPrintDialog.setRetVal(false);
        wPrintDialog.setVisible(true);
        boolean bl = wPrintDialog.getRetVal();
        wPrintDialog.dispose();
        Destination destination = (Destination)this.attributes.get(Destination.class);
        if (destination == null || !bl) {
            return bl;
        }
        String string2 = null;
        String string3 = "sun.print.resources.serviceui";
        ResourceBundle resourceBundle = ResourceBundle.getBundle(string3);
        try {
            string2 = resourceBundle.getString("dialog.printtofile");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        FileDialog fileDialog = new FileDialog(frame, string2, 1);
        URI uRI = destination.getURI();
        String string4 = string = uRI != null ? uRI.getSchemeSpecificPart() : null;
        if (string != null) {
            object2 = new File(string);
            fileDialog.setFile(((File)object2).getName());
            object = ((File)object2).getParentFile();
            if (object != null) {
                fileDialog.setDirectory(((File)object).getPath());
            }
        } else {
            fileDialog.setFile("out.prn");
        }
        fileDialog.setVisible(true);
        object2 = fileDialog.getFile();
        if (object2 == null) {
            fileDialog.dispose();
            return false;
        }
        object = fileDialog.getDirectory() + (String)object2;
        File file = new File((String)object);
        File file2 = file.getParentFile();
        while (file.exists() && (!file.isFile() || !file.canWrite()) || file2 != null && (!file2.exists() || file2.exists() && !file2.canWrite())) {
            new PrintToFileErrorDialog(frame, ServiceDialog.getMsg("dialog.owtitle"), ServiceDialog.getMsg("dialog.writeerror") + " " + (String)object, ServiceDialog.getMsg("button.ok")).setVisible(true);
            fileDialog.setVisible(true);
            object2 = fileDialog.getFile();
            if (object2 == null) {
                fileDialog.dispose();
                return false;
            }
            object = fileDialog.getDirectory() + (String)object2;
            file = new File((String)object);
            file2 = file.getParentFile();
        }
        fileDialog.dispose();
        this.attributes.add(new Destination(file.toURI()));
        return true;
    }

    @Override
    public boolean printDialog() throws HeadlessException {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        if (this.attributes == null) {
            this.attributes = new HashPrintRequestAttributeSet();
        }
        if (!(this.getPrintService() instanceof Win32PrintService)) {
            return super.printDialog(this.attributes);
        }
        if (this.noDefaultPrinter) {
            return false;
        }
        return this.displayNativeDialog();
    }

    @Override
    public void setPrintService(PrintService printService) throws PrinterException {
        super.setPrintService(printService);
        if (!(printService instanceof Win32PrintService)) {
            return;
        }
        this.driverDoesMultipleCopies = false;
        this.driverDoesCollation = false;
        this.setNativePrintServiceIfNeeded(printService.getName());
    }

    private native void setNativePrintService(String var1) throws PrinterException;

    private void setNativePrintServiceIfNeeded(String string) throws PrinterException {
        if (string != null && !string.equals(this.lastNativeService)) {
            this.setNativePrintService(string);
            this.lastNativeService = string;
        }
    }

    @Override
    public PrintService getPrintService() {
        if (this.myService == null) {
            String string = this.getNativePrintService();
            if (string != null) {
                this.myService = Win32PrintServiceLookup.getWin32PrintLUS().getPrintServiceByName(string);
                if (this.myService != null) {
                    return this.myService;
                }
            }
            this.myService = PrintServiceLookup.lookupDefaultPrintService();
            if (this.myService instanceof Win32PrintService) {
                try {
                    this.setNativePrintServiceIfNeeded(this.myService.getName());
                }
                catch (Exception exception) {
                    this.myService = null;
                }
            }
        }
        return this.myService;
    }

    private native String getNativePrintService();

    private void initAttributeMembers() {
        this.mAttSides = 0;
        this.mAttChromaticity = 0;
        this.mAttXRes = 0;
        this.mAttYRes = 0;
        this.mAttQuality = 0;
        this.mAttCollate = -1;
        this.mAttCopies = 0;
        this.mAttMediaTray = 0;
        this.mAttMediaSizeName = 0;
        this.mDestination = null;
    }

    @Override
    protected void setAttributes(PrintRequestAttributeSet printRequestAttributeSet) throws PrinterException {
        this.initAttributeMembers();
        super.setAttributes(printRequestAttributeSet);
        this.mAttCopies = this.getCopiesInt();
        this.mDestination = this.destinationAttr;
        if (printRequestAttributeSet == null) {
            return;
        }
        Attribute[] attributeArray = printRequestAttributeSet.toArray();
        for (int i = 0; i < attributeArray.length; ++i) {
            Attribute attribute = attributeArray[i];
            try {
                Media media;
                if (attribute.getCategory() == Sides.class) {
                    this.setSidesAttrib(attribute);
                    continue;
                }
                if (attribute.getCategory() == Chromaticity.class) {
                    this.setColorAttrib(attribute);
                    continue;
                }
                if (attribute.getCategory() == PrinterResolution.class) {
                    this.setResolutionAttrib(attribute);
                    continue;
                }
                if (attribute.getCategory() == PrintQuality.class) {
                    this.setQualityAttrib(attribute);
                    continue;
                }
                if (attribute.getCategory() == SheetCollate.class) {
                    this.setCollateAttrib(attribute);
                    continue;
                }
                if (attribute.getCategory() != Media.class && attribute.getCategory() != SunAlternateMedia.class) continue;
                if (!(attribute.getCategory() != SunAlternateMedia.class || (media = (Media)printRequestAttributeSet.get(Media.class)) != null && media instanceof MediaTray)) {
                    attribute = ((SunAlternateMedia)attribute).getMedia();
                }
                if (attribute instanceof MediaSizeName) {
                    this.setWin32MediaAttrib(attribute);
                }
                if (!(attribute instanceof MediaTray)) continue;
                this.setMediaTrayAttrib(attribute);
                continue;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    private native void getDefaultPage(PageFormat var1);

    @Override
    public PageFormat defaultPage(PageFormat pageFormat) {
        PageFormat pageFormat2 = (PageFormat)pageFormat.clone();
        this.getDefaultPage(pageFormat2);
        return pageFormat2;
    }

    @Override
    protected native void validatePaper(Paper var1, Paper var2);

    @Override
    protected Graphics2D createPathGraphics(PeekGraphics peekGraphics, PrinterJob printerJob, Printable printable, PageFormat pageFormat, int n) {
        WPathGraphics wPathGraphics;
        PeekMetrics peekMetrics = peekGraphics.getMetrics();
        if (!forcePDL && (forceRaster || peekMetrics.hasNonSolidColors() || peekMetrics.hasCompositing())) {
            wPathGraphics = null;
        } else {
            BufferedImage bufferedImage = new BufferedImage(8, 8, 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            boolean bl = !peekGraphics.getAWTDrawingOnly();
            wPathGraphics = new WPathGraphics(graphics2D, printerJob, printable, pageFormat, n, bl);
        }
        return wPathGraphics;
    }

    @Override
    protected double getXRes() {
        if (this.mAttXRes != 0) {
            return this.mAttXRes;
        }
        return this.mPrintXRes;
    }

    @Override
    protected double getYRes() {
        if (this.mAttYRes != 0) {
            return this.mAttYRes;
        }
        return this.mPrintYRes;
    }

    @Override
    protected double getPhysicalPrintableX(Paper paper) {
        return this.mPrintPhysX;
    }

    @Override
    protected double getPhysicalPrintableY(Paper paper) {
        return this.mPrintPhysY;
    }

    @Override
    protected double getPhysicalPrintableWidth(Paper paper) {
        return this.mPrintWidth;
    }

    @Override
    protected double getPhysicalPrintableHeight(Paper paper) {
        return this.mPrintHeight;
    }

    @Override
    protected double getPhysicalPageWidth(Paper paper) {
        return this.mPageWidth;
    }

    @Override
    protected double getPhysicalPageHeight(Paper paper) {
        return this.mPageHeight;
    }

    @Override
    protected boolean isCollated() {
        return this.userRequestedCollation;
    }

    @Override
    protected int getCollatedCopies() {
        this.debug_println("driverDoesMultipleCopies=" + this.driverDoesMultipleCopies + " driverDoesCollation=" + this.driverDoesCollation);
        if (super.isCollated() && !this.driverDoesCollation) {
            this.mAttCollate = 0;
            this.mAttCopies = 1;
            return this.getCopies();
        }
        return 1;
    }

    @Override
    protected int getNoncollatedCopies() {
        if (this.driverDoesMultipleCopies || super.isCollated()) {
            return 1;
        }
        return this.getCopies();
    }

    private long getPrintDC() {
        return this.handleRecord.mPrintDC;
    }

    private void setPrintDC(long l) {
        this.handleRecord.mPrintDC = l;
    }

    private long getDevMode() {
        return this.handleRecord.mPrintHDevMode;
    }

    private void setDevMode(long l) {
        this.handleRecord.mPrintHDevMode = l;
    }

    private long getDevNames() {
        return this.handleRecord.mPrintHDevNames;
    }

    private void setDevNames(long l) {
        this.handleRecord.mPrintHDevNames = l;
    }

    protected void beginPath() {
        this.beginPath(this.getPrintDC());
    }

    protected void endPath() {
        this.endPath(this.getPrintDC());
    }

    protected void closeFigure() {
        this.closeFigure(this.getPrintDC());
    }

    protected void fillPath() {
        this.fillPath(this.getPrintDC());
    }

    protected void moveTo(float f, float f2) {
        this.moveTo(this.getPrintDC(), f, f2);
    }

    protected void lineTo(float f, float f2) {
        this.lineTo(this.getPrintDC(), f, f2);
    }

    protected void polyBezierTo(float f, float f2, float f3, float f4, float f5, float f6) {
        this.polyBezierTo(this.getPrintDC(), f, f2, f3, f4, f5, f6);
    }

    protected void setPolyFillMode(int n) {
        this.setPolyFillMode(this.getPrintDC(), n);
    }

    protected void selectSolidBrush(Color color) {
        if (!color.equals(this.mLastColor)) {
            this.mLastColor = color;
            float[] fArray = color.getRGBColorComponents(null);
            this.selectSolidBrush(this.getPrintDC(), (int)(fArray[0] * 255.0f), (int)(fArray[1] * 255.0f), (int)(fArray[2] * 255.0f));
        }
    }

    protected int getPenX() {
        return this.getPenX(this.getPrintDC());
    }

    protected int getPenY() {
        return this.getPenY(this.getPrintDC());
    }

    protected void selectClipPath() {
        this.selectClipPath(this.getPrintDC());
    }

    protected void frameRect(float f, float f2, float f3, float f4) {
        this.frameRect(this.getPrintDC(), f, f2, f3, f4);
    }

    protected void fillRect(float f, float f2, float f3, float f4, Color color) {
        float[] fArray = color.getRGBColorComponents(null);
        this.fillRect(this.getPrintDC(), f, f2, f3, f4, (int)(fArray[0] * 255.0f), (int)(fArray[1] * 255.0f), (int)(fArray[2] * 255.0f));
    }

    protected void selectPen(float f, Color color) {
        float[] fArray = color.getRGBColorComponents(null);
        this.selectPen(this.getPrintDC(), f, (int)(fArray[0] * 255.0f), (int)(fArray[1] * 255.0f), (int)(fArray[2] * 255.0f));
    }

    protected boolean selectStylePen(int n, int n2, float f, Color color) {
        long l;
        long l2;
        float[] fArray = color.getRGBColorComponents(null);
        switch (n) {
            case 0: {
                l2 = 512L;
                break;
            }
            case 1: {
                l2 = 0L;
                break;
            }
            default: {
                l2 = 256L;
            }
        }
        switch (n2) {
            case 2: {
                l = 4096L;
                break;
            }
            default: {
                l = 8192L;
                break;
            }
            case 1: {
                l = 0L;
            }
        }
        return this.selectStylePen(this.getPrintDC(), l2, l, f, (int)(fArray[0] * 255.0f), (int)(fArray[1] * 255.0f), (int)(fArray[2] * 255.0f));
    }

    protected boolean setFont(String string, float f, int n, int n2, float f2) {
        boolean bl = true;
        if ((!string.equals(this.mLastFontFamily) || f != this.mLastFontSize || n != this.mLastFontStyle || n2 != this.mLastRotation || f2 != this.mLastAwScale) && (bl = this.setFont(this.getPrintDC(), string, f, (n & 1) != 0, (n & 2) != 0, n2, f2))) {
            this.mLastFontFamily = string;
            this.mLastFontSize = f;
            this.mLastFontStyle = n;
            this.mLastRotation = n2;
            this.mLastAwScale = f2;
        }
        return bl;
    }

    protected void setTextColor(Color color) {
        if (!color.equals(this.mLastTextColor)) {
            this.mLastTextColor = color;
            float[] fArray = color.getRGBColorComponents(null);
            this.setTextColor(this.getPrintDC(), (int)(fArray[0] * 255.0f), (int)(fArray[1] * 255.0f), (int)(fArray[2] * 255.0f));
        }
    }

    @Override
    protected String removeControlChars(String string) {
        return super.removeControlChars(string);
    }

    protected void textOut(String string, float f, float f2, float[] fArray) {
        String string2 = this.removeControlChars(string);
        assert (fArray == null || string2.length() == string.length());
        if (string2.length() == 0) {
            return;
        }
        this.textOut(this.getPrintDC(), string2, string2.length(), false, f, f2, fArray);
    }

    protected void glyphsOut(int[] nArray, float f, float f2, float[] fArray) {
        char[] cArray = new char[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            cArray[i] = (char)(nArray[i] & 0xFFFF);
        }
        String string = new String(cArray);
        this.textOut(this.getPrintDC(), string, nArray.length, true, f, f2, fArray);
    }

    protected int getGDIAdvance(String string) {
        if ((string = this.removeControlChars(string)).length() == 0) {
            return 0;
        }
        return this.getGDIAdvance(this.getPrintDC(), string);
    }

    protected void drawImage3ByteBGR(byte[] byArray, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        this.drawDIBImage(this.getPrintDC(), byArray, f, f2, f3, f4, f5, f6, f7, f8, 24, null);
    }

    protected void drawDIBImage(byte[] byArray, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, int n, IndexColorModel indexColorModel) {
        int n2 = 24;
        byte[] byArray2 = null;
        if (indexColorModel != null) {
            n2 = n;
            byArray2 = new byte[(1 << indexColorModel.getPixelSize()) * 4];
            for (int i = 0; i < indexColorModel.getMapSize(); ++i) {
                byArray2[i * 4 + 0] = (byte)(indexColorModel.getBlue(i) & 0xFF);
                byArray2[i * 4 + 1] = (byte)(indexColorModel.getGreen(i) & 0xFF);
                byArray2[i * 4 + 2] = (byte)(indexColorModel.getRed(i) & 0xFF);
            }
        }
        this.drawDIBImage(this.getPrintDC(), byArray, f, f2, f3, f4, f5, f6, f7, f8, n2, byArray2);
    }

    @Override
    protected void startPage(PageFormat pageFormat, Printable printable, int n, boolean bl) {
        this.invalidateCachedState();
        this.deviceStartPage(pageFormat, printable, n, bl);
    }

    @Override
    protected void endPage(PageFormat pageFormat, Printable printable, int n) {
        this.deviceEndPage(pageFormat, printable, n);
    }

    private void invalidateCachedState() {
        this.mLastColor = null;
        this.mLastTextColor = null;
        this.mLastFontFamily = null;
    }

    @Override
    public void setCopies(int n) {
        super.setCopies(n);
        this.defaultCopies = false;
        this.mAttCopies = n;
        this.setNativeCopies(n);
    }

    private native void setNativeCopies(int var1);

    private native boolean jobSetup(Pageable var1, boolean var2);

    @Override
    protected native void initPrinter();

    private native boolean _startDoc(String var1, String var2) throws PrinterException;

    @Override
    protected void startDoc() throws PrinterException {
        if (!this._startDoc(this.mDestination, this.getJobName())) {
            this.cancel();
        }
    }

    @Override
    protected native void endDoc();

    @Override
    protected native void abortDoc();

    private static native void deleteDC(long var0, long var2, long var4);

    protected native void deviceStartPage(PageFormat var1, Printable var2, int var3, boolean var4);

    protected native void deviceEndPage(PageFormat var1, Printable var2, int var3);

    @Override
    protected native void printBand(byte[] var1, int var2, int var3, int var4, int var5);

    protected native void beginPath(long var1);

    protected native void endPath(long var1);

    protected native void closeFigure(long var1);

    protected native void fillPath(long var1);

    protected native void moveTo(long var1, float var3, float var4);

    protected native void lineTo(long var1, float var3, float var4);

    protected native void polyBezierTo(long var1, float var3, float var4, float var5, float var6, float var7, float var8);

    protected native void setPolyFillMode(long var1, int var3);

    protected native void selectSolidBrush(long var1, int var3, int var4, int var5);

    protected native int getPenX(long var1);

    protected native int getPenY(long var1);

    protected native void selectClipPath(long var1);

    protected native void frameRect(long var1, float var3, float var4, float var5, float var6);

    protected native void fillRect(long var1, float var3, float var4, float var5, float var6, int var7, int var8, int var9);

    protected native void selectPen(long var1, float var3, int var4, int var5, int var6);

    protected native boolean selectStylePen(long var1, long var3, long var5, float var7, int var8, int var9, int var10);

    protected native boolean setFont(long var1, String var3, float var4, boolean var5, boolean var6, int var7, float var8);

    protected native void setTextColor(long var1, int var3, int var4, int var5);

    protected native void textOut(long var1, String var3, int var4, boolean var5, float var6, float var7, float[] var8);

    private native int getGDIAdvance(long var1, String var3);

    private native void drawDIBImage(long var1, byte[] var3, float var4, float var5, float var6, float var7, float var8, float var9, float var10, float var11, int var12, byte[] var13);

    private final String getPrinterAttrib() {
        PrintService printService = this.getPrintService();
        String string = printService != null ? printService.getName() : null;
        return string;
    }

    private final int getCollateAttrib() {
        return this.mAttCollate;
    }

    private void setCollateAttrib(Attribute attribute) {
        this.mAttCollate = attribute == SheetCollate.COLLATED ? 1 : 0;
    }

    private void setCollateAttrib(Attribute attribute, PrintRequestAttributeSet printRequestAttributeSet) {
        this.setCollateAttrib(attribute);
        printRequestAttributeSet.add(attribute);
    }

    private final int getOrientAttrib() {
        OrientationRequested orientationRequested;
        int n = 1;
        OrientationRequested orientationRequested2 = orientationRequested = this.attributes == null ? null : (OrientationRequested)this.attributes.get(OrientationRequested.class);
        if (orientationRequested == null) {
            orientationRequested = (OrientationRequested)this.myService.getDefaultAttributeValue(OrientationRequested.class);
        }
        if (orientationRequested != null) {
            if (orientationRequested == OrientationRequested.REVERSE_LANDSCAPE) {
                n = 2;
            } else if (orientationRequested == OrientationRequested.LANDSCAPE) {
                n = 0;
            }
        }
        return n;
    }

    private void setOrientAttrib(Attribute attribute, PrintRequestAttributeSet printRequestAttributeSet) {
        if (printRequestAttributeSet != null) {
            printRequestAttributeSet.add(attribute);
        }
    }

    private final int getCopiesAttrib() {
        if (this.defaultCopies) {
            return 0;
        }
        return this.getCopiesInt();
    }

    private final void setRangeCopiesAttribute(int n, int n2, boolean bl, int n3) {
        if (this.attributes != null) {
            if (bl) {
                this.attributes.add(new PageRanges(n, n2));
                this.setPageRange(n, n2);
            }
            this.defaultCopies = false;
            this.attributes.add(new Copies(n3));
            super.setCopies(n3);
            this.mAttCopies = n3;
        }
    }

    private final boolean getDestAttrib() {
        return this.mDestination != null;
    }

    private final int getQualityAttrib() {
        return this.mAttQuality;
    }

    private void setQualityAttrib(Attribute attribute) {
        this.mAttQuality = attribute == PrintQuality.HIGH ? -4 : (attribute == PrintQuality.NORMAL ? -3 : -2);
    }

    private void setQualityAttrib(Attribute attribute, PrintRequestAttributeSet printRequestAttributeSet) {
        this.setQualityAttrib(attribute);
        printRequestAttributeSet.add(attribute);
    }

    private final int getColorAttrib() {
        return this.mAttChromaticity;
    }

    private void setColorAttrib(Attribute attribute) {
        this.mAttChromaticity = attribute == Chromaticity.COLOR ? 2 : 1;
    }

    private void setColorAttrib(Attribute attribute, PrintRequestAttributeSet printRequestAttributeSet) {
        this.setColorAttrib(attribute);
        printRequestAttributeSet.add(attribute);
    }

    private final int getSidesAttrib() {
        return this.mAttSides;
    }

    private void setSidesAttrib(Attribute attribute) {
        this.mAttSides = attribute == Sides.TWO_SIDED_LONG_EDGE ? 2 : (attribute == Sides.TWO_SIDED_SHORT_EDGE ? 3 : 1);
    }

    private void setSidesAttrib(Attribute attribute, PrintRequestAttributeSet printRequestAttributeSet) {
        this.setSidesAttrib(attribute);
        printRequestAttributeSet.add(attribute);
    }

    private final int[] getWin32MediaAttrib() {
        MediaSizeName mediaSizeName;
        MediaSize mediaSize;
        Media media;
        int[] nArray = new int[]{0, 0};
        if (this.attributes != null && (media = (Media)this.attributes.get(Media.class)) instanceof MediaSizeName && (mediaSize = MediaSize.getMediaSizeForName(mediaSizeName = (MediaSizeName)media)) != null) {
            nArray[0] = (int)((double)mediaSize.getX(25400) * 72.0);
            nArray[1] = (int)((double)mediaSize.getY(25400) * 72.0);
        }
        return nArray;
    }

    private void setWin32MediaAttrib(Attribute attribute) {
        if (!(attribute instanceof MediaSizeName)) {
            return;
        }
        MediaSizeName mediaSizeName = (MediaSizeName)attribute;
        this.mAttMediaSizeName = ((Win32PrintService)this.myService).findPaperID(mediaSizeName);
    }

    private void addPaperSize(PrintRequestAttributeSet printRequestAttributeSet, int n, int n2, int n3) {
        if (printRequestAttributeSet == null) {
            return;
        }
        MediaSizeName mediaSizeName = ((Win32PrintService)this.myService).findWin32Media(n);
        if (mediaSizeName == null) {
            mediaSizeName = ((Win32PrintService)this.myService).findMatchingMediaSizeNameMM(n2, n3);
        }
        if (mediaSizeName != null) {
            printRequestAttributeSet.add(mediaSizeName);
        }
    }

    private void setWin32MediaAttrib(int n, int n2, int n3) {
        this.addPaperSize(this.attributes, n, n2, n3);
        this.mAttMediaSizeName = n;
    }

    private void setMediaTrayAttrib(Attribute attribute) {
        this.mAttMediaTray = attribute == MediaTray.BOTTOM ? 2 : (attribute == MediaTray.ENVELOPE ? 5 : (attribute == MediaTray.LARGE_CAPACITY ? 11 : (attribute == MediaTray.MAIN ? 1 : (attribute == MediaTray.MANUAL ? 4 : (attribute == MediaTray.MIDDLE ? 3 : (attribute == MediaTray.SIDE ? 7 : (attribute == MediaTray.TOP ? 1 : (attribute instanceof Win32MediaTray ? ((Win32MediaTray)attribute).winID : 1))))))));
    }

    private void setMediaTrayAttrib(int n) {
        this.mAttMediaTray = n;
        MediaTray mediaTray = ((Win32PrintService)this.myService).findMediaTray(n);
    }

    private int getMediaTrayAttrib() {
        return this.mAttMediaTray;
    }

    private final boolean getPrintToFileEnabled() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            FilePermission filePermission = new FilePermission("<<ALL FILES>>", "read,write");
            try {
                securityManager.checkPermission(filePermission);
            }
            catch (SecurityException securityException) {
                return false;
            }
        }
        return true;
    }

    private final void setNativeAttributes(int n, int n2, int n3) {
        Cloneable cloneable;
        if (this.attributes == null) {
            return;
        }
        if ((n & 0x20) != 0) {
            cloneable = (Destination)this.attributes.get(Destination.class);
            if (cloneable == null) {
                try {
                    this.attributes.add(new Destination(new File("./out.prn").toURI()));
                }
                catch (SecurityException securityException) {
                    try {
                        this.attributes.add(new Destination(new URI("file:out.prn")));
                    }
                    catch (URISyntaxException uRISyntaxException) {}
                }
            }
        } else {
            this.attributes.remove(Destination.class);
        }
        if ((n & 0x10) != 0) {
            this.setCollateAttrib(SheetCollate.COLLATED, this.attributes);
        } else {
            this.setCollateAttrib(SheetCollate.UNCOLLATED, this.attributes);
        }
        if ((n & 2) != 0) {
            this.attributes.add(SunPageSelection.RANGE);
        } else if ((n & 1) != 0) {
            this.attributes.add(SunPageSelection.SELECTION);
        } else {
            this.attributes.add(SunPageSelection.ALL);
        }
        if ((n2 & 1) != 0) {
            if ((n3 & 0x4000) != 0) {
                this.setOrientAttrib(OrientationRequested.LANDSCAPE, this.attributes);
            } else {
                this.setOrientAttrib(OrientationRequested.PORTRAIT, this.attributes);
            }
        }
        if ((n2 & 0x800) != 0) {
            if ((n3 & 0x200) != 0) {
                this.setColorAttrib(Chromaticity.COLOR, this.attributes);
            } else {
                this.setColorAttrib(Chromaticity.MONOCHROME, this.attributes);
            }
        }
        if ((n2 & 0x400) != 0) {
            cloneable = (n3 & 0x80) != 0 ? PrintQuality.DRAFT : ((n2 & 0x40) != 0 ? PrintQuality.HIGH : PrintQuality.NORMAL);
            this.setQualityAttrib((Attribute)((Object)cloneable), this.attributes);
        }
        if ((n2 & 0x1000) != 0) {
            cloneable = (n3 & 0x10) != 0 ? Sides.TWO_SIDED_LONG_EDGE : ((n3 & 0x20) != 0 ? Sides.TWO_SIDED_SHORT_EDGE : Sides.ONE_SIDED);
            this.setSidesAttrib((Attribute)((Object)cloneable), this.attributes);
        }
    }

    private void getDevModeValues(PrintRequestAttributeSet printRequestAttributeSet, DevModeValues devModeValues) {
        PrinterResolution printerResolution;
        PrintRequestAttribute printRequestAttribute;
        Media media;
        Media media2;
        OrientationRequested orientationRequested;
        Sides sides;
        Chromaticity chromaticity;
        SheetCollate sheetCollate;
        Copies copies = (Copies)printRequestAttributeSet.get(Copies.class);
        if (copies != null) {
            devModeValues.dmFields |= 0x100;
            devModeValues.copies = (short)copies.getValue();
        }
        if ((sheetCollate = (SheetCollate)printRequestAttributeSet.get(SheetCollate.class)) != null) {
            devModeValues.dmFields |= 0x8000;
            short s = devModeValues.collate = sheetCollate == SheetCollate.COLLATED ? (short)1 : 0;
        }
        if ((chromaticity = (Chromaticity)printRequestAttributeSet.get(Chromaticity.class)) != null) {
            devModeValues.dmFields |= 0x800;
            devModeValues.color = chromaticity == Chromaticity.COLOR ? (short)2 : (short)1;
        }
        if ((sides = (Sides)printRequestAttributeSet.get(Sides.class)) != null) {
            devModeValues.dmFields |= 0x1000;
            devModeValues.duplex = sides == Sides.TWO_SIDED_LONG_EDGE ? (short)2 : (sides == Sides.TWO_SIDED_SHORT_EDGE ? (short)3 : (short)1);
        }
        if ((orientationRequested = (OrientationRequested)printRequestAttributeSet.get(OrientationRequested.class)) != null) {
            devModeValues.dmFields |= 1;
            devModeValues.orient = (short)(orientationRequested == OrientationRequested.LANDSCAPE ? 2 : 1);
        }
        if ((media2 = (Media)printRequestAttributeSet.get(Media.class)) instanceof MediaSizeName) {
            devModeValues.dmFields |= 2;
            media = (MediaSizeName)media2;
            devModeValues.paper = (short)((Win32PrintService)this.myService).findPaperID((MediaSizeName)media);
        }
        media = null;
        if (media2 instanceof MediaTray) {
            media = (MediaTray)media2;
        }
        if (media == null && (printRequestAttribute = (SunAlternateMedia)printRequestAttributeSet.get(SunAlternateMedia.class)) != null && ((SunAlternateMedia)printRequestAttribute).getMedia() instanceof MediaTray) {
            media = (MediaTray)((SunAlternateMedia)printRequestAttribute).getMedia();
        }
        if (media != null) {
            devModeValues.dmFields |= 0x200;
            devModeValues.bin = (short)((Win32PrintService)this.myService).findTrayID((MediaTray)media);
        }
        if ((printRequestAttribute = (PrintQuality)printRequestAttributeSet.get(PrintQuality.class)) != null) {
            devModeValues.dmFields |= 0x400;
            devModeValues.xres_quality = printRequestAttribute == PrintQuality.DRAFT ? (short)-1 : (printRequestAttribute == PrintQuality.HIGH ? (short)-4 : (short)-3);
        }
        if ((printerResolution = (PrinterResolution)printRequestAttributeSet.get(PrinterResolution.class)) != null) {
            devModeValues.dmFields |= 0x2400;
            devModeValues.xres_quality = (short)printerResolution.getCrossFeedResolution(100);
            devModeValues.yres = (short)printerResolution.getFeedResolution(100);
        }
    }

    private final void setJobAttributes(PrintRequestAttributeSet printRequestAttributeSet, int n, int n2, short s, short s2, short s3, short s4, short s5, short s6, short s7) {
        EnumSyntax enumSyntax;
        if (printRequestAttributeSet == null) {
            return;
        }
        if ((n & 0x100) != 0) {
            printRequestAttributeSet.add(new Copies(s));
        }
        if ((n & 0x8000) != 0) {
            if ((n2 & 0x8000) != 0) {
                printRequestAttributeSet.add(SheetCollate.COLLATED);
            } else {
                printRequestAttributeSet.add(SheetCollate.UNCOLLATED);
            }
        }
        if ((n & 1) != 0) {
            if ((n2 & 0x4000) != 0) {
                printRequestAttributeSet.add(OrientationRequested.LANDSCAPE);
            } else {
                printRequestAttributeSet.add(OrientationRequested.PORTRAIT);
            }
        }
        if ((n & 0x800) != 0) {
            if ((n2 & 0x200) != 0) {
                printRequestAttributeSet.add(Chromaticity.COLOR);
            } else {
                printRequestAttributeSet.add(Chromaticity.MONOCHROME);
            }
        }
        if ((n & 0x400) != 0) {
            if (s6 < 0) {
                enumSyntax = (n2 & 0x80) != 0 ? PrintQuality.DRAFT : ((n & 0x40) != 0 ? PrintQuality.HIGH : PrintQuality.NORMAL);
                printRequestAttributeSet.add((Attribute)((Object)enumSyntax));
            } else if (s6 > 0 && s7 > 0) {
                printRequestAttributeSet.add(new PrinterResolution(s6, s7, 100));
            }
        }
        if ((n & 0x1000) != 0) {
            enumSyntax = (n2 & 0x10) != 0 ? Sides.TWO_SIDED_LONG_EDGE : ((n2 & 0x20) != 0 ? Sides.TWO_SIDED_SHORT_EDGE : Sides.ONE_SIDED);
            printRequestAttributeSet.add((Attribute)((Object)enumSyntax));
        }
        if ((n & 2) != 0) {
            this.addPaperSize(printRequestAttributeSet, s2, s3, s4);
        }
        if ((n & 0x200) != 0) {
            enumSyntax = ((Win32PrintService)this.myService).findMediaTray(s5);
            printRequestAttributeSet.add(new SunAlternateMedia((Media)enumSyntax));
        }
    }

    private native boolean showDocProperties(long var1, PrintRequestAttributeSet var3, int var4, short var5, short var6, short var7, short var8, short var9, short var10, short var11, short var12, short var13);

    public PrintRequestAttributeSet showDocumentProperties(Window window, PrintService printService, PrintRequestAttributeSet printRequestAttributeSet) {
        try {
            this.setNativePrintServiceIfNeeded(printService.getName());
        }
        catch (PrinterException printerException) {
            // empty catch block
        }
        long l = ((WWindowPeer)window.getPeer()).getHWnd();
        DevModeValues devModeValues = new DevModeValues();
        this.getDevModeValues(printRequestAttributeSet, devModeValues);
        boolean bl = this.showDocProperties(l, printRequestAttributeSet, devModeValues.dmFields, devModeValues.copies, devModeValues.collate, devModeValues.color, devModeValues.duplex, devModeValues.orient, devModeValues.paper, devModeValues.bin, devModeValues.xres_quality, devModeValues.yres);
        if (bl) {
            return printRequestAttributeSet;
        }
        return null;
    }

    private final void setResolutionDPI(int n, int n2) {
        if (this.attributes != null) {
            PrinterResolution printerResolution = new PrinterResolution(n, n2, 100);
            this.attributes.add(printerResolution);
        }
        this.mAttXRes = n;
        this.mAttYRes = n2;
    }

    private void setResolutionAttrib(Attribute attribute) {
        PrinterResolution printerResolution = (PrinterResolution)attribute;
        this.mAttXRes = printerResolution.getCrossFeedResolution(100);
        this.mAttYRes = printerResolution.getFeedResolution(100);
    }

    private void setPrinterNameAttrib(String string) {
        PrintService printService = this.getPrintService();
        if (string == null) {
            return;
        }
        if (printService != null && string.equals(printService.getName())) {
            return;
        }
        PrintService[] printServiceArray = PrinterJob.lookupPrintServices();
        for (int i = 0; i < printServiceArray.length; ++i) {
            if (!string.equals(printServiceArray[i].getName())) continue;
            try {
                this.setPrintService(printServiceArray[i]);
            }
            catch (PrinterException printerException) {
                // empty catch block
            }
            return;
        }
    }

    private static native void initIDs();

    static {
        Toolkit.getDefaultToolkit();
        WPrinterJob.initIDs();
        Win32FontManager.registerJREFontsForPrinting();
    }

    class PrintToFileErrorDialog
    extends Dialog
    implements ActionListener {
        public PrintToFileErrorDialog(Frame frame, String string, String string2, String string3) {
            super(frame, string, true);
            this.init(frame, string, string2, string3);
        }

        public PrintToFileErrorDialog(Dialog dialog, String string, String string2, String string3) {
            super(dialog, string, true);
            this.init(dialog, string, string2, string3);
        }

        private void init(Component component, String string, String string2, String string3) {
            Panel panel = new Panel();
            this.add("Center", new Label(string2));
            Button button = new Button(string3);
            button.addActionListener(this);
            panel.add(button);
            this.add("South", panel);
            this.pack();
            Dimension dimension = this.getSize();
            if (component != null) {
                Rectangle rectangle = component.getBounds();
                this.setLocation(rectangle.x + (rectangle.width - dimension.width) / 2, rectangle.y + (rectangle.height - dimension.height) / 2);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.setVisible(false);
            this.dispose();
        }
    }

    private static final class DevModeValues {
        int dmFields;
        short copies;
        short collate;
        short color;
        short duplex;
        short orient;
        short paper;
        short bin;
        short xres_quality;
        short yres;

        private DevModeValues() {
        }
    }

    static class HandleRecord
    implements DisposerRecord {
        private long mPrintDC;
        private long mPrintHDevMode;
        private long mPrintHDevNames;

        HandleRecord() {
        }

        @Override
        public void dispose() {
            WPrinterJob.deleteDC(this.mPrintDC, this.mPrintHDevMode, this.mPrintHDevNames);
        }
    }
}

