/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import java.awt.Color;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.igv.ga4gh.GoogleUtils;
import org.broad.igv.gs.GSUtils;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.HttpUtils;
import org.broad.igv.util.ParsingUtils;

public class ResourceLocator {
    private static Logger log = Logger.getLogger(ResourceLocator.class);
    String name;
    String path;
    String dbURL;
    String indexPath;
    String coverage;
    String mappingPath;
    String trackInforURL;
    String featureInfoURL;
    String description;
    String type;
    String trackLine;
    Color color;
    String sampleId;
    String username;
    String password;
    private HashMap attributes = new HashMap();

    public ResourceLocator(String path) {
        this.setPath(path);
    }

    public ResourceLocator(String dbURL, String path) {
        this.dbURL = dbURL;
        this.setPath(path);
    }

    public boolean exists() {
        return ParsingUtils.pathExists(this.path);
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public String getTypeString() {
        if (this.type != null) {
            return this.type;
        }
        String typeString = this.path.toLowerCase();
        if (this.path.startsWith("http://") || this.path.startsWith("https://")) {
            try {
                URL url = new URL(this.path);
                typeString = url.getPath().toLowerCase();
                String query = url.getQuery();
                if (query != null) {
                    Map<String, String> queryMap = HttpUtils.parseQueryString(query);
                    if (queryMap.containsKey("dataformat")) {
                        String format = queryMap.get("dataformat");
                        typeString = format.contains("genomespace") ? GSUtils.parseDataFormatString(format) : format;
                    } else if (queryMap.containsKey("file")) {
                        typeString = queryMap.get("file");
                    }
                }
            }
            catch (MalformedURLException e2) {
                log.error("Error interpreting url: " + this.path, e2);
                typeString = this.path;
            }
        }
        if (typeString.endsWith(".txt") || typeString.endsWith(".xls") || typeString.endsWith(".gz") || typeString.endsWith(".bgz")) {
            typeString = typeString.substring(0, typeString.lastIndexOf(".")).trim();
        }
        return typeString;
    }

    public String getURLPath() {
        return this.getPath().split("\\?", 2)[0];
    }

    public String getURLQueryString() {
        String[] tmp = this.getPath().split("\\?", 2);
        if (tmp.length == 1) {
            return "";
        }
        return tmp[1];
    }

    public String toString() {
        return this.path + (this.dbURL == null ? "" : " " + this.dbURL);
    }

    public String getPath() {
        return this.path;
    }

    public String getFileName() {
        return new File(this.path).getName();
    }

    public String getDBUrl() {
        return this.dbURL;
    }

    public boolean isLocal() {
        return this.dbURL == null && !FileUtils.isRemote(this.path) && !"ga4gh".equals(this.type);
    }

    public void setTrackInforURL(String trackInforURL) {
        this.trackInforURL = trackInforURL;
    }

    public String getTrackInfoURL() {
        return this.trackInforURL;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getTrackName() {
        if (this.name == null) {
            if (this.path.startsWith("http://") || this.path.startsWith("https://")) {
                try {
                    return new File(new URL(this.path).getPath()).getName();
                }
                catch (MalformedURLException e2) {
                    return this.path;
                }
            }
            return new File(this.path).getName();
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getCoverage() {
        return this.coverage;
    }

    public void setCoverage(String coverage) {
        this.coverage = coverage;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public String getFeatureInfoURL() {
        return this.featureInfoURL;
    }

    public void setFeatureInfoURL(String featureInfoURL) {
        this.featureInfoURL = featureInfoURL;
    }

    public void setPath(String path) {
        this.path = path != null && path.startsWith("file://") ? path.substring(7) : (path != null && path.startsWith("gs://") ? GoogleUtils.translateGoogleCloudURL(path) : path);
    }

    public String getTrackLine() {
        return this.trackLine;
    }

    public void setTrackLine(String trackLine) {
        this.trackLine = trackLine;
    }

    public String getSampleId() {
        return this.sampleId;
    }

    public void setSampleId(String sampleId) {
        this.sampleId = sampleId;
    }

    public String getIndexPath() {
        return this.indexPath;
    }

    public void setIndexPath(String indexPath) {
        this.indexPath = indexPath;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        ResourceLocator that = (ResourceLocator)o2;
        if (this.dbURL != null ? !this.dbURL.equals(that.dbURL) : that.dbURL != null) {
            return false;
        }
        return !(this.path != null ? !this.path.equals(that.path) : that.path != null);
    }

    public int hashCode() {
        int result = this.path != null ? this.path.hashCode() : 0;
        result = 31 * result + (this.dbURL != null ? this.dbURL.hashCode() : 0);
        return result;
    }

    public String getBamIndexPath() {
        if (this.indexPath != null) {
            return this.indexPath;
        }
        if (this.path.toLowerCase().startsWith("http://") || this.path.toLowerCase().startsWith("https://")) {
            try {
                URL url = new URL(this.path);
                String queryString = url.getQuery();
                if (queryString != null) {
                    Map<String, String> parameters = HttpUtils.parseQueryString(queryString);
                    if (parameters.containsKey("index")) {
                        return parameters.get("index");
                    }
                    if (parameters.containsKey("file")) {
                        String bamFile = parameters.get("file");
                        String bamIndexFile = bamFile + ".bai";
                        String newQueryString = queryString.replace(bamFile, bamIndexFile);
                        return this.path.replace(queryString, newQueryString);
                    }
                    String ip = this.path.replace(url.getPath(), url.getPath() + ".bai");
                    return ip;
                }
            }
            catch (MalformedURLException e2) {
                log.error(e2.getMessage(), e2);
            }
        }
        return this.path + ".bai";
    }

    public String getMappingPath() {
        return this.mappingPath;
    }

    public void setMappingPath(String mappingPath) {
        this.mappingPath = mappingPath;
    }

    public static String appendToPath(ResourceLocator locator, String indexExtension) {
        String indexFile = locator.getURLPath() + indexExtension;
        String qs = locator.getURLQueryString();
        if (qs != null && qs.length() > 0) {
            indexFile = indexFile + "?" + qs;
        }
        return indexFile;
    }

    public static String indexFile(ResourceLocator locator) {
        if (locator.getIndexPath() != null) {
            return locator.getIndexPath();
        }
        String indexExtension = locator.getURLPath().toLowerCase().endsWith(".gz") || locator.getPath().toLowerCase().endsWith(".bgz") ? ".tbi" : ".idx";
        return ResourceLocator.appendToPath(locator, indexExtension);
    }

    public void setAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public static enum AttributeType {
        DB_URL("serverURL"),
        PATH("path"),
        DESCRIPTION("description"),
        HYPERLINK("hyperlink"),
        INFOLINK("infolink"),
        ID("id"),
        SAMPLE_ID("sampleId"),
        NAME("name"),
        URL("url"),
        RESOURCE_TYPE("resourceType"),
        TRACK_LINE("trackLine"),
        COVERAGE("coverage"),
        MAPPING("mapping"),
        COLOR("color"),
        INDEX("index");

        private String name;

        private AttributeType(String name) {
            this.name = name;
        }

        public String getText() {
            return this.name;
        }

        public String toString() {
            return this.getText();
        }
    }
}

