/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam.cram;

import com.google.common.io.LittleEndianDataInputStream;
import htsjdk.samtools.cram.io.CramArray;
import htsjdk.samtools.cram.io.CramInt;
import htsjdk.samtools.cram.io.ExternalCompression;
import htsjdk.samtools.cram.io.ITF8;
import htsjdk.samtools.seekablestream.SeekableStream;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.broad.igv.util.stream.IGVSeekableStreamFactory;

public class CRAMFile {
    String path;
    int major;
    int minor;
    String fileId;
    static final int RAW = 0;
    static final int GZIP = 1;
    static final int BZIP2 = 2;
    static final int LZMA = 3;
    static final int RANS = 4;

    public CRAMFile(String path, int majorFormatNumber, int minorFormatNumber, String fileId) {
        this.path = path;
        this.major = majorFormatNumber;
        this.minor = minorFormatNumber;
        this.fileId = fileId;
    }

    public void readContainerHeader(long position) throws IOException {
        SeekableStream ss = IGVSeekableStreamFactory.getInstance().getStreamFor(this.path);
        ss.seek(position);
        BufferedInputStream bis = new BufferedInputStream(ss);
        int length = CramInt.int32(bis);
        int refSeqId = ITF8.readUnsignedITF8(bis);
        int startPos = ITF8.readUnsignedITF8(bis);
        int alignmentSpan = ITF8.readUnsignedITF8(bis);
        int nRecords = ITF8.readUnsignedITF8(bis);
        int recordCounter = ITF8.readUnsignedITF8(bis);
        int bases = ITF8.readUnsignedITF8(bis);
        int nBlocks = ITF8.readUnsignedITF8(bis);
        int[] landmarks = CramArray.array(bis);
        if (this.major >= 3) {
            int checksum = CramInt.int32(bis);
        }
        this.readBlocks(bis, nBlocks);
    }

    public void readBlocks(InputStream is, int nBlocks) throws IOException {
        LittleEndianDataInputStream lis = new LittleEndianDataInputStream(is);
        for (int i2 = 0; i2 < nBlocks; ++i2) {
            int compressionMethod = lis.read();
            int contentType = lis.read();
            int contentId = ITF8.readUnsignedITF8(lis);
            int size = ITF8.readUnsignedITF8(lis);
            int rawSize = ITF8.readUnsignedITF8(lis);
            byte[] blockData = new byte[size];
            lis.readFully(blockData);
            blockData = this.uncompress(blockData, compressionMethod);
            String tmp = new String(blockData);
            if (this.major < 3) continue;
            int checksum = CramInt.int32(lis);
        }
    }

    private byte[] uncompress(byte[] compressedContent, int method) throws IOException {
        switch (method) {
            case 0: {
                return compressedContent;
            }
            case 1: {
                return ExternalCompression.gunzip(compressedContent);
            }
            case 2: {
                return ExternalCompression.unbzip2(compressedContent);
            }
            case 3: {
                return ExternalCompression.unxz(compressedContent);
            }
            case 4: {
                return ExternalCompression.unrans(compressedContent);
            }
        }
        throw new RuntimeException("Unknown block compression method: " + method);
    }
}

