/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.log4j.Logger;
import org.broad.igv.feature.Range;
import org.broad.igv.feature.Strand;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentInterval;
import org.broad.igv.sam.AlignmentRenderer;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.sam.PEStats;
import org.broad.igv.sam.PackedAlignments;
import org.broad.igv.sam.PairedAlignment;
import org.broad.igv.sam.ReadMate;
import org.broad.igv.sam.Row;

public class AlignmentPacker {
    private static final Logger log = Logger.getLogger(AlignmentPacker.class);
    public static final int MIN_ALIGNMENT_SPACING = 5;
    private static final Comparator<Alignment> lengthComparator = new Comparator<Alignment>(){

        @Override
        public int compare(Alignment row1, Alignment row2) {
            return row2.getEnd() - row2.getStart() - (row1.getEnd() - row2.getStart());
        }
    };
    private static final String NULL_GROUP_VALUE = "Because google-guava tables don't support a null key, we use a special value for null keys. It doesn't matter much what it is, but we want to avoid collisions. I find it unlikely that  this sentence will ever be used as a group value";
    public static final int tenMB = 10000000;

    public PackedAlignments packAlignments(AlignmentInterval interval, AlignmentTrack.RenderOptions renderOptions) {
        boolean isPairedAlignments;
        if (renderOptions == null) {
            renderOptions = new AlignmentTrack.RenderOptions();
        }
        LinkedHashMap<String, List<Row>> packedAlignments = new LinkedHashMap<String, List<Row>>();
        boolean bl = isPairedAlignments = renderOptions.isViewPairs() || renderOptions.isPairedArcView();
        if (renderOptions.groupByOption == null) {
            ArrayList<Row> alignmentRows = new ArrayList<Row>(10000);
            this.pack(interval.getAlignments(), isPairedAlignments, alignmentRows);
            packedAlignments.put("", alignmentRows);
        } else {
            HashMap<String, ArrayList<Alignment>> groupedAlignments = new HashMap<String, ArrayList<Alignment>>();
            Iterator<Alignment> iter = interval.getAlignmentIterator();
            while (iter.hasNext()) {
                ArrayList<Alignment> groupList;
                Alignment alignment = iter.next();
                String groupKey = this.getGroupValue(alignment, renderOptions);
                if (groupKey == null) {
                    groupKey = NULL_GROUP_VALUE;
                }
                if ((groupList = (ArrayList<Alignment>)groupedAlignments.get(groupKey)) == null) {
                    groupList = new ArrayList<Alignment>(1000);
                    groupedAlignments.put(groupKey, groupList);
                }
                groupList.add(alignment);
            }
            ArrayList keys = new ArrayList(groupedAlignments.keySet());
            Comparator<String> groupComparator = this.getGroupComparator(renderOptions.groupByOption);
            Collections.sort(keys, groupComparator);
            for (String key : keys) {
                if (key.equals(NULL_GROUP_VALUE)) continue;
                ArrayList<Row> alignmentRows = new ArrayList<Row>(10000);
                List group = (List)groupedAlignments.get(key);
                this.pack(group, isPairedAlignments, alignmentRows);
                packedAlignments.put(key, alignmentRows);
            }
            ArrayList<Row> alignmentRows = new ArrayList<Row>(10000);
            List group = (List)groupedAlignments.get(NULL_GROUP_VALUE);
            this.pack(group, isPairedAlignments, alignmentRows);
            packedAlignments.put("", alignmentRows);
        }
        ArrayList<AlignmentInterval> tmp = new ArrayList<AlignmentInterval>();
        tmp.add(interval);
        return new PackedAlignments(tmp, packedAlignments);
    }

    private void pack(List<Alignment> alList, boolean pairAlignments, List<Row> alignmentRows) {
        HashMap<String, PairedAlignment> pairs = null;
        if (pairAlignments) {
            pairs = new HashMap<String, PairedAlignment>(1000);
        }
        int totalCount = 0;
        if (alList == null || alList.size() == 0) {
            return;
        }
        Range curRange = this.getAlignmentListRange(alList);
        int bpLength = curRange.getLength();
        BucketCollection bucketCollection = bpLength < 10000000 ? new DenseBucketCollection(bpLength, curRange) : new SparseBucketCollection(curRange);
        int curRangeStart = curRange.getStart();
        for (Alignment al : alList) {
            int bucketNumber;
            if (!al.isMapped()) continue;
            Alignment alignment = al;
            if (pairAlignments && al.isPaired() && al.isPrimary() && al.getMate().isMapped() && al.getMate().getChr().equals(al.getChr())) {
                String readName = al.getReadName();
                PairedAlignment pair = (PairedAlignment)pairs.get(readName);
                if (pair == null) {
                    pair = new PairedAlignment(al);
                    pairs.put(readName, pair);
                    alignment = pair;
                } else {
                    pair.setSecondAlignment(al);
                    pairs.remove(readName);
                    continue;
                }
            }
            if ((bucketNumber = Math.max(0, al.getStart() - curRangeStart)) < bucketCollection.getBucketCount()) {
                PriorityQueue<Alignment> bucket = bucketCollection.get(bucketNumber);
                if (bucket == null) {
                    bucket = new PriorityQueue<Alignment>(5, lengthComparator);
                    bucketCollection.set(bucketNumber, bucket);
                }
                bucket.add(alignment);
                ++totalCount;
                continue;
            }
            log.debug("Alignment out of bounds. name: " + alignment.getReadName() + " startPos:" + alignment.getStart());
        }
        bucketCollection.finishedAdding();
        long t0 = System.currentTimeMillis();
        int allocatedCount = 0;
        Row currentRow = new Row();
        while (allocatedCount < totalCount) {
            PriorityQueue<Alignment> bucket;
            curRange = bucketCollection.getRange();
            int nextStart = curRangeStart = curRange.getStart();
            ArrayList<Integer> emptyBuckets = new ArrayList<Integer>(100);
            do {
                int bucketNumber;
                if ((bucket = bucketCollection.getNextBucket(bucketNumber = nextStart - curRangeStart, emptyBuckets)) == null) continue;
                Alignment alignment = (Alignment)bucket.remove();
                currentRow.addAlignment(alignment);
                ++allocatedCount;
                nextStart = alignment.getEnd() + 5;
            } while (bucket != null && nextStart <= curRange.getEnd());
            bucketCollection.removeBuckets(emptyBuckets);
            emptyBuckets.clear();
            if (currentRow.alignments.size() > 0) {
                alignmentRows.add(currentRow);
            }
            currentRow = new Row();
        }
        if (log.isDebugEnabled()) {
            long dt = System.currentTimeMillis() - t0;
            log.debug("Packed alignments in " + dt);
        }
        if (currentRow != null && currentRow.alignments.size() > 0) {
            alignmentRows.add(currentRow);
        }
    }

    private Range getAlignmentListRange(List<Alignment> alignmentsList) {
        if (alignmentsList == null || alignmentsList.size() == 0) {
            return null;
        }
        Alignment firstAlignment = alignmentsList.get(0);
        int minStart = firstAlignment.getStart();
        int maxEnd = firstAlignment.getEnd();
        for (Alignment alignment : alignmentsList) {
            maxEnd = Math.max(maxEnd, alignment.getEnd());
        }
        return new Range(firstAlignment.getChr(), minStart, maxEnd);
    }

    private Comparator<String> getGroupComparator(AlignmentTrack.GroupOption groupByOption) {
        switch (groupByOption) {
            case PAIR_ORIENTATION: {
                return new PairOrientationComparator();
            }
        }
        return new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (o1 != null) {
                    return o1.compareToIgnoreCase(o2);
                }
                if (o2 != null) {
                    return o2.compareToIgnoreCase(o1);
                }
                return 0;
            }
        };
    }

    private String getGroupValue(Alignment al, AlignmentTrack.RenderOptions renderOptions) {
        AlignmentTrack.GroupOption groupBy = renderOptions.groupByOption;
        String tag = renderOptions.getGroupByTag();
        switch (groupBy) {
            case STRAND: {
                return String.valueOf(al.isNegativeStrand());
            }
            case SAMPLE: {
                return al.getSample();
            }
            case LIBRARY: {
                return al.getLibrary();
            }
            case READ_GROUP: {
                return al.getReadGroup();
            }
            case TAG: {
                Object tagValue = al.getAttribute(tag);
                return tagValue == null ? null : tagValue.toString();
            }
            case FIRST_OF_PAIR_STRAND: {
                Strand strand = al.getFirstOfPairStrand();
                String strandString = strand == Strand.NONE ? null : strand.toString();
                System.out.println(strandString);
                return strandString;
            }
            case PAIR_ORIENTATION: {
                PEStats peStats = AlignmentRenderer.getPEStats(al, renderOptions);
                AlignmentTrack.OrientationType type = AlignmentRenderer.getOrientationType(al, peStats);
                if (type == null) {
                    return AlignmentTrack.OrientationType.UNKNOWN.name();
                }
                return type.name();
            }
            case MATE_CHROMOSOME: {
                ReadMate mate = al.getMate();
                if (mate == null) {
                    return null;
                }
                if (!mate.isMapped()) {
                    return "UNMAPPED";
                }
                return mate.getChr();
            }
            case SUPPLEMENTARY: {
                return String.valueOf(!al.isSupplementary());
            }
        }
        return null;
    }

    private class PairOrientationComparator
    implements Comparator<String> {
        private final List<AlignmentTrack.OrientationType> orientationTypes = Arrays.asList(AlignmentTrack.OrientationType.values());

        @Override
        public int compare(String s0, String s1) {
            if (s0 != null && s1 != null) {
                AlignmentTrack.OrientationType t0 = AlignmentTrack.OrientationType.valueOf(s0);
                AlignmentTrack.OrientationType t1 = AlignmentTrack.OrientationType.valueOf(s1);
                return this.orientationTypes.indexOf((Object)t0) - this.orientationTypes.indexOf((Object)t1);
            }
            if (s0 == null ^ s1 == null) {
                return s0 == null ? 1 : -1;
            }
            return 0;
        }
    }

    static class SparseBucketCollection
    implements BucketCollection {
        Range range;
        boolean finished = false;
        List<Integer> keys;
        final HashMap<Integer, PriorityQueue<Alignment>> buckets;

        SparseBucketCollection(Range range) {
            this.range = range;
            this.buckets = new HashMap(1000);
        }

        @Override
        public void set(int idx, PriorityQueue<Alignment> bucket) {
            if (this.finished) {
                log.error("Error: bucket added after finishAdding() called");
            }
            this.buckets.put(idx, bucket);
        }

        @Override
        public PriorityQueue<Alignment> get(int idx) {
            return this.buckets.get(idx);
        }

        @Override
        public Range getRange() {
            return this.range;
        }

        @Override
        public PriorityQueue<Alignment> getNextBucket(int bucketNumber, Collection<Integer> emptyBuckets) {
            Integer key;
            PriorityQueue<Alignment> bucket = null;
            int min = 0;
            int max = this.keys.size() - 1;
            while (max - min > 5) {
                int mid = (max + min) / 2;
                key = this.keys.get(mid);
                if (key > bucketNumber) {
                    max = mid;
                    continue;
                }
                min = mid;
            }
            for (int i2 = min; i2 < this.keys.size(); ++i2) {
                key = this.keys.get(i2);
                if (key < bucketNumber) continue;
                bucket = this.buckets.get(key);
                if (bucket.isEmpty()) {
                    emptyBuckets.add(key);
                    bucket = null;
                    continue;
                }
                return bucket;
            }
            return null;
        }

        @Override
        public void removeBuckets(Collection<Integer> emptyBuckets) {
            if (emptyBuckets.isEmpty()) {
                return;
            }
            for (Integer i2 : emptyBuckets) {
                this.buckets.remove(i2);
            }
            this.keys = new ArrayList<Integer>(this.buckets.keySet());
            Collections.sort(this.keys);
        }

        @Override
        public void finishedAdding() {
            this.finished = true;
            this.keys = new ArrayList<Integer>(this.buckets.keySet());
            Collections.sort(this.keys);
        }

        @Override
        public int getBucketCount() {
            return Integer.MAX_VALUE;
        }
    }

    static class DenseBucketCollection
    implements BucketCollection {
        Range range;
        int lastBucketNumber = -1;
        final PriorityQueue[] bucketArray;

        DenseBucketCollection(int bucketCount, Range range) {
            this.bucketArray = new PriorityQueue[bucketCount];
            this.range = range;
        }

        @Override
        public void set(int idx, PriorityQueue<Alignment> bucket) {
            this.bucketArray[idx] = bucket;
        }

        @Override
        public PriorityQueue<Alignment> get(int idx) {
            return this.bucketArray[idx];
        }

        @Override
        public int getBucketCount() {
            return this.bucketArray.length;
        }

        @Override
        public Range getRange() {
            return this.range;
        }

        @Override
        public PriorityQueue<Alignment> getNextBucket(int bucketNumber, Collection<Integer> emptyBuckets) {
            if (bucketNumber == this.lastBucketNumber) {
                // empty if block
            }
            PriorityQueue bucket = null;
            while (bucketNumber < this.bucketArray.length) {
                if (bucketNumber < 0) {
                    System.out.println();
                }
                if ((bucket = this.bucketArray[bucketNumber]) != null) {
                    if (bucket.isEmpty()) {
                        this.bucketArray[bucketNumber] = null;
                        bucket = null;
                    } else {
                        return bucket;
                    }
                }
                ++bucketNumber;
            }
            return null;
        }

        @Override
        public void removeBuckets(Collection<Integer> emptyBuckets) {
        }

        @Override
        public void finishedAdding() {
        }
    }

    static interface BucketCollection {
        public Range getRange();

        public void set(int var1, PriorityQueue<Alignment> var2);

        public PriorityQueue<Alignment> get(int var1);

        public PriorityQueue<Alignment> getNextBucket(int var1, Collection<Integer> var2);

        public void removeBuckets(Collection<Integer> var1);

        public void finishedAdding();

        public int getBucketCount();
    }
}

