/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.optimization.general;

import java.util.Arrays;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.optimization.OptimizationException;
import org.apache.commons.math.optimization.VectorialPointValuePair;
import org.apache.commons.math.optimization.general.AbstractLeastSquaresOptimizer;
import org.apache.commons.math.util.FastMath;

public class LevenbergMarquardtOptimizer
extends AbstractLeastSquaresOptimizer {
    private int solvedCols;
    private double[] diagR;
    private double[] jacNorm;
    private double[] beta;
    private int[] permutation;
    private int rank;
    private double lmPar;
    private double[] lmDir;
    private double initialStepBoundFactor;
    private double costRelativeTolerance;
    private double parRelativeTolerance;
    private double orthoTolerance;
    private double qrRankingThreshold;

    public LevenbergMarquardtOptimizer() {
        this.setMaxIterations(1000);
        this.setConvergenceChecker(null);
        this.setInitialStepBoundFactor(100.0);
        this.setCostRelativeTolerance(1.0E-10);
        this.setParRelativeTolerance(1.0E-10);
        this.setOrthoTolerance(1.0E-10);
        this.setQRRankingThreshold(Double.MIN_NORMAL);
    }

    public void setInitialStepBoundFactor(double initialStepBoundFactor) {
        this.initialStepBoundFactor = initialStepBoundFactor;
    }

    public void setCostRelativeTolerance(double costRelativeTolerance) {
        this.costRelativeTolerance = costRelativeTolerance;
    }

    public void setParRelativeTolerance(double parRelativeTolerance) {
        this.parRelativeTolerance = parRelativeTolerance;
    }

    public void setOrthoTolerance(double orthoTolerance) {
        this.orthoTolerance = orthoTolerance;
    }

    public void setQRRankingThreshold(double threshold) {
        this.qrRankingThreshold = threshold;
    }

    /*
     * Unable to fully structure code
     */
    protected VectorialPointValuePair doOptimize() throws FunctionEvaluationException, OptimizationException, IllegalArgumentException {
        this.solvedCols = Math.min(this.rows, this.cols);
        this.diagR = new double[this.cols];
        this.jacNorm = new double[this.cols];
        this.beta = new double[this.cols];
        this.permutation = new int[this.cols];
        this.lmDir = new double[this.cols];
        delta = 0.0;
        xNorm = 0.0;
        diag = new double[this.cols];
        oldX = new double[this.cols];
        oldRes = new double[this.rows];
        oldObj = new double[this.rows];
        qtf = new double[this.rows];
        work1 = new double[this.cols];
        work2 = new double[this.cols];
        work3 = new double[this.cols];
        this.updateResidualsAndCost();
        this.lmPar = 0.0;
        firstIteration = true;
        current = new VectorialPointValuePair(this.point, this.objective);
        while (true) {
            for (i = 0; i < this.rows; ++i) {
                qtf[i] = this.wresiduals[i];
            }
            this.incrementIterationsCounter();
            previous = current;
            this.updateJacobian();
            this.qrDecomposition();
            this.qTy(qtf);
            for (k = 0; k < this.solvedCols; ++k) {
                pk = this.permutation[k];
                this.wjacobian[k][pk] = this.diagR[pk];
            }
            if (firstIteration) {
                xNorm = 0.0;
                for (k = 0; k < this.cols; ++k) {
                    dk = this.jacNorm[k];
                    if (dk == 0.0) {
                        dk = 1.0;
                    }
                    xk = dk * this.point[k];
                    xNorm += xk * xk;
                    diag[k] = dk;
                }
                delta = (xNorm = FastMath.sqrt(xNorm)) == 0.0 ? this.initialStepBoundFactor : this.initialStepBoundFactor * xNorm;
            }
            maxCosine = 0.0;
            if (this.cost != 0.0) {
                for (j = 0; j < this.solvedCols; ++j) {
                    pj = this.permutation[j];
                    s = this.jacNorm[pj];
                    if (s == 0.0) continue;
                    sum = 0.0;
                    for (i = 0; i <= j; ++i) {
                        sum += this.wjacobian[i][pj] * qtf[i];
                    }
                    maxCosine = FastMath.max(maxCosine, FastMath.abs(sum) / (s * this.cost));
                }
            }
            if (maxCosine <= this.orthoTolerance) {
                this.updateResidualsAndCost();
                current = new VectorialPointValuePair(this.point, this.objective);
                return current;
            }
            for (j = 0; j < this.cols; ++j) {
                diag[j] = FastMath.max(diag[j], this.jacNorm[j]);
            }
            ratio = 0.0;
            do {
                if (!(ratio < 1.0E-4)) ** continue;
                for (j = 0; j < this.solvedCols; ++j) {
                    pj = this.permutation[j];
                    oldX[pj] = this.point[pj];
                }
                previousCost = this.cost;
                tmpVec = this.residuals;
                this.residuals = oldRes;
                oldRes = tmpVec;
                tmpVec = this.objective;
                this.objective = oldObj;
                oldObj = tmpVec;
                this.determineLMParameter(qtf, delta, diag, work1, work2, work3);
                lmNorm = 0.0;
                for (j = 0; j < this.solvedCols; ++j) {
                    pj = this.permutation[j];
                    this.lmDir[pj] = -this.lmDir[pj];
                    this.point[pj] = oldX[pj] + this.lmDir[pj];
                    s = diag[pj] * this.lmDir[pj];
                    lmNorm += s * s;
                }
                lmNorm = FastMath.sqrt(lmNorm);
                if (firstIteration) {
                    delta = FastMath.min(delta, lmNorm);
                }
                this.updateResidualsAndCost();
                actRed = -1.0;
                if (0.1 * this.cost < previousCost) {
                    r = this.cost / previousCost;
                    actRed = 1.0 - r * r;
                }
                for (j = 0; j < this.solvedCols; ++j) {
                    pj = this.permutation[j];
                    dirJ = this.lmDir[pj];
                    work1[j] = 0.0;
                    for (i = 0; i <= j; ++i) {
                        v0 = i;
                        work1[v0] = work1[v0] + this.wjacobian[i][pj] * dirJ;
                    }
                }
                coeff1 = 0.0;
                for (j = 0; j < this.solvedCols; ++j) {
                    coeff1 += work1[j] * work1[j];
                }
                pc2 = previousCost * previousCost;
                coeff2 = this.lmPar * lmNorm * lmNorm / pc2;
                preRed = (coeff1 /= pc2) + 2.0 * coeff2;
                dirDer = -(coeff1 + coeff2);
                v1 = ratio = preRed == 0.0 ? 0.0 : actRed / preRed;
                if (ratio <= 0.25) {
                    v2 = tmp = actRed < 0.0 ? 0.5 * dirDer / (dirDer + 0.5 * actRed) : 0.5;
                    if (0.1 * this.cost >= previousCost || tmp < 0.1) {
                        tmp = 0.1;
                    }
                    delta = tmp * FastMath.min(delta, 10.0 * lmNorm);
                    this.lmPar /= tmp;
                } else if (this.lmPar == 0.0 || ratio >= 0.75) {
                    delta = 2.0 * lmNorm;
                    this.lmPar *= 0.5;
                }
                if (ratio >= 1.0E-4) {
                    firstIteration = false;
                    xNorm = 0.0;
                    for (k = 0; k < this.cols; ++k) {
                        xK = diag[k] * this.point[k];
                        xNorm += xK * xK;
                    }
                    xNorm = FastMath.sqrt(xNorm);
                    current = new VectorialPointValuePair(this.point, this.objective);
                    if (this.checker != null && this.checker.converged(this.getIterations(), previous, current)) {
                        return current;
                    }
                } else {
                    this.cost = previousCost;
                    for (j = 0; j < this.solvedCols; ++j) {
                        pj = this.permutation[j];
                        this.point[pj] = oldX[pj];
                    }
                    tmpVec = this.residuals;
                    this.residuals = oldRes;
                    oldRes = tmpVec;
                    tmpVec = this.objective;
                    this.objective = oldObj;
                    oldObj = tmpVec;
                }
                if (this.checker == null && (FastMath.abs(actRed) <= this.costRelativeTolerance && preRed <= this.costRelativeTolerance && ratio <= 2.0 || delta <= this.parRelativeTolerance * xNorm)) {
                    return current;
                }
                if (FastMath.abs(actRed) <= 2.2204E-16 && preRed <= 2.2204E-16 && ratio <= 2.0) {
                    throw new OptimizationException(LocalizedFormats.TOO_SMALL_COST_RELATIVE_TOLERANCE, new Object[]{this.costRelativeTolerance});
                }
                if (!(delta <= 2.2204E-16 * xNorm)) continue;
                throw new OptimizationException(LocalizedFormats.TOO_SMALL_PARAMETERS_RELATIVE_TOLERANCE, new Object[]{this.parRelativeTolerance});
            } while (!(maxCosine <= 2.2204E-16));
            break;
        }
        throw new OptimizationException(LocalizedFormats.TOO_SMALL_ORTHOGONALITY_TOLERANCE, new Object[]{this.orthoTolerance});
    }

    private void determineLMParameter(double[] qy, double delta, double[] diag, double[] work1, double[] work2, double[] work3) {
        double sum;
        int pj;
        int j2;
        int j3;
        for (j3 = 0; j3 < this.rank; ++j3) {
            this.lmDir[this.permutation[j3]] = qy[j3];
        }
        for (j3 = this.rank; j3 < this.cols; ++j3) {
            this.lmDir[this.permutation[j3]] = 0.0;
        }
        for (int k2 = this.rank - 1; k2 >= 0; --k2) {
            int pk = this.permutation[k2];
            double ypk = this.lmDir[pk] / this.diagR[pk];
            for (int i2 = 0; i2 < k2; ++i2) {
                int n2 = this.permutation[i2];
                this.lmDir[n2] = this.lmDir[n2] - ypk * this.wjacobian[i2][pk];
            }
            this.lmDir[pk] = ypk;
        }
        double dxNorm = 0.0;
        for (int j4 = 0; j4 < this.solvedCols; ++j4) {
            double s2;
            int pj2 = this.permutation[j4];
            work1[pj2] = s2 = diag[pj2] * this.lmDir[pj2];
            dxNorm += s2 * s2;
        }
        double fp = (dxNorm = FastMath.sqrt(dxNorm)) - delta;
        if (fp <= 0.1 * delta) {
            this.lmPar = 0.0;
            return;
        }
        double parl = 0.0;
        if (this.rank == this.solvedCols) {
            for (j2 = 0; j2 < this.solvedCols; ++j2) {
                int n3 = pj = this.permutation[j2];
                work1[n3] = work1[n3] * (diag[pj] / dxNorm);
            }
            double sum2 = 0.0;
            for (j2 = 0; j2 < this.solvedCols; ++j2) {
                double s3;
                pj = this.permutation[j2];
                sum = 0.0;
                for (int i3 = 0; i3 < j2; ++i3) {
                    sum += this.wjacobian[i3][pj] * work1[this.permutation[i3]];
                }
                work1[pj] = s3 = (work1[pj] - sum) / this.diagR[pj];
                sum2 += s3 * s3;
            }
            parl = fp / (delta * sum2);
        }
        double sum2 = 0.0;
        for (j2 = 0; j2 < this.solvedCols; ++j2) {
            pj = this.permutation[j2];
            sum = 0.0;
            for (int i4 = 0; i4 <= j2; ++i4) {
                sum += this.wjacobian[i4][pj] * qy[i4];
            }
            sum2 += (sum /= diag[pj]) * sum;
        }
        double gNorm = FastMath.sqrt(sum2);
        double paru = gNorm / delta;
        if (paru == 0.0) {
            paru = 2.2251E-308 / FastMath.min(delta, 0.1);
        }
        this.lmPar = FastMath.min(paru, FastMath.max(this.lmPar, parl));
        if (this.lmPar == 0.0) {
            this.lmPar = gNorm / dxNorm;
        }
        for (int countdown = 10; countdown >= 0; --countdown) {
            int pj3;
            int j5;
            int pj4;
            int j6;
            if (this.lmPar == 0.0) {
                this.lmPar = FastMath.max(2.2251E-308, 0.001 * paru);
            }
            double sPar = FastMath.sqrt(this.lmPar);
            for (j6 = 0; j6 < this.solvedCols; ++j6) {
                pj4 = this.permutation[j6];
                work1[pj4] = sPar * diag[pj4];
            }
            this.determineLMDirection(qy, work1, work2, work3);
            dxNorm = 0.0;
            for (j6 = 0; j6 < this.solvedCols; ++j6) {
                double s4;
                pj4 = this.permutation[j6];
                work3[pj4] = s4 = diag[pj4] * this.lmDir[pj4];
                dxNorm += s4 * s4;
            }
            dxNorm = FastMath.sqrt(dxNorm);
            double previousFP = fp;
            fp = dxNorm - delta;
            if (FastMath.abs(fp) <= 0.1 * delta || parl == 0.0 && fp <= previousFP && previousFP < 0.0) {
                return;
            }
            for (j5 = 0; j5 < this.solvedCols; ++j5) {
                pj3 = this.permutation[j5];
                work1[pj3] = work3[pj3] * diag[pj3] / dxNorm;
            }
            for (j5 = 0; j5 < this.solvedCols; ++j5) {
                int n4 = pj3 = this.permutation[j5];
                work1[n4] = work1[n4] / work2[j5];
                double tmp = work1[pj3];
                for (int i5 = j5 + 1; i5 < this.solvedCols; ++i5) {
                    int n5 = this.permutation[i5];
                    work1[n5] = work1[n5] - this.wjacobian[i5][pj3] * tmp;
                }
            }
            sum2 = 0.0;
            for (j5 = 0; j5 < this.solvedCols; ++j5) {
                double s5 = work1[this.permutation[j5]];
                sum2 += s5 * s5;
            }
            double correction = fp / (delta * sum2);
            if (fp > 0.0) {
                parl = FastMath.max(parl, this.lmPar);
            } else if (fp < 0.0) {
                paru = FastMath.min(paru, this.lmPar);
            }
            this.lmPar = FastMath.max(parl, this.lmPar + correction);
        }
    }

    private void determineLMDirection(double[] qy, double[] diag, double[] lmDiag, double[] work) {
        int j2;
        int pj;
        int j3;
        for (j3 = 0; j3 < this.solvedCols; ++j3) {
            pj = this.permutation[j3];
            for (int i2 = j3 + 1; i2 < this.solvedCols; ++i2) {
                this.wjacobian[i2][pj] = this.wjacobian[j3][this.permutation[i2]];
            }
            this.lmDir[j3] = this.diagR[pj];
            work[j3] = qy[j3];
        }
        for (j3 = 0; j3 < this.solvedCols; ++j3) {
            pj = this.permutation[j3];
            double dpj = diag[pj];
            if (dpj != 0.0) {
                Arrays.fill(lmDiag, j3 + 1, lmDiag.length, 0.0);
            }
            lmDiag[j3] = dpj;
            double qtbpj = 0.0;
            for (int k2 = j3; k2 < this.solvedCols; ++k2) {
                double cos;
                double sin;
                int pk = this.permutation[k2];
                if (lmDiag[k2] == 0.0) continue;
                double rkk = this.wjacobian[k2][pk];
                if (FastMath.abs(rkk) < FastMath.abs(lmDiag[k2])) {
                    double cotan = rkk / lmDiag[k2];
                    sin = 1.0 / FastMath.sqrt(1.0 + cotan * cotan);
                    cos = sin * cotan;
                } else {
                    double tan = lmDiag[k2] / rkk;
                    cos = 1.0 / FastMath.sqrt(1.0 + tan * tan);
                    sin = cos * tan;
                }
                this.wjacobian[k2][pk] = cos * rkk + sin * lmDiag[k2];
                double temp = cos * work[k2] + sin * qtbpj;
                qtbpj = -sin * work[k2] + cos * qtbpj;
                work[k2] = temp;
                for (int i3 = k2 + 1; i3 < this.solvedCols; ++i3) {
                    double rik = this.wjacobian[i3][pk];
                    double temp2 = cos * rik + sin * lmDiag[i3];
                    lmDiag[i3] = -sin * rik + cos * lmDiag[i3];
                    this.wjacobian[i3][pk] = temp2;
                }
            }
            lmDiag[j3] = this.wjacobian[j3][this.permutation[j3]];
            this.wjacobian[j3][this.permutation[j3]] = this.lmDir[j3];
        }
        int nSing = this.solvedCols;
        for (j2 = 0; j2 < this.solvedCols; ++j2) {
            if (lmDiag[j2] == 0.0 && nSing == this.solvedCols) {
                nSing = j2;
            }
            if (nSing >= this.solvedCols) continue;
            work[j2] = 0.0;
        }
        if (nSing > 0) {
            for (j2 = nSing - 1; j2 >= 0; --j2) {
                int pj2 = this.permutation[j2];
                double sum = 0.0;
                for (int i4 = j2 + 1; i4 < nSing; ++i4) {
                    sum += this.wjacobian[i4][pj2] * work[i4];
                }
                work[j2] = (work[j2] - sum) / lmDiag[j2];
            }
        }
        for (j2 = 0; j2 < this.lmDir.length; ++j2) {
            this.lmDir[this.permutation[j2]] = work[j2];
        }
    }

    private void qrDecomposition() throws OptimizationException {
        int k2;
        for (k2 = 0; k2 < this.cols; ++k2) {
            this.permutation[k2] = k2;
            double norm2 = 0.0;
            for (int i2 = 0; i2 < this.wjacobian.length; ++i2) {
                double akk = this.wjacobian[i2][k2];
                norm2 += akk * akk;
            }
            this.jacNorm[k2] = FastMath.sqrt(norm2);
        }
        for (k2 = 0; k2 < this.cols; ++k2) {
            double betak;
            int nextColumn = -1;
            double ak2 = Double.NEGATIVE_INFINITY;
            for (int i3 = k2; i3 < this.cols; ++i3) {
                double norm2 = 0.0;
                for (int j2 = k2; j2 < this.wjacobian.length; ++j2) {
                    double aki = this.wjacobian[j2][this.permutation[i3]];
                    norm2 += aki * aki;
                }
                if (Double.isInfinite(norm2) || Double.isNaN(norm2)) {
                    throw new OptimizationException(LocalizedFormats.UNABLE_TO_PERFORM_QR_DECOMPOSITION_ON_JACOBIAN, this.rows, this.cols);
                }
                if (!(norm2 > ak2)) continue;
                nextColumn = i3;
                ak2 = norm2;
            }
            if (ak2 <= this.qrRankingThreshold) {
                this.rank = k2;
                return;
            }
            int pk = this.permutation[nextColumn];
            this.permutation[nextColumn] = this.permutation[k2];
            this.permutation[k2] = pk;
            double akk = this.wjacobian[k2][pk];
            double alpha = akk > 0.0 ? -FastMath.sqrt(ak2) : FastMath.sqrt(ak2);
            this.beta[pk] = betak = 1.0 / (ak2 - akk * alpha);
            this.diagR[pk] = alpha;
            double[] dArray = this.wjacobian[k2];
            int n2 = pk;
            dArray[n2] = dArray[n2] - alpha;
            for (int dk = this.cols - 1 - k2; dk > 0; --dk) {
                int j3;
                double gamma = 0.0;
                for (j3 = k2; j3 < this.wjacobian.length; ++j3) {
                    gamma += this.wjacobian[j3][pk] * this.wjacobian[j3][this.permutation[k2 + dk]];
                }
                gamma *= betak;
                for (j3 = k2; j3 < this.wjacobian.length; ++j3) {
                    double[] dArray2 = this.wjacobian[j3];
                    int n3 = this.permutation[k2 + dk];
                    dArray2[n3] = dArray2[n3] - gamma * this.wjacobian[j3][pk];
                }
            }
        }
        this.rank = this.solvedCols;
    }

    private void qTy(double[] y) {
        for (int k2 = 0; k2 < this.cols; ++k2) {
            int i2;
            int pk = this.permutation[k2];
            double gamma = 0.0;
            for (i2 = k2; i2 < this.rows; ++i2) {
                gamma += this.wjacobian[i2][pk] * y[i2];
            }
            gamma *= this.beta[pk];
            for (i2 = k2; i2 < this.rows; ++i2) {
                int n2 = i2;
                y[n2] = y[n2] - gamma * this.wjacobian[i2][pk];
            }
        }
    }
}

