/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.linear;

import java.io.Serializable;
import org.apache.commons.math.Field;
import org.apache.commons.math.FieldElement;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.linear.AbstractFieldMatrix;
import org.apache.commons.math.linear.FieldMatrix;
import org.apache.commons.math.linear.FieldMatrixChangingVisitor;
import org.apache.commons.math.linear.FieldMatrixPreservingVisitor;
import org.apache.commons.math.linear.MatrixIndexException;
import org.apache.commons.math.linear.MatrixVisitorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Array2DRowFieldMatrix<T extends FieldElement<T>>
extends AbstractFieldMatrix<T>
implements Serializable {
    private static final long serialVersionUID = 7260756672015356458L;
    protected T[][] data;

    public Array2DRowFieldMatrix(Field<T> field) {
        super(field);
    }

    public Array2DRowFieldMatrix(Field<T> field, int rowDimension, int columnDimension) throws IllegalArgumentException {
        super(field, rowDimension, columnDimension);
        this.data = Array2DRowFieldMatrix.buildArray(field, (int)rowDimension, (int)columnDimension);
    }

    public Array2DRowFieldMatrix(T[][] d2) throws IllegalArgumentException, NullPointerException {
        super(Array2DRowFieldMatrix.extractField(d2));
        this.copyIn((FieldElement[][])d2);
    }

    public Array2DRowFieldMatrix(T[][] d2, boolean copyArray) throws IllegalArgumentException, NullPointerException {
        super(Array2DRowFieldMatrix.extractField(d2));
        if (copyArray) {
            this.copyIn((FieldElement[][])d2);
        } else {
            if (d2 == null) {
                throw new NullPointerException();
            }
            int nRows = d2.length;
            if (nRows == 0) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.AT_LEAST_ONE_ROW, new Object[0]);
            }
            int nCols = d2[0].length;
            if (nCols == 0) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.AT_LEAST_ONE_COLUMN, new Object[0]);
            }
            for (int r2 = 1; r2 < nRows; ++r2) {
                if (d2[r2].length == nCols) continue;
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.DIFFERENT_ROWS_LENGTHS, nCols, d2[r2].length);
            }
            this.data = d2;
        }
    }

    public Array2DRowFieldMatrix(T[] v2) {
        super(Array2DRowFieldMatrix.extractField(v2));
        int nRows = v2.length;
        this.data = Array2DRowFieldMatrix.buildArray(this.getField(), (int)nRows, (int)1);
        for (int row = 0; row < nRows; ++row) {
            this.data[row][0] = v2[row];
        }
    }

    @Override
    public FieldMatrix<T> createMatrix(int rowDimension, int columnDimension) throws IllegalArgumentException {
        return new Array2DRowFieldMatrix(this.getField(), rowDimension, columnDimension);
    }

    @Override
    public FieldMatrix<T> copy() {
        return new Array2DRowFieldMatrix(this.copyOut(), false);
    }

    @Override
    public FieldMatrix<T> add(FieldMatrix<T> m2) throws IllegalArgumentException {
        try {
            return this.add((Array2DRowFieldMatrix)m2);
        }
        catch (ClassCastException cce) {
            return super.add(m2);
        }
    }

    @Override
    public Array2DRowFieldMatrix<T> add(Array2DRowFieldMatrix<T> m2) throws IllegalArgumentException {
        this.checkAdditionCompatible(m2);
        int rowCount = this.getRowDimension();
        int columnCount = this.getColumnDimension();
        FieldElement[][] outData = Array2DRowFieldMatrix.buildArray(this.getField(), (int)rowCount, (int)columnCount);
        for (int row = 0; row < rowCount; ++row) {
            T[] dataRow = this.data[row];
            T[] mRow = m2.data[row];
            FieldElement[] outDataRow = outData[row];
            for (int col = 0; col < columnCount; ++col) {
                outDataRow[col] = (FieldElement)dataRow[col].add(mRow[col]);
            }
        }
        return new Array2DRowFieldMatrix(outData, false);
    }

    @Override
    public FieldMatrix<T> subtract(FieldMatrix<T> m2) throws IllegalArgumentException {
        try {
            return this.subtract((Array2DRowFieldMatrix)m2);
        }
        catch (ClassCastException cce) {
            return super.subtract(m2);
        }
    }

    @Override
    public Array2DRowFieldMatrix<T> subtract(Array2DRowFieldMatrix<T> m2) throws IllegalArgumentException {
        this.checkSubtractionCompatible(m2);
        int rowCount = this.getRowDimension();
        int columnCount = this.getColumnDimension();
        FieldElement[][] outData = Array2DRowFieldMatrix.buildArray(this.getField(), (int)rowCount, (int)columnCount);
        for (int row = 0; row < rowCount; ++row) {
            T[] dataRow = this.data[row];
            T[] mRow = m2.data[row];
            FieldElement[] outDataRow = outData[row];
            for (int col = 0; col < columnCount; ++col) {
                outDataRow[col] = (FieldElement)dataRow[col].subtract(mRow[col]);
            }
        }
        return new Array2DRowFieldMatrix(outData, false);
    }

    @Override
    public FieldMatrix<T> multiply(FieldMatrix<T> m2) throws IllegalArgumentException {
        try {
            return this.multiply((Array2DRowFieldMatrix)m2);
        }
        catch (ClassCastException cce) {
            return super.multiply(m2);
        }
    }

    @Override
    public Array2DRowFieldMatrix<T> multiply(Array2DRowFieldMatrix<T> m2) throws IllegalArgumentException {
        this.checkMultiplicationCompatible(m2);
        int nRows = this.getRowDimension();
        int nCols = m2.getColumnDimension();
        int nSum = this.getColumnDimension();
        FieldElement[][] outData = Array2DRowFieldMatrix.buildArray(this.getField(), (int)nRows, (int)nCols);
        for (int row = 0; row < nRows; ++row) {
            T[] dataRow = this.data[row];
            FieldElement[] outDataRow = outData[row];
            for (int col = 0; col < nCols; ++col) {
                FieldElement sum = (FieldElement)this.getField().getZero();
                for (int i2 = 0; i2 < nSum; ++i2) {
                    sum = (FieldElement)sum.add(dataRow[i2].multiply(m2.data[i2][col]));
                }
                outDataRow[col] = sum;
            }
        }
        return new Array2DRowFieldMatrix(outData, false);
    }

    @Override
    public T[][] getData() {
        return this.copyOut();
    }

    public T[][] getDataRef() {
        return this.data;
    }

    @Override
    public void setSubMatrix(T[][] subMatrix, int row, int column) throws MatrixIndexException {
        if (this.data == null) {
            if (row > 0) {
                throw MathRuntimeException.createIllegalStateException(LocalizedFormats.FIRST_ROWS_NOT_INITIALIZED_YET, row);
            }
            if (column > 0) {
                throw MathRuntimeException.createIllegalStateException(LocalizedFormats.FIRST_COLUMNS_NOT_INITIALIZED_YET, column);
            }
            int nRows = subMatrix.length;
            if (nRows == 0) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.AT_LEAST_ONE_ROW, new Object[0]);
            }
            int nCols = subMatrix[0].length;
            if (nCols == 0) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.AT_LEAST_ONE_COLUMN, new Object[0]);
            }
            this.data = Array2DRowFieldMatrix.buildArray(this.getField(), (int)subMatrix.length, (int)nCols);
            for (int i2 = 0; i2 < this.data.length; ++i2) {
                if (subMatrix[i2].length != nCols) {
                    throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.DIFFERENT_ROWS_LENGTHS, nCols, subMatrix[i2].length);
                }
                System.arraycopy(subMatrix[i2], 0, this.data[i2 + row], column, nCols);
            }
        } else {
            super.setSubMatrix(subMatrix, row, column);
        }
    }

    @Override
    public T getEntry(int row, int column) throws MatrixIndexException {
        try {
            return this.data[row][column];
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            throw new MatrixIndexException(LocalizedFormats.NO_SUCH_MATRIX_ENTRY, row, column, this.getRowDimension(), this.getColumnDimension());
        }
    }

    @Override
    public void setEntry(int row, int column, T value) throws MatrixIndexException {
        try {
            this.data[row][column] = value;
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            throw new MatrixIndexException(LocalizedFormats.NO_SUCH_MATRIX_ENTRY, row, column, this.getRowDimension(), this.getColumnDimension());
        }
    }

    @Override
    public void addToEntry(int row, int column, T increment) throws MatrixIndexException {
        try {
            this.data[row][column] = (FieldElement)this.data[row][column].add(increment);
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            throw new MatrixIndexException(LocalizedFormats.NO_SUCH_MATRIX_ENTRY, row, column, this.getRowDimension(), this.getColumnDimension());
        }
    }

    @Override
    public void multiplyEntry(int row, int column, T factor) throws MatrixIndexException {
        try {
            this.data[row][column] = (FieldElement)this.data[row][column].multiply(factor);
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            throw new MatrixIndexException(LocalizedFormats.NO_SUCH_MATRIX_ENTRY, row, column, this.getRowDimension(), this.getColumnDimension());
        }
    }

    @Override
    public int getRowDimension() {
        return this.data == null ? 0 : this.data.length;
    }

    @Override
    public int getColumnDimension() {
        return this.data == null || this.data[0] == null ? 0 : this.data[0].length;
    }

    @Override
    public T[] operate(T[] v2) throws IllegalArgumentException {
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        if (v2.length != nCols) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.VECTOR_LENGTH_MISMATCH, v2.length, nCols);
        }
        FieldElement[] out = Array2DRowFieldMatrix.buildArray(this.getField(), (int)nRows);
        for (int row = 0; row < nRows; ++row) {
            T[] dataRow = this.data[row];
            FieldElement sum = (FieldElement)this.getField().getZero();
            for (int i2 = 0; i2 < nCols; ++i2) {
                sum = (FieldElement)sum.add(dataRow[i2].multiply(v2[i2]));
            }
            out[row] = sum;
        }
        return out;
    }

    @Override
    public T[] preMultiply(T[] v2) throws IllegalArgumentException {
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        if (v2.length != nRows) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.VECTOR_LENGTH_MISMATCH, v2.length, nRows);
        }
        FieldElement[] out = Array2DRowFieldMatrix.buildArray(this.getField(), (int)nCols);
        for (int col = 0; col < nCols; ++col) {
            FieldElement sum = (FieldElement)this.getField().getZero();
            for (int i2 = 0; i2 < nRows; ++i2) {
                sum = (FieldElement)sum.add(this.data[i2][col].multiply(v2[i2]));
            }
            out[col] = sum;
        }
        return out;
    }

    @Override
    public T walkInRowOrder(FieldMatrixChangingVisitor<T> visitor) throws MatrixVisitorException {
        int rows = this.getRowDimension();
        int columns = this.getColumnDimension();
        visitor.start(rows, columns, 0, rows - 1, 0, columns - 1);
        for (int i2 = 0; i2 < rows; ++i2) {
            T[] rowI = this.data[i2];
            for (int j2 = 0; j2 < columns; ++j2) {
                rowI[j2] = visitor.visit(i2, j2, rowI[j2]);
            }
        }
        return visitor.end();
    }

    @Override
    public T walkInRowOrder(FieldMatrixPreservingVisitor<T> visitor) throws MatrixVisitorException {
        int rows = this.getRowDimension();
        int columns = this.getColumnDimension();
        visitor.start(rows, columns, 0, rows - 1, 0, columns - 1);
        for (int i2 = 0; i2 < rows; ++i2) {
            T[] rowI = this.data[i2];
            for (int j2 = 0; j2 < columns; ++j2) {
                visitor.visit(i2, j2, rowI[j2]);
            }
        }
        return visitor.end();
    }

    @Override
    public T walkInRowOrder(FieldMatrixChangingVisitor<T> visitor, int startRow, int endRow, int startColumn, int endColumn) throws MatrixIndexException, MatrixVisitorException {
        this.checkSubMatrixIndex(startRow, endRow, startColumn, endColumn);
        visitor.start(this.getRowDimension(), this.getColumnDimension(), startRow, endRow, startColumn, endColumn);
        for (int i2 = startRow; i2 <= endRow; ++i2) {
            T[] rowI = this.data[i2];
            for (int j2 = startColumn; j2 <= endColumn; ++j2) {
                rowI[j2] = visitor.visit(i2, j2, rowI[j2]);
            }
        }
        return visitor.end();
    }

    @Override
    public T walkInRowOrder(FieldMatrixPreservingVisitor<T> visitor, int startRow, int endRow, int startColumn, int endColumn) throws MatrixIndexException, MatrixVisitorException {
        this.checkSubMatrixIndex(startRow, endRow, startColumn, endColumn);
        visitor.start(this.getRowDimension(), this.getColumnDimension(), startRow, endRow, startColumn, endColumn);
        for (int i2 = startRow; i2 <= endRow; ++i2) {
            T[] rowI = this.data[i2];
            for (int j2 = startColumn; j2 <= endColumn; ++j2) {
                visitor.visit(i2, j2, rowI[j2]);
            }
        }
        return visitor.end();
    }

    @Override
    public T walkInColumnOrder(FieldMatrixChangingVisitor<T> visitor) throws MatrixVisitorException {
        int rows = this.getRowDimension();
        int columns = this.getColumnDimension();
        visitor.start(rows, columns, 0, rows - 1, 0, columns - 1);
        for (int j2 = 0; j2 < columns; ++j2) {
            for (int i2 = 0; i2 < rows; ++i2) {
                T[] rowI = this.data[i2];
                rowI[j2] = visitor.visit(i2, j2, rowI[j2]);
            }
        }
        return visitor.end();
    }

    @Override
    public T walkInColumnOrder(FieldMatrixPreservingVisitor<T> visitor) throws MatrixVisitorException {
        int rows = this.getRowDimension();
        int columns = this.getColumnDimension();
        visitor.start(rows, columns, 0, rows - 1, 0, columns - 1);
        for (int j2 = 0; j2 < columns; ++j2) {
            for (int i2 = 0; i2 < rows; ++i2) {
                visitor.visit(i2, j2, this.data[i2][j2]);
            }
        }
        return visitor.end();
    }

    @Override
    public T walkInColumnOrder(FieldMatrixChangingVisitor<T> visitor, int startRow, int endRow, int startColumn, int endColumn) throws MatrixIndexException, MatrixVisitorException {
        this.checkSubMatrixIndex(startRow, endRow, startColumn, endColumn);
        visitor.start(this.getRowDimension(), this.getColumnDimension(), startRow, endRow, startColumn, endColumn);
        for (int j2 = startColumn; j2 <= endColumn; ++j2) {
            for (int i2 = startRow; i2 <= endRow; ++i2) {
                T[] rowI = this.data[i2];
                rowI[j2] = visitor.visit(i2, j2, rowI[j2]);
            }
        }
        return visitor.end();
    }

    @Override
    public T walkInColumnOrder(FieldMatrixPreservingVisitor<T> visitor, int startRow, int endRow, int startColumn, int endColumn) throws MatrixIndexException, MatrixVisitorException {
        this.checkSubMatrixIndex(startRow, endRow, startColumn, endColumn);
        visitor.start(this.getRowDimension(), this.getColumnDimension(), startRow, endRow, startColumn, endColumn);
        for (int j2 = startColumn; j2 <= endColumn; ++j2) {
            for (int i2 = startRow; i2 <= endRow; ++i2) {
                visitor.visit(i2, j2, this.data[i2][j2]);
            }
        }
        return visitor.end();
    }

    private T[][] copyOut() {
        int nRows = this.getRowDimension();
        FieldElement[][] out = Array2DRowFieldMatrix.buildArray(this.getField(), (int)nRows, (int)this.getColumnDimension());
        for (int i2 = 0; i2 < nRows; ++i2) {
            System.arraycopy(this.data[i2], 0, out[i2], 0, this.data[i2].length);
        }
        return out;
    }

    private void copyIn(T[][] in) {
        this.setSubMatrix((FieldElement[][])in, 0, 0);
    }
}

