/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.rendered;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.rendered.AbstractRed;
import org.apache.batik.ext.awt.image.rendered.AbstractTiledRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;
import org.apache.batik.ext.awt.image.rendered.TileCacheRed;
import org.apache.batik.ext.awt.image.rendered.TileGenerator;
import org.apache.batik.ext.awt.image.rendered.TileStore;
import org.apache.batik.util.HaltingThread;

public class TileRed
extends AbstractRed
implements TileGenerator {
    static final AffineTransform IDENTITY = new AffineTransform();
    Rectangle tiledRegion;
    int xStep;
    int yStep;
    TileStore tiles;
    private RenderingHints hints;
    final boolean is_INT_PACK;
    RenderedImage tile = null;
    WritableRaster raster = null;

    public TileRed(RenderedImage tile, Rectangle tiledRegion) {
        this(tile, tiledRegion, tile.getWidth(), tile.getHeight(), null);
    }

    public TileRed(RenderedImage tile, Rectangle tiledRegion, RenderingHints hints) {
        this(tile, tiledRegion, tile.getWidth(), tile.getHeight(), hints);
    }

    public TileRed(RenderedImage tile, Rectangle tiledRegion, int xStep, int yStep) {
        this(tile, tiledRegion, xStep, yStep, null);
    }

    public TileRed(RenderedImage tile, Rectangle tiledRegion, int xStep, int yStep, RenderingHints hints) {
        if (tiledRegion == null) {
            throw new IllegalArgumentException();
        }
        if (tile == null) {
            throw new IllegalArgumentException();
        }
        this.tiledRegion = tiledRegion;
        this.xStep = xStep;
        this.yStep = yStep;
        this.hints = hints;
        SampleModel sm = TileRed.fixSampleModel(tile, xStep, yStep, tiledRegion.width, tiledRegion.height);
        ColorModel cm = tile.getColorModel();
        double smSz = AbstractTiledRed.getDefaultTileSize();
        double stepSz = (double)xStep * (double)yStep;
        if (16.1 * (smSz *= smSz) > stepSz) {
            int xSz = xStep;
            int ySz = yStep;
            if (4.0 * stepSz <= smSz) {
                int mult = (int)Math.ceil(Math.sqrt(smSz / stepSz));
                xSz *= mult;
                ySz *= mult;
            }
            sm = sm.createCompatibleSampleModel(xSz, ySz);
            this.raster = Raster.createWritableRaster(sm, new Point(tile.getMinX(), tile.getMinY()));
        }
        this.is_INT_PACK = GraphicsUtil.is_INT_PACK_Data(sm, false);
        this.init((CachableRed)null, tiledRegion, cm, sm, tile.getMinX(), tile.getMinY(), null);
        if (this.raster != null) {
            WritableRaster fromRaster = this.raster.createWritableChild(tile.getMinX(), tile.getMinY(), xStep, yStep, tile.getMinX(), tile.getMinY(), null);
            this.fillRasterFrom(fromRaster, tile);
            this.fillOutRaster(this.raster);
        } else {
            this.tile = new TileCacheRed(GraphicsUtil.wrap(tile));
        }
    }

    public WritableRaster copyData(WritableRaster wr) {
        int xOff = (int)Math.floor(wr.getMinX() / this.xStep) * this.xStep;
        int yOff = (int)Math.floor(wr.getMinY() / this.yStep) * this.yStep;
        int x0 = wr.getMinX() - xOff;
        int y0 = wr.getMinY() - yOff;
        int tx0 = this.getXTile(x0);
        int ty0 = this.getYTile(y0);
        int tx1 = this.getXTile(x0 + wr.getWidth() - 1);
        int ty1 = this.getYTile(y0 + wr.getHeight() - 1);
        int y = ty0;
        while (y <= ty1) {
            int x2 = tx0;
            while (x2 <= tx1) {
                Raster r2 = this.getTile(x2, y);
                r2 = r2.createChild(r2.getMinX(), r2.getMinY(), r2.getWidth(), r2.getHeight(), r2.getMinX() + xOff, r2.getMinY() + yOff, null);
                if (this.is_INT_PACK) {
                    GraphicsUtil.copyData_INT_PACK(r2, wr);
                } else {
                    GraphicsUtil.copyData_FALLBACK(r2, wr);
                }
                ++x2;
            }
            ++y;
        }
        return wr;
    }

    public Raster getTile(int x2, int y) {
        if (this.raster != null) {
            int tx = this.tileGridXOff + x2 * this.tileWidth;
            int ty = this.tileGridYOff + y * this.tileHeight;
            return this.raster.createTranslatedChild(tx, ty);
        }
        return this.genTile(x2, y);
    }

    public Raster genTile(int x2, int y) {
        int tx = this.tileGridXOff + x2 * this.tileWidth;
        int ty = this.tileGridYOff + y * this.tileHeight;
        if (this.raster != null) {
            return this.raster.createTranslatedChild(tx, ty);
        }
        Point pt = new Point(tx, ty);
        WritableRaster wr = Raster.createWritableRaster(this.sm, pt);
        this.fillRasterFrom(wr, this.tile);
        return wr;
    }

    /*
     * Unable to fully structure code
     */
    public WritableRaster fillRasterFrom(WritableRaster wr, RenderedImage src) {
        cm = this.getColorModel();
        bi = new BufferedImage(cm, wr.createWritableTranslatedChild(0, 0), cm.isAlphaPremultiplied(), null);
        g = GraphicsUtil.createGraphics(bi, this.hints);
        minX = wr.getMinX();
        minY = wr.getMinY();
        maxX = wr.getWidth();
        maxY = wr.getHeight();
        g.setComposite(AlphaComposite.Clear);
        g.setColor(new Color(0, 0, 0, 0));
        g.fillRect(0, 0, maxX, maxY);
        g.setComposite(AlphaComposite.SrcOver);
        g.translate(-minX, -minY);
        x1 = src.getMinX() + src.getWidth() - 1;
        y1 = src.getMinY() + src.getHeight() - 1;
        tileTx = (int)Math.ceil((minX - x1) / this.xStep) * this.xStep;
        tileTy = (int)Math.ceil((minY - y1) / this.yStep) * this.yStep;
        g.translate(tileTx, tileTy);
        curX = tileTx - wr.getMinX() + src.getMinX();
        curY = tileTy - wr.getMinY() + src.getMinY();
        minX = curX;
        while (curY < maxY) {
            if (!HaltingThread.hasBeenHalted()) ** GOTO lbl27
            return wr;
lbl-1000:
            // 1 sources

            {
                GraphicsUtil.drawImage(g, src);
                curX += this.xStep;
                g.translate(this.xStep, 0);
lbl27:
                // 2 sources

                ** while (curX < maxX)
            }
lbl28:
            // 1 sources

            curY += this.yStep;
            g.translate(minX - curX, this.yStep);
            curX = minX;
        }
        return wr;
    }

    protected void fillOutRaster(WritableRaster wr) {
        if (this.is_INT_PACK) {
            this.fillOutRaster_INT_PACK(wr);
        } else {
            this.fillOutRaster_FALLBACK(wr);
        }
    }

    protected void fillOutRaster_INT_PACK(WritableRaster wr) {
        int dstSP;
        int x0 = wr.getMinX();
        int y0 = wr.getMinY();
        int width = wr.getWidth();
        int height = wr.getHeight();
        SinglePixelPackedSampleModel sppsm = (SinglePixelPackedSampleModel)wr.getSampleModel();
        int scanStride = sppsm.getScanlineStride();
        DataBufferInt db = (DataBufferInt)wr.getDataBuffer();
        int[] pixels = db.getBankData()[0];
        int base = db.getOffset() + sppsm.getOffset(x0 - wr.getSampleModelTranslateX(), y0 - wr.getSampleModelTranslateY());
        int step = this.xStep;
        int x2 = this.xStep;
        while (x2 < width) {
            int y;
            int srcSP;
            int w2 = step;
            if (x2 + w2 > width) {
                w2 = width - x2;
            }
            if (w2 >= 128) {
                srcSP = base;
                dstSP = base + x2;
                y = 0;
                while (y < this.yStep) {
                    System.arraycopy(pixels, srcSP, pixels, dstSP, w2);
                    srcSP += scanStride;
                    dstSP += scanStride;
                    ++y;
                }
            } else {
                srcSP = base;
                dstSP = base + x2;
                y = 0;
                while (y < this.yStep) {
                    int end = srcSP;
                    srcSP += w2 - 1;
                    dstSP += w2 - 1;
                    while (srcSP >= end) {
                        pixels[dstSP--] = pixels[srcSP--];
                    }
                    srcSP += scanStride + 1;
                    dstSP += scanStride + 1;
                    ++y;
                }
            }
            x2 += step;
            step *= 2;
        }
        step = this.yStep;
        int y = this.yStep;
        while (y < height) {
            int h2 = step;
            if (y + h2 > height) {
                h2 = height - y;
            }
            dstSP = base + y * scanStride;
            System.arraycopy(pixels, base, pixels, dstSP, h2 * scanStride);
            y += step;
            step *= 2;
        }
    }

    protected void fillOutRaster_FALLBACK(WritableRaster wr) {
        int width = wr.getWidth();
        int height = wr.getHeight();
        Object data = null;
        int step = this.xStep;
        int x2 = this.xStep;
        while (x2 < width) {
            int w2 = step;
            if (x2 + w2 > width) {
                w2 = width - x2;
            }
            data = wr.getDataElements(0, 0, w2, this.yStep, data);
            wr.setDataElements(x2, 0, w2, this.yStep, data);
            if ((x2 += w2) >= width) break;
            if (x2 + w2 > width) {
                w2 = width - x2;
            }
            wr.setDataElements(x2, 0, w2, this.yStep, data);
            if ((x2 += w2) >= width) break;
            if (x2 + w2 > width) {
                w2 = width - x2;
            }
            wr.setDataElements(x2, 0, w2, this.yStep, data);
            x2 += step;
            step *= 4;
        }
        step = this.yStep;
        int y = this.yStep;
        while (y < height) {
            int h2 = step;
            if (y + h2 > height) {
                h2 = height - y;
            }
            data = wr.getDataElements(0, 0, width, h2, data);
            wr.setDataElements(0, y, width, h2, data);
            y += h2;
            if (h2 >= height) break;
            if (y + h2 > height) {
                h2 = height - y;
            }
            wr.setDataElements(0, y, width, h2, data);
            y += h2;
            if (h2 >= height) break;
            if (y + h2 > height) {
                h2 = height - y;
            }
            wr.setDataElements(0, y, width, h2, data);
            y += h2;
            y += step;
            step *= 4;
        }
    }

    protected static SampleModel fixSampleModel(RenderedImage src, int stepX, int stepY, int width, int height) {
        int h2;
        int defSz = AbstractTiledRed.getDefaultTileSize();
        SampleModel sm = src.getSampleModel();
        int w2 = sm.getWidth();
        if (w2 < defSz) {
            w2 = defSz;
        }
        if (w2 > stepX) {
            w2 = stepX;
        }
        if ((h2 = sm.getHeight()) < defSz) {
            h2 = defSz;
        }
        if (h2 > stepY) {
            h2 = stepY;
        }
        return sm.createCompatibleSampleModel(w2, h2);
    }
}

