/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge.svg12;

import org.apache.batik.bridge.AbstractGraphicsNodeBridge;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.ScriptingEnvironment;
import org.apache.batik.bridge.UpdateManager;
import org.apache.batik.bridge.svg12.ContentSelectionChangedEvent;
import org.apache.batik.bridge.svg12.SVG12BridgeUpdateHandler;
import org.apache.batik.dom.svg12.BindableElement;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.MutationEvent;

public class BindableElementBridge
extends AbstractGraphicsNodeBridge
implements SVG12BridgeUpdateHandler {
    public String getNamespaceURI() {
        return "*";
    }

    public String getLocalName() {
        return "*";
    }

    public Bridge getInstance() {
        return new BindableElementBridge();
    }

    public GraphicsNode createGraphicsNode(BridgeContext ctx, Element e2) {
        if (!SVGUtilities.matchUserAgent(e2, ctx.getUserAgent())) {
            return null;
        }
        CompositeGraphicsNode gn = this.buildCompositeGraphicsNode(ctx, e2, null);
        return gn;
    }

    public CompositeGraphicsNode buildCompositeGraphicsNode(BridgeContext ctx, Element e2, CompositeGraphicsNode gn) {
        ScriptingEnvironment se;
        BindableElement be = (BindableElement)e2;
        Element shadowTree = be.getXblShadowTree();
        UpdateManager um = ctx.getUpdateManager();
        ScriptingEnvironment scriptingEnvironment = se = um == null ? null : um.getScriptingEnvironment();
        if (se != null && shadowTree != null) {
            se.addScriptingListeners(shadowTree);
        }
        if (gn == null) {
            gn = new CompositeGraphicsNode();
            this.associateSVGContext(ctx, e2, gn);
        } else {
            int s2 = gn.size();
            int i2 = 0;
            while (i2 < s2) {
                gn.remove(0);
                ++i2;
            }
        }
        GVTBuilder builder = ctx.getGVTBuilder();
        if (shadowTree != null) {
            GraphicsNode shadowNode = builder.build(ctx, shadowTree);
            if (shadowNode != null) {
                gn.add(shadowNode);
            }
        } else {
            Node m2 = e2.getFirstChild();
            while (m2 != null) {
                GraphicsNode n2;
                if (m2.getNodeType() == 1 && (n2 = builder.build(ctx, (Element)m2)) != null) {
                    gn.add(n2);
                }
                m2 = m2.getNextSibling();
            }
        }
        return gn;
    }

    public void dispose() {
        BindableElement be = (BindableElement)this.e;
        if (be != null && be.getCSSFirstChild() != null) {
            this.disposeTree(be.getCSSFirstChild());
        }
        super.dispose();
    }

    protected GraphicsNode instantiateGraphicsNode() {
        return null;
    }

    public boolean isComposite() {
        return false;
    }

    public void buildGraphicsNode(BridgeContext ctx, Element e2, GraphicsNode node) {
        this.initializeDynamicSupport(ctx, e2, node);
    }

    public void handleDOMNodeInsertedEvent(MutationEvent evt) {
        BindableElement be = (BindableElement)this.e;
        Element shadowTree = be.getXblShadowTree();
        if (shadowTree == null && evt.getTarget() instanceof Element) {
            this.handleElementAdded((CompositeGraphicsNode)this.node, this.e, (Element)((Object)evt.getTarget()));
        }
    }

    public void handleBindingEvent(Element bindableElement, Element shadowTree) {
        CompositeGraphicsNode gn = this.node.getParent();
        gn.remove(this.node);
        this.disposeTree(this.e);
        this.handleElementAdded(gn, this.e.getParentNode(), this.e);
    }

    public void handleContentSelectionChangedEvent(ContentSelectionChangedEvent csce) {
    }

    protected void handleElementAdded(CompositeGraphicsNode gn, Node parent, Element childElt) {
        GVTBuilder builder = this.ctx.getGVTBuilder();
        GraphicsNode childNode = builder.build(this.ctx, childElt);
        if (childNode == null) {
            return;
        }
        int idx = -1;
        Node ps = childElt.getPreviousSibling();
        while (ps != null) {
            if (ps.getNodeType() == 1) {
                Element pse = (Element)ps;
                GraphicsNode psgn = this.ctx.getGraphicsNode(pse);
                while (psgn != null && psgn.getParent() != gn) {
                    psgn = psgn.getParent();
                }
                if (psgn != null && (idx = gn.indexOf(psgn)) != -1) break;
            }
            ps = ps.getPreviousSibling();
        }
        gn.add(++idx, childNode);
    }
}

