/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JPanel;
import javax.swing.JViewport;
import org.apache.log4j.Logger;
import org.broad.igv.ui.panel.MainPanel;
import org.broad.igv.ui.panel.Paintable;
import org.broad.igv.ui.panel.TrackPanelScrollPane;

public class IGVPanel
extends JPanel
implements Paintable {
    Logger log = Logger.getLogger(IGVPanel.class);
    MainPanel mainPanel;

    public IGVPanel(MainPanel mainPanel) {
        this.setLayout(null);
        this.mainPanel = mainPanel;
    }

    public int getViewportHeight() {
        Container parent = this.getParent();
        return parent == null ? 0 : parent.getHeight();
    }

    public TrackPanelScrollPane getScrollPane() {
        TrackPanelScrollPane scollpane = null;
        Container parent = this.getParent();
        if (parent instanceof JViewport) {
            scollpane = (TrackPanelScrollPane)((JViewport)parent).getParent();
        }
        return scollpane;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doLayout() {
        Object object = this.getTreeLock();
        synchronized (object) {
            this.log.trace("Layout: " + this.toString());
            int h2 = this.getHeight();
            Component[] children = this.getComponents();
            int nw = this.mainPanel.getNamePanelWidth();
            int grabBarWidth = nw - 10;
            int idx = 0;
            if (children.length > 3) {
                children[idx++].setBounds(this.mainPanel.getNamePanelX(), 0, 10, h2);
                children[idx++].setBounds(this.mainPanel.getNamePanelX() + 10, 0, nw - 10, h2);
            } else {
                children[idx++].setBounds(this.mainPanel.getNamePanelX(), 0, nw, h2);
            }
            children[idx++].setBounds(this.mainPanel.getAttributePanelX(), 0, this.mainPanel.getAttributePanelWidth(), h2);
            children[idx].setBounds(this.mainPanel.getDataPanelX(), 0, this.mainPanel.getDataPanelWidth(), h2);
            children[idx].doLayout();
        }
    }

    @Override
    public void paintOffscreen(Graphics2D g2, Rectangle rect) {
        int h2 = rect.height;
        Component[] children = this.getComponents();
        g2.translate(this.mainPanel.getNamePanelX(), 0);
        Rectangle nameRect = new Rectangle(children[0].getBounds());
        nameRect.height = h2;
        g2.setClip(nameRect);
        ((Paintable)((Object)children[0])).paintOffscreen(g2, nameRect);
        int dx = this.mainPanel.getAttributePanelX() - this.mainPanel.getNamePanelX();
        g2.translate(dx, 0);
        Rectangle attRect = new Rectangle(0, 0, children[1].getWidth(), h2);
        g2.setClip(attRect);
        ((Paintable)((Object)children[1])).paintOffscreen(g2, attRect);
        dx = this.mainPanel.getDataPanelX() - this.mainPanel.getAttributePanelX();
        g2.translate(dx, 0);
        Rectangle dataRect = new Rectangle(0, 0, this.mainPanel.getDataPanelWidth(), h2);
        g2.setClip(dataRect);
        ((Paintable)((Object)children[2])).paintOffscreen(g2, dataRect);
    }
}

