/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentBlock;
import org.broad.igv.sam.AlignmentBlockImpl;
import org.broad.igv.sam.FlowSignalContextBuilder;
import org.broad.igv.sam.FlowSignalSubContext;
import org.broad.igv.sam.Gap;
import org.broad.igv.sam.ReadMate;
import org.broad.igv.sam.SpliceGap;
import org.broad.igv.track.WindowFunction;

public abstract class SAMAlignment
implements Alignment {
    private static Logger log = Logger.getLogger(SAMAlignment.class);
    public static final char DELETE_CHAR = '-';
    public static final char SKIP_CHAR = '=';
    public static final char MATCH = 'M';
    public static final char PERFECT_MATCH = '=';
    public static final char MISMATCH = 'X';
    public static final char INSERTION = 'I';
    public static final char DELETION = 'D';
    public static final char SKIPPED_REGION = 'N';
    public static final char SOFT_CLIP = 'S';
    public static final char HARD_CLIP = 'H';
    public static final char PADDING = 'P';
    public static final char ZERO_GAP = 'O';
    public static final char UNKNOWN = '\u0000';
    public static final String REDUCE_READS_TAG = "RR";
    protected static final char[] NT2COMP = new char[]{'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'T', 'N', 'G', 'N', 'N', 'N', 'C', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'A', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'T', 'N', 'G', 'N', 'N', 'N', 'C', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'A', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N'};
    private static final String FLOW_SIGNAL_TAG = "ZF";
    String chr;
    protected int start;
    protected int end;
    protected Color color = null;
    protected String readGroup;
    protected String library;
    protected String sample;
    ReadMate mate;
    AlignmentBlockImpl[] alignmentBlocks;
    AlignmentBlockImpl[] insertions;
    List<Gap> gaps;
    char[] gapTypes;
    protected String mateSequence = null;
    protected String pairOrientation = "";
    private Strand firstOfPairStrand;
    private Strand secondOfPairStrand;

    @Override
    public String getChr() {
        return this.chr;
    }

    @Override
    public String getContig() {
        return this.chr;
    }

    public String getDescription() {
        return this.getReadName();
    }

    @Override
    public ReadMate getMate() {
        return this.mate;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public abstract String getReadName();

    @Override
    public abstract int getMappingQuality();

    @Override
    public abstract int getInferredInsertSize();

    @Override
    public abstract String getCigarString();

    public abstract int getReadLength();

    @Override
    public abstract String getReadSequence();

    @Override
    public AlignmentBlock[] getAlignmentBlocks() {
        return this.alignmentBlocks;
    }

    public AlignmentBlockImpl[] getInsertions() {
        return this.insertions;
    }

    @Override
    public abstract boolean isNegativeStrand();

    @Override
    public boolean contains(double location) {
        return location >= (double)this.getStart() && location < (double)this.getEnd();
    }

    @Override
    public byte getBase(double position) {
        int basePosition = (int)position;
        for (AlignmentBlockImpl block : this.alignmentBlocks) {
            if (!block.contains(basePosition)) continue;
            int offset = basePosition - block.getStart();
            byte base = block.getBase(offset);
            return base;
        }
        return 0;
    }

    @Override
    public byte getPhred(double position) {
        int basePosition = (int)position;
        for (AlignmentBlockImpl block : this.alignmentBlocks) {
            if (!block.contains(basePosition)) continue;
            int offset = basePosition - block.getStart();
            byte qual = block.getQuality(offset);
            return qual;
        }
        return 0;
    }

    protected void setPairStrands() {
        if (this.isPaired()) {
            ReadMate mate;
            this.firstOfPairStrand = this.isFirstOfPair() ? this.getReadStrand() : ((mate = this.getMate()) != null && mate.isMapped() ? mate.getStrand() : Strand.NONE);
            this.secondOfPairStrand = this.isSecondOfPair() ? (this.isNegativeStrand() ? Strand.NEGATIVE : Strand.POSITIVE) : ((mate = this.getMate()) != null && mate.isMapped() && this.isProperPair() ? (mate.isNegativeStrand() ? Strand.NEGATIVE : Strand.POSITIVE) : Strand.NONE);
        } else {
            this.firstOfPairStrand = this.getReadStrand();
            this.secondOfPairStrand = Strand.NONE;
        }
    }

    private static boolean operatorIsMatch(boolean showSoftClipped, char operator) {
        return operator == 'M' || operator == '=' || operator == 'X' || showSoftClipped && operator == 'S';
    }

    protected void createAlignmentBlocks(String cigarString, byte[] readBases, byte[] readBaseQualities, short[] flowSignals, String flowOrder, int flowOrderStart) {
        if (cigarString.equals("*")) {
            this.alignmentBlocks = new AlignmentBlockImpl[1];
            this.alignmentBlocks[0] = new AlignmentBlockImpl(this.getChr(), this.getStart(), readBases, readBaseQualities);
            return;
        }
        List<CigarOperator> operators = SAMAlignment.buildOperators(cigarString);
        boolean showSoftClipped = PreferenceManager.getInstance().getAsBoolean("SAM.SHOW_SOFT_CLIPPED");
        int nInsertions = 0;
        int nBlocks = 0;
        boolean firstOperator = true;
        int softClippedBaseCount = 0;
        int nGaps = 0;
        int nRealGaps = 0;
        char prevOp = '\u0000';
        for (CigarOperator operator : operators) {
            char op = operator.operator;
            if (op == 'H') continue;
            int nBases = operator.nBases;
            if (SAMAlignment.operatorIsMatch(showSoftClipped, op)) {
                ++nBlocks;
                if (SAMAlignment.operatorIsMatch(showSoftClipped, prevOp)) {
                    ++nGaps;
                }
            } else if (op == 'D' || op == 'N') {
                ++nGaps;
                ++nRealGaps;
            } else if (op == 'I') {
                ++nInsertions;
                ++nGaps;
            }
            if (firstOperator && op == 'S') {
                softClippedBaseCount += nBases;
            }
            if (op != 'S') {
                firstOperator = false;
            }
            prevOp = op;
        }
        this.alignmentBlocks = new AlignmentBlockImpl[nBlocks];
        this.insertions = new AlignmentBlockImpl[nInsertions];
        if (nGaps > 0) {
            this.gapTypes = new char[nGaps];
        }
        if (nRealGaps > 0) {
            this.gaps = new ArrayList<Gap>();
        }
        if (showSoftClipped) {
            this.start -= softClippedBaseCount;
        }
        int fromIdx = showSoftClipped ? 0 : softClippedBaseCount;
        int blockStart = this.start;
        int blockIdx = 0;
        int insertionIdx = 0;
        int gapIdx = 0;
        FlowSignalContextBuilder fBlockBuilder = null;
        if (null != flowSignals && 0 < readBases.length) {
            fBlockBuilder = new FlowSignalContextBuilder(flowSignals, flowOrder, flowOrderStart, readBases, fromIdx, this.isNegativeStrand());
        }
        prevOp = '\u0000';
        for (int i2 = 0; i2 < operators.size(); ++i2) {
            CigarOperator op = operators.get(i2);
            try {
                AlignmentBlockImpl block;
                if (op.operator == 'H') continue;
                if (SAMAlignment.operatorIsMatch(showSoftClipped, op.operator)) {
                    block = SAMAlignment.buildAlignmentBlock(fBlockBuilder, readBases, readBaseQualities, this.getChr(), blockStart, fromIdx, op.nBases, true);
                    if (op.operator == 'S') {
                        block.setSoftClipped(true);
                    }
                    this.alignmentBlocks[blockIdx++] = block;
                    fromIdx += op.nBases;
                    blockStart += op.nBases;
                    if (SAMAlignment.operatorIsMatch(showSoftClipped, prevOp)) {
                        this.gapTypes[gapIdx++] = 79;
                    }
                } else if (op.operator == 'D') {
                    this.gaps.add(new Gap(blockStart, op.nBases, op.operator));
                    blockStart += op.nBases;
                    this.gapTypes[gapIdx++] = op.operator;
                } else if (op.operator == 'N') {
                    int flankingLeft = 0;
                    int flankingRight = 0;
                    if (i2 > 0) {
                        flankingLeft = operators.get((int)(i2 - 1)).nBases;
                    }
                    if (i2 < operators.size() - 1) {
                        flankingRight = operators.get((int)(i2 + 1)).nBases;
                    }
                    this.gaps.add(new SpliceGap(blockStart, op.nBases, op.operator, flankingLeft, flankingRight));
                    blockStart += op.nBases;
                    this.gapTypes[gapIdx++] = op.operator;
                } else if (op.operator == 'I') {
                    this.gapTypes[gapIdx++] = 79;
                    block = SAMAlignment.buildAlignmentBlock(fBlockBuilder, readBases, readBaseQualities, this.getChr(), blockStart, fromIdx, op.nBases, false);
                    this.insertions[insertionIdx++] = block;
                    fromIdx += op.nBases;
                } else if (op.operator == 'P') {
                    this.gapTypes[gapIdx++] = 79;
                }
            }
            catch (Exception e2) {
                log.error("Error processing CIGAR string", e2);
            }
            prevOp = op.operator;
        }
        if (showSoftClipped && operators.size() > 0) {
            CigarOperator last = operators.get(operators.size() - 1);
            if (last.operator == 'S') {
                this.end += last.nBases;
            }
        }
    }

    public static List<CigarOperator> buildOperators(String cigarString) {
        ArrayList<CigarOperator> operators = new ArrayList<CigarOperator>();
        StringBuilder buffer = new StringBuilder(4);
        CigarOperator prevOp = null;
        for (int i2 = 0; i2 < cigarString.length(); ++i2) {
            char next = cigarString.charAt(i2);
            if (Character.isDigit(next)) {
                buffer.append(next);
                continue;
            }
            char op = next;
            int nBases = Integer.parseInt(buffer.toString());
            buffer.setLength(0);
            if (op == 'P') continue;
            if (prevOp != null && prevOp.operator == op) {
                prevOp.nBases += nBases;
                continue;
            }
            prevOp = new CigarOperator(nBases, op);
            operators.add(prevOp);
        }
        return operators;
    }

    private static AlignmentBlockImpl buildAlignmentBlock(FlowSignalContextBuilder fBlockBuilder, byte[] readBases, byte[] readBaseQualities, String chr, int blockStart, int fromIdx, int nBases, boolean checkNBasesAvailable) {
        byte[] blockBases = new byte[nBases];
        byte[] blockQualities = new byte[nBases];
        int nBasesAvailable = nBases;
        if (checkNBasesAvailable) {
            nBasesAvailable = readBases.length - fromIdx;
        }
        if (readBases == null || readBases.length == 0) {
            Arrays.fill(blockBases, (byte)61);
        } else if (nBasesAvailable < nBases) {
            Arrays.fill(blockBases, (byte)63);
        } else {
            System.arraycopy(readBases, fromIdx, blockBases, 0, nBases);
        }
        nBasesAvailable = nBases;
        if (checkNBasesAvailable) {
            nBasesAvailable = readBaseQualities.length - fromIdx;
        }
        if (readBaseQualities == null || readBaseQualities.length == 0 || nBasesAvailable < nBases) {
            Arrays.fill(blockQualities, (byte)126);
        } else {
            System.arraycopy(readBaseQualities, fromIdx, blockQualities, 0, nBases);
        }
        AlignmentBlockImpl block = fBlockBuilder != null ? new AlignmentBlockImpl(chr, blockStart, blockBases, blockQualities, fBlockBuilder.getFlowSignalContext(readBases, fromIdx, nBases)) : new AlignmentBlockImpl(chr, blockStart, blockBases, blockQualities);
        return block;
    }

    private static void bufAppendFlowSignals(AlignmentBlock block, StringBuffer buf, int offset) {
        if (block.hasFlowSignals()) {
            int n2 = 0;
            FlowSignalSubContext f2 = block.getFlowSignalSubContext(offset);
            if (null != f2 && null != f2.getSignals() && null != f2.getBases()) {
                buf.append("FZ = ");
                StringBuffer spos = new StringBuffer();
                spos.append("Flow position = ").append(f2.getFlowOrderIndex());
                for (int i2 = 0; i2 < f2.getNrSignalTypes(); ++i2) {
                    short[] signals = f2.getSignalsOfType(i2);
                    char[] bases = f2.getBasesOfType(i2);
                    if (null == signals || 0 >= signals.length) continue;
                    if (1 == i2) {
                        if (0 < n2) {
                            buf.append(",");
                        }
                        buf.append("[");
                    }
                    for (int j2 = 0; j2 < signals.length; ++j2) {
                        if (1 != i2 && 0 < n2) {
                            buf.append(",");
                        }
                        buf.append(bases[j2]);
                        buf.append(signals[j2]);
                        ++n2;
                    }
                    if (1 != i2) continue;
                    buf.append("]");
                }
                buf.append("<br>").append(spos);
                buf.append("<br>");
            }
        }
    }

    @Override
    public String getClipboardString(double location) {
        return this.getValueStringImpl(location, false);
    }

    @Override
    public String getValueString(double position, WindowFunction windowFunction) {
        return this.getValueStringImpl(position, true);
    }

    private String getValueStringImpl(double position, boolean truncate) {
        String attributeString;
        String readGroup;
        int basePosition = (int)position;
        StringBuffer buf = new StringBuffer();
        buf.append("Read name = " + this.getReadName() + "<br>");
        String sample = this.getSample();
        if (sample != null) {
            buf.append("Sample = " + sample + "<br>");
        }
        if ((readGroup = this.getReadGroup()) != null) {
            buf.append("Read group = " + readGroup + "<br>");
        }
        buf.append("Read length = " + Globals.DECIMAL_FORMAT.format(this.getReadLength()) + "bp<br>");
        String cigarString = this.getCigarString();
        int maxCigarStringLength = 60;
        if (cigarString.length() > maxCigarStringLength) {
            Matcher lMatcher = Pattern.compile("^(.{1," + Integer.toString(maxCigarStringLength / 2 - 1) + "}[A-Z])").matcher(cigarString);
            Matcher rMatcher = Pattern.compile("[A-Z](.{1," + Integer.toString(maxCigarStringLength / 2) + "})$").matcher(cigarString);
            cigarString = (lMatcher.find() ? lMatcher.group(1) : "") + "..." + (rMatcher.find() ? rMatcher.group(1) : "");
        }
        Matcher lclipMatcher = Pattern.compile("^(([0-9]+)H)?(([0-9]+)S)?").matcher(cigarString);
        Matcher rclipMatcher = Pattern.compile("(([0-9]+)S)?(([0-9]+)H)?$").matcher(cigarString);
        int lclipHard = 0;
        int lclipSoft = 0;
        int rclipHard = 0;
        int rclipSoft = 0;
        if (lclipMatcher.find()) {
            lclipHard = lclipMatcher.group(2) == null ? 0 : Integer.parseInt(lclipMatcher.group(2), 10);
            int n2 = lclipSoft = lclipMatcher.group(4) == null ? 0 : Integer.parseInt(lclipMatcher.group(4), 10);
        }
        if (rclipMatcher.find()) {
            rclipHard = rclipMatcher.group(4) == null ? 0 : Integer.parseInt(rclipMatcher.group(4), 10);
            rclipSoft = rclipMatcher.group(2) == null ? 0 : Integer.parseInt(rclipMatcher.group(2), 10);
        }
        buf.append("----------------------<br>");
        buf.append("Mapping = " + (this.isPrimary() ? (this.isSupplementary() ? "Supplementary" : "Primary") : "Secondary") + (this.isDuplicate() ? " Duplicate" : "") + (this.isVendorFailedRead() ? " Failed QC" : "") + " @ MAPQ " + Globals.DECIMAL_FORMAT.format(this.getMappingQuality()) + "<br>");
        buf.append("Reference span = " + this.getChr() + ":" + Globals.DECIMAL_FORMAT.format(this.getAlignmentStart() + 1) + "-" + Globals.DECIMAL_FORMAT.format(this.getAlignmentEnd()) + " (" + (this.isNegativeStrand() ? "-" : "+") + ")" + " = " + Globals.DECIMAL_FORMAT.format(this.getAlignmentEnd() - this.getAlignmentStart()) + "bp<br>");
        buf.append("Cigar = " + cigarString + "<br>");
        buf.append("Clipping = ");
        if (lclipHard + lclipSoft + rclipHard + rclipSoft == 0) {
            buf.append("None");
        } else {
            if (lclipHard + lclipSoft > 0) {
                buf.append("Left");
                if (lclipHard > 0) {
                    buf.append(" " + Globals.DECIMAL_FORMAT.format(lclipHard) + " hard");
                }
                if (lclipSoft > 0) {
                    buf.append(" " + Globals.DECIMAL_FORMAT.format(lclipSoft) + " soft");
                }
            }
            if (rclipHard + rclipSoft > 0) {
                buf.append((lclipHard + lclipSoft > 0 ? "; " : "") + "Right");
                if (rclipHard > 0) {
                    buf.append(" " + Globals.DECIMAL_FORMAT.format(rclipHard) + " hard");
                }
                if (rclipSoft > 0) {
                    buf.append(" " + Globals.DECIMAL_FORMAT.format(rclipSoft) + " soft");
                }
            }
        }
        buf.append("<br>");
        buf.append("----------------------<br>");
        if (this.insertions != null) {
            for (AlignmentBlockImpl block : this.insertions) {
                double insertionLeft = (double)block.getStart() - 0.25;
                double insertionRight = (double)block.getStart() + 0.25;
                if (!(position > insertionLeft) || !(position < insertionRight)) continue;
                if (block.hasFlowSignals()) {
                    int offset;
                    buf = new StringBuffer();
                    buf.append("Insertion: " + new String(block.getBases()) + "<br>");
                    buf.append("Base phred quality = ");
                    for (offset = 0; offset < block.getLength(); ++offset) {
                        byte quality = block.getQuality(offset);
                        if (0 < offset) {
                            buf.append(",");
                        }
                        buf.append(quality);
                    }
                    buf.append("<br>");
                    for (offset = 0; offset < block.getLength(); ++offset) {
                        byte base = block.getBase(offset);
                        if (base <= 0) continue;
                        buf.append((char)base + ": ");
                        SAMAlignment.bufAppendFlowSignals(block, buf, offset);
                    }
                    buf.append("----------------------");
                    return buf.toString();
                }
                byte[] bases = block.getBases();
                return bases == null ? "Insertion: " + block.getLength() + " bases" : "Insertion: " + new String(block.getBases());
            }
        }
        Genome genome = GenomeManager.getInstance().getCurrentGenome();
        for (AlignmentBlockImpl block : this.alignmentBlocks) {
            if (!block.contains(basePosition)) continue;
            int offset = basePosition - block.getStart();
            byte base = block.getBase(offset);
            if (base == 0 && this.getReadSequence().equals("=") && !block.isSoftClipped() && genome != null) {
                base = genome.getReference(this.chr, basePosition);
            }
            byte quality = block.getQuality(offset);
            buf.append("Location = " + this.getChr() + ":" + Globals.DECIMAL_FORMAT.format(1L + (long)position) + "<br>");
            buf.append("Base = " + (char)base + " @ QV " + Globals.DECIMAL_FORMAT.format(quality) + "<br>");
            if (!block.hasFlowSignals()) continue;
            SAMAlignment.bufAppendFlowSignals(block, buf, offset);
        }
        if (this.isPaired()) {
            buf.append("----------------------<br>");
            buf.append("Mate is mapped = " + (this.getMate().isMapped() ? "yes" : "no") + "<br>");
            if (this.getMate().isMapped()) {
                buf.append("Mate start = " + this.getMate().positionString() + "<br>");
                if (this.getChr().equals(this.getMate().getChr())) {
                    buf.append("Insert size = " + this.getInferredInsertSize() + "<br>");
                }
            }
            if (this.isFirstOfPair()) {
                buf.append("First in pair<br>");
            }
            if (this.isSecondOfPair()) {
                buf.append("Second in pair<br>");
            }
            if (this.getPairOrientation().length() > 0) {
                buf.append("Pair orientation = " + this.getPairOrientation() + "<br>");
            }
        }
        if ((attributeString = this.getAttributeString(truncate)) != null && attributeString.length() > 0) {
            buf.append("----------------------");
            buf.append(this.getAttributeString(truncate));
        }
        if (this.mateSequence != null) {
            buf.append("----------------------<br>");
            buf.append("Mate sequence: " + this.mateSequence);
        }
        return buf.toString();
    }

    protected abstract String getAttributeString(boolean var1);

    @Override
    public abstract boolean isFirstOfPair();

    @Override
    public abstract boolean isSecondOfPair();

    @Override
    public abstract boolean isDuplicate();

    @Override
    public abstract boolean isMapped();

    @Override
    public abstract boolean isPaired();

    @Override
    public abstract boolean isProperPair();

    @Override
    public abstract boolean isSupplementary();

    @Override
    public abstract boolean isVendorFailedRead();

    @Override
    public abstract boolean isPrimary();

    @Override
    public abstract int getAlignmentStart();

    @Override
    public abstract int getAlignmentEnd();

    @Override
    public float getScore() {
        return this.getMappingQuality();
    }

    public void setMate(ReadMate mate) {
        this.mate = mate;
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public void setStart(int start) {
        this.start = start;
    }

    @Override
    public int getEnd() {
        return this.end;
    }

    @Override
    public void setEnd(int end) {
        this.end = end;
    }

    @Override
    public String getSample() {
        return this.sample;
    }

    @Override
    public String getReadGroup() {
        return this.readGroup;
    }

    @Override
    public abstract Object getAttribute(String var1);

    @Override
    public String getLibrary() {
        return this.library;
    }

    @Override
    public List<Gap> getGaps() {
        return this.gaps;
    }

    @Override
    public void finish() {
    }

    @Override
    public Strand getReadStrand() {
        return this.isNegativeStrand() ? Strand.NEGATIVE : Strand.POSITIVE;
    }

    @Override
    public String getPairOrientation() {
        return this.pairOrientation;
    }

    @Override
    public void setMateSequence(String sequence) {
        this.mateSequence = sequence;
    }

    @Override
    public Strand getFirstOfPairStrand() {
        return this.firstOfPairStrand;
    }

    @Override
    public Strand getSecondOfPairStrand() {
        return this.secondOfPairStrand;
    }

    public int getFlowSignalsStart() {
        Object attribute = this.getAttribute(FLOW_SIGNAL_TAG);
        int toRet = -1;
        if (attribute != null && attribute instanceof Integer) {
            toRet = (Integer)attribute;
        }
        return toRet;
    }

    protected void setPairOrientation() {
        if (this.isPaired() && this.isMapped() && this.mate != null && this.mate.isMapped() && this.getChr().equals(this.mate.getChr())) {
            int s1 = this.isNegativeStrand() ? 82 : 70;
            int s2 = this.mate.isNegativeStrand() ? 82 : 70;
            int o1 = 32;
            int o2 = 32;
            if (this.isFirstOfPair()) {
                o1 = 49;
                o2 = 50;
            } else if (this.isSecondOfPair()) {
                o1 = 50;
                o2 = 49;
            }
            char[] tmp = new char[4];
            int isize = this.getInferredInsertSize();
            int estReadLen = this.getAlignmentEnd() - this.getAlignmentStart();
            if (isize == 0) {
                int estMateEnd = this.getAlignmentStart() < this.mate.getStart() ? this.getMate().getStart() + estReadLen : this.mate.getStart() - estReadLen;
                isize = estMateEnd - this.getAlignmentStart();
            }
            if (isize > 0) {
                tmp[0] = s1;
                tmp[1] = o1;
                tmp[2] = s2;
                tmp[3] = o2;
            } else {
                tmp[2] = s1;
                tmp[3] = o1;
                tmp[0] = s2;
                tmp[1] = o2;
            }
            this.pairOrientation = new String(tmp);
        }
    }

    static List<ReadMate> parseSupplementaryTag(String sa) {
        String[] records;
        ArrayList<ReadMate> mates = new ArrayList<ReadMate>();
        for (String rec : records = Globals.semicolonPattern.split(sa)) {
            String[] tokens = Globals.commaPattern.split(rec);
            String seq = tokens[0];
            int pos = Integer.parseInt(tokens[1]);
            boolean negStrand = tokens[2].equals("-");
            String cigar = tokens[3];
            int mapQ = Integer.parseInt(tokens[4]);
            int numMismatches = Integer.parseInt(tokens[5]);
            mates.add(new ReadMate(seq, pos, negStrand, true));
        }
        return mates;
    }

    public void setChr(String chr) {
        this.chr = chr;
    }

    static class CigarOperator {
        int nBases;
        char operator;

        public CigarOperator(int nBases, char operator) {
            this.nBases = nBases;
            this.operator = operator;
        }
    }
}

