/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.AbstractBitCodec;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;
import java.io.IOException;

class SubexponentialIntegerCodec
extends AbstractBitCodec<Integer> {
    private int offset = 0;
    private int k = 2;
    private boolean unaryBit = true;

    SubexponentialIntegerCodec(int offset, int k2) {
        this.offset = offset;
        this.k = k2;
        this.unaryBit = true;
    }

    @Override
    public final Integer read(BitInputStream bitInputStream) throws IOException {
        int n2;
        int u2 = 0;
        while (bitInputStream.readBit() == this.unaryBit) {
            ++u2;
        }
        if (u2 == 0) {
            int b2 = this.k;
            n2 = bitInputStream.readBits(b2);
        } else {
            int b3 = u2 + this.k - 1;
            n2 = 1 << b3 | bitInputStream.readBits(b3);
        }
        return n2 - this.offset;
    }

    @Override
    public final long write(BitOutputStream bitOutputStream, Integer value) throws IOException {
        int u2;
        int b2;
        if (value + this.offset < 0) {
            throw new IllegalArgumentException("Value is less then offset: " + value);
        }
        long newValue = value + this.offset;
        if (newValue < 1L << this.k) {
            b2 = this.k;
            u2 = 0;
        } else {
            b2 = (int)(Math.log(newValue) / Math.log(2.0));
            u2 = b2 - this.k + 1;
        }
        bitOutputStream.write(this.unaryBit, (long)u2);
        bitOutputStream.write(!this.unaryBit);
        bitOutputStream.write(newValue, b2);
        return u2 + 1 + b2;
    }

    @Override
    public final long numberOfBits(Integer value) {
        long u2;
        long b2;
        long newValue = value + this.offset;
        if (newValue < 1L << this.k) {
            b2 = this.k;
            u2 = 0L;
        } else {
            b2 = (long)Math.floor(Math.log(newValue) / Math.log(2.0));
            u2 = b2 - (long)this.k + 1L;
        }
        return u2 + 1L + b2;
    }

    @Override
    public Integer read(BitInputStream bitInputStream, int length) throws IOException {
        throw new RuntimeException("Not implemented.");
    }
}

