/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.SAMUtils;
import java.util.ArrayList;
import java.util.Random;
import picard.sam.HitsForInsert;
import picard.sam.PrimaryAlignmentSelectionStrategy;

public class BestMapqPrimaryAlignmentSelectionStrategy
implements PrimaryAlignmentSelectionStrategy {
    private final Random random = new Random(1L);

    @Override
    public void pickPrimaryAlignment(HitsForInsert hits) {
        if (hits.numHits() == 0) {
            throw new IllegalArgumentException("No alignments to pick from");
        }
        hits.coordinateByHitIndex();
        HitsForInsert.NumPrimaryAlignmentState firstEndAlignmentState = hits.tallyPrimaryAlignments(true);
        HitsForInsert.NumPrimaryAlignmentState secondEndAlignmentState = hits.tallyPrimaryAlignments(false);
        if (firstEndAlignmentState == HitsForInsert.NumPrimaryAlignmentState.NONE && secondEndAlignmentState == HitsForInsert.NumPrimaryAlignmentState.NONE || firstEndAlignmentState == HitsForInsert.NumPrimaryAlignmentState.MORE_THAN_ONE || secondEndAlignmentState == HitsForInsert.NumPrimaryAlignmentState.MORE_THAN_ONE) {
            int primaryAlignmentIndex;
            ArrayList<Integer> primaryAlignmentIndices = new ArrayList<Integer>(hits.numHits());
            int bestMapQ = -1;
            for (int i2 = 0; i2 < hits.numHits(); ++i2) {
                int secondEndMapq;
                int firstEndMapq = hits.getFirstOfPair(i2) != null ? hits.getFirstOfPair(i2).getMappingQuality() : 0;
                int thisMapQ = SAMUtils.combineMapqs(firstEndMapq, secondEndMapq = hits.getSecondOfPair(i2) != null ? hits.getSecondOfPair(i2).getMappingQuality() : 0);
                if (thisMapQ > bestMapQ) {
                    bestMapQ = thisMapQ;
                    primaryAlignmentIndices.clear();
                }
                if (thisMapQ != bestMapQ) continue;
                primaryAlignmentIndices.add(i2);
            }
            if (primaryAlignmentIndices.size() == 1) {
                primaryAlignmentIndex = (Integer)primaryAlignmentIndices.get(0);
            } else if (primaryAlignmentIndices.size() > 1) {
                primaryAlignmentIndex = (Integer)primaryAlignmentIndices.get(this.random.nextInt(primaryAlignmentIndices.size()));
            } else {
                throw new IllegalStateException("Never found a best MAPQ -- should never happen");
            }
            hits.setPrimaryAlignment(primaryAlignmentIndex);
        }
    }
}

