/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam.reader;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileReader;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.ValidationStringency;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.broad.igv.exceptions.DataLoadException;
import org.broad.igv.ga4gh.Ga4ghAlignmentReader;
import org.broad.igv.ga4gh.Ga4ghProvider;
import org.broad.igv.goby.GobyAlignmentQueryReader;
import org.broad.igv.sam.reader.AlignmentReader;
import org.broad.igv.sam.reader.BAMFileReader;
import org.broad.igv.sam.reader.BAMHttpReader;
import org.broad.igv.sam.reader.CGIAlignmentReader;
import org.broad.igv.sam.reader.GeraldReader;
import org.broad.igv.sam.reader.MergedAlignmentReader;
import org.broad.igv.sam.reader.SAMReader;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;

public class AlignmentReaderFactory {
    private static Logger log = Logger.getLogger(AlignmentReaderFactory.class);

    public static AlignmentReader getReader(String path, boolean requireIndex) throws IOException {
        return AlignmentReaderFactory.getReader(new ResourceLocator(path), requireIndex);
    }

    public static AlignmentReader getReader(ResourceLocator locator) throws IOException {
        return AlignmentReaderFactory.getReader(locator, true);
    }

    public static AlignmentReader getReader(ResourceLocator locator, boolean requireIndex) throws IOException {
        log.debug("Getting alignment reader for " + locator);
        String pathLowerCase = locator.getPath().toLowerCase();
        AlignmentReader reader = null;
        String samFile = locator.getPath();
        String typeString = locator.getTypeString();
        if ("alist".equals(locator.getType())) {
            reader = AlignmentReaderFactory.getMergedReader(locator.getPath(), true);
        } else if (pathLowerCase.startsWith("http") && pathLowerCase.contains("/query.cgi?")) {
            reader = new CGIAlignmentReader(samFile);
        } else if (typeString.endsWith(".sam")) {
            reader = new SAMReader(samFile, requireIndex);
        } else if (typeString.endsWith(".aligned") || typeString.endsWith(".aligned.txt") || typeString.endsWith("bedz") || typeString.endsWith("bed") || typeString.endsWith("psl") || typeString.endsWith("pslx")) {
            reader = new GeraldReader(samFile, requireIndex);
        } else if (typeString.endsWith(".bam")) {
            if (locator.isLocal()) {
                reader = new BAMFileReader(new File(samFile));
            } else {
                try {
                    reader = new BAMHttpReader(locator, requireIndex);
                }
                catch (MalformedURLException e2) {
                    log.error(e2.getMessage(), e2);
                    throw new DataLoadException("Error loading BAM file: " + e2.toString(), locator.getPath());
                }
            }
        } else if (typeString.endsWith(".bam.list") || pathLowerCase.endsWith(".sam.list")) {
            reader = AlignmentReaderFactory.getBamListReader(locator.getPath(), requireIndex);
        } else if (GobyAlignmentQueryReader.supportsFileType(locator.getPath())) {
            try {
                reader = new GobyAlignmentQueryReader(locator.getPath());
            }
            catch (IOException e3) {
                throw new RuntimeException("Cannot load Goby alignment " + locator.getPath(), e3);
            }
        } else {
            if (Ga4ghAlignmentReader.supportsFileType(locator.getType())) {
                Ga4ghProvider provider = (Ga4ghProvider)locator.getAttribute("provider");
                return new Ga4ghAlignmentReader(provider, locator.getPath());
            }
            throw new RuntimeException("Cannot find reader for aligment file: " + locator.getPath());
        }
        return reader;
    }

    static AlignmentReader getBamListReader(String listFile, boolean requireIndex) {
        AlignmentReader alignmentReader;
        ArrayList<AlignmentReader> readers = new ArrayList<AlignmentReader>();
        BufferedReader reader = null;
        try {
            reader = ParsingUtils.openBufferedReader(listFile);
            HashMap<String, String> replacements = new HashMap<String, String>();
            String nextLine = null;
            while ((nextLine = reader.readLine()) != null) {
                if (nextLine.startsWith("#replace")) {
                    String[] kv;
                    String[] tokens = nextLine.split("\\s+");
                    if (tokens.length != 2 || (kv = tokens[1].split("=")).length != 2) continue;
                    replacements.put(kv[0], kv[1]);
                    continue;
                }
                String f2 = nextLine.trim();
                if (f2.length() == 0) continue;
                for (Map.Entry entry : replacements.entrySet()) {
                    f2 = f2.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
                }
                f2 = FileUtils.getAbsolutePath(f2, listFile);
                readers.add(AlignmentReaderFactory.getReader(f2, requireIndex));
            }
            if (readers.size() == 1) {
                alignmentReader = (AlignmentReader)readers.get(0);
                return alignmentReader;
            }
            alignmentReader = new MergedAlignmentReader(readers);
        }
        catch (IOException e2) {
            log.error("Error parsing " + listFile, e2);
            throw new RuntimeException("Error parsing: " + listFile + " (" + e2.toString() + ")");
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e3) {}
            }
        }
        return alignmentReader;
    }

    public static AlignmentReader getMergedReader(String alignmentFileList, boolean requireIndex) {
        String aFile = null;
        try {
            String[] alignmentFiles = ParsingUtils.COMMA_PATTERN.split(alignmentFileList);
            ArrayList<AlignmentReader> readers = new ArrayList<AlignmentReader>(alignmentFiles.length);
            String[] arr$ = alignmentFiles;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String f2;
                aFile = f2 = arr$[i$];
                readers.add(AlignmentReaderFactory.getReader(aFile, requireIndex));
            }
            if (readers.size() == 1) {
                return (AlignmentReader)readers.get(0);
            }
            return new MergedAlignmentReader(readers);
        }
        catch (IOException e2) {
            log.error("Error instantiating reader for: " + aFile, e2);
            throw new RuntimeException("Error instantiating reader for : " + aFile + " (" + e2.toString() + ")");
        }
    }

    public static Set<String> getPlatforms(SAMFileHeader header) {
        List<SAMReadGroupRecord> readGroups;
        HashSet<String> platforms = null;
        if (header != null && (readGroups = header.getReadGroups()) != null) {
            platforms = new HashSet<String>();
            for (SAMReadGroupRecord rg : readGroups) {
                String platform = rg.getPlatform();
                if (platform == null) continue;
                platforms.add(platform.toUpperCase());
            }
        }
        return platforms;
    }

    static {
        SAMFileReader.setDefaultValidationStringency(ValidationStringency.SILENT);
    }
}

