/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.analysis.integration;

import org.apache.commons.math.ConvergingAlgorithmImpl;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.analysis.integration.UnivariateRealIntegrator;
import org.apache.commons.math.exception.NullArgumentException;
import org.apache.commons.math.exception.util.LocalizedFormats;

public abstract class UnivariateRealIntegratorImpl
extends ConvergingAlgorithmImpl
implements UnivariateRealIntegrator {
    private static final long serialVersionUID = 6248808456637441533L;
    protected int minimalIterationCount;
    protected int defaultMinimalIterationCount;
    protected boolean resultComputed = false;
    protected double result;
    @Deprecated
    protected UnivariateRealFunction f;

    @Deprecated
    protected UnivariateRealIntegratorImpl(UnivariateRealFunction f2, int defaultMaximalIterationCount) throws IllegalArgumentException {
        super(defaultMaximalIterationCount, 1.0E-15);
        if (f2 == null) {
            throw new NullArgumentException(LocalizedFormats.FUNCTION);
        }
        this.f = f2;
        this.setRelativeAccuracy(1.0E-6);
        this.minimalIterationCount = this.defaultMinimalIterationCount = 3;
        this.verifyIterationCount();
    }

    protected UnivariateRealIntegratorImpl(int defaultMaximalIterationCount) throws IllegalArgumentException {
        super(defaultMaximalIterationCount, 1.0E-15);
        this.setRelativeAccuracy(1.0E-6);
        this.minimalIterationCount = this.defaultMinimalIterationCount = 3;
        this.verifyIterationCount();
    }

    public double getResult() throws IllegalStateException {
        if (this.resultComputed) {
            return this.result;
        }
        throw MathRuntimeException.createIllegalStateException(LocalizedFormats.NO_RESULT_AVAILABLE, new Object[0]);
    }

    protected final void setResult(double newResult, int iterationCount) {
        this.result = newResult;
        this.iterationCount = iterationCount;
        this.resultComputed = true;
    }

    protected final void clearResult() {
        this.iterationCount = 0;
        this.resultComputed = false;
    }

    public void setMinimalIterationCount(int count) {
        this.minimalIterationCount = count;
    }

    public int getMinimalIterationCount() {
        return this.minimalIterationCount;
    }

    public void resetMinimalIterationCount() {
        this.minimalIterationCount = this.defaultMinimalIterationCount;
    }

    protected void verifyInterval(double lower, double upper) throws IllegalArgumentException {
        if (lower >= upper) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.ENDPOINTS_NOT_AN_INTERVAL, lower, upper);
        }
    }

    protected void verifyIterationCount() throws IllegalArgumentException {
        if (this.minimalIterationCount <= 0 || this.maximalIterationCount <= this.minimalIterationCount) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.INVALID_ITERATIONS_LIMITS, this.minimalIterationCount, this.maximalIterationCount);
        }
    }
}

