/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.util.ArrayList;
import org.apache.batik.anim.AbstractAnimation;
import org.apache.batik.anim.MotionAnimation;
import org.apache.batik.anim.values.AnimatableMotionPointValue;
import org.apache.batik.anim.values.AnimatableValue;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.SVGAnimateElementBridge;
import org.apache.batik.bridge.SVGAnimateMotionElementBridge;
import org.apache.batik.dom.anim.AnimatableElement;
import org.apache.batik.dom.anim.AnimationTarget;
import org.apache.batik.dom.svg.SVGAnimatedPathDataSupport;
import org.apache.batik.dom.svg.SVGOMElement;
import org.apache.batik.dom.svg.SVGOMPathElement;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.ext.awt.geom.ExtendedGeneralPath;
import org.apache.batik.parser.AWTPathProducer;
import org.apache.batik.parser.AngleHandler;
import org.apache.batik.parser.AngleParser;
import org.apache.batik.parser.LengthArrayProducer;
import org.apache.batik.parser.LengthPairListParser;
import org.apache.batik.parser.ParseException;
import org.apache.batik.parser.PathParser;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SVGAnimateMotionElementBridge
extends SVGAnimateElementBridge {
    public String getLocalName() {
        return "animateMotion";
    }

    public Bridge getInstance() {
        return new SVGAnimateMotionElementBridge();
    }

    protected AbstractAnimation createAnimation(AnimationTarget target) {
        this.animationType = (short)2;
        this.attributeLocalName = "motion";
        AnimatableValue from = this.parseLengthPair("from");
        AnimatableValue to = this.parseLengthPair("to");
        AnimatableValue by = this.parseLengthPair("by");
        boolean rotateAuto = false;
        boolean rotateAutoReverse = false;
        float rotateAngle = 0.0f;
        short rotateAngleUnit = 0;
        String rotateString = this.element.getAttributeNS(null, "rotate");
        if (rotateString.length() != 0) {
            if (rotateString.equals("auto")) {
                rotateAuto = true;
            } else if (rotateString.equals("auto-reverse")) {
                rotateAuto = true;
                rotateAutoReverse = true;
            } else {
                AngleParser ap = new AngleParser();
                class Handler
                implements AngleHandler {
                    float theAngle;
                    short theUnit;
                    private final /* synthetic */ SVGAnimateMotionElementBridge this$0;

                    Handler(SVGAnimateMotionElementBridge this$0) {
                        this.this$0 = this$0;
                        this.theUnit = 1;
                    }

                    public void startAngle() throws ParseException {
                    }

                    public void angleValue(float v2) throws ParseException {
                        this.theAngle = v2;
                    }

                    public void deg() throws ParseException {
                        this.theUnit = (short)2;
                    }

                    public void grad() throws ParseException {
                        this.theUnit = (short)4;
                    }

                    public void rad() throws ParseException {
                        this.theUnit = (short)3;
                    }

                    public void endAngle() throws ParseException {
                    }
                }
                Handler h2 = new Handler(this);
                ap.setAngleHandler(h2);
                try {
                    ap.parse(rotateString);
                }
                catch (ParseException pEx) {
                    throw new BridgeException(this.ctx, this.element, pEx, "attribute.malformed", new Object[]{"rotate", rotateString});
                }
                rotateAngle = h2.theAngle;
                rotateAngleUnit = h2.theUnit;
            }
        }
        return new MotionAnimation(this.timedElement, (AnimatableElement)this, this.parseCalcMode(), this.parseKeyTimes(), this.parseKeySplines(), this.parseAdditive(), this.parseAccumulate(), this.parseValues(), from, to, by, this.parsePath(), this.parseKeyPoints(), rotateAuto, rotateAutoReverse, rotateAngle, rotateAngleUnit);
    }

    protected ExtendedGeneralPath parsePath() {
        Node n2 = this.element.getFirstChild();
        while (n2 != null) {
            if (n2.getNodeType() == 1 && "http://www.w3.org/2000/svg".equals(n2.getNamespaceURI()) && "mpath".equals(n2.getLocalName())) {
                String uri = XLinkSupport.getXLinkHref((Element)n2);
                Element path = this.ctx.getReferencedElement(this.element, uri);
                if (!"http://www.w3.org/2000/svg".equals(path.getNamespaceURI()) || !"path".equals(path.getLocalName())) {
                    throw new BridgeException(this.ctx, this.element, "uri.badTarget", new Object[]{uri});
                }
                SVGOMPathElement pathElt = (SVGOMPathElement)path;
                AWTPathProducer app = new AWTPathProducer();
                SVGAnimatedPathDataSupport.handlePathSegList(pathElt.getPathSegList(), app);
                return (ExtendedGeneralPath)app.getShape();
            }
            n2 = n2.getNextSibling();
        }
        String pathString = this.element.getAttributeNS(null, "path");
        if (pathString.length() == 0) {
            return null;
        }
        try {
            AWTPathProducer app = new AWTPathProducer();
            PathParser pp = new PathParser();
            pp.setPathHandler(app);
            pp.parse(pathString);
            return (ExtendedGeneralPath)app.getShape();
        }
        catch (ParseException pEx) {
            throw new BridgeException(this.ctx, this.element, pEx, "attribute.malformed", new Object[]{"path", pathString});
        }
    }

    /*
     * Unable to fully structure code
     */
    protected float[] parseKeyPoints() {
        keyPointsString = this.element.getAttributeNS(null, "keyPoints");
        len = keyPointsString.length();
        if (len == 0) {
            return null;
        }
        keyPoints = new ArrayList<Float>(7);
        i = 0;
        start = 0;
        ** GOTO lbl26
        while (++i != len) {
            while (keyPointsString.charAt(i) != ' ') {
                start = i++;
                if (i != len) {
                    c = keyPointsString.charAt(i);
                    while (c != ' ' && c != ';' && c != ',') {
                        if (++i == len) break;
                        c = keyPointsString.charAt(i);
                    }
                }
                end = i++;
                try {
                    keyPointCoord = Float.parseFloat(keyPointsString.substring(start, end));
                    keyPoints.add(new Float(keyPointCoord));
                }
                catch (NumberFormatException nfEx) {
                    throw new BridgeException(this.ctx, this.element, nfEx, "attribute.malformed", new Object[]{"keyPoints", keyPointsString});
                }
lbl26:
                // 2 sources

                if (i < len) continue;
            }
        }
        len = keyPoints.size();
        ret = new float[len];
        j = 0;
        while (j < len) {
            ret[j] = ((Float)keyPoints.get(j)).floatValue();
            ++j;
        }
        return ret;
    }

    protected int getDefaultCalcMode() {
        return 2;
    }

    protected AnimatableValue[] parseValues() {
        String valuesString = this.element.getAttributeNS(null, "values");
        int len = valuesString.length();
        if (len == 0) {
            return null;
        }
        return this.parseValues(valuesString);
    }

    protected AnimatableValue[] parseValues(String s2) {
        try {
            LengthPairListParser lplp = new LengthPairListParser();
            LengthArrayProducer lap = new LengthArrayProducer();
            lplp.setLengthListHandler(lap);
            lplp.parse(s2);
            short[] types = lap.getLengthTypeArray();
            float[] values = lap.getLengthValueArray();
            AnimatableValue[] ret = new AnimatableValue[types.length / 2];
            int i2 = 0;
            while (i2 < types.length) {
                float x2 = this.animationTarget.svgToUserSpace(values[i2], types[i2], (short)1);
                float y = this.animationTarget.svgToUserSpace(values[i2 + 1], types[i2 + 1], (short)2);
                ret[i2 / 2] = new AnimatableMotionPointValue(this.animationTarget, x2, y, 0.0f);
                i2 += 2;
            }
            return ret;
        }
        catch (ParseException pEx) {
            throw new BridgeException(this.ctx, this.element, pEx, "attribute.malformed", new Object[]{"values", s2});
        }
    }

    protected AnimatableValue parseLengthPair(String ln) {
        String s2 = this.element.getAttributeNS(null, ln);
        if (s2.length() == 0) {
            return null;
        }
        return this.parseValues(s2)[0];
    }

    public AnimatableValue getUnderlyingValue() {
        return new AnimatableMotionPointValue(this.animationTarget, 0.0f, 0.0f, 0.0f);
    }

    protected void initializeAnimation() {
        Node t2;
        String uri = XLinkSupport.getXLinkHref(this.element);
        if (uri.length() == 0) {
            t2 = this.element.getParentNode();
        } else {
            t2 = this.ctx.getReferencedElement(this.element, uri);
            if (t2.getOwnerDocument() != this.element.getOwnerDocument()) {
                throw new BridgeException(this.ctx, this.element, "uri.badTarget", new Object[]{uri});
            }
        }
        this.animationTarget = null;
        if (t2 instanceof SVGOMElement) {
            this.targetElement = (SVGOMElement)t2;
            this.animationTarget = this.targetElement;
        }
        if (this.animationTarget == null) {
            throw new BridgeException(this.ctx, this.element, "uri.badTarget", new Object[]{uri});
        }
        this.timedElement = this.createTimedElement();
        this.animation = this.createAnimation(this.animationTarget);
        this.eng.addAnimation(this.animationTarget, (short)2, this.attributeNamespaceURI, this.attributeLocalName, this.animation);
    }
}

