/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.Locus;
import org.broad.igv.feature.Range;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.event.DragStoppedEvent;
import org.broad.igv.ui.event.ViewChange;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.LongRunningTask;

public class ReferenceFrame {
    private static Logger log = Logger.getLogger(ReferenceFrame.class);
    boolean visible = true;
    public static int binsPerTile = 700;
    private String name;
    protected String chrName = "chrAll";
    private int minZoom = 0;
    public int maxZoom = 23;
    protected static final int minBP = 40;
    protected int zoom = this.minZoom;
    volatile int pixelX;
    protected int widthInPixels;
    protected double nTiles = 1.0;
    protected volatile double origin = 0.0;
    protected volatile double locationScale;
    protected Locus initialLocus = null;
    private EventBus eventBus;

    public ReferenceFrame(String name) {
        this.name = name;
        Genome genome = ReferenceFrame.getGenome();
        this.chrName = genome == null ? "" : genome.getHomeChromosome();
        this.registerEventBuses();
    }

    public ReferenceFrame(ReferenceFrame otherFrame) {
        this.chrName = otherFrame.chrName;
        this.initialLocus = otherFrame.initialLocus;
        this.locationScale = otherFrame.locationScale;
        this.minZoom = otherFrame.minZoom;
        this.name = otherFrame.name;
        this.nTiles = otherFrame.nTiles;
        this.origin = otherFrame.origin;
        this.pixelX = otherFrame.pixelX;
        this.widthInPixels = otherFrame.widthInPixels;
        this.zoom = otherFrame.zoom;
        this.maxZoom = otherFrame.maxZoom;
        this.registerEventBuses();
    }

    private void registerEventBuses() {
        if (IGV.hasInstance()) {
            this.getEventBus().register(IGV.getInstance());
        }
    }

    public EventBus getEventBus() {
        if (this.eventBus == null) {
            this.eventBus = new AsyncEventBus(LongRunningTask.getThreadExecutor());
            this.eventBus.register(this);
        }
        return this.eventBus;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public synchronized void setBounds(int pixelX, int widthInPixels) {
        this.pixelX = pixelX;
        if (this.widthInPixels != widthInPixels) {
            if (this.widthInPixels > 0 && this.initialLocus == null) {
                int start = (int)this.getOrigin();
                int end = (int)this.getEnd();
                if (start >= 0 && end >= 1) {
                    this.initialLocus = new Locus(this.getChrName(), start, end);
                }
            }
            this.widthInPixels = widthInPixels;
            this.computeLocationScale();
            this.computeZoom();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setZoom(int newZoom) {
        if (this.zoom != newZoom) {
            ReferenceFrame referenceFrame = this;
            synchronized (referenceFrame) {
                this.setZoomWithinLimits(newZoom);
                this.computeLocationScale();
            }
        }
    }

    public void setOrigin(double position) {
        int windowLengthBP = (int)((double)this.widthInPixels * this.getScale());
        double newOrigin = PreferenceManager.getInstance().getAsBoolean("SAM.SHOW_SOFT_CLIPPED") ? Math.max(-1000.0, Math.min(position, (double)(this.getMaxCoordinate() + 1000 - windowLengthBP))) : Math.max(0.0, Math.min(position, (double)(this.getMaxCoordinate() - windowLengthBP)));
        this.origin = newOrigin;
    }

    protected synchronized void setZoomWithinLimits(int newZoom) {
        this.zoom = Math.max(this.minZoom, Math.min(this.maxZoom, newZoom));
        this.nTiles = Math.pow(2.0, this.zoom);
    }

    public void doZoomIncrement(int zoomIncrement) {
        double currentCenter = this.getGenomeCenterPosition();
        this.doIncrementZoom(zoomIncrement, currentCenter);
    }

    public void doSetZoom(int newZoom) {
        double currentCenter = this.getGenomeCenterPosition();
        this.doSetZoomCenter(newZoom, currentCenter);
    }

    @Subscribe
    public void receiveZoomChange(ViewChange.ZoomCause e2) {
        this.doSetZoom(e2.newZoom);
        ViewChange.Result result = new ViewChange.Result();
        result.setRecordHistory(false);
        this.getEventBus().post(result);
    }

    @Subscribe
    public void receiveDragStopped(DragStoppedEvent e2) {
        this.snapToGrid();
        this.getEventBus().post(new ViewChange.Result());
    }

    public void doIncrementZoom(int zoomIncrement, double newCenter) {
        this.doSetZoomCenter(this.getZoom() + zoomIncrement, newCenter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSetZoomCenter(int newZoom, double newCenter) {
        if (this.chrName.equals("All")) {
            this.chrName = ReferenceFrame.getGenome().getHomeChromosome();
        }
        if (this.chrName.equals("All")) {
            ReferenceFrame referenceFrame = this;
            synchronized (referenceFrame) {
                this.jumpToChromosomeForGenomeLocation(newCenter);
            }
        } else {
            this.setZoom(newZoom);
            this.centerOnLocation(newCenter);
        }
    }

    protected double getGenomeCenterPosition() {
        return this.origin + (double)(this.widthInPixels / 2) * this.getScale();
    }

    public double getScale() {
        if (this.locationScale <= 0.0) {
            this.computeLocationScale();
        }
        return this.locationScale;
    }

    public boolean setChromosomeName(String name) {
        return this.setChromosomeName(name, false);
    }

    public synchronized boolean setChromosomeName(String name, boolean force) {
        if (this.shouldChangeChromosome(name) || force) {
            this.chrName = name;
            this.origin = 0.0;
            this.locationScale = -1.0;
            this.calculateMaxZoom();
            this.zoom = -1;
            this.setZoom(0);
            return true;
        }
        return false;
    }

    protected synchronized void computeLocationScale() {
        Genome genome = ReferenceFrame.getGenome();
        if (genome != null) {
            int setEnd = -1;
            if (this.initialLocus != null) {
                setEnd = this.initialLocus.getEnd();
            }
            if (setEnd > 0 && this.widthInPixels > 0) {
                this.locationScale = ((double)setEnd - this.origin) / (double)this.widthInPixels;
                this.initialLocus = null;
            } else {
                double virtualPixelSize = this.getTilesTimesBinsPerTile();
                double nPixel = Math.max(virtualPixelSize, (double)this.widthInPixels);
                this.locationScale = (double)this.getChromosomeLength() / nPixel;
            }
        }
    }

    protected void computeZoom() {
        int newZoom = this.calculateZoom(this.getOrigin(), this.getEnd());
        this.setZoomWithinLimits(newZoom);
    }

    public void recordHistory() {
        IGV.getInstance().getSession().getHistory().push(this.getFormattedLocusString(), this.zoom);
    }

    private void jumpToChromosomeForGenomeLocation(double locationMB) {
        double startMB = 0.0;
        for (String chr : ReferenceFrame.getGenome().getLongChromosomeNames()) {
            double endMB = startMB + (double)ReferenceFrame.getGenome().getChromosome(chr).getLength() / 1000.0;
            if (locationMB > startMB && locationMB <= endMB) {
                this.setChromosomeName(chr);
                break;
            }
            startMB = endMB;
        }
    }

    public void shiftOriginPixels(int delta) {
        double shiftBP = (double)delta * this.getScale();
        this.setOrigin(this.origin + shiftBP);
        this.getEventBus().post(new ViewChange.Result());
    }

    public void snapToGrid() {
        this.setOrigin(Math.round(this.origin));
        this.getEventBus().post(new ViewChange.Result());
    }

    public void centerOnLocation(String chr, double chrLocation) {
        if (!this.chrName.equals(chr)) {
            this.setChromosomeName(chr);
        }
        this.centerOnLocation(chrLocation);
    }

    public void centerOnLocation(double chrLocation) {
        double windowWidth = (double)this.widthInPixels * this.getScale() / 2.0;
        this.setOrigin(Math.round(chrLocation - windowWidth));
        this.getEventBus().post(new ViewChange.LocusChangeResult(this.chrName, this.origin, chrLocation + windowWidth));
    }

    public boolean windowAtEnd() {
        double windowLengthBP = (double)this.widthInPixels * this.getScale();
        return this.origin + windowLengthBP + 1.0 > (double)this.getMaxCoordinate();
    }

    public void jumpTo(String chr, int start, int end) {
        Locus locus = new Locus(chr, start, end);
        this.jumpTo(locus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jumpTo(Locus locus) {
        String chr = locus.getChr();
        int start = locus.getStart();
        int end = locus.getEnd();
        Genome genome = ReferenceFrame.getGenome();
        if (chr != null && genome.getChromosome(chr) == null && !chr.contains("All")) {
            MessageUtils.showMessage(chr + " is not a valid chromosome.");
            return;
        }
        end = Math.min(ReferenceFrame.getMaxCoordinate(chr), end);
        ReferenceFrame referenceFrame = this;
        synchronized (referenceFrame) {
            this.initialLocus = locus;
            this.chrName = chr;
            if (start >= 0 && end >= 0) {
                this.origin = start;
                this.beforeScaleZoom(locus);
                this.computeLocationScale();
                this.computeZoom();
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Data panel width = " + this.widthInPixels);
            log.debug("New start = " + (int)this.origin);
            log.debug("New end = " + (int)this.getEnd());
            log.debug("New center = " + (int)this.getCenter());
            log.debug("Scale = " + this.locationScale);
        }
        this.getEventBus().post(new ViewChange.LocusChangeResult(this.chrName, start, end));
    }

    protected void beforeScaleZoom(Locus locus) {
        this.calculateMaxZoom();
    }

    protected int calculateZoom(double start, double end) {
        return (int)Math.round(Math.log((double)this.getChromosomeLength() / (end - start) * ((double)this.widthInPixels / (double)binsPerTile)) / Globals.log2);
    }

    protected static Genome getGenome() {
        return GenomeManager.getInstance().getCurrentGenome();
    }

    public double getOrigin() {
        return this.origin;
    }

    public double getCenter() {
        return this.origin + this.getScale() * (double)this.widthInPixels / 2.0;
    }

    public double getEnd() {
        return this.origin + this.getScale() * (double)this.widthInPixels;
    }

    protected double getnTiles() {
        return this.nTiles;
    }

    public int getZoom() {
        return this.zoom;
    }

    public int getMaxZoom() {
        return this.maxZoom;
    }

    public int getAdjustedZoom() {
        return this.zoom - this.minZoom;
    }

    public double getMaxPixel() {
        return this.getTilesTimesBinsPerTile();
    }

    private boolean shouldChangeChromosome(String newChrName) {
        return this.chrName == null || !this.chrName.equals(newChrName);
    }

    @Subscribe
    public void receiveChromosomeChange(ViewChange.ChromosomeChangeCause chromoChangeCause) {
        boolean changed = this.setChromosomeName(chromoChangeCause.chrName, false);
        if (changed) {
            ViewChange.ChromosomeChangeResult resultEvent = new ViewChange.ChromosomeChangeResult(chromoChangeCause.source, this.chrName);
            resultEvent.setRecordHistory(chromoChangeCause.recordHistory());
            this.getEventBus().post(resultEvent);
        }
    }

    protected void calculateMaxZoom() {
        this.maxZoom = "All".equals(this.chrName) ? 0 : (int)Math.ceil(Math.log(this.getChromosomeLength() / 40) / Globals.log2);
    }

    public String getChrName() {
        return this.chrName;
    }

    public int getWidthInPixels() {
        return this.widthInPixels;
    }

    public double getChromosomePosition(int screenPosition) {
        return this.origin + this.getScale() * (double)screenPosition;
    }

    public int getScreenPosition(double chromosomePosition) {
        return (int)((chromosomePosition - this.origin) / this.getScale());
    }

    public Chromosome getChromosome() {
        Genome genome = ReferenceFrame.getGenome();
        if (genome == null) {
            return null;
        }
        return genome.getChromosome(this.chrName);
    }

    public int getMaxCoordinate() {
        return this.getChromosomeLength();
    }

    private static int getMaxCoordinate(String chrName) {
        return ReferenceFrame.getChromosomeLength(chrName);
    }

    public int getChromosomeLength() {
        return ReferenceFrame.getChromosomeLength(this.chrName);
    }

    private static int getChromosomeLength(String chrName) {
        Genome genome = ReferenceFrame.getGenome();
        if (genome == null) {
            return 1;
        }
        if (chrName.equals("All")) {
            return (int)(genome.getNominalLength() / 1000L);
        }
        Chromosome chromosome = genome.getChromosome(chrName);
        if (chromosome == null) {
            log.error("Null chromosome: " + chrName);
            if (genome.getChromosomes().size() == 0) {
                return 1;
            }
            return genome.getChromosomes().iterator().next().getLength();
        }
        return chromosome.getLength();
    }

    public double getTilesTimesBinsPerTile() {
        return this.nTiles * (double)binsPerTile;
    }

    public int getMidpoint() {
        return this.pixelX + this.widthInPixels / 2;
    }

    public String getFormattedLocusString() {
        if (this.zoom == 0) {
            return this.getChrName();
        }
        Range range = this.getCurrentRange();
        return Locus.getFormattedLocusString(range.getChr(), range.getStart(), range.getEnd());
    }

    public Range getCurrentRange() {
        int start = 0;
        int end = this.widthInPixels;
        int startLoc = (int)this.getChromosomePosition(start) + 1;
        int endLoc = (int)this.getChromosomePosition(end);
        Range range = new Range(this.getChrName(), startLoc, endLoc);
        return range;
    }

    public void reset() {
        this.jumpTo(FrameManager.getLocus(this.name));
    }

    public String getName() {
        return this.name;
    }

    public Locus getInitialLocus() {
        return this.initialLocus;
    }

    public int getMinZoom() {
        return this.minZoom;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getStateHash() {
        return (this.chrName + this.origin + this.locationScale + this.widthInPixels).hashCode();
    }
}

