/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.tdf;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.broad.igv.tdf.BufferedByteWriter;
import org.broad.igv.tdf.TDFTile;

public class TDFFixedTile
implements TDFTile {
    int tileStart;
    double span;
    int start;
    float[][] data;

    public TDFFixedTile(ByteBuffer byteBuffer, int nSamples) throws IOException {
        this.fill(byteBuffer, nSamples);
    }

    public TDFFixedTile(int tileStart, int start, double span, float[][] data) {
        this.tileStart = tileStart;
        this.span = span;
        this.data = data;
        this.start = start;
    }

    @Override
    public int getTileStart() {
        return this.start;
    }

    public int getTileEnd() {
        return this.getSize() == 0 ? 0 : this.getEndPosition(this.getSize() - 1);
    }

    @Override
    public int getStartPosition(int idx) {
        return this.start + (int)((double)idx * this.span);
    }

    @Override
    public int getEndPosition(int idx) {
        return this.start + (int)((double)(idx + 1) * this.span);
    }

    @Override
    public String getName(int idx) {
        return null;
    }

    @Override
    public float getValue(int row, int idx) {
        return this.data[row][idx];
    }

    @Override
    public int getSize() {
        return this.data == null ? 0 : this.data[0].length;
    }

    @Override
    public void writeTo(BufferedByteWriter fos) throws IOException {
        fos.putNullTerminatedString(TDFTile.Type.fixedStep.toString());
        fos.putInt(this.getSize());
        fos.putInt(this.start);
        fos.putFloat((float)this.span);
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            for (int j2 = 0; j2 < this.data[i2].length; ++j2) {
                fos.putFloat(this.data[i2][j2]);
            }
        }
    }

    public void fill(ByteBuffer byteBuffer, int nSamples) throws IOException {
        int nPositions = byteBuffer.getInt();
        this.start = byteBuffer.getInt();
        this.span = byteBuffer.getFloat();
        this.data = new float[nSamples][nPositions];
        for (int sample = 0; sample < nSamples; ++sample) {
            this.data[sample] = new float[nPositions];
            for (int i2 = 0; i2 < nPositions; ++i2) {
                this.data[sample][i2] = byteBuffer.getFloat();
            }
        }
    }

    @Override
    public int[] getStart() {
        int nPts = this.data[0].length;
        int[] startArray = new int[nPts];
        for (int i2 = 0; i2 < nPts; ++i2) {
            startArray[i2] = this.start + (int)((double)i2 * this.span);
        }
        return startArray;
    }

    @Override
    public int[] getEnd() {
        int nPts = this.data[0].length;
        int[] endArray = new int[nPts];
        for (int i2 = 0; i2 < nPts; ++i2) {
            endArray[i2] = this.start + (int)((double)(i2 + 1) * this.span);
        }
        return endArray;
    }

    @Override
    public float[] getData(int trackNumber) {
        return this.data[trackNumber];
    }

    @Override
    public String[] getNames() {
        return null;
    }
}

