/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.DBObject;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.bson.BSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReflectionDBObject
implements DBObject {
    JavaWrapper _wrapper;
    Object _id;
    private static final Map<Class, JavaWrapper> _wrappers = Collections.synchronizedMap(new HashMap());
    private static final Set<String> IGNORE_FIELDS = new HashSet<String>();

    @Override
    public Object get(String key) {
        return this.getWrapper().get(this, key);
    }

    @Override
    public Set<String> keySet() {
        return this.getWrapper().keySet();
    }

    @Override
    @Deprecated
    public boolean containsKey(String s2) {
        return this.containsField(s2);
    }

    @Override
    public boolean containsField(String s2) {
        return this.getWrapper().containsKey(s2);
    }

    @Override
    public Object put(String key, Object v2) {
        return this.getWrapper().set(this, key, v2);
    }

    @Override
    public void putAll(Map m2) {
        for (Map.Entry entry : m2.entrySet()) {
            this.put(entry.getKey().toString(), entry.getValue());
        }
    }

    @Override
    public void putAll(BSONObject o2) {
        for (String k2 : o2.keySet()) {
            this.put(k2, o2.get(k2));
        }
    }

    public Object get_id() {
        return this._id;
    }

    public void set_id(Object id) {
        this._id = id;
    }

    @Override
    public boolean isPartialObject() {
        return false;
    }

    @Override
    public Map toMap() {
        HashMap<String, Object> m2 = new HashMap<String, Object>();
        for (String s2 : this.keySet()) {
            m2.put(s2, this.get(s2 + ""));
        }
        return m2;
    }

    @Override
    public void markAsPartialObject() {
        throw new RuntimeException("ReflectionDBObjects can't be partial");
    }

    @Override
    public Object removeField(String key) {
        throw new RuntimeException("can't remove from a ReflectionDBObject");
    }

    JavaWrapper getWrapper() {
        if (this._wrapper != null) {
            return this._wrapper;
        }
        this._wrapper = ReflectionDBObject.getWrapper(this.getClass());
        return this._wrapper;
    }

    public static JavaWrapper getWrapperIfReflectionObject(Class c2) {
        if (ReflectionDBObject.class.isAssignableFrom(c2)) {
            return ReflectionDBObject.getWrapper(c2);
        }
        return null;
    }

    public static JavaWrapper getWrapper(Class c2) {
        JavaWrapper w2 = _wrappers.get(c2);
        if (w2 == null) {
            w2 = new JavaWrapper(c2);
            _wrappers.put(c2, w2);
        }
        return w2;
    }

    static {
        IGNORE_FIELDS.add("Int");
    }

    static class FieldInfo {
        final String _name;
        final Class _class;
        Method _getter;
        Method _setter;

        FieldInfo(String name, Class c2) {
            this._name = name;
            this._class = c2;
        }

        boolean ok() {
            return this._getter != null && this._setter != null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JavaWrapper {
        final Class _class;
        final String _name;
        final Map<String, FieldInfo> _fields;
        final Set<String> _keys;

        JavaWrapper(Class c2) {
            this._class = c2;
            this._name = c2.getName();
            this._fields = new TreeMap<String, FieldInfo>();
            for (Method m2 : c2.getMethods()) {
                String name;
                if (!m2.getName().startsWith("get") && !m2.getName().startsWith("set") || (name = m2.getName().substring(3)).length() == 0 || IGNORE_FIELDS.contains(name)) continue;
                Class<?> type = m2.getName().startsWith("get") ? m2.getReturnType() : m2.getParameterTypes()[0];
                FieldInfo fi = this._fields.get(name);
                if (fi == null) {
                    fi = new FieldInfo(name, type);
                    this._fields.put(name, fi);
                }
                if (m2.getName().startsWith("get")) {
                    fi._getter = m2;
                    continue;
                }
                fi._setter = m2;
            }
            HashSet<String> names = new HashSet<String>(this._fields.keySet());
            for (String name : names) {
                if (this._fields.get(name).ok()) continue;
                this._fields.remove(name);
            }
            this._keys = Collections.unmodifiableSet(this._fields.keySet());
        }

        public Set<String> keySet() {
            return this._keys;
        }

        @Deprecated
        public boolean containsKey(String key) {
            return this._keys.contains(key);
        }

        public Object get(ReflectionDBObject t2, String name) {
            FieldInfo i2 = this._fields.get(name);
            if (i2 == null) {
                return null;
            }
            try {
                return i2._getter.invoke((Object)t2, new Object[0]);
            }
            catch (Exception e2) {
                throw new RuntimeException("could not invoke getter for [" + name + "] on [" + this._name + "]", e2);
            }
        }

        public Object set(ReflectionDBObject t2, String name, Object val) {
            FieldInfo i2 = this._fields.get(name);
            if (i2 == null) {
                throw new IllegalArgumentException("no field [" + name + "] on [" + this._name + "]");
            }
            try {
                return i2._setter.invoke((Object)t2, val);
            }
            catch (Exception e2) {
                throw new RuntimeException("could not invoke setter for [" + name + "] on [" + this._name + "]", e2);
            }
        }

        Class getInternalClass(String path) {
            FieldInfo fi;
            String cur = path;
            String next = null;
            int idx = path.indexOf(".");
            if (idx >= 0) {
                cur = path.substring(0, idx);
                next = path.substring(idx + 1);
            }
            if ((fi = this._fields.get(cur)) == null) {
                return null;
            }
            if (next == null) {
                return fi._class;
            }
            JavaWrapper w2 = ReflectionDBObject.getWrapperIfReflectionObject(fi._class);
            if (w2 == null) {
                return null;
            }
            return w2.getInternalClass(next);
        }
    }
}

