/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.popup.JidePopup;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.Resource;
import com.jidesoft.swing.SearchableProvider;
import com.jidesoft.swing.SearchableUtils;
import com.jidesoft.swing.event.SearchableEvent;
import com.jidesoft.swing.event.SearchableListener;
import com.jidesoft.utils.DefaultWildcardSupport;
import com.jidesoft.utils.WildcardSupport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Searchable {
    private final PropertyChangeSupport _propertyChangeSupport = new PropertyChangeSupport(this);
    protected final JComponent _component;
    private SearchPopup _popup;
    private JLayeredPane _layeredPane;
    private boolean _heavyweightComponentEnabled;
    private SearchableProvider _searchableProvider;
    private Pattern _pattern;
    private String _searchText;
    private String _previousSearchText;
    private boolean _fromStart = true;
    private boolean _caseSensitive = false;
    private boolean _repeats = false;
    private boolean _wildcardEnabled = true;
    private boolean _countMatch;
    protected int _matchCount;
    private WildcardSupport _wildcardSupport = null;
    private Color _mismatchForeground;
    private Color _foreground = null;
    private Color _background = null;
    protected ComponentListener _componentListener;
    protected KeyListener _keyListener;
    protected FocusListener _focusListener;
    private SearchableListener _searchableListener;
    public static final String PROPERTY_SEARCH_TEXT = "searchText";
    private int _cursor = -1;
    private String _searchLabel = null;
    private int _popupLocation = 1;
    private int _searchingDelay = 0;
    private int _popupTimeout = 0;
    private Timer _popupTimer;
    private boolean _reverseOrder = false;
    protected EventListenerList listenerList = new EventListenerList();
    private Component _popupLocationRelativeTo;
    public static final String CLIENT_PROPERTY_SEARCHABLE = "Searchable";
    private Set<Integer> _selection;
    private boolean _processModelChangeEvent = true;
    private boolean _hideSearchPopupOnEvent = true;

    public Searchable(JComponent component) {
        Searchable searchable = Searchable.getSearchable(component);
        if (searchable != null) {
            SearchableUtils.uninstallSearchable(searchable);
        }
        this._previousSearchText = null;
        this._component = component;
        this._selection = new HashSet<Integer>();
        this.installListeners();
        this.updateClientProperty(this._component, this);
    }

    public Searchable(JComponent component, SearchableProvider searchableProvider) {
        Searchable searchable = Searchable.getSearchable(component);
        if (searchable != null) {
            SearchableUtils.uninstallSearchable(searchable);
        }
        this._searchableProvider = searchableProvider;
        this._previousSearchText = null;
        this._component = component;
        this._selection = new HashSet<Integer>();
        this.installListeners();
        this.updateClientProperty(this._component, this);
    }

    protected abstract int getSelectedIndex();

    protected abstract void setSelectedIndex(int var1, boolean var2);

    public void adjustSelectedIndex(int index, boolean incremental) {
        this.setSelectedIndex(index, incremental);
    }

    protected abstract int getElementCount();

    protected abstract Object getElementAt(int var1);

    protected abstract String convertElementToString(Object var1);

    public String convertToString(Object element) {
        return this.convertElementToString(element);
    }

    public boolean isHideSearchPopupOnEvent() {
        return this._hideSearchPopupOnEvent;
    }

    public void setHideSearchPopupOnEvent(boolean hideSearchPopupOnEvent) {
        this._hideSearchPopupOnEvent = hideSearchPopupOnEvent;
    }

    public void hidePopup() {
        if (this._popup != null) {
            if (this.isHeavyweightComponentEnabled()) {
                this._popup.hidePopupImmediately();
            } else if (this._layeredPane != null) {
                this._layeredPane.remove(this._popup);
                this._layeredPane.validate();
                this._layeredPane.repaint();
                this._layeredPane = null;
            }
            this._popup = null;
            this._searchableProvider = null;
            this.fireSearchableEvent(new SearchableEvent(this, 3000, "", this.getCurrentIndex(), this._previousSearchText));
        }
        this.setCursor(-1);
    }

    public SearchableProvider getSearchableProvider() {
        return this._searchableProvider;
    }

    public void setSearchableProvider(SearchableProvider searchableProvider) {
        this._searchableProvider = searchableProvider;
    }

    public void installListeners() {
        if (this._componentListener == null) {
            this._componentListener = this.createComponentListener();
        }
        this._component.addComponentListener(this._componentListener);
        Component scrollPane = JideSwingUtilities.getScrollPane(this._component);
        if (scrollPane != null) {
            scrollPane.addComponentListener(this._componentListener);
        }
        if (this._keyListener == null) {
            this._keyListener = this.createKeyListener();
        }
        JideSwingUtilities.insertKeyListener(this.getComponent(), this._keyListener, 0);
        if (this._focusListener == null) {
            this._focusListener = this.createFocusListener();
        }
        this.getComponent().addFocusListener(this._focusListener);
        if (this._searchableListener == null) {
            this._searchableListener = new SearchableListener(){

                public void searchableEventFired(SearchableEvent e2) {
                    if (e2.getID() == 2999) {
                        if (Searchable.this.getPopupTimeout() > 0) {
                            Searchable.this._popupTimer = new Timer(Searchable.this.getPopupTimeout(), new ActionListener(){

                                public void actionPerformed(ActionEvent e2) {
                                    if (Searchable.this.isPopupVisible()) {
                                        Searchable.this.hidePopup();
                                    }
                                }
                            });
                            Searchable.this._popupTimer.setRepeats(false);
                            Searchable.this._popupTimer.start();
                        }
                    } else if (Searchable.this._popupTimer != null) {
                        if (e2.getID() == 3000) {
                            Searchable.this._popupTimer.stop();
                        } else {
                            Searchable.this._popupTimer.restart();
                        }
                    }
                }
            };
        }
        this.addSearchableListener(this._searchableListener);
    }

    protected ComponentListener createComponentListener() {
        return new ComponentAdapter(){

            public void componentHidden(ComponentEvent e2) {
                boolean passive;
                super.componentHidden(e2);
                boolean bl = passive = Searchable.this._searchableProvider == null || Searchable.this._searchableProvider.isPassive();
                if (passive) {
                    Searchable.this.hidePopup();
                }
            }

            public void componentResized(ComponentEvent e2) {
                boolean passive;
                super.componentResized(e2);
                boolean bl = passive = Searchable.this._searchableProvider == null || Searchable.this._searchableProvider.isPassive();
                if (passive) {
                    Searchable.this.updateSizeAndLocation();
                }
            }

            public void componentMoved(ComponentEvent e2) {
                boolean passive;
                super.componentMoved(e2);
                boolean bl = passive = Searchable.this._searchableProvider == null || Searchable.this._searchableProvider.isPassive();
                if (passive) {
                    Searchable.this.updateSizeAndLocation();
                }
            }
        };
    }

    protected KeyListener createKeyListener() {
        return new KeyAdapter(){

            public void keyTyped(KeyEvent e2) {
                boolean passive;
                boolean bl = passive = Searchable.this._searchableProvider == null || Searchable.this._searchableProvider.isPassive();
                if (passive) {
                    Searchable.this.keyTypedOrPressed(e2);
                }
            }

            public void keyPressed(KeyEvent e2) {
                boolean passive;
                boolean bl = passive = Searchable.this._searchableProvider == null || Searchable.this._searchableProvider.isPassive();
                if (passive) {
                    Searchable.this.keyTypedOrPressed(e2);
                }
            }
        };
    }

    protected FocusListener createFocusListener() {
        return new FocusAdapter(){

            public void focusLost(FocusEvent focusevent) {
                boolean passive;
                boolean bl = passive = Searchable.this._searchableProvider == null || Searchable.this._searchableProvider.isPassive();
                if (passive) {
                    Searchable.this.hidePopup();
                }
            }
        };
    }

    public void uninstallListeners() {
        if (this._componentListener != null) {
            this.getComponent().removeComponentListener(this._componentListener);
            Component scrollPane = JideSwingUtilities.getScrollPane(this.getComponent());
            if (scrollPane != null) {
                scrollPane.removeComponentListener(this._componentListener);
            }
            this._componentListener = null;
        }
        if (this._keyListener != null) {
            this.getComponent().removeKeyListener(this._keyListener);
            this._keyListener = null;
        }
        if (this._focusListener != null) {
            this.getComponent().removeFocusListener(this._focusListener);
            this._focusListener = null;
        }
        if (this._searchableListener != null) {
            this.removeSearchableListener(this._searchableListener);
            this._searchableListener = null;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertychangelistener) {
        this._propertyChangeSupport.addPropertyChangeListener(propertychangelistener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertychangelistener) {
        this._propertyChangeSupport.removePropertyChangeListener(propertychangelistener);
    }

    public void firePropertyChangeEvent(String searchingText) {
        if (!searchingText.equals(this._previousSearchText)) {
            this._propertyChangeSupport.firePropertyChange(PROPERTY_SEARCH_TEXT, this._previousSearchText, searchingText);
            this.fireSearchableEvent(new SearchableEvent(this, 3004, searchingText, this.getCurrentIndex(), this._previousSearchText));
            this._previousSearchText = searchingText;
            if (searchingText.length() == 0) {
                this.searchingTextEmpty();
            }
        }
    }

    protected void searchingTextEmpty() {
    }

    protected boolean compare(Object element, String searchingText) {
        String text = this.convertElementToString(element);
        return text != null && this.compare(this.isCaseSensitive() ? text : text.toLowerCase(), searchingText);
    }

    protected boolean compare(String text, String searchingText) {
        if (searchingText == null || searchingText.trim().length() == 0) {
            return true;
        }
        if (!this.isWildcardEnabled()) {
            return searchingText != null && (searchingText.equals(text) || searchingText.length() > 0 && (this.isFromStart() ? text.startsWith(searchingText) : text.indexOf(searchingText) != -1));
        }
        if (this._searchText != null && this._searchText.equals(searchingText) && this._pattern != null) {
            return this._pattern.matcher(text).find();
        }
        WildcardSupport wildcardSupport = this.getWildcardSupport();
        String s2 = wildcardSupport.convert(searchingText);
        if (searchingText.equals(s2)) {
            return this.isFromStart() ? text.startsWith(searchingText) : text.indexOf(searchingText) != -1;
        }
        this._searchText = searchingText;
        try {
            this._pattern = Pattern.compile(this.isFromStart() ? "^" + s2 : s2, this.isCaseSensitive() ? 0 : 2);
            return this._pattern.matcher(text).find();
        }
        catch (PatternSyntaxException e2) {
            return false;
        }
    }

    public int getCursor() {
        return this._cursor;
    }

    public void setCursor(int cursor) {
        this.setCursor(cursor, false);
    }

    public void setCursor(int cursor, boolean incremental) {
        if (!incremental || this._cursor < 0) {
            this._selection.clear();
        }
        if (this._cursor >= 0) {
            this._selection.add(cursor);
        }
        this._cursor = cursor;
    }

    protected void highlightAll() {
        int firstIndex = -1;
        int index = this.getSelectedIndex();
        String text = this.getSearchingText();
        while (index != -1) {
            int newIndex = this.findNext(text);
            if ((index = index == newIndex ? -1 : newIndex) == -1) continue;
            if (firstIndex == -1) {
                firstIndex = index;
            }
            this.select(index, text);
        }
        if (firstIndex != -1) {
            this.select(firstIndex, text);
        }
    }

    protected void cancelHighlightAll() {
    }

    protected void select(int index, String searchingText) {
        if (index != -1) {
            this.setSelectedIndex(index, true);
            this.setCursor(index, true);
            Object element = this.getElementAt(index);
            this.fireSearchableEvent(new SearchableEvent(this, 3002, searchingText, element, this.convertElementToString(element)));
        } else {
            this.setSelectedIndex(-1, false);
            this.fireSearchableEvent(new SearchableEvent(this, 3003, searchingText));
        }
    }

    public int findNext(String s2) {
        Object element;
        int i2;
        String str = this.isCaseSensitive() ? s2 : s2.toLowerCase();
        int count = this.getElementCount();
        if (count == 0) {
            return s2.length() > 0 ? -1 : 0;
        }
        int selectedIndex = this.getCurrentIndex();
        for (i2 = selectedIndex + 1; i2 < count; ++i2) {
            element = this.getElementAt(i2);
            if (!this.compare(element, str)) continue;
            return i2;
        }
        if (this.isRepeats()) {
            for (i2 = 0; i2 < selectedIndex; ++i2) {
                element = this.getElementAt(i2);
                if (!this.compare(element, str)) continue;
                return i2;
            }
        }
        return selectedIndex == -1 ? -1 : (this.compare(this.getElementAt(selectedIndex), str) ? selectedIndex : -1);
    }

    protected int getCurrentIndex() {
        if (this._selection.contains(this.getSelectedIndex())) {
            return this._cursor != -1 ? this._cursor : this.getSelectedIndex();
        }
        this._selection.clear();
        return this.getSelectedIndex();
    }

    public int findPrevious(String s2) {
        Object element;
        int i2;
        String str = this.isCaseSensitive() ? s2 : s2.toLowerCase();
        int count = this.getElementCount();
        if (count == 0) {
            return s2.length() > 0 ? -1 : 0;
        }
        int selectedIndex = this.getCurrentIndex();
        for (i2 = selectedIndex - 1; i2 >= 0; --i2) {
            element = this.getElementAt(i2);
            if (!this.compare(element, str)) continue;
            return i2;
        }
        if (this.isRepeats()) {
            for (i2 = count - 1; i2 >= selectedIndex; --i2) {
                element = this.getElementAt(i2);
                if (!this.compare(element, str)) continue;
                return i2;
            }
        }
        return selectedIndex == -1 ? -1 : (this.compare(this.getElementAt(selectedIndex), str) ? selectedIndex : -1);
    }

    public int findFromCursor(String s2) {
        Object element;
        int i2;
        int count;
        int selectedIndex;
        if (this.isCountMatch()) {
            int oldIndex;
            boolean reverse = this.isReverseOrder();
            this.setReverseOrder(false);
            selectedIndex = this.getCurrentIndex();
            if (selectedIndex < 0) {
                selectedIndex = 0;
            }
            int newIndex = -1;
            this._matchCount = -1;
            do {
                this.setSelectedIndex(newIndex, false);
                oldIndex = newIndex;
                newIndex = this.findNext(s2);
                ++this._matchCount;
            } while (newIndex > oldIndex);
            this.setSelectedIndex(selectedIndex, false);
            this.setReverseOrder(reverse);
        }
        if (this.isReverseOrder()) {
            return this.reverseFindFromCursor(s2);
        }
        String str = this.isCaseSensitive() ? s2 : s2.toLowerCase();
        selectedIndex = this.getCurrentIndex();
        if (selectedIndex < 0) {
            selectedIndex = 0;
        }
        if ((count = this.getElementCount()) == 0) {
            return -1;
        }
        for (i2 = selectedIndex; i2 < count; ++i2) {
            element = this.getElementAt(i2);
            if (!this.compare(element, str)) continue;
            return i2;
        }
        for (i2 = 0; i2 < selectedIndex; ++i2) {
            element = this.getElementAt(i2);
            if (!this.compare(element, str)) continue;
            return i2;
        }
        return -1;
    }

    public int reverseFindFromCursor(String s2) {
        Object element;
        int i2;
        int count;
        if (!this.isReverseOrder()) {
            return this.findFromCursor(s2);
        }
        String str = this.isCaseSensitive() ? s2 : s2.toLowerCase();
        int selectedIndex = this.getCurrentIndex();
        if (selectedIndex < 0) {
            selectedIndex = 0;
        }
        if ((count = this.getElementCount()) == 0) {
            return -1;
        }
        for (i2 = selectedIndex; i2 >= 0; --i2) {
            element = this.getElementAt(i2);
            if (!this.compare(element, str)) continue;
            return i2;
        }
        for (i2 = count - 1; i2 >= selectedIndex; --i2) {
            element = this.getElementAt(i2);
            if (!this.compare(element, str)) continue;
            return i2;
        }
        return -1;
    }

    public int findFirst(String s2) {
        String str = this.isCaseSensitive() ? s2 : s2.toLowerCase();
        int count = this.getElementCount();
        if (count == 0) {
            return s2.length() > 0 ? -1 : 0;
        }
        for (int i2 = 0; i2 < count; ++i2) {
            int index = this.getIndex(count, i2);
            Object element = this.getElementAt(index);
            if (!this.compare(element, str)) continue;
            return index;
        }
        return -1;
    }

    public int findLast(String s2) {
        String str = this.isCaseSensitive() ? s2 : s2.toLowerCase();
        int count = this.getElementCount();
        if (count == 0) {
            return s2.length() > 0 ? -1 : 0;
        }
        for (int i2 = count - 1; i2 >= 0; --i2) {
            Object element = this.getElementAt(i2);
            if (!this.compare(element, str)) continue;
            return i2;
        }
        return -1;
    }

    protected void keyTypedOrPressed(KeyEvent e2) {
        if (this._searchableProvider != null && this._searchableProvider.isPassive()) {
            this._searchableProvider.processKeyEvent(e2);
            return;
        }
        if (this.isActivateKey(e2)) {
            String searchingText = "";
            if (e2.getID() == 400) {
                if (JideSwingUtilities.isMenuShortcutKeyDown(e2)) {
                    return;
                }
                if (e2.isAltDown()) {
                    return;
                }
                searchingText = String.valueOf(e2.getKeyChar());
            }
            this.showPopup(searchingText);
            if (e2.getKeyCode() != 10) {
                e2.consume();
            }
        }
    }

    private int getIndex(int count, int index) {
        return this.isReverseOrder() ? count - index - 1 : index;
    }

    public void showPopup(String searchingText) {
        if (this._searchableProvider == null) {
            this.fireSearchableEvent(new SearchableEvent(this, 2999, searchingText));
            this.showPopup(this.createSearchPopup(searchingText));
            this._searchableProvider = new SearchableProvider(){

                public String getSearchingText() {
                    return Searchable.this._popup != null ? Searchable.this._popup.getSearchingText() : "";
                }

                public boolean isPassive() {
                    return true;
                }

                public void processKeyEvent(KeyEvent e2) {
                    if (Searchable.this._popup != null) {
                        Searchable.this._popup.processKeyEvent(e2);
                    }
                }
            };
        }
    }

    protected SearchPopup createSearchPopup(String searchingText) {
        return new DefaultSearchPopup(searchingText);
    }

    public String getSearchingText() {
        return this._searchableProvider != null ? this._searchableProvider.getSearchingText() : "";
    }

    private void showPopup(SearchPopup searchpopup) {
        JRootPane rootPane = this._component.getRootPane();
        this._layeredPane = rootPane != null ? rootPane.getLayeredPane() : null;
        if (this._layeredPane == null || this.isHeavyweightComponentEnabled()) {
            this._popup = searchpopup;
            Point location = this.updateSizeAndLocation();
            if (location != null) {
                searchpopup.showPopup(location.x, location.y);
                this._popup.setVisible(true);
            } else {
                this._popup = null;
            }
        } else {
            if (this._popup != null && this._layeredPane != null) {
                this._layeredPane.remove(this._popup);
                this._layeredPane.validate();
                this._layeredPane.repaint();
                this._layeredPane = null;
            } else {
                this._popup = !this._component.isShowing() ? null : searchpopup;
            }
            if (this._popup == null || !this._component.isDisplayable()) {
                return;
            }
            if (this._layeredPane == null) {
                System.err.println("Failed to find layeredPane.");
                return;
            }
            this._layeredPane.add((Component)this._popup, JLayeredPane.POPUP_LAYER);
            this.updateSizeAndLocation();
            this._popup.setVisible(true);
            this._popup.validate();
        }
    }

    private Point updateSizeAndLocation() {
        Component component = this.getPopupLocationRelativeTo();
        if (component == null) {
            component = JideSwingUtilities.getScrollPane(this._component);
        }
        if (component == null) {
            component = this._component;
        }
        if (this._popup != null) {
            Point componentLocation;
            Dimension size = this._popup.getPreferredSize();
            switch (this.getPopupLocation()) {
                case 3: {
                    try {
                        componentLocation = component.getLocationOnScreen();
                        componentLocation.y += component.getHeight();
                        if (this.isHeavyweightComponentEnabled()) break;
                        SwingUtilities.convertPointFromScreen(componentLocation, this._layeredPane);
                        if (componentLocation.y + size.height <= this._layeredPane.getHeight()) break;
                        componentLocation.y = this._layeredPane.getHeight() - size.height;
                        break;
                    }
                    catch (IllegalComponentStateException e2) {
                        return null;
                    }
                }
                default: {
                    try {
                        componentLocation = component.getLocationOnScreen();
                        if (!this.isHeavyweightComponentEnabled()) {
                            SwingUtilities.convertPointFromScreen(componentLocation, this._layeredPane);
                        }
                        componentLocation.y -= size.height;
                        if (componentLocation.y >= 0) break;
                        componentLocation.y = 0;
                        break;
                    }
                    catch (IllegalComponentStateException e3) {
                        return null;
                    }
                }
            }
            if (!this.isHeavyweightComponentEnabled()) {
                this._popup.setLocation(componentLocation);
                this._popup.setSize(size);
            } else {
                this._popup.packPopup();
            }
            return componentLocation;
        }
        return null;
    }

    protected boolean isFindFirstKey(KeyEvent e2) {
        return e2.getKeyCode() == 36;
    }

    protected boolean isFindLastKey(KeyEvent e2) {
        return e2.getKeyCode() == 35;
    }

    protected boolean isFindPreviousKey(KeyEvent e2) {
        return e2.getKeyCode() == 38;
    }

    protected boolean isFindNextKey(KeyEvent e2) {
        return e2.getKeyCode() == 40;
    }

    protected boolean isNavigationKey(KeyEvent e2) {
        return this.isFindFirstKey(e2) || this.isFindLastKey(e2) || this.isFindNextKey(e2) || this.isFindPreviousKey(e2);
    }

    protected boolean isActivateKey(KeyEvent e2) {
        char keyChar = e2.getKeyChar();
        return e2.getID() == 400 && keyChar > ' ' && keyChar != '\u007f';
    }

    protected boolean isDeactivateKey(KeyEvent e2) {
        int keyCode = e2.getKeyCode();
        return keyCode == 10 || keyCode == 27 || keyCode == 33 || keyCode == 34 || keyCode == 36 || keyCode == 35 || keyCode == 37 || keyCode == 39 || keyCode == 38 || keyCode == 40;
    }

    protected boolean isSelectAllKey(KeyEvent e2) {
        return JideSwingUtilities.isMenuShortcutKeyDown(e2) && e2.getKeyCode() == 65;
    }

    protected boolean isIncrementalSelectKey(KeyEvent e2) {
        return JideSwingUtilities.isMenuShortcutKeyDown(e2);
    }

    public Color getMismatchForeground() {
        if (this._mismatchForeground == null) {
            return Color.RED;
        }
        return this._mismatchForeground;
    }

    public void setMismatchForeground(Color mismatchForeground) {
        this._mismatchForeground = mismatchForeground;
    }

    public boolean isCaseSensitive() {
        return this._caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this._caseSensitive = caseSensitive;
    }

    public int getSearchingDelay() {
        return this._searchingDelay;
    }

    public void setSearchingDelay(int searchingDelay) {
        this._searchingDelay = searchingDelay;
    }

    public boolean isRepeats() {
        return this._repeats;
    }

    public void setRepeats(boolean repeats) {
        this._repeats = repeats;
    }

    public Color getForeground() {
        if (this._foreground == null) {
            return UIDefaultsLookup.getColor("ToolTip.foreground");
        }
        return this._foreground;
    }

    public void setForeground(Color foreground) {
        this._foreground = foreground;
    }

    public Color getBackground() {
        if (this._background == null) {
            return UIDefaultsLookup.getColor("ToolTip.background");
        }
        return this._background;
    }

    public void setBackground(Color background) {
        this._background = background;
    }

    public boolean isWildcardEnabled() {
        return this._wildcardEnabled;
    }

    public void setWildcardEnabled(boolean wildcardEnabled) {
        this._wildcardEnabled = wildcardEnabled;
    }

    public WildcardSupport getWildcardSupport() {
        if (this._wildcardSupport == null) {
            this._wildcardSupport = new DefaultWildcardSupport();
        }
        return this._wildcardSupport;
    }

    public void setWildcardSupport(WildcardSupport wildcardSupport) {
        this._wildcardSupport = wildcardSupport;
    }

    public String getSearchLabel() {
        if (this._searchLabel == null) {
            return this.getResourceString("Searchable.searchFor");
        }
        return this._searchLabel;
    }

    public void setSearchLabel(String searchLabel) {
        this._searchLabel = searchLabel;
    }

    public void addSearchableListener(SearchableListener l2) {
        this.listenerList.add(SearchableListener.class, l2);
    }

    public void removeSearchableListener(SearchableListener l2) {
        this.listenerList.remove(SearchableListener.class, l2);
    }

    public SearchableListener[] getSearchableListeners() {
        return (SearchableListener[])this.listenerList.getListeners(SearchableListener.class);
    }

    public boolean isSearchableListenerInstalled(SearchableListener l2) {
        SearchableListener[] listeners;
        for (SearchableListener listener : listeners = this.getSearchableListeners()) {
            if (listener != l2) continue;
            return true;
        }
        return false;
    }

    protected void fireSearchableEvent(SearchableEvent e2) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i2 = listeners.length - 2; i2 >= 0; i2 -= 2) {
            if (listeners[i2] != SearchableListener.class) continue;
            ((SearchableListener)listeners[i2 + 1]).searchableEventFired(e2);
        }
    }

    public Component getComponent() {
        return this._component;
    }

    public int getPopupLocation() {
        return this._popupLocation;
    }

    public void setPopupLocation(int popupLocation) {
        this._popupLocation = popupLocation;
    }

    public boolean isReverseOrder() {
        return this._reverseOrder;
    }

    public void setReverseOrder(boolean reverseOrder) {
        this._reverseOrder = reverseOrder;
    }

    protected String getResourceString(String key) {
        return Resource.getResourceBundle(this._component != null ? this._component.getLocale() : Locale.getDefault()).getString(key);
    }

    public boolean isPopupVisible() {
        return this._popup != null;
    }

    public boolean isHeavyweightComponentEnabled() {
        return this._heavyweightComponentEnabled;
    }

    public void setHeavyweightComponentEnabled(boolean heavyweightComponentEnabled) {
        this._heavyweightComponentEnabled = heavyweightComponentEnabled;
    }

    public Component getPopupLocationRelativeTo() {
        return this._popupLocationRelativeTo;
    }

    public void setPopupLocationRelativeTo(Component popupLocationRelativeTo) {
        this._popupLocationRelativeTo = popupLocationRelativeTo;
    }

    public boolean isFromStart() {
        return this._fromStart;
    }

    public void setFromStart(boolean fromStart) {
        this.hidePopup();
        this._fromStart = fromStart;
    }

    public static Searchable getSearchable(JComponent component) {
        Object clientProperty = component.getClientProperty(CLIENT_PROPERTY_SEARCHABLE);
        if (clientProperty instanceof Searchable) {
            return (Searchable)clientProperty;
        }
        return null;
    }

    private void updateClientProperty(JComponent component, Searchable searchable) {
        if (component != null) {
            Object clientProperty = this._component.getClientProperty(CLIENT_PROPERTY_SEARCHABLE);
            if (clientProperty instanceof Searchable) {
                ((Searchable)clientProperty).uninstallListeners();
            }
            component.putClientProperty(CLIENT_PROPERTY_SEARCHABLE, searchable);
        }
    }

    public boolean isProcessModelChangeEvent() {
        return this._processModelChangeEvent;
    }

    public void setProcessModelChangeEvent(boolean processModelChangeEvent) {
        this._processModelChangeEvent = processModelChangeEvent;
    }

    public int getPopupTimeout() {
        return this._popupTimeout;
    }

    public void setPopupTimeout(int popupTimeout) {
        this._popupTimeout = popupTimeout;
    }

    public boolean isCountMatch() {
        return this._countMatch;
    }

    public void setCountMatch(boolean countMatch) {
        this._countMatch = countMatch;
    }

    int getMatchCount() {
        return this._matchCount;
    }

    public List<Integer> findAll(String s2) {
        String str = this.isCaseSensitive() ? s2 : s2.toLowerCase();
        ArrayList<Integer> list = new ArrayList<Integer>();
        int count = this.getElementCount();
        for (int i2 = 0; i2 < count; ++i2) {
            Object elementAt = this.getElementAt(i2);
            if (!this.compare(elementAt, str)) continue;
            list.add(i2);
        }
        return list;
    }

    public String getElementAtAsString(int index) {
        return this.convertElementToString(this.getElementAt(index));
    }

    protected void textChanged(String text) {
        if (text == null || text.length() == 0) {
            this.firePropertyChangeEvent("");
            return;
        }
        int found = this.findFromCursor(text);
        if (found == -1) {
            this.firePropertyChangeEvent(text);
            this.fireSearchableEvent(new SearchableEvent(this, 3003, text));
        } else {
            this.firePropertyChangeEvent(text);
            Object element = this.getElementAt(found);
            this.fireSearchableEvent(new SearchableEvent(this, 3002, text, element, this.convertElementToString(element)));
        }
    }

    public abstract class SearchPopup
    extends JidePopup {
        protected SearchField _textField;

        public void processKeyEvent(KeyEvent e2) {
            this._textField.processKeyEvent(e2);
            if (e2.isConsumed()) {
                String text = this.getSearchingText();
                if (text.length() == 0) {
                    return;
                }
                if (Searchable.this.isSelectAllKey(e2)) {
                    this.selectAll(e2, text);
                    return;
                }
                if (Searchable.this.isFindPreviousKey(e2)) {
                    int found = Searchable.this.findPrevious(text);
                    this.select(found, e2, text);
                } else if (Searchable.this.isFindNextKey(e2)) {
                    int found = Searchable.this.findNext(text);
                    this.select(found, e2, text);
                } else if (Searchable.this.isFindFirstKey(e2)) {
                    int found = Searchable.this.findFirst(text);
                    this.select(found, e2, text);
                } else if (Searchable.this.isFindLastKey(e2)) {
                    int found = Searchable.this.findLast(text);
                    this.select(found, e2, text);
                }
            }
            if (e2.getKeyCode() != 10) {
                e2.consume();
            }
        }

        private void selectAll(KeyEvent e2, String text) {
            int newIndex;
            boolean oldRepeats;
            int index;
            boolean oldReverseOrder = Searchable.this.isReverseOrder();
            if (oldReverseOrder) {
                Searchable.this.setReverseOrder(false);
            }
            if ((index = Searchable.this.findFirst(text)) != -1) {
                Searchable.this.setSelectedIndex(index, false);
                Searchable.this.setCursor(index);
            }
            if (oldRepeats = Searchable.this.isRepeats()) {
                Searchable.this.setRepeats(false);
            }
            while (index != -1 && (index = index == (newIndex = Searchable.this.findNext(text)) ? -1 : newIndex) != -1) {
                this.select(index, e2, text);
            }
            if (oldRepeats) {
                Searchable.this.setRepeats(oldRepeats);
            }
            if (oldReverseOrder) {
                Searchable.this.setReverseOrder(oldReverseOrder);
            }
        }

        public String getSearchingText() {
            return this._textField != null ? this._textField.getText() : "";
        }

        protected abstract void select(int var1, KeyEvent var2, String var3);
    }

    private class DefaultSearchPopup
    extends SearchPopup {
        private JLabel _label;
        private JLabel _noMatch;

        public DefaultSearchPopup(String text) {
            this.initComponents(text);
        }

        private void initComponents(String text) {
            final Color foreground = Searchable.this.getForeground();
            Color background = Searchable.this.getBackground();
            this._label = new JLabel(Searchable.this.getSearchLabel());
            this._label.setForeground(foreground);
            this._label.setVerticalAlignment(3);
            this._noMatch = new JLabel();
            this._noMatch.setForeground(Searchable.this.getMismatchForeground());
            this._noMatch.setVerticalAlignment(3);
            this._textField = new SearchField();
            this._textField.setFocusable(false);
            this._textField.setBorder(BorderFactory.createEmptyBorder());
            this._textField.setForeground(foreground);
            this._textField.setCursor(this.getCursor());
            this._textField.getDocument().addDocumentListener(new DocumentListener(){
                private Timer timer = new Timer(200, new ActionListener(){

                    public void actionPerformed(ActionEvent e2) {
                        this.applyText();
                    }
                });

                public void insertUpdate(DocumentEvent e2) {
                    this.startTimer();
                }

                public void removeUpdate(DocumentEvent e2) {
                    this.startTimer();
                }

                public void changedUpdate(DocumentEvent e2) {
                    this.startTimer();
                }

                protected void applyText() {
                    String text = DefaultSearchPopup.this._textField.getText().trim();
                    Searchable.this.firePropertyChangeEvent(text);
                    if (text.length() != 0) {
                        int found = Searchable.this.findFromCursor(text);
                        if (found == -1) {
                            DefaultSearchPopup.this._textField.setForeground(Searchable.this.getMismatchForeground());
                        } else {
                            DefaultSearchPopup.this._textField.setForeground(foreground);
                        }
                        DefaultSearchPopup.this.select(found, null, text);
                    } else {
                        DefaultSearchPopup.this._textField.setForeground(foreground);
                        DefaultSearchPopup.this._noMatch.setText("");
                        DefaultSearchPopup.this.updatePopupBounds();
                        DefaultSearchPopup.this.hidePopup();
                    }
                }

                void startTimer() {
                    DefaultSearchPopup.this.updatePopupBounds();
                    if (Searchable.this.getSearchingDelay() > 0) {
                        this.timer.setInitialDelay(Searchable.this.getSearchingDelay());
                        if (this.timer.isRunning()) {
                            this.timer.restart();
                        } else {
                            this.timer.setRepeats(false);
                            this.timer.start();
                        }
                    } else {
                        this.applyText();
                    }
                }
            });
            this._textField.setText(text);
            this.setBackground(background);
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIDefaultsLookup.getColor("controlShadow"), 1), BorderFactory.createEmptyBorder(0, 6, 1, 8)));
            this.setLayout(new BorderLayout(2, 0));
            Dimension size = this._label.getPreferredSize();
            size.height = this._textField.getPreferredSize().height;
            this._label.setPreferredSize(size);
            this.add((Component)this._label, "Before");
            this.add((Component)this._textField, "Center");
            this.add((Component)this._noMatch, "After");
            this.setPopupBorder(BorderFactory.createEmptyBorder());
        }

        protected void select(int index, KeyEvent e2, String searchingText) {
            if (index != -1) {
                boolean incremental = e2 != null && Searchable.this.isIncrementalSelectKey(e2);
                Searchable.this.setSelectedIndex(index, incremental);
                Searchable.this.setCursor(index, incremental);
                this._textField.setForeground(this.getForeground());
                this._noMatch.setText("");
            } else {
                this._textField.setForeground(Searchable.this.getMismatchForeground());
                this._noMatch.setText(Searchable.this.getResourceString("Searchable.noMatch"));
            }
            this.updatePopupBounds();
            if (index != -1) {
                Object element = Searchable.this.getElementAt(index);
                Searchable.this.fireSearchableEvent(new SearchableEvent(Searchable.this, 3002, searchingText, element, Searchable.this.convertElementToString(element)));
            } else {
                Searchable.this.fireSearchableEvent(new SearchableEvent(Searchable.this, 3003, searchingText));
            }
        }

        private void updatePopupBounds() {
            if (Searchable.this._popup != null) {
                this._textField.invalidate();
                try {
                    if (!Searchable.this.isHeavyweightComponentEnabled()) {
                        Dimension size = this._noMatch.getPreferredSize();
                        size.width += this._label.getPreferredSize().width;
                        size.width += new JLabel((String)this._textField.getText()).getPreferredSize().width + 24;
                        size.height = ((Searchable)Searchable.this)._popup.getSize().height;
                        Searchable.this._popup.setSize(size);
                        Searchable.this._popup.validate();
                    } else {
                        Searchable.this._popup.packPopup();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    protected class SearchField
    extends JTextField {
        SearchField() {
            JideSwingUtilities.setComponentTransparent(this);
        }

        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            size.width = this.getFontMetrics(this.getFont()).stringWidth(this.getText()) + 4;
            return size;
        }

        public void processKeyEvent(KeyEvent e2) {
            int keyCode = e2.getKeyCode();
            if (keyCode == 8 && this.getDocument().getLength() == 0) {
                e2.consume();
                return;
            }
            boolean isNavigationKey = Searchable.this.isNavigationKey(e2);
            if (Searchable.this.isDeactivateKey(e2) && !isNavigationKey) {
                Searchable.this.hidePopup();
                if (keyCode == 27) {
                    e2.consume();
                }
                return;
            }
            super.processKeyEvent(e2);
            if (keyCode == 8 || isNavigationKey) {
                e2.consume();
            }
            if (Searchable.this.isSelectAllKey(e2)) {
                e2.consume();
            }
        }
    }
}

