/*
 * Decompiled with CFR 0.152.
 */
package picard.util;

import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProcessExecutor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import picard.PicardException;

public class RExecutor {
    private static final Log LOG = Log.getInstance(RExecutor.class);
    private static final String R_EXE = "Rscript";

    public static int executeFromClasspath(String rScriptName, String ... arguments) {
        File scriptFile = RExecutor.writeScriptFile(rScriptName);
        int returnCode = RExecutor.executeFromFile(scriptFile, arguments);
        IOUtil.deleteFiles(scriptFile);
        return returnCode;
    }

    public static int executeFromFile(File scriptFile, String ... arguments) {
        String[] command = new String[arguments.length + 2];
        command[0] = R_EXE;
        command[1] = scriptFile.getAbsolutePath();
        System.arraycopy(arguments, 0, command, 2, arguments.length);
        LOG.info(String.format("Executing R script via command: %s", CollectionUtil.join(Arrays.asList(command), " ")));
        return ProcessExecutor.execute(command);
    }

    private static File writeScriptFile(String rScriptName) {
        InputStream scriptStream = null;
        OutputStream scriptFileStream = null;
        try {
            scriptStream = RExecutor.class.getClassLoader().getResourceAsStream(rScriptName);
            if (scriptStream == null) {
                throw new IllegalArgumentException("Script [" + rScriptName + "] not found in classpath");
            }
            File scriptFile = File.createTempFile("script", ".R");
            scriptFileStream = IOUtil.openFileForWriting(scriptFile);
            IOUtil.copyStream(scriptStream, scriptFileStream);
            File file = scriptFile;
            return file;
        }
        catch (IOException e2) {
            throw new PicardException("Unexpected exception creating R script file", e2);
        }
        finally {
            if (scriptStream != null) {
                try {
                    scriptStream.close();
                }
                catch (IOException ignored) {}
            }
            if (scriptFileStream != null) {
                try {
                    scriptFileStream.close();
                }
                catch (IOException ignored) {}
            }
        }
    }
}

