/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.BAMRecordCodec;
import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.ReservedTagConstants;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMProgramRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordCoordinateComparator;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SAMRecordQueryNameComparator;
import htsjdk.samtools.SAMRecordUtil;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SAMTag;
import htsjdk.samtools.SAMUtils;
import htsjdk.samtools.SamPairUtil;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.filter.FilteringIterator;
import htsjdk.samtools.filter.SamRecordFilter;
import htsjdk.samtools.reference.ReferenceSequenceFileWalker;
import htsjdk.samtools.util.CigarUtil;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.samtools.util.SequenceUtil;
import htsjdk.samtools.util.SortingCollection;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import picard.PicardException;
import picard.sam.HitsForInsert;
import picard.sam.MultiHitAlignedReadIterator;
import picard.sam.PrimaryAlignmentSelectionStrategy;

public abstract class AbstractAlignmentMerger {
    public static final int MAX_RECORDS_IN_RAM = 500000;
    private static final char[] RESERVED_ATTRIBUTE_STARTS = new char[]{'X', 'Y', 'Z'};
    private final Log log = Log.getInstance(AbstractAlignmentMerger.class);
    private final ProgressLogger progress = new ProgressLogger(this.log, 1000000, "Written to sorting collection in queryname order", "records");
    private final File unmappedBamFile;
    private final File targetBamFile;
    private final SAMSequenceDictionary sequenceDictionary;
    private ReferenceSequenceFileWalker refSeq = null;
    private final boolean clipAdapters;
    private final boolean bisulfiteSequence;
    private SAMProgramRecord programRecord;
    private final boolean alignedReadsOnly;
    private final SAMFileHeader header;
    private final List<String> attributesToRetain = new ArrayList<String>();
    private final List<String> attributesToRemove = new ArrayList<String>();
    private final File referenceFasta;
    private final Integer read1BasesTrimmed;
    private final Integer read2BasesTrimmed;
    private final List<SamPairUtil.PairOrientation> expectedOrientations;
    private final SAMFileHeader.SortOrder sortOrder;
    private MultiHitAlignedReadIterator alignedIterator = null;
    private boolean clipOverlappingReads = true;
    private int maxRecordsInRam = 500000;
    private final PrimaryAlignmentSelectionStrategy primaryAlignmentSelectionStrategy;
    private boolean keepAlignerProperPairFlags = false;
    private boolean addMateCigar = false;
    private final SamRecordFilter alignmentFilter = new SamRecordFilter(){

        @Override
        public boolean filterOut(SAMRecord record) {
            return AbstractAlignmentMerger.this.ignoreAlignment(record);
        }

        @Override
        public boolean filterOut(SAMRecord first, SAMRecord second) {
            throw new UnsupportedOperationException("Paired SamRecordFilter not implemented!");
        }
    };
    private boolean includeSecondaryAlignments = true;

    protected abstract CloseableIterator<SAMRecord> getQuerynameSortedAlignedRecords();

    protected boolean ignoreAlignment(SAMRecord sam) {
        return false;
    }

    public AbstractAlignmentMerger(File unmappedBamFile, File targetBamFile, File referenceFasta, boolean clipAdapters, boolean bisulfiteSequence, boolean alignedReadsOnly, SAMProgramRecord programRecord, List<String> attributesToRetain, List<String> attributesToRemove, Integer read1BasesTrimmed, Integer read2BasesTrimmed, List<SamPairUtil.PairOrientation> expectedOrientations, SAMFileHeader.SortOrder sortOrder, PrimaryAlignmentSelectionStrategy primaryAlignmentSelectionStrategy, boolean addMateCigar) {
        IOUtil.assertFileIsReadable(unmappedBamFile);
        IOUtil.assertFileIsWritable(targetBamFile);
        IOUtil.assertFileIsReadable(referenceFasta);
        this.unmappedBamFile = unmappedBamFile;
        this.targetBamFile = targetBamFile;
        this.referenceFasta = referenceFasta;
        this.refSeq = new ReferenceSequenceFileWalker(referenceFasta);
        this.sequenceDictionary = this.refSeq.getSequenceDictionary();
        if (this.sequenceDictionary == null) {
            throw new PicardException("No sequence dictionary found for " + referenceFasta.getAbsolutePath() + ".  Use CreateSequenceDictionary.jar to create a sequence dictionary.");
        }
        this.clipAdapters = clipAdapters;
        this.bisulfiteSequence = bisulfiteSequence;
        this.alignedReadsOnly = alignedReadsOnly;
        this.header = new SAMFileHeader();
        this.sortOrder = sortOrder != null ? sortOrder : SAMFileHeader.SortOrder.coordinate;
        this.header.setSortOrder(SAMFileHeader.SortOrder.coordinate);
        if (programRecord != null) {
            this.setProgramRecord(programRecord);
        }
        this.header.setSequenceDictionary(this.sequenceDictionary);
        if (attributesToRetain != null) {
            this.attributesToRetain.addAll(attributesToRetain);
        }
        if (attributesToRemove != null) {
            this.attributesToRemove.addAll(attributesToRemove);
            if (!this.attributesToRetain.isEmpty()) {
                for (String attribute : this.attributesToRemove) {
                    if (!this.attributesToRetain.contains(attribute)) continue;
                    this.log.info("Overriding retaining the " + attribute + " tag since remove overrides retain.");
                    this.attributesToRetain.remove(attribute);
                }
            }
        }
        this.read1BasesTrimmed = read1BasesTrimmed;
        this.read2BasesTrimmed = read2BasesTrimmed;
        this.expectedOrientations = expectedOrientations;
        this.primaryAlignmentSelectionStrategy = primaryAlignmentSelectionStrategy;
        this.addMateCigar = addMateCigar;
    }

    public void setMaxRecordsInRam(int maxRecordsInRam) {
        this.maxRecordsInRam = maxRecordsInRam;
    }

    private void maybeSetPgTag(SAMRecord rec) {
        if (this.programRecord != null) {
            rec.setAttribute(ReservedTagConstants.PROGRAM_GROUP_ID, (Object)this.programRecord.getProgramGroupId());
        }
    }

    public void mergeAlignment() {
        SamReader unmappedSam = SamReaderFactory.makeDefault().open(this.unmappedBamFile);
        if (this.getProgramRecord() != null) {
            for (SAMProgramRecord pg : unmappedSam.getFileHeader().getProgramRecords()) {
                if (!pg.getId().equals(this.getProgramRecord().getId())) continue;
                throw new PicardException("Program Record ID already in use in unmapped BAM file.");
            }
        }
        SAMRecordIterator unmappedIterator = unmappedSam.iterator();
        this.header.setReadGroups(unmappedSam.getFileHeader().getReadGroups());
        int aligned = 0;
        int unmapped = 0;
        this.alignedIterator = new MultiHitAlignedReadIterator(new FilteringIterator(this.getQuerynameSortedAlignedRecords(), this.alignmentFilter), this.primaryAlignmentSelectionStrategy);
        HitsForInsert nextAligned = this.nextAligned();
        SortingCollection<SAMRecord> sorted = SortingCollection.newInstance(SAMRecord.class, new BAMRecordCodec(this.header), new SAMRecordCoordinateComparator(), 500000);
        while (unmappedIterator.hasNext()) {
            SAMRecord secondOfPair;
            SAMRecord rec = (SAMRecord)unmappedIterator.next();
            rec.setHeader(this.header);
            this.maybeSetPgTag(rec);
            if (rec.getReadPairedFlag()) {
                secondOfPair = (SAMRecord)unmappedIterator.next();
                secondOfPair.setHeader(this.header);
                this.maybeSetPgTag(secondOfPair);
                if (!rec.getReadName().equals(secondOfPair.getReadName())) {
                    throw new PicardException("Second read from pair not found in unmapped bam: " + rec.getReadName() + ", " + secondOfPair.getReadName());
                }
                if (!rec.getFirstOfPairFlag()) {
                    throw new PicardException("First record in unmapped bam is not first of pair: " + rec.getReadName());
                }
                if (!secondOfPair.getReadPairedFlag()) {
                    throw new PicardException("Second record in unmapped bam is not marked as paired: " + secondOfPair.getReadName());
                }
                if (!secondOfPair.getSecondOfPairFlag()) {
                    throw new PicardException("Second record in unmapped bam is not second of pair: " + secondOfPair.getReadName());
                }
            } else {
                secondOfPair = null;
            }
            if (nextAligned != null && rec.getReadName().equals(nextAligned.getReadName())) {
                boolean clone = nextAligned.numHits() > 1 || nextAligned.hasSupplementalHits();
                SAMRecord r1Primary = null;
                SAMRecord r2Primary = null;
                if (rec.getReadPairedFlag()) {
                    for (int i2 = 0; i2 < nextAligned.numHits(); ++i2) {
                        SAMRecord secondToWrite;
                        SAMRecord firstToWrite;
                        boolean isPrimaryAlignment;
                        SAMRecord firstAligned = nextAligned.getFirstOfPair(i2);
                        SAMRecord secondAligned = nextAligned.getSecondOfPair(i2);
                        boolean bl = isPrimaryAlignment = firstAligned != null && !firstAligned.isSecondaryOrSupplementary() || secondAligned != null && !secondAligned.isSecondaryOrSupplementary();
                        if (clone) {
                            firstToWrite = this.clone(rec);
                            secondToWrite = this.clone(secondOfPair);
                        } else {
                            firstToWrite = rec;
                            secondToWrite = secondOfPair;
                        }
                        if (isPrimaryAlignment) {
                            r1Primary = firstToWrite;
                            r2Primary = secondToWrite;
                        }
                        this.transferAlignmentInfoToPairedRead(firstToWrite, secondToWrite, firstAligned, secondAligned);
                        if (!firstToWrite.getReadUnmappedFlag() || isPrimaryAlignment) {
                            this.addIfNotFiltered(sorted, firstToWrite);
                            if (firstToWrite.getReadUnmappedFlag()) {
                                ++unmapped;
                            } else {
                                ++aligned;
                            }
                        }
                        if (secondToWrite.getReadUnmappedFlag() && !isPrimaryAlignment) continue;
                        this.addIfNotFiltered(sorted, secondToWrite);
                        if (!secondToWrite.getReadUnmappedFlag()) {
                            ++aligned;
                            continue;
                        }
                        ++unmapped;
                    }
                    for (boolean isRead1 : new boolean[]{true, false}) {
                        List<SAMRecord> supplementals = isRead1 ? nextAligned.getSupplementalFirstOfPairOrFragment() : nextAligned.getSupplementalSecondOfPair();
                        SAMRecord sourceRec = isRead1 ? rec : secondOfPair;
                        SAMRecord matePrimary = isRead1 ? r2Primary : r1Primary;
                        for (SAMRecord supp : supplementals) {
                            SAMRecord out = this.clone(sourceRec);
                            this.transferAlignmentInfoToFragment(out, supp);
                            if (matePrimary != null) {
                                SamPairUtil.setMateInformationOnSupplementalAlignment(out, matePrimary, this.addMateCigar);
                            }
                            ++aligned;
                            this.addIfNotFiltered(sorted, out);
                        }
                    }
                } else {
                    for (int i3 = 0; i3 < nextAligned.numHits(); ++i3) {
                        SAMRecord recToWrite = clone ? this.clone(rec) : rec;
                        this.transferAlignmentInfoToFragment(recToWrite, nextAligned.getFragment(i3));
                        this.addIfNotFiltered(sorted, recToWrite);
                        if (recToWrite.getReadUnmappedFlag()) {
                            ++unmapped;
                            continue;
                        }
                        ++aligned;
                    }
                    for (SAMRecord supplementalRec : nextAligned.getSupplementalFirstOfPairOrFragment()) {
                        SAMRecord recToWrite = this.clone(rec);
                        this.transferAlignmentInfoToFragment(recToWrite, supplementalRec);
                        this.addIfNotFiltered(sorted, recToWrite);
                        ++aligned;
                    }
                }
                nextAligned = this.nextAligned();
                continue;
            }
            if (nextAligned != null && SAMRecordQueryNameComparator.compareReadNames(rec.getReadName(), nextAligned.getReadName()) > 0) {
                throw new IllegalStateException("Aligned record iterator (" + nextAligned.getReadName() + ") is behind the unmapped reads (" + rec.getReadName() + ")");
            }
            if (this.alignedReadsOnly) continue;
            sorted.add(rec);
            ++unmapped;
            if (secondOfPair == null) continue;
            sorted.add(secondOfPair);
            ++unmapped;
        }
        unmappedIterator.close();
        if (this.alignedIterator.hasNext()) {
            throw new IllegalStateException("Reads remaining on alignment iterator: " + this.alignedIterator.next().getReadName() + "!");
        }
        this.alignedIterator.close();
        this.header.setSortOrder(this.sortOrder);
        boolean presorted = this.sortOrder == SAMFileHeader.SortOrder.coordinate;
        SAMFileWriter writer = new SAMFileWriterFactory().makeSAMOrBAMWriter(this.header, presorted, this.targetBamFile);
        writer.setProgressLogger(new ProgressLogger(this.log, 10000000, "Wrote", "records from a sorting collection"));
        ProgressLogger finalProgress = new ProgressLogger(this.log, 10000000, "Written in coordinate order to output", "records");
        for (SAMRecord rec : sorted) {
            if (!rec.getReadUnmappedFlag() && this.refSeq != null) {
                byte[] referenceBases = this.refSeq.get(this.sequenceDictionary.getSequenceIndex(rec.getReferenceName())).getBases();
                rec.setAttribute(SAMTag.NM.name(), (Object)SequenceUtil.calculateSamNmTag(rec, referenceBases, 0, this.bisulfiteSequence));
                if (rec.getBaseQualities() != SAMRecord.NULL_QUALS) {
                    rec.setAttribute(SAMTag.UQ.name(), (Object)SequenceUtil.sumQualitiesOfMismatches(rec, referenceBases, 0, this.bisulfiteSequence));
                }
            }
            writer.addAlignment(rec);
            finalProgress.record(rec);
        }
        writer.close();
        sorted.cleanup();
        this.log.info("Wrote " + aligned + " alignment records and " + (this.alignedReadsOnly ? 0 : unmapped) + " unmapped reads.");
    }

    private void addIfNotFiltered(SortingCollection<SAMRecord> sorted, SAMRecord rec) {
        if (this.includeSecondaryAlignments || !rec.getNotPrimaryAlignmentFlag()) {
            sorted.add(rec);
            this.progress.record(rec);
        }
    }

    private SAMRecord clone(SAMRecord rec) {
        try {
            return (SAMRecord)rec.clone();
        }
        catch (CloneNotSupportedException e2) {
            throw new PicardException("Should never happen.");
        }
    }

    private HitsForInsert nextAligned() {
        if (this.alignedIterator.hasNext()) {
            return this.alignedIterator.next();
        }
        return null;
    }

    private void transferAlignmentInfoToFragment(SAMRecord unaligned, SAMRecord aligned) {
        this.setValuesFromAlignment(unaligned, aligned);
        this.updateCigarForTrimmedOrClippedBases(unaligned, aligned);
        if (SAMUtils.cigarMapsNoBasesToRef(unaligned.getCigar())) {
            SAMUtils.makeReadUnmapped(unaligned);
        } else if (SAMUtils.recordMapsEntirelyBeyondEndOfReference(aligned)) {
            this.log.warn("Record mapped off end of reference; making unmapped: " + aligned);
            SAMUtils.makeReadUnmapped(unaligned);
        }
    }

    private void transferAlignmentInfoToPairedRead(SAMRecord firstUnaligned, SAMRecord secondUnaligned, SAMRecord firstAligned, SAMRecord secondAligned) {
        if (firstAligned != null) {
            this.transferAlignmentInfoToFragment(firstUnaligned, firstAligned);
        }
        if (secondAligned != null) {
            this.transferAlignmentInfoToFragment(secondUnaligned, secondAligned);
        }
        if (this.isClipOverlappingReads()) {
            this.clipForOverlappingReads(firstUnaligned, secondUnaligned);
        }
        SamPairUtil.setMateInfo(secondUnaligned, firstUnaligned, this.header, this.addMateCigar);
        if (!this.keepAlignerProperPairFlags) {
            SamPairUtil.setProperPairFlags(secondUnaligned, firstUnaligned, this.expectedOrientations);
        }
    }

    protected void clipForOverlappingReads(SAMRecord read1, SAMRecord read2) {
        if (!read1.getReadUnmappedFlag() && !read2.getReadUnmappedFlag() && read1.getReadNegativeStrandFlag() != read2.getReadNegativeStrandFlag()) {
            SAMRecord neg;
            SAMRecord pos = read1.getReadNegativeStrandFlag() ? read2 : read1;
            SAMRecord sAMRecord = neg = read1.getReadNegativeStrandFlag() ? read1 : read2;
            if (pos.getAlignmentStart() < neg.getAlignmentEnd()) {
                int posDiff = pos.getAlignmentEnd() - neg.getAlignmentEnd();
                int negDiff = pos.getAlignmentStart() - neg.getAlignmentStart();
                if (posDiff > 0) {
                    CigarUtil.softClip3PrimeEndOfRead(pos, Math.min(pos.getReadLength(), pos.getReadLength() - posDiff + 1));
                }
                if (negDiff > 0) {
                    CigarUtil.softClip3PrimeEndOfRead(neg, Math.min(neg.getReadLength(), neg.getReadLength() - negDiff + 1));
                }
            }
        }
    }

    protected void setValuesFromAlignment(SAMRecord rec, SAMRecord alignment) {
        for (SAMRecord.SAMTagAndValue attr : alignment.getAttributes()) {
            if (this.isReservedTag(attr.tag) && !this.attributesToRetain.contains(attr.tag) || this.attributesToRemove.contains(attr.tag)) continue;
            rec.setAttribute(attr.tag, attr.value);
        }
        rec.setReadUnmappedFlag(alignment.getReadUnmappedFlag());
        rec.setReferenceName(alignment.getReferenceName());
        rec.setAlignmentStart(alignment.getAlignmentStart());
        rec.setReadNegativeStrandFlag(alignment.getReadNegativeStrandFlag());
        rec.setNotPrimaryAlignmentFlag(alignment.getNotPrimaryAlignmentFlag());
        rec.setSupplementaryAlignmentFlag(alignment.getSupplementaryAlignmentFlag());
        if (!alignment.getReadUnmappedFlag()) {
            rec.setCigar(alignment.getCigar());
            rec.setMappingQuality(alignment.getMappingQuality());
        }
        if (rec.getReadPairedFlag()) {
            rec.setProperPairFlag(alignment.getProperPairFlag());
        }
        if (rec.getReadNegativeStrandFlag()) {
            SAMRecordUtil.reverseComplement(rec);
        }
    }

    private static Cigar createNewCigarIfMapsOffEndOfReference(SAMFileHeader header, boolean isUnmapped, int referenceIndex, int alignmentEnd, int readLength, Cigar oldCigar) {
        SAMSequenceRecord refseq;
        int overhang;
        Cigar newCigar = null;
        if (!isUnmapped && (overhang = alignmentEnd - (refseq = header.getSequence(referenceIndex)).getSequenceLength()) > 0) {
            int clipFrom = readLength - overhang + 1;
            CigarElement cigarElement = oldCigar.getCigarElement(oldCigar.getCigarElements().size() - 1);
            if (CigarOperator.SOFT_CLIP == cigarElement.getOperator()) {
                clipFrom -= cigarElement.getLength();
            }
            List<CigarElement> newCigarElements = CigarUtil.softClipEndOfRead(clipFrom, oldCigar.getCigarElements());
            newCigar = new Cigar(newCigarElements);
        }
        return newCigar;
    }

    public static void createNewCigarsIfMapsOffEndOfReference(SAMRecord rec) {
        Cigar readCigar;
        if (!rec.getReadUnmappedFlag() && null != (readCigar = AbstractAlignmentMerger.createNewCigarIfMapsOffEndOfReference(rec.getHeader(), rec.getReadUnmappedFlag(), rec.getReferenceIndex(), rec.getAlignmentEnd(), rec.getReadLength(), rec.getCigar()))) {
            rec.setCigar(readCigar);
        }
        if (SAMUtils.hasMateCigar(rec)) {
            Cigar mateCigar = SAMUtils.getMateCigar(rec);
            mateCigar = AbstractAlignmentMerger.createNewCigarIfMapsOffEndOfReference(rec.getHeader(), rec.getMateUnmappedFlag(), rec.getMateReferenceIndex(), SAMUtils.getMateAlignmentEnd(rec), mateCigar.getReadLength(), mateCigar);
            if (null != mateCigar) {
                rec.setAttribute(SAMTag.MC.name(), (Object)mateCigar.toString());
            }
        }
    }

    protected void updateCigarForTrimmedOrClippedBases(SAMRecord rec, SAMRecord alignment) {
        int alignmentReadLength = alignment.getReadLength();
        int originalReadLength = rec.getReadLength();
        int trimmed = !rec.getReadPairedFlag() || rec.getFirstOfPairFlag() ? (this.read1BasesTrimmed != null ? this.read1BasesTrimmed : 0) : (this.read2BasesTrimmed != null ? this.read2BasesTrimmed : 0);
        int notWritten = originalReadLength - (alignmentReadLength + trimmed);
        AbstractAlignmentMerger.createNewCigarsIfMapsOffEndOfReference(rec);
        rec.setCigar(CigarUtil.addSoftClippedBasesToEndsOfCigar(rec.getCigar(), rec.getReadNegativeStrandFlag(), notWritten, trimmed));
        if (this.clipAdapters && rec.getAttribute("XT") != null) {
            CigarUtil.softClip3PrimeEndOfRead(rec, rec.getIntegerAttribute("XT"));
        }
    }

    protected SAMSequenceDictionary getSequenceDictionary() {
        return this.sequenceDictionary;
    }

    protected SAMProgramRecord getProgramRecord() {
        return this.programRecord;
    }

    protected void setProgramRecord(SAMProgramRecord pg) {
        if (this.programRecord != null) {
            throw new IllegalStateException("Cannot set program record more than once on alignment merger.");
        }
        this.programRecord = pg;
        this.header.addProgramRecord(pg);
        SAMUtils.chainSAMProgramRecord(this.header, pg);
    }

    protected boolean isReservedTag(String tag) {
        char firstCharOfTag = tag.charAt(0);
        if (Character.isLowerCase(firstCharOfTag)) {
            return true;
        }
        for (char c2 : RESERVED_ATTRIBUTE_STARTS) {
            if (firstCharOfTag != c2) continue;
            return true;
        }
        return false;
    }

    protected SAMFileHeader getHeader() {
        return this.header;
    }

    protected void resetRefSeqFileWalker() {
        this.refSeq = new ReferenceSequenceFileWalker(this.referenceFasta);
    }

    public boolean isClipOverlappingReads() {
        return this.clipOverlappingReads;
    }

    public void setClipOverlappingReads(boolean clipOverlappingReads) {
        this.clipOverlappingReads = clipOverlappingReads;
    }

    public boolean isKeepAlignerProperPairFlags() {
        return this.keepAlignerProperPairFlags;
    }

    public void setKeepAlignerProperPairFlags(boolean keepAlignerProperPairFlags) {
        this.keepAlignerProperPairFlags = keepAlignerProperPairFlags;
    }

    public void setIncludeSecondaryAlignments(boolean includeSecondaryAlignments) {
        this.includeSecondaryAlignments = includeSecondaryAlignments;
    }

    public void close() {
        CloserUtil.close(this.refSeq);
    }
}

